# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkSecurity
      module V1beta1
        # ClientTlsPolicy is a resource that specifies how a client should authenticate
        # connections to backends of a service. This resource itself does not affect
        # configuration unless it is attached to a backend service resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ClientTlsPolicy resource. It matches the pattern
        #     `projects/*/locations/{location}/clientTlsPolicies/{client_tls_policy}`
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Free-text description of the resource.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the resource was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Set of label tags associated with the resource.
        # @!attribute [rw] sni
        #   @return [::String]
        #     Optional. Server Name Indication string to present to the server during TLS
        #     handshake. E.g: "secure.example.com".
        # @!attribute [rw] client_certificate
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::CertificateProvider]
        #     Optional. Defines a mechanism to provision client identity (public and
        #     private keys) for peer to peer authentication. The presence of this
        #     dictates mTLS.
        # @!attribute [rw] server_validation_ca
        #   @return [::Array<::Google::Cloud::NetworkSecurity::V1beta1::ValidationCA>]
        #     Optional. Defines the mechanism to obtain the Certificate Authority
        #     certificate to validate the server certificate. If empty, client does not
        #     validate the server certificate.
        class ClientTlsPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request used by the ListClientTlsPolicies method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the ClientTlsPolicies should
        #     be listed, specified in the format `projects/*/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of ClientTlsPolicies to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The value returned by the last `ListClientTlsPoliciesResponse`
        #     Indicates that this is a continuation of a prior
        #     `ListClientTlsPolicies` call, and that the system
        #     should return the next page of data.
        class ListClientTlsPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response returned by the ListClientTlsPolicies method.
        # @!attribute [rw] client_tls_policies
        #   @return [::Array<::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy>]
        #     List of ClientTlsPolicy resources.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there might be more results than those appearing in this response, then
        #     `next_page_token` is included. To get the next set of results, call this
        #     method again using the value of `next_page_token` as `page_token`.
        class ListClientTlsPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the GetClientTlsPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the ClientTlsPolicy to get. Must be in the format
        #     `projects/*/locations/{location}/clientTlsPolicies/*`.
        class GetClientTlsPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the CreateClientTlsPolicy method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the ClientTlsPolicy. Must be in
        #     the format `projects/*/locations/{location}`.
        # @!attribute [rw] client_tls_policy_id
        #   @return [::String]
        #     Required. Short name of the ClientTlsPolicy resource to be created. This
        #     value should be 1-63 characters long, containing only letters, numbers,
        #     hyphens, and underscores, and should not start with a number. E.g.
        #     "client_mtls_policy".
        # @!attribute [rw] client_tls_policy
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy]
        #     Required. ClientTlsPolicy resource to be created.
        class CreateClientTlsPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by UpdateClientTlsPolicy method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     ClientTlsPolicy resource by the update.  The fields
        #     specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the
        #     mask. If the user does not provide a mask then all fields will be
        #     overwritten.
        # @!attribute [rw] client_tls_policy
        #   @return [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy]
        #     Required. Updated ClientTlsPolicy resource.
        class UpdateClientTlsPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request used by the DeleteClientTlsPolicy method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. A name of the ClientTlsPolicy to delete. Must be in
        #     the format `projects/*/locations/{location}/clientTlsPolicies/*`.
        class DeleteClientTlsPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
