# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networksecurity/v1beta1/network_security_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkSecurity
      module V1beta1
        module NetworkSecurity
          ##
          # Client for the NetworkSecurity service.
          #
          # Network Security API provides resources to configure authentication and
          # authorization policies. Refer to per API resource documentation for more
          # information.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networksecurity.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :network_security_stub

            ##
            # Configure the NetworkSecurity Client class.
            #
            # See {::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all NetworkSecurity clients
            #   ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkSecurity", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the NetworkSecurity Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @network_security_stub.universe_domain
            end

            ##
            # Create a new NetworkSecurity client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the NetworkSecurity client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networksecurity/v1beta1/network_security_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @network_security_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @network_security_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @network_security_stub.endpoint
                config.universe_domain = @network_security_stub.universe_domain
                config.logger = @network_security_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @network_security_stub.endpoint
                config.universe_domain = @network_security_stub.universe_domain
                config.logger = @network_security_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @network_security_stub.logger
            end

            # Service calls

            ##
            # Lists AuthorizationPolicies in a given project and location.
            #
            # @overload list_authorization_policies(request, options = nil)
            #   Pass arguments to `list_authorization_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_authorization_policies(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_authorization_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the AuthorizationPolicies
            #     should be listed, specified in the format
            #     `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     Maximum number of AuthorizationPolicies to return per call.
            #   @param page_token [::String]
            #     The value returned by the last
            #     `ListAuthorizationPoliciesResponse` Indicates that this is a
            #     continuation of a prior `ListAuthorizationPolicies` call, and
            #     that the system should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest.new
            #
            #   # Call the list_authorization_policies method.
            #   result = client.list_authorization_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy.
            #     p item
            #   end
            #
            def list_authorization_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::ListAuthorizationPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_authorization_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_authorization_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_authorization_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :list_authorization_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_security_stub, :list_authorization_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single AuthorizationPolicy.
            #
            # @overload get_authorization_policy(request, options = nil)
            #   Pass arguments to `get_authorization_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_authorization_policy(name: nil)
            #   Pass arguments to `get_authorization_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the AuthorizationPolicy to get. Must be in the format
            #     `projects/{project}/locations/{location}/authorizationPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest.new
            #
            #   # Call the get_authorization_policy method.
            #   result = client.get_authorization_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy.
            #   p result
            #
            def get_authorization_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::GetAuthorizationPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_authorization_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_authorization_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_authorization_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :get_authorization_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new AuthorizationPolicy in a given project and location.
            #
            # @overload create_authorization_policy(request, options = nil)
            #   Pass arguments to `create_authorization_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_authorization_policy(parent: nil, authorization_policy_id: nil, authorization_policy: nil)
            #   Pass arguments to `create_authorization_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the AuthorizationPolicy. Must be in the
            #     format `projects/{project}/locations/{location}`.
            #   @param authorization_policy_id [::String]
            #     Required. Short name of the AuthorizationPolicy resource to be created.
            #     This value should be 1-63 characters long, containing only
            #     letters, numbers, hyphens, and underscores, and should not start
            #     with a number. E.g. "authz_policy".
            #   @param authorization_policy [::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy, ::Hash]
            #     Required. AuthorizationPolicy resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest.new
            #
            #   # Call the create_authorization_policy method.
            #   result = client.create_authorization_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_authorization_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::CreateAuthorizationPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_authorization_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_authorization_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_authorization_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :create_authorization_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single AuthorizationPolicy.
            #
            # @overload update_authorization_policy(request, options = nil)
            #   Pass arguments to `update_authorization_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_authorization_policy(update_mask: nil, authorization_policy: nil)
            #   Pass arguments to `update_authorization_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     AuthorizationPolicy resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param authorization_policy [::Google::Cloud::NetworkSecurity::V1beta1::AuthorizationPolicy, ::Hash]
            #     Required. Updated AuthorizationPolicy resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest.new
            #
            #   # Call the update_authorization_policy method.
            #   result = client.update_authorization_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_authorization_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::UpdateAuthorizationPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_authorization_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.authorization_policy&.name
                header_params["authorization_policy.name"] = request.authorization_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_authorization_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_authorization_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :update_authorization_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single AuthorizationPolicy.
            #
            # @overload delete_authorization_policy(request, options = nil)
            #   Pass arguments to `delete_authorization_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_authorization_policy(name: nil)
            #   Pass arguments to `delete_authorization_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the AuthorizationPolicy to delete. Must be in the
            #     format `projects/{project}/locations/{location}/authorizationPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest.new
            #
            #   # Call the delete_authorization_policy method.
            #   result = client.delete_authorization_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_authorization_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::DeleteAuthorizationPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_authorization_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_authorization_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_authorization_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :delete_authorization_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServerTlsPolicies in a given project and location.
            #
            # @overload list_server_tls_policies(request, options = nil)
            #   Pass arguments to `list_server_tls_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_server_tls_policies(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_server_tls_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the ServerTlsPolicies should
            #     be listed, specified in the format `projects/*/locations/{location}`.
            #   @param page_size [::Integer]
            #     Maximum number of ServerTlsPolicies to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListServerTlsPoliciesResponse`
            #     Indicates that this is a continuation of a prior
            #     `ListServerTlsPolicies` call, and that the system
            #     should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest.new
            #
            #   # Call the list_server_tls_policies method.
            #   result = client.list_server_tls_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy.
            #     p item
            #   end
            #
            def list_server_tls_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::ListServerTlsPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_server_tls_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_server_tls_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_server_tls_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :list_server_tls_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_security_stub, :list_server_tls_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServerTlsPolicy.
            #
            # @overload get_server_tls_policy(request, options = nil)
            #   Pass arguments to `get_server_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_server_tls_policy(name: nil)
            #   Pass arguments to `get_server_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServerTlsPolicy to get. Must be in the format
            #     `projects/*/locations/{location}/serverTlsPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest.new
            #
            #   # Call the get_server_tls_policy method.
            #   result = client.get_server_tls_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy.
            #   p result
            #
            def get_server_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::GetServerTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_server_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_server_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_server_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :get_server_tls_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServerTlsPolicy in a given project and location.
            #
            # @overload create_server_tls_policy(request, options = nil)
            #   Pass arguments to `create_server_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_server_tls_policy(parent: nil, server_tls_policy_id: nil, server_tls_policy: nil)
            #   Pass arguments to `create_server_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the ServerTlsPolicy. Must be in
            #     the format `projects/*/locations/{location}`.
            #   @param server_tls_policy_id [::String]
            #     Required. Short name of the ServerTlsPolicy resource to be created. This
            #     value should be 1-63 characters long, containing only letters, numbers,
            #     hyphens, and underscores, and should not start with a number. E.g.
            #     "server_mtls_policy".
            #   @param server_tls_policy [::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy, ::Hash]
            #     Required. ServerTlsPolicy resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest.new
            #
            #   # Call the create_server_tls_policy method.
            #   result = client.create_server_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_server_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::CreateServerTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_server_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_server_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_server_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :create_server_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServerTlsPolicy.
            #
            # @overload update_server_tls_policy(request, options = nil)
            #   Pass arguments to `update_server_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_server_tls_policy(update_mask: nil, server_tls_policy: nil)
            #   Pass arguments to `update_server_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServerTlsPolicy resource by the update.  The fields
            #     specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the
            #     mask. If the user does not provide a mask then all fields will be
            #     overwritten.
            #   @param server_tls_policy [::Google::Cloud::NetworkSecurity::V1beta1::ServerTlsPolicy, ::Hash]
            #     Required. Updated ServerTlsPolicy resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest.new
            #
            #   # Call the update_server_tls_policy method.
            #   result = client.update_server_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_server_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::UpdateServerTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_server_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.server_tls_policy&.name
                header_params["server_tls_policy.name"] = request.server_tls_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_server_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_server_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :update_server_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServerTlsPolicy.
            #
            # @overload delete_server_tls_policy(request, options = nil)
            #   Pass arguments to `delete_server_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_server_tls_policy(name: nil)
            #   Pass arguments to `delete_server_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ServerTlsPolicy to delete. Must be in
            #     the format `projects/*/locations/{location}/serverTlsPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest.new
            #
            #   # Call the delete_server_tls_policy method.
            #   result = client.delete_server_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_server_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::DeleteServerTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_server_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_server_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_server_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :delete_server_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ClientTlsPolicies in a given project and location.
            #
            # @overload list_client_tls_policies(request, options = nil)
            #   Pass arguments to `list_client_tls_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_client_tls_policies(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_client_tls_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location from which the ClientTlsPolicies should
            #     be listed, specified in the format `projects/*/locations/{location}`.
            #   @param page_size [::Integer]
            #     Maximum number of ClientTlsPolicies to return per call.
            #   @param page_token [::String]
            #     The value returned by the last `ListClientTlsPoliciesResponse`
            #     Indicates that this is a continuation of a prior
            #     `ListClientTlsPolicies` call, and that the system
            #     should return the next page of data.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest.new
            #
            #   # Call the list_client_tls_policies method.
            #   result = client.list_client_tls_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy.
            #     p item
            #   end
            #
            def list_client_tls_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::ListClientTlsPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_client_tls_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_client_tls_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_client_tls_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :list_client_tls_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @network_security_stub, :list_client_tls_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ClientTlsPolicy.
            #
            # @overload get_client_tls_policy(request, options = nil)
            #   Pass arguments to `get_client_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_client_tls_policy(name: nil)
            #   Pass arguments to `get_client_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ClientTlsPolicy to get. Must be in the format
            #     `projects/*/locations/{location}/clientTlsPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest.new
            #
            #   # Call the get_client_tls_policy method.
            #   result = client.get_client_tls_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy.
            #   p result
            #
            def get_client_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::GetClientTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_client_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_client_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_client_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :get_client_tls_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ClientTlsPolicy in a given project and location.
            #
            # @overload create_client_tls_policy(request, options = nil)
            #   Pass arguments to `create_client_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_client_tls_policy(parent: nil, client_tls_policy_id: nil, client_tls_policy: nil)
            #   Pass arguments to `create_client_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the ClientTlsPolicy. Must be in
            #     the format `projects/*/locations/{location}`.
            #   @param client_tls_policy_id [::String]
            #     Required. Short name of the ClientTlsPolicy resource to be created. This
            #     value should be 1-63 characters long, containing only letters, numbers,
            #     hyphens, and underscores, and should not start with a number. E.g.
            #     "client_mtls_policy".
            #   @param client_tls_policy [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy, ::Hash]
            #     Required. ClientTlsPolicy resource to be created.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest.new
            #
            #   # Call the create_client_tls_policy method.
            #   result = client.create_client_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_client_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::CreateClientTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_client_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_client_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_client_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :create_client_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ClientTlsPolicy.
            #
            # @overload update_client_tls_policy(request, options = nil)
            #   Pass arguments to `update_client_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_client_tls_policy(update_mask: nil, client_tls_policy: nil)
            #   Pass arguments to `update_client_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ClientTlsPolicy resource by the update.  The fields
            #     specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the
            #     mask. If the user does not provide a mask then all fields will be
            #     overwritten.
            #   @param client_tls_policy [::Google::Cloud::NetworkSecurity::V1beta1::ClientTlsPolicy, ::Hash]
            #     Required. Updated ClientTlsPolicy resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest.new
            #
            #   # Call the update_client_tls_policy method.
            #   result = client.update_client_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_client_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::UpdateClientTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_client_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.client_tls_policy&.name
                header_params["client_tls_policy.name"] = request.client_tls_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_client_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_client_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :update_client_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ClientTlsPolicy.
            #
            # @overload delete_client_tls_policy(request, options = nil)
            #   Pass arguments to `delete_client_tls_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_client_tls_policy(name: nil)
            #   Pass arguments to `delete_client_tls_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. A name of the ClientTlsPolicy to delete. Must be in
            #     the format `projects/*/locations/{location}/clientTlsPolicies/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest.new
            #
            #   # Call the delete_client_tls_policy method.
            #   result = client.delete_client_tls_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_client_tls_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::DeleteClientTlsPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_client_tls_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_client_tls_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_client_tls_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @network_security_stub.call_rpc :delete_client_tls_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the NetworkSecurity API.
            #
            # This class represents the configuration for NetworkSecurity,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_authorization_policies to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_authorization_policies.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_authorization_policies.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkSecurity::V1beta1::NetworkSecurity::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networksecurity.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the NetworkSecurity API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_authorization_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_authorization_policies
                ##
                # RPC-specific configuration for `get_authorization_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_authorization_policy
                ##
                # RPC-specific configuration for `create_authorization_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_authorization_policy
                ##
                # RPC-specific configuration for `update_authorization_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_authorization_policy
                ##
                # RPC-specific configuration for `delete_authorization_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_authorization_policy
                ##
                # RPC-specific configuration for `list_server_tls_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_server_tls_policies
                ##
                # RPC-specific configuration for `get_server_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_server_tls_policy
                ##
                # RPC-specific configuration for `create_server_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_server_tls_policy
                ##
                # RPC-specific configuration for `update_server_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_server_tls_policy
                ##
                # RPC-specific configuration for `delete_server_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_server_tls_policy
                ##
                # RPC-specific configuration for `list_client_tls_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_client_tls_policies
                ##
                # RPC-specific configuration for `get_client_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_client_tls_policy
                ##
                # RPC-specific configuration for `create_client_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_client_tls_policy
                ##
                # RPC-specific configuration for `update_client_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_client_tls_policy
                ##
                # RPC-specific configuration for `delete_client_tls_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_client_tls_policy

                # @private
                def initialize parent_rpcs = nil
                  list_authorization_policies_config = parent_rpcs.list_authorization_policies if parent_rpcs.respond_to? :list_authorization_policies
                  @list_authorization_policies = ::Gapic::Config::Method.new list_authorization_policies_config
                  get_authorization_policy_config = parent_rpcs.get_authorization_policy if parent_rpcs.respond_to? :get_authorization_policy
                  @get_authorization_policy = ::Gapic::Config::Method.new get_authorization_policy_config
                  create_authorization_policy_config = parent_rpcs.create_authorization_policy if parent_rpcs.respond_to? :create_authorization_policy
                  @create_authorization_policy = ::Gapic::Config::Method.new create_authorization_policy_config
                  update_authorization_policy_config = parent_rpcs.update_authorization_policy if parent_rpcs.respond_to? :update_authorization_policy
                  @update_authorization_policy = ::Gapic::Config::Method.new update_authorization_policy_config
                  delete_authorization_policy_config = parent_rpcs.delete_authorization_policy if parent_rpcs.respond_to? :delete_authorization_policy
                  @delete_authorization_policy = ::Gapic::Config::Method.new delete_authorization_policy_config
                  list_server_tls_policies_config = parent_rpcs.list_server_tls_policies if parent_rpcs.respond_to? :list_server_tls_policies
                  @list_server_tls_policies = ::Gapic::Config::Method.new list_server_tls_policies_config
                  get_server_tls_policy_config = parent_rpcs.get_server_tls_policy if parent_rpcs.respond_to? :get_server_tls_policy
                  @get_server_tls_policy = ::Gapic::Config::Method.new get_server_tls_policy_config
                  create_server_tls_policy_config = parent_rpcs.create_server_tls_policy if parent_rpcs.respond_to? :create_server_tls_policy
                  @create_server_tls_policy = ::Gapic::Config::Method.new create_server_tls_policy_config
                  update_server_tls_policy_config = parent_rpcs.update_server_tls_policy if parent_rpcs.respond_to? :update_server_tls_policy
                  @update_server_tls_policy = ::Gapic::Config::Method.new update_server_tls_policy_config
                  delete_server_tls_policy_config = parent_rpcs.delete_server_tls_policy if parent_rpcs.respond_to? :delete_server_tls_policy
                  @delete_server_tls_policy = ::Gapic::Config::Method.new delete_server_tls_policy_config
                  list_client_tls_policies_config = parent_rpcs.list_client_tls_policies if parent_rpcs.respond_to? :list_client_tls_policies
                  @list_client_tls_policies = ::Gapic::Config::Method.new list_client_tls_policies_config
                  get_client_tls_policy_config = parent_rpcs.get_client_tls_policy if parent_rpcs.respond_to? :get_client_tls_policy
                  @get_client_tls_policy = ::Gapic::Config::Method.new get_client_tls_policy_config
                  create_client_tls_policy_config = parent_rpcs.create_client_tls_policy if parent_rpcs.respond_to? :create_client_tls_policy
                  @create_client_tls_policy = ::Gapic::Config::Method.new create_client_tls_policy_config
                  update_client_tls_policy_config = parent_rpcs.update_client_tls_policy if parent_rpcs.respond_to? :update_client_tls_policy
                  @update_client_tls_policy = ::Gapic::Config::Method.new update_client_tls_policy_config
                  delete_client_tls_policy_config = parent_rpcs.delete_client_tls_policy if parent_rpcs.respond_to? :delete_client_tls_policy
                  @delete_client_tls_policy = ::Gapic::Config::Method.new delete_client_tls_policy_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
