# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networksecurity/v1beta1/dns_threat_detector_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkSecurity
      module V1beta1
        module DnsThreatDetectorService
          ##
          # Client for the DnsThreatDetectorService service.
          #
          # The Network Security API for DNS Threat Detectors.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networksecurity.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :dns_threat_detector_service_stub

            ##
            # Configure the DnsThreatDetectorService Client class.
            #
            # See {::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DnsThreatDetectorService clients
            #   ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkSecurity", "V1beta1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DnsThreatDetectorService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @dns_threat_detector_service_stub.universe_domain
            end

            ##
            # Create a new DnsThreatDetectorService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DnsThreatDetectorService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networksecurity/v1beta1/dns_threat_detector_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @dns_threat_detector_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @dns_threat_detector_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dns_threat_detector_service_stub.endpoint
                config.universe_domain = @dns_threat_detector_service_stub.universe_domain
                config.logger = @dns_threat_detector_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @dns_threat_detector_service_stub.endpoint
                config.universe_domain = @dns_threat_detector_service_stub.universe_domain
                config.logger = @dns_threat_detector_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @dns_threat_detector_service_stub.logger
            end

            # Service calls

            ##
            # Lists DnsThreatDetectors in a given project and location.
            #
            # @overload list_dns_threat_detectors(request, options = nil)
            #   Pass arguments to `list_dns_threat_detectors` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::ListDnsThreatDetectorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::ListDnsThreatDetectorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_dns_threat_detectors(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_dns_threat_detectors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent value for `ListDnsThreatDetectorsRequest`.
            #   @param page_size [::Integer]
            #     Optional. The requested page size. The server may return fewer items than
            #     requested. If unspecified, the server picks an appropriate default.
            #   @param page_token [::String]
            #     Optional. A page token received from a previous
            #     `ListDnsThreatDetectorsRequest` call. Provide this to retrieve the
            #     subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::ListDnsThreatDetectorsRequest.new
            #
            #   # Call the list_dns_threat_detectors method.
            #   result = client.list_dns_threat_detectors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector.
            #     p item
            #   end
            #
            def list_dns_threat_detectors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::ListDnsThreatDetectorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_dns_threat_detectors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_dns_threat_detectors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_dns_threat_detectors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dns_threat_detector_service_stub.call_rpc :list_dns_threat_detectors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @dns_threat_detector_service_stub, :list_dns_threat_detectors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a single DnsThreatDetector.
            #
            # @overload get_dns_threat_detector(request, options = nil)
            #   Pass arguments to `get_dns_threat_detector` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::GetDnsThreatDetectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::GetDnsThreatDetectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dns_threat_detector(name: nil)
            #   Pass arguments to `get_dns_threat_detector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the DnsThreatDetector resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::GetDnsThreatDetectorRequest.new
            #
            #   # Call the get_dns_threat_detector method.
            #   result = client.get_dns_threat_detector request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector.
            #   p result
            #
            def get_dns_threat_detector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::GetDnsThreatDetectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dns_threat_detector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dns_threat_detector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dns_threat_detector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dns_threat_detector_service_stub.call_rpc :get_dns_threat_detector, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new DnsThreatDetector in a given project and location.
            #
            # @overload create_dns_threat_detector(request, options = nil)
            #   Pass arguments to `create_dns_threat_detector` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::CreateDnsThreatDetectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::CreateDnsThreatDetectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_dns_threat_detector(parent: nil, dns_threat_detector_id: nil, dns_threat_detector: nil)
            #   Pass arguments to `create_dns_threat_detector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The value for the parent of the DnsThreatDetector resource.
            #   @param dns_threat_detector_id [::String]
            #     Optional. The ID of the requesting DnsThreatDetector object.
            #     If this field is not supplied, the service generates an identifier.
            #   @param dns_threat_detector [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector, ::Hash]
            #     Required. The `DnsThreatDetector` resource to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::CreateDnsThreatDetectorRequest.new
            #
            #   # Call the create_dns_threat_detector method.
            #   result = client.create_dns_threat_detector request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector.
            #   p result
            #
            def create_dns_threat_detector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::CreateDnsThreatDetectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_dns_threat_detector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_dns_threat_detector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_dns_threat_detector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dns_threat_detector_service_stub.call_rpc :create_dns_threat_detector, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a single DnsThreatDetector.
            #
            # @overload update_dns_threat_detector(request, options = nil)
            #   Pass arguments to `update_dns_threat_detector` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::UpdateDnsThreatDetectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::UpdateDnsThreatDetectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_dns_threat_detector(update_mask: nil, dns_threat_detector: nil)
            #   Pass arguments to `update_dns_threat_detector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The field mask is used to specify the fields to be overwritten in
            #     the DnsThreatDetector resource by the update. The fields specified in the
            #     update_mask are relative to the resource, not the full request. A field
            #     will be overwritten if it is in the mask. If the mask is not provided then
            #     all fields present in the request will be overwritten.
            #   @param dns_threat_detector [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector, ::Hash]
            #     Required. The DnsThreatDetector resource being updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::UpdateDnsThreatDetectorRequest.new
            #
            #   # Call the update_dns_threat_detector method.
            #   result = client.update_dns_threat_detector request
            #
            #   # The returned object is of type Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetector.
            #   p result
            #
            def update_dns_threat_detector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::UpdateDnsThreatDetectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_dns_threat_detector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.dns_threat_detector&.name
                header_params["dns_threat_detector.name"] = request.dns_threat_detector.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_dns_threat_detector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_dns_threat_detector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dns_threat_detector_service_stub.call_rpc :update_dns_threat_detector, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single DnsThreatDetector.
            #
            # @overload delete_dns_threat_detector(request, options = nil)
            #   Pass arguments to `delete_dns_threat_detector` via a request object, either of type
            #   {::Google::Cloud::NetworkSecurity::V1beta1::DeleteDnsThreatDetectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkSecurity::V1beta1::DeleteDnsThreatDetectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_dns_threat_detector(name: nil)
            #   Pass arguments to `delete_dns_threat_detector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the DnsThreatDetector resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_security/v1beta1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkSecurity::V1beta1::DeleteDnsThreatDetectorRequest.new
            #
            #   # Call the delete_dns_threat_detector method.
            #   result = client.delete_dns_threat_detector request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_dns_threat_detector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkSecurity::V1beta1::DeleteDnsThreatDetectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_dns_threat_detector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkSecurity::V1beta1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_dns_threat_detector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_dns_threat_detector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @dns_threat_detector_service_stub.call_rpc :delete_dns_threat_detector, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DnsThreatDetectorService API.
            #
            # This class represents the configuration for DnsThreatDetectorService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_dns_threat_detectors to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_dns_threat_detectors.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_dns_threat_detectors.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkSecurity::V1beta1::DnsThreatDetectorService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networksecurity.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DnsThreatDetectorService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_dns_threat_detectors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_dns_threat_detectors
                ##
                # RPC-specific configuration for `get_dns_threat_detector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dns_threat_detector
                ##
                # RPC-specific configuration for `create_dns_threat_detector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_dns_threat_detector
                ##
                # RPC-specific configuration for `update_dns_threat_detector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_dns_threat_detector
                ##
                # RPC-specific configuration for `delete_dns_threat_detector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_dns_threat_detector

                # @private
                def initialize parent_rpcs = nil
                  list_dns_threat_detectors_config = parent_rpcs.list_dns_threat_detectors if parent_rpcs.respond_to? :list_dns_threat_detectors
                  @list_dns_threat_detectors = ::Gapic::Config::Method.new list_dns_threat_detectors_config
                  get_dns_threat_detector_config = parent_rpcs.get_dns_threat_detector if parent_rpcs.respond_to? :get_dns_threat_detector
                  @get_dns_threat_detector = ::Gapic::Config::Method.new get_dns_threat_detector_config
                  create_dns_threat_detector_config = parent_rpcs.create_dns_threat_detector if parent_rpcs.respond_to? :create_dns_threat_detector
                  @create_dns_threat_detector = ::Gapic::Config::Method.new create_dns_threat_detector_config
                  update_dns_threat_detector_config = parent_rpcs.update_dns_threat_detector if parent_rpcs.respond_to? :update_dns_threat_detector
                  @update_dns_threat_detector = ::Gapic::Config::Method.new update_dns_threat_detector_config
                  delete_dns_threat_detector_config = parent_rpcs.delete_dns_threat_detector if parent_rpcs.respond_to? :delete_dns_threat_detector
                  @delete_dns_threat_detector = ::Gapic::Config::Method.new delete_dns_threat_detector_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
