# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networkmanagement/v1/vpc_flow_logs_pb"
require "google/cloud/network_management/v1/vpc_flow_logs_service"

class ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_vpc_flow_logs_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vpc_flow_logs_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vpc_flow_logs_configs, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vpc_flow_logs_configs_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vpc_flow_logs_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vpc_flow_logs_configs ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vpc_flow_logs_configs(::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vpc_flow_logs_configs_client_stub.call_rpc_count
    end
  end

  def test_get_vpc_flow_logs_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vpc_flow_logs_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vpc_flow_logs_config, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vpc_flow_logs_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vpc_flow_logs_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vpc_flow_logs_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vpc_flow_logs_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vpc_flow_logs_config_client_stub.call_rpc_count
    end
  end

  def test_create_vpc_flow_logs_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vpc_flow_logs_config_id = "hello world"
    vpc_flow_logs_config = {}

    create_vpc_flow_logs_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_vpc_flow_logs_config, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["vpc_flow_logs_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig), request["vpc_flow_logs_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_vpc_flow_logs_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_vpc_flow_logs_config({ parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_vpc_flow_logs_config parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest.new(parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_vpc_flow_logs_config({ parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest.new(parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_vpc_flow_logs_config_client_stub.call_rpc_count
    end
  end

  def test_update_vpc_flow_logs_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    vpc_flow_logs_config = {}

    update_vpc_flow_logs_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_vpc_flow_logs_config, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig), request["vpc_flow_logs_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_vpc_flow_logs_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_vpc_flow_logs_config({ update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_vpc_flow_logs_config update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest.new(update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_vpc_flow_logs_config({ update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest.new(update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_vpc_flow_logs_config_client_stub.call_rpc_count
    end
  end

  def test_delete_vpc_flow_logs_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_vpc_flow_logs_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_vpc_flow_logs_config, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_vpc_flow_logs_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_vpc_flow_logs_config({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_vpc_flow_logs_config name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_vpc_flow_logs_config({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_vpc_flow_logs_config_client_stub.call_rpc_count
    end
  end

  def test_query_org_vpc_flow_logs_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    query_org_vpc_flow_logs_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_org_vpc_flow_logs_configs, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_org_vpc_flow_logs_configs_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_org_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_org_vpc_flow_logs_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_org_vpc_flow_logs_configs ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_org_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_org_vpc_flow_logs_configs(::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_org_vpc_flow_logs_configs_client_stub.call_rpc_count
    end
  end

  def test_show_effective_flow_logs_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    resource = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    show_effective_flow_logs_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :show_effective_flow_logs_configs, name
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["resource"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, show_effective_flow_logs_configs_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.show_effective_flow_logs_configs({ parent: parent, resource: resource, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.show_effective_flow_logs_configs parent: parent, resource: resource, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.show_effective_flow_logs_configs ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest.new(parent: parent, resource: resource, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.show_effective_flow_logs_configs({ parent: parent, resource: resource, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.show_effective_flow_logs_configs(::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest.new(parent: parent, resource: resource, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, show_effective_flow_logs_configs_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Operations, client.operations_client
  end
end
