# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/networkmanagement/v1/vpc_flow_logs_pb"
require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/rest"


class ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_vpc_flow_logs_configs
    # Create test objects.
    client_result = ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vpc_flow_logs_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ServiceStub.stub :transcode_list_vpc_flow_logs_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_vpc_flow_logs_configs_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_vpc_flow_logs_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_vpc_flow_logs_configs ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_vpc_flow_logs_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_vpc_flow_logs_configs(::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_vpc_flow_logs_configs_client_stub.call_count
      end
    end
  end

  def test_get_vpc_flow_logs_config
    # Create test objects.
    client_result = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vpc_flow_logs_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ServiceStub.stub :transcode_get_vpc_flow_logs_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_vpc_flow_logs_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_vpc_flow_logs_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_vpc_flow_logs_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_vpc_flow_logs_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_vpc_flow_logs_config_client_stub.call_count
      end
    end
  end

  def test_create_vpc_flow_logs_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vpc_flow_logs_config_id = "hello world"
    vpc_flow_logs_config = {}

    create_vpc_flow_logs_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ServiceStub.stub :transcode_create_vpc_flow_logs_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_vpc_flow_logs_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_vpc_flow_logs_config({ parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_vpc_flow_logs_config parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest.new(parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_vpc_flow_logs_config({ parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest.new(parent: parent, vpc_flow_logs_config_id: vpc_flow_logs_config_id, vpc_flow_logs_config: vpc_flow_logs_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_vpc_flow_logs_config_client_stub.call_count
      end
    end
  end

  def test_update_vpc_flow_logs_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    vpc_flow_logs_config = {}

    update_vpc_flow_logs_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ServiceStub.stub :transcode_update_vpc_flow_logs_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_vpc_flow_logs_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_vpc_flow_logs_config({ update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_vpc_flow_logs_config update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest.new(update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_vpc_flow_logs_config({ update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest.new(update_mask: update_mask, vpc_flow_logs_config: vpc_flow_logs_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_vpc_flow_logs_config_client_stub.call_count
      end
    end
  end

  def test_delete_vpc_flow_logs_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_vpc_flow_logs_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::ServiceStub.stub :transcode_delete_vpc_flow_logs_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_vpc_flow_logs_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_vpc_flow_logs_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_vpc_flow_logs_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_vpc_flow_logs_config ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_vpc_flow_logs_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_vpc_flow_logs_config(::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_vpc_flow_logs_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client::Configuration, config
  end
end
