# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkManagement
      module V1
        # Request for the `ListConnectivityTests` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the Connectivity Tests:
        #         `projects/{project_id}/locations/global`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Number of `ConnectivityTests` to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token from an earlier query, as returned in `next_page_token`.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the `ConnectivityTests` that match the filter expression. A filter
        #     expression filters the resources listed in the response. The expression
        #     must be of the form `<field> <operator> <value>` where operators: `<`, `>`,
        #     `<=`,
        #     `>=`,
        #     `!=`, `=`, `:` are supported (colon `:` represents a HAS operator which is
        #     roughly synonymous with equality). <field> can refer to a proto or JSON
        #     field, or a synthetic field. Field names can be camelCase or snake_case.
        #
        #     Examples:
        #     - Filter by name:
        #       name = "projects/proj-1/locations/global/connectivityTests/test-1
        #
        #     - Filter by labels:
        #       - Resources that have a key called `foo`
        #         labels.foo:*
        #       - Resources that have a key called `foo` whose value is `bar`
        #         labels.foo = bar
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        class ListConnectivityTestsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the `ListConnectivityTests` method.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::NetworkManagement::V1::ConnectivityTest>]
        #     List of Connectivity Tests.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Page token to fetch the next set of Connectivity Tests.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached (when querying all locations with `-`).
        class ListConnectivityTestsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `GetConnectivityTest` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. `ConnectivityTest` resource name using the form:
        #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
        class GetConnectivityTestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `CreateConnectivityTest` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource of the Connectivity Test to create:
        #         `projects/{project_id}/locations/global`
        # @!attribute [rw] test_id
        #   @return [::String]
        #     Required. The logical name of the Connectivity Test in your project
        #     with the following restrictions:
        #
        #     * Must contain only lowercase letters, numbers, and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-40 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the customer project
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::NetworkManagement::V1::ConnectivityTest]
        #     Required. A `ConnectivityTest` resource
        class CreateConnectivityTestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `UpdateConnectivityTest` method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update. At least one path must be supplied in
        #     this field.
        # @!attribute [rw] resource
        #   @return [::Google::Cloud::NetworkManagement::V1::ConnectivityTest]
        #     Required. Only fields specified in update_mask are updated.
        class UpdateConnectivityTestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `DeleteConnectivityTest` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Connectivity Test resource name using the form:
        #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
        class DeleteConnectivityTestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the `RerunConnectivityTest` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Connectivity Test resource name using the form:
        #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
        class RerunConnectivityTestRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata describing an {::Google::Longrunning::Operation Operation}
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] target
        #   @return [::String]
        #     Target of the operation - for example
        #     projects/project-1/locations/global/connectivityTests/test-1
        # @!attribute [rw] verb
        #   @return [::String]
        #     Name of the verb executed by the operation.
        # @!attribute [rw] status_detail
        #   @return [::String]
        #     Human-readable status of the operation, if any.
        # @!attribute [rw] cancel_requested
        #   @return [::Boolean]
        #     Specifies if cancellation was requested for the operation.
        # @!attribute [rw] api_version
        #   @return [::String]
        #     API version.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
