# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/networkmanagement/v1/vpc_flow_logs.proto for package 'Google.Cloud.NetworkManagement.V1'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/networkmanagement/v1/vpc_flow_logs_pb'

module Google
  module Cloud
    module NetworkManagement
      module V1
        module VpcFlowLogsService
          # The VPC Flow Logs service in the Google Cloud Network Management API provides
          # configurations that generate Flow Logs. The service and the configuration
          # resources created using this service are global.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.networkmanagement.v1.VpcFlowLogsService'

            # Lists all `VpcFlowLogsConfigs` in a given project.
            rpc :ListVpcFlowLogsConfigs, ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest, ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsResponse
            # Gets the details of a specific `VpcFlowLogsConfig`.
            rpc :GetVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest, ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig
            # Creates a new `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Creating a configuration with `state=DISABLED` will fail
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - creating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            rpc :CreateVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
            # Updates an existing `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Updating a configuration with `state=DISABLED` will fail.
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - updating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            rpc :UpdateVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
            # Deletes a specific `VpcFlowLogsConfig`.
            rpc :DeleteVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
            # QueryOrgVpcFlowLogsConfigs returns a list of all organization-level VPC
            # Flow Logs configurations applicable to the specified project.
            rpc :QueryOrgVpcFlowLogsConfigs, ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest, ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsResponse
            # ShowEffectiveFlowLogsConfigs returns a list of all VPC Flow Logs
            # configurations applicable to a specified resource.
            rpc :ShowEffectiveFlowLogsConfigs, ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest, ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsResponse
          end

          Stub = Service.rpc_stub_class
        end
        module OrganizationVpcFlowLogsService
          # The VPC Flow Logs organization service in the Google Cloud Network Management
          # API provides organization level configurations that generate Flow Logs. The
          # service and the configuration resources created using this service are
          # global.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.networkmanagement.v1.OrganizationVpcFlowLogsService'

            # Lists all `VpcFlowLogsConfigs` in a given organization.
            rpc :ListVpcFlowLogsConfigs, ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest, ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsResponse
            # Gets the details of a specific `VpcFlowLogsConfig`.
            rpc :GetVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest, ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig
            # Creates a new `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Creating a configuration with `state=DISABLED` will fail
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - creating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            rpc :CreateVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
            # Updates an existing `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Updating a configuration with `state=DISABLED` will fail
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - updating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            rpc :UpdateVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
            # Deletes a specific `VpcFlowLogsConfig`.
            rpc :DeleteVpcFlowLogsConfig, ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
