# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/networkmanagement/v1/reachability.proto for package 'Google.Cloud.NetworkManagement.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/networkmanagement/v1/reachability_pb'

module Google
  module Cloud
    module NetworkManagement
      module V1
        module ReachabilityService
          # The Reachability service in Google Cloud Network Management API
          #
          # The Reachability service in the Google Cloud Network Management API provides
          # services that analyze the reachability within a single Google Virtual Private
          # Cloud (VPC) network, between peered VPC networks, between VPC and on-premises
          # networks, or between VPC networks and internet hosts. A reachability analysis
          # is based on Google Cloud network configurations.
          #
          # You can use the analysis results to verify these configurations and
          # to troubleshoot connectivity issues.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.networkmanagement.v1.ReachabilityService'

            # Lists all Connectivity Tests owned by a project.
            rpc :ListConnectivityTests, ::Google::Cloud::NetworkManagement::V1::ListConnectivityTestsRequest, ::Google::Cloud::NetworkManagement::V1::ListConnectivityTestsResponse
            # Gets the details of a specific Connectivity Test.
            rpc :GetConnectivityTest, ::Google::Cloud::NetworkManagement::V1::GetConnectivityTestRequest, ::Google::Cloud::NetworkManagement::V1::ConnectivityTest
            # Creates a new Connectivity Test.
            # After you create a test, the reachability analysis is performed as part
            # of the long running operation, which completes when the analysis completes.
            #
            # If the endpoint specifications in `ConnectivityTest` are invalid
            # (for example, containing non-existent resources in the network, or you
            # don't have read permissions to the network configurations of listed
            # projects), then the reachability result returns a value of `UNKNOWN`.
            #
            # If the endpoint specifications in `ConnectivityTest` are
            # incomplete, the reachability result returns a value of
            # <code>AMBIGUOUS</code>. For more information,
            # see the Connectivity Test documentation.
            rpc :CreateConnectivityTest, ::Google::Cloud::NetworkManagement::V1::CreateConnectivityTestRequest, ::Google::Longrunning::Operation
            # Updates the configuration of an existing `ConnectivityTest`.
            # After you update a test, the reachability analysis is performed as part
            # of the long running operation, which completes when the analysis completes.
            # The Reachability state in the test resource is updated with the new result.
            #
            # If the endpoint specifications in `ConnectivityTest` are invalid
            # (for example, they contain non-existent resources in the network, or the
            # user does not have read permissions to the network configurations of
            # listed projects), then the reachability result returns a value of
            # <code>UNKNOWN</code>.
            #
            # If the endpoint specifications in `ConnectivityTest` are incomplete, the
            # reachability result returns a value of `AMBIGUOUS`. See the documentation
            # in `ConnectivityTest` for more details.
            rpc :UpdateConnectivityTest, ::Google::Cloud::NetworkManagement::V1::UpdateConnectivityTestRequest, ::Google::Longrunning::Operation
            # Rerun an existing `ConnectivityTest`.
            # After the user triggers the rerun, the reachability analysis is performed
            # as part of the long running operation, which completes when the analysis
            # completes.
            #
            # Even though the test configuration remains the same, the reachability
            # result may change due to underlying network configuration changes.
            #
            # If the endpoint specifications in `ConnectivityTest` become invalid (for
            # example, specified resources are deleted in the network, or you lost
            # read permissions to the network configurations of listed projects), then
            # the reachability result returns a value of `UNKNOWN`.
            rpc :RerunConnectivityTest, ::Google::Cloud::NetworkManagement::V1::RerunConnectivityTestRequest, ::Google::Longrunning::Operation
            # Deletes a specific `ConnectivityTest`.
            rpc :DeleteConnectivityTest, ::Google::Cloud::NetworkManagement::V1::DeleteConnectivityTestRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
