# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkManagement
      module V1
        module VpcFlowLogsService
          # Path helper methods for the VpcFlowLogsService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified OrganizationLocation resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/locations/{location}`
            #
            # @param organization [String]
            # @param location [String]
            #
            # @return [::String]
            def organization_location_path organization:, location:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/locations/#{location}"
            end

            ##
            # Create a fully-qualified VpcFlowLogsConfig resource string.
            #
            # @overload vpc_flow_logs_config_path(project:, location:, vpc_flow_logs_config:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/locations/{location}/vpcFlowLogsConfigs/{vpc_flow_logs_config}`
            #
            #   @param project [String]
            #   @param location [String]
            #   @param vpc_flow_logs_config [String]
            #
            # @overload vpc_flow_logs_config_path(organization:, location:, vpc_flow_logs_config:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/locations/{location}/vpcFlowLogsConfigs/{vpc_flow_logs_config}`
            #
            #   @param organization [String]
            #   @param location [String]
            #   @param vpc_flow_logs_config [String]
            #
            # @return [::String]
            def vpc_flow_logs_config_path **args
              resources = {
                "location:project:vpc_flow_logs_config" => (proc do |project:, location:, vpc_flow_logs_config:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "projects/#{project}/locations/#{location}/vpcFlowLogsConfigs/#{vpc_flow_logs_config}"
                end),
                "location:organization:vpc_flow_logs_config" => (proc do |organization:, location:, vpc_flow_logs_config:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

                  "organizations/#{organization}/locations/#{location}/vpcFlowLogsConfigs/#{vpc_flow_logs_config}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
