# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkmanagement/v1/vpc_flow_logs_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkManagement
      module V1
        module VpcFlowLogsService
          ##
          # Client for the VpcFlowLogsService service.
          #
          # The VPC Flow Logs service in the Google Cloud Network Management API provides
          # configurations that generate Flow Logs. The service and the configuration
          # resources created using this service are global.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networkmanagement.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :vpc_flow_logs_service_stub

            ##
            # Configure the VpcFlowLogsService Client class.
            #
            # See {::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all VpcFlowLogsService clients
            #   ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkManagement", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the VpcFlowLogsService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @vpc_flow_logs_service_stub.universe_domain
            end

            ##
            # Create a new VpcFlowLogsService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the VpcFlowLogsService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networkmanagement/v1/vpc_flow_logs_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @vpc_flow_logs_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @vpc_flow_logs_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @vpc_flow_logs_service_stub.endpoint
                config.universe_domain = @vpc_flow_logs_service_stub.universe_domain
                config.logger = @vpc_flow_logs_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @vpc_flow_logs_service_stub.endpoint
                config.universe_domain = @vpc_flow_logs_service_stub.universe_domain
                config.logger = @vpc_flow_logs_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @vpc_flow_logs_service_stub.logger
            end

            # Service calls

            ##
            # Lists all `VpcFlowLogsConfigs` in a given project.
            #
            # @overload list_vpc_flow_logs_configs(request, options = nil)
            #   Pass arguments to `list_vpc_flow_logs_configs` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_vpc_flow_logs_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_vpc_flow_logs_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the VpcFlowLogsConfig,
            #     in one of the following formats:
            #
            #     - For project-level resourcs: `projects/{project_id}/locations/global`
            #
            #     - For organization-level resources:
            #     `organizations/{organization_id}/locations/global`
            #   @param page_size [::Integer]
            #     Optional. Number of `VpcFlowLogsConfigs` to return.
            #   @param page_token [::String]
            #     Optional. Page token from an earlier query, as returned in
            #     `next_page_token`.
            #   @param filter [::String]
            #     Optional. Lists the `VpcFlowLogsConfigs` that match the filter expression.
            #     A filter expression must use the supported [CEL logic operators]
            #     (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
            #   @param order_by [::String]
            #     Optional. Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest.new
            #
            #   # Call the list_vpc_flow_logs_configs method.
            #   result = client.list_vpc_flow_logs_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig.
            #     p item
            #   end
            #
            def list_vpc_flow_logs_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::ListVpcFlowLogsConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_vpc_flow_logs_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_vpc_flow_logs_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_vpc_flow_logs_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :list_vpc_flow_logs_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vpc_flow_logs_service_stub, :list_vpc_flow_logs_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific `VpcFlowLogsConfig`.
            #
            # @overload get_vpc_flow_logs_config(request, options = nil)
            #   Pass arguments to `get_vpc_flow_logs_config` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_vpc_flow_logs_config(name: nil)
            #   Pass arguments to `get_vpc_flow_logs_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the VpcFlowLogsConfig,
            #     in one of the following formats:
            #
            #     - For project-level resources:
            #     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
            #
            #     - For organization-level resources:
            #     `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest.new
            #
            #   # Call the get_vpc_flow_logs_config method.
            #   result = client.get_vpc_flow_logs_config request
            #
            #   # The returned object is of type Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig.
            #   p result
            #
            def get_vpc_flow_logs_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::GetVpcFlowLogsConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_vpc_flow_logs_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_vpc_flow_logs_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_vpc_flow_logs_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :get_vpc_flow_logs_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Creating a configuration with `state=DISABLED` will fail
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - creating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            #
            # @overload create_vpc_flow_logs_config(request, options = nil)
            #   Pass arguments to `create_vpc_flow_logs_config` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_vpc_flow_logs_config(parent: nil, vpc_flow_logs_config_id: nil, vpc_flow_logs_config: nil)
            #   Pass arguments to `create_vpc_flow_logs_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the VpcFlowLogsConfig to create,
            #     in one of the following formats:
            #
            #     - For project-level resources: `projects/{project_id}/locations/global`
            #
            #     - For organization-level resources:
            #     `organizations/{organization_id}/locations/global`
            #   @param vpc_flow_logs_config_id [::String]
            #     Required. ID of the `VpcFlowLogsConfig`.
            #   @param vpc_flow_logs_config [::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig, ::Hash]
            #     Required. A `VpcFlowLogsConfig` resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest.new
            #
            #   # Call the create_vpc_flow_logs_config method.
            #   result = client.create_vpc_flow_logs_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_vpc_flow_logs_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::CreateVpcFlowLogsConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_vpc_flow_logs_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_vpc_flow_logs_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_vpc_flow_logs_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :create_vpc_flow_logs_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing `VpcFlowLogsConfig`.
            # If a configuration with the exact same settings already exists (even if the
            # ID is different), the creation fails.
            # Notes:
            #
            #   1. Updating a configuration with `state=DISABLED` will fail.
            #   2. The following fields are not considered as settings for the purpose
            #   of the check mentioned above, therefore - updating another configuration
            #   with the same fields but different values for the following fields will
            #   fail as well:
            #       * name
            #       * create_time
            #       * update_time
            #       * labels
            #       * description
            #
            # @overload update_vpc_flow_logs_config(request, options = nil)
            #   Pass arguments to `update_vpc_flow_logs_config` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_vpc_flow_logs_config(update_mask: nil, vpc_flow_logs_config: nil)
            #   Pass arguments to `update_vpc_flow_logs_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field.
            #     For example, to change the state of the configuration to ENABLED, specify
            #       `update_mask` = `"state"`, and the `vpc_flow_logs_config` would be:
            #       `vpc_flow_logs_config = {
            #         name =
            #         "projects/my-project/locations/global/vpcFlowLogsConfigs/my-config"
            #         state = "ENABLED" }`
            #   @param vpc_flow_logs_config [::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig, ::Hash]
            #     Required. Only fields specified in update_mask are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest.new
            #
            #   # Call the update_vpc_flow_logs_config method.
            #   result = client.update_vpc_flow_logs_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_vpc_flow_logs_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::UpdateVpcFlowLogsConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_vpc_flow_logs_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.vpc_flow_logs_config&.name
                header_params["vpc_flow_logs_config.name"] = request.vpc_flow_logs_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_vpc_flow_logs_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_vpc_flow_logs_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :update_vpc_flow_logs_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific `VpcFlowLogsConfig`.
            #
            # @overload delete_vpc_flow_logs_config(request, options = nil)
            #   Pass arguments to `delete_vpc_flow_logs_config` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_vpc_flow_logs_config(name: nil)
            #   Pass arguments to `delete_vpc_flow_logs_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the VpcFlowLogsConfig,
            #     in one of the following formats:
            #
            #     - For a project-level resource:
            #     `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
            #
            #     - For an organization-level resource:
            #     `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest.new
            #
            #   # Call the delete_vpc_flow_logs_config method.
            #   result = client.delete_vpc_flow_logs_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_vpc_flow_logs_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::DeleteVpcFlowLogsConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_vpc_flow_logs_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_vpc_flow_logs_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_vpc_flow_logs_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :delete_vpc_flow_logs_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # QueryOrgVpcFlowLogsConfigs returns a list of all organization-level VPC
            # Flow Logs configurations applicable to the specified project.
            #
            # @overload query_org_vpc_flow_logs_configs(request, options = nil)
            #   Pass arguments to `query_org_vpc_flow_logs_configs` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload query_org_vpc_flow_logs_configs(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `query_org_vpc_flow_logs_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the VpcFlowLogsConfig, specified in
            #     the following format: `projects/{project_id}/locations/global`
            #   @param page_size [::Integer]
            #     Optional. Number of `VpcFlowLogsConfigs` to return.
            #   @param page_token [::String]
            #     Optional. Page token from an earlier query, as returned in
            #     `next_page_token`.
            #   @param filter [::String]
            #     Optional. Lists the `VpcFlowLogsConfigs` that match the filter expression.
            #     A filter expression must use the supported [CEL logic operators]
            #     (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest.new
            #
            #   # Call the query_org_vpc_flow_logs_configs method.
            #   result = client.query_org_vpc_flow_logs_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsConfig.
            #     p item
            #   end
            #
            def query_org_vpc_flow_logs_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::QueryOrgVpcFlowLogsConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.query_org_vpc_flow_logs_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.query_org_vpc_flow_logs_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.query_org_vpc_flow_logs_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :query_org_vpc_flow_logs_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vpc_flow_logs_service_stub, :query_org_vpc_flow_logs_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # ShowEffectiveFlowLogsConfigs returns a list of all VPC Flow Logs
            # configurations applicable to a specified resource.
            #
            # @overload show_effective_flow_logs_configs(request, options = nil)
            #   Pass arguments to `show_effective_flow_logs_configs` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload show_effective_flow_logs_configs(parent: nil, resource: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `show_effective_flow_logs_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the VpcFlowLogsConfig, specified in
            #     the following format: `projects/{project_id}/locations/global`
            #   @param resource [::String]
            #     Required. The resource to get the effective VPC Flow Logs configuration
            #     for. The resource must belong to the same project as the parent. The
            #     resource must be a network, subnetwork, interconnect attachment, VPN
            #     tunnel, or a project.
            #   @param page_size [::Integer]
            #     Optional. Number of `EffectiveVpcFlowLogsConfigs` to return. Default is 30.
            #   @param page_token [::String]
            #     Optional. Page token from an earlier query, as returned in
            #     `next_page_token`.
            #   @param filter [::String]
            #     Optional. Lists the `EffectiveVpcFlowLogsConfigs` that match the filter
            #     expression. A filter expression must use the supported [CEL logic
            #     operators]
            #     (https://cloud.google.com/vpc/docs/about-flow-logs-records#supported_cel_logic_operators).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::EffectiveVpcFlowLogsConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::EffectiveVpcFlowLogsConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest.new
            #
            #   # Call the show_effective_flow_logs_configs method.
            #   result = client.show_effective_flow_logs_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkManagement::V1::EffectiveVpcFlowLogsConfig.
            #     p item
            #   end
            #
            def show_effective_flow_logs_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::ShowEffectiveFlowLogsConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.show_effective_flow_logs_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.show_effective_flow_logs_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.show_effective_flow_logs_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vpc_flow_logs_service_stub.call_rpc :show_effective_flow_logs_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vpc_flow_logs_service_stub, :show_effective_flow_logs_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the VpcFlowLogsService API.
            #
            # This class represents the configuration for VpcFlowLogsService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_vpc_flow_logs_configs to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_vpc_flow_logs_configs.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_vpc_flow_logs_configs.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networkmanagement.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the VpcFlowLogsService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_vpc_flow_logs_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_vpc_flow_logs_configs
                ##
                # RPC-specific configuration for `get_vpc_flow_logs_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_vpc_flow_logs_config
                ##
                # RPC-specific configuration for `create_vpc_flow_logs_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_vpc_flow_logs_config
                ##
                # RPC-specific configuration for `update_vpc_flow_logs_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_vpc_flow_logs_config
                ##
                # RPC-specific configuration for `delete_vpc_flow_logs_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_vpc_flow_logs_config
                ##
                # RPC-specific configuration for `query_org_vpc_flow_logs_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :query_org_vpc_flow_logs_configs
                ##
                # RPC-specific configuration for `show_effective_flow_logs_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :show_effective_flow_logs_configs

                # @private
                def initialize parent_rpcs = nil
                  list_vpc_flow_logs_configs_config = parent_rpcs.list_vpc_flow_logs_configs if parent_rpcs.respond_to? :list_vpc_flow_logs_configs
                  @list_vpc_flow_logs_configs = ::Gapic::Config::Method.new list_vpc_flow_logs_configs_config
                  get_vpc_flow_logs_config_config = parent_rpcs.get_vpc_flow_logs_config if parent_rpcs.respond_to? :get_vpc_flow_logs_config
                  @get_vpc_flow_logs_config = ::Gapic::Config::Method.new get_vpc_flow_logs_config_config
                  create_vpc_flow_logs_config_config = parent_rpcs.create_vpc_flow_logs_config if parent_rpcs.respond_to? :create_vpc_flow_logs_config
                  @create_vpc_flow_logs_config = ::Gapic::Config::Method.new create_vpc_flow_logs_config_config
                  update_vpc_flow_logs_config_config = parent_rpcs.update_vpc_flow_logs_config if parent_rpcs.respond_to? :update_vpc_flow_logs_config
                  @update_vpc_flow_logs_config = ::Gapic::Config::Method.new update_vpc_flow_logs_config_config
                  delete_vpc_flow_logs_config_config = parent_rpcs.delete_vpc_flow_logs_config if parent_rpcs.respond_to? :delete_vpc_flow_logs_config
                  @delete_vpc_flow_logs_config = ::Gapic::Config::Method.new delete_vpc_flow_logs_config_config
                  query_org_vpc_flow_logs_configs_config = parent_rpcs.query_org_vpc_flow_logs_configs if parent_rpcs.respond_to? :query_org_vpc_flow_logs_configs
                  @query_org_vpc_flow_logs_configs = ::Gapic::Config::Method.new query_org_vpc_flow_logs_configs_config
                  show_effective_flow_logs_configs_config = parent_rpcs.show_effective_flow_logs_configs if parent_rpcs.respond_to? :show_effective_flow_logs_configs
                  @show_effective_flow_logs_configs = ::Gapic::Config::Method.new show_effective_flow_logs_configs_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
