# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/network_management/v1/version"

require "google/cloud/network_management/v1/vpc_flow_logs_service/credentials"
require "google/cloud/network_management/v1/vpc_flow_logs_service/paths"
require "google/cloud/network_management/v1/vpc_flow_logs_service/operations"
require "google/cloud/network_management/v1/vpc_flow_logs_service/client"
require "google/cloud/network_management/v1/vpc_flow_logs_service/rest"

module Google
  module Cloud
    module NetworkManagement
      module V1
        ##
        # The VPC Flow Logs service in the Google Cloud Network Management API provides
        # configurations that generate Flow Logs. The service and the configuration
        # resources created using this service are global.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/network_management/v1/vpc_flow_logs_service"
        #     client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/network_management/v1/vpc_flow_logs_service/rest"
        #     client = ::Google::Cloud::NetworkManagement::V1::VpcFlowLogsService::Rest::Client.new
        #
        module VpcFlowLogsService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "vpc_flow_logs_service", "helpers.rb"
require "google/cloud/network_management/v1/vpc_flow_logs_service/helpers" if ::File.file? helper_path
