# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkmanagement/v1/reachability_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkManagement
      module V1
        module ReachabilityService
          ##
          # Client for the ReachabilityService service.
          #
          # The Reachability service in the Google Cloud Network Management API provides
          # services that analyze the reachability within a single Google Virtual Private
          # Cloud (VPC) network, between peered VPC networks, between VPC and on-premises
          # networks, or between VPC networks and internet hosts. A reachability analysis
          # is based on Google Cloud network configurations.
          #
          # You can use the analysis results to verify these configurations and
          # to troubleshoot connectivity issues.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networkmanagement.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :reachability_service_stub

            ##
            # Configure the ReachabilityService Client class.
            #
            # See {::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ReachabilityService clients
            #   ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkManagement", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ReachabilityService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @reachability_service_stub.universe_domain
            end

            ##
            # Create a new ReachabilityService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ReachabilityService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networkmanagement/v1/reachability_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @reachability_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @reachability_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @reachability_service_stub.endpoint
                config.universe_domain = @reachability_service_stub.universe_domain
                config.logger = @reachability_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @reachability_service_stub.endpoint
                config.universe_domain = @reachability_service_stub.universe_domain
                config.logger = @reachability_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkManagement::V1::ReachabilityService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @reachability_service_stub.logger
            end

            # Service calls

            ##
            # Lists all Connectivity Tests owned by a project.
            #
            # @overload list_connectivity_tests(request, options = nil)
            #   Pass arguments to `list_connectivity_tests` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::ListConnectivityTestsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::ListConnectivityTestsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_connectivity_tests(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_connectivity_tests` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the Connectivity Tests:
            #         `projects/{project_id}/locations/global`
            #   @param page_size [::Integer]
            #     Number of `ConnectivityTests` to return.
            #   @param page_token [::String]
            #     Page token from an earlier query, as returned in `next_page_token`.
            #   @param filter [::String]
            #     Lists the `ConnectivityTests` that match the filter expression. A filter
            #     expression filters the resources listed in the response. The expression
            #     must be of the form `<field> <operator> <value>` where operators: `<`, `>`,
            #     `<=`,
            #     `>=`,
            #     `!=`, `=`, `:` are supported (colon `:` represents a HAS operator which is
            #     roughly synonymous with equality). <field> can refer to a proto or JSON
            #     field, or a synthetic field. Field names can be camelCase or snake_case.
            #
            #     Examples:
            #     - Filter by name:
            #       name = "projects/proj-1/locations/global/connectivityTests/test-1
            #
            #     - Filter by labels:
            #       - Resources that have a key called `foo`
            #         labels.foo:*
            #       - Resources that have a key called `foo` whose value is `bar`
            #         labels.foo = bar
            #   @param order_by [::String]
            #     Field to use to sort the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::ConnectivityTest>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkManagement::V1::ConnectivityTest>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::ListConnectivityTestsRequest.new
            #
            #   # Call the list_connectivity_tests method.
            #   result = client.list_connectivity_tests request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkManagement::V1::ConnectivityTest.
            #     p item
            #   end
            #
            def list_connectivity_tests request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::ListConnectivityTestsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_connectivity_tests.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_connectivity_tests.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_connectivity_tests.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :list_connectivity_tests, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @reachability_service_stub, :list_connectivity_tests, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific Connectivity Test.
            #
            # @overload get_connectivity_test(request, options = nil)
            #   Pass arguments to `get_connectivity_test` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::GetConnectivityTestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::GetConnectivityTestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_connectivity_test(name: nil)
            #   Pass arguments to `get_connectivity_test` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. `ConnectivityTest` resource name using the form:
            #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkManagement::V1::ConnectivityTest]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkManagement::V1::ConnectivityTest]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::GetConnectivityTestRequest.new
            #
            #   # Call the get_connectivity_test method.
            #   result = client.get_connectivity_test request
            #
            #   # The returned object is of type Google::Cloud::NetworkManagement::V1::ConnectivityTest.
            #   p result
            #
            def get_connectivity_test request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::GetConnectivityTestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_connectivity_test.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_connectivity_test.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_connectivity_test.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :get_connectivity_test, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Connectivity Test.
            # After you create a test, the reachability analysis is performed as part
            # of the long running operation, which completes when the analysis completes.
            #
            # If the endpoint specifications in `ConnectivityTest` are invalid
            # (for example, containing non-existent resources in the network, or you
            # don't have read permissions to the network configurations of listed
            # projects), then the reachability result returns a value of `UNKNOWN`.
            #
            # If the endpoint specifications in `ConnectivityTest` are
            # incomplete, the reachability result returns a value of
            # <code>AMBIGUOUS</code>. For more information,
            # see the Connectivity Test documentation.
            #
            # @overload create_connectivity_test(request, options = nil)
            #   Pass arguments to `create_connectivity_test` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::CreateConnectivityTestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::CreateConnectivityTestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_connectivity_test(parent: nil, test_id: nil, resource: nil)
            #   Pass arguments to `create_connectivity_test` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource of the Connectivity Test to create:
            #         `projects/{project_id}/locations/global`
            #   @param test_id [::String]
            #     Required. The logical name of the Connectivity Test in your project
            #     with the following restrictions:
            #
            #     * Must contain only lowercase letters, numbers, and hyphens.
            #     * Must start with a letter.
            #     * Must be between 1-40 characters.
            #     * Must end with a number or a letter.
            #     * Must be unique within the customer project
            #   @param resource [::Google::Cloud::NetworkManagement::V1::ConnectivityTest, ::Hash]
            #     Required. A `ConnectivityTest` resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::CreateConnectivityTestRequest.new
            #
            #   # Call the create_connectivity_test method.
            #   result = client.create_connectivity_test request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_connectivity_test request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::CreateConnectivityTestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_connectivity_test.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_connectivity_test.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_connectivity_test.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :create_connectivity_test, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the configuration of an existing `ConnectivityTest`.
            # After you update a test, the reachability analysis is performed as part
            # of the long running operation, which completes when the analysis completes.
            # The Reachability state in the test resource is updated with the new result.
            #
            # If the endpoint specifications in `ConnectivityTest` are invalid
            # (for example, they contain non-existent resources in the network, or the
            # user does not have read permissions to the network configurations of
            # listed projects), then the reachability result returns a value of
            # <code>UNKNOWN</code>.
            #
            # If the endpoint specifications in `ConnectivityTest` are incomplete, the
            # reachability result returns a value of `AMBIGUOUS`. See the documentation
            # in `ConnectivityTest` for more details.
            #
            # @overload update_connectivity_test(request, options = nil)
            #   Pass arguments to `update_connectivity_test` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::UpdateConnectivityTestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::UpdateConnectivityTestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_connectivity_test(update_mask: nil, resource: nil)
            #   Pass arguments to `update_connectivity_test` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field.
            #   @param resource [::Google::Cloud::NetworkManagement::V1::ConnectivityTest, ::Hash]
            #     Required. Only fields specified in update_mask are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::UpdateConnectivityTestRequest.new
            #
            #   # Call the update_connectivity_test method.
            #   result = client.update_connectivity_test request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_connectivity_test request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::UpdateConnectivityTestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_connectivity_test.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.resource&.name
                header_params["resource.name"] = request.resource.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_connectivity_test.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_connectivity_test.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :update_connectivity_test, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rerun an existing `ConnectivityTest`.
            # After the user triggers the rerun, the reachability analysis is performed
            # as part of the long running operation, which completes when the analysis
            # completes.
            #
            # Even though the test configuration remains the same, the reachability
            # result may change due to underlying network configuration changes.
            #
            # If the endpoint specifications in `ConnectivityTest` become invalid (for
            # example, specified resources are deleted in the network, or you lost
            # read permissions to the network configurations of listed projects), then
            # the reachability result returns a value of `UNKNOWN`.
            #
            # @overload rerun_connectivity_test(request, options = nil)
            #   Pass arguments to `rerun_connectivity_test` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::RerunConnectivityTestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::RerunConnectivityTestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rerun_connectivity_test(name: nil)
            #   Pass arguments to `rerun_connectivity_test` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Connectivity Test resource name using the form:
            #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::RerunConnectivityTestRequest.new
            #
            #   # Call the rerun_connectivity_test method.
            #   result = client.rerun_connectivity_test request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def rerun_connectivity_test request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::RerunConnectivityTestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rerun_connectivity_test.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rerun_connectivity_test.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rerun_connectivity_test.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :rerun_connectivity_test, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a specific `ConnectivityTest`.
            #
            # @overload delete_connectivity_test(request, options = nil)
            #   Pass arguments to `delete_connectivity_test` via a request object, either of type
            #   {::Google::Cloud::NetworkManagement::V1::DeleteConnectivityTestRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkManagement::V1::DeleteConnectivityTestRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_connectivity_test(name: nil)
            #   Pass arguments to `delete_connectivity_test` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Connectivity Test resource name using the form:
            #         `projects/{project_id}/locations/global/connectivityTests/{test_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_management/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkManagement::V1::DeleteConnectivityTestRequest.new
            #
            #   # Call the delete_connectivity_test method.
            #   result = client.delete_connectivity_test request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_connectivity_test request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkManagement::V1::DeleteConnectivityTestRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_connectivity_test.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkManagement::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_connectivity_test.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_connectivity_test.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @reachability_service_stub.call_rpc :delete_connectivity_test, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ReachabilityService API.
            #
            # This class represents the configuration for ReachabilityService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_connectivity_tests to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_connectivity_tests.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_connectivity_tests.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkManagement::V1::ReachabilityService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networkmanagement.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ReachabilityService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_connectivity_tests`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_connectivity_tests
                ##
                # RPC-specific configuration for `get_connectivity_test`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_connectivity_test
                ##
                # RPC-specific configuration for `create_connectivity_test`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_connectivity_test
                ##
                # RPC-specific configuration for `update_connectivity_test`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_connectivity_test
                ##
                # RPC-specific configuration for `rerun_connectivity_test`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rerun_connectivity_test
                ##
                # RPC-specific configuration for `delete_connectivity_test`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_connectivity_test

                # @private
                def initialize parent_rpcs = nil
                  list_connectivity_tests_config = parent_rpcs.list_connectivity_tests if parent_rpcs.respond_to? :list_connectivity_tests
                  @list_connectivity_tests = ::Gapic::Config::Method.new list_connectivity_tests_config
                  get_connectivity_test_config = parent_rpcs.get_connectivity_test if parent_rpcs.respond_to? :get_connectivity_test
                  @get_connectivity_test = ::Gapic::Config::Method.new get_connectivity_test_config
                  create_connectivity_test_config = parent_rpcs.create_connectivity_test if parent_rpcs.respond_to? :create_connectivity_test
                  @create_connectivity_test = ::Gapic::Config::Method.new create_connectivity_test_config
                  update_connectivity_test_config = parent_rpcs.update_connectivity_test if parent_rpcs.respond_to? :update_connectivity_test
                  @update_connectivity_test = ::Gapic::Config::Method.new update_connectivity_test_config
                  rerun_connectivity_test_config = parent_rpcs.rerun_connectivity_test if parent_rpcs.respond_to? :rerun_connectivity_test
                  @rerun_connectivity_test = ::Gapic::Config::Method.new rerun_connectivity_test_config
                  delete_connectivity_test_config = parent_rpcs.delete_connectivity_test if parent_rpcs.respond_to? :delete_connectivity_test
                  @delete_connectivity_test = ::Gapic::Config::Method.new delete_connectivity_test_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
