# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/network_management/v1/version"
require "google/cloud/network_management/v1/bindings_override"

require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/credentials"
require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/paths"
require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/rest/operations"
require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/rest/client"

module Google
  module Cloud
    module NetworkManagement
      module V1
        ##
        # The VPC Flow Logs organization service in the Google Cloud Network Management
        # API provides organization level configurations that generate Flow Logs. The
        # service and the configuration resources created using this service are
        # global.
        #
        # To load this service and instantiate a REST client:
        #
        #     require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/rest"
        #     client = ::Google::Cloud::NetworkManagement::V1::OrganizationVpcFlowLogsService::Rest::Client.new
        #
        module OrganizationVpcFlowLogsService
          # Client for the REST transport
          module Rest
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/network_management/v1/organization_vpc_flow_logs_service/rest/helpers" if ::File.file? helper_path
