# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "google/cloud/network_connectivity"
require "gapic/common"
require "gapic/grpc"

class Google::Cloud::NetworkConnectivity::ClientConstructionMinitest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_cross_network_automation_service_grpc
    skip unless Google::Cloud::NetworkConnectivity.cross_network_automation_service_available?
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::NetworkConnectivity.cross_network_automation_service do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client, client
    end
  end

  def test_data_transfer_service_grpc
    skip unless Google::Cloud::NetworkConnectivity.data_transfer_service_available?
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::NetworkConnectivity.data_transfer_service do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client, client
    end
  end

  def test_hub_service_grpc
    skip unless Google::Cloud::NetworkConnectivity.hub_service_available?
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::NetworkConnectivity.hub_service do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::NetworkConnectivity::V1::HubService::Client, client
    end
  end

  def test_internal_range_service_grpc
    skip unless Google::Cloud::NetworkConnectivity.internal_range_service_available?
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::NetworkConnectivity.internal_range_service do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::NetworkConnectivity::V1::InternalRangeService::Client, client
    end
  end

  def test_policy_based_routing_service_grpc
    skip unless Google::Cloud::NetworkConnectivity.policy_based_routing_service_available?
    Gapic::ServiceStub.stub :new, DummyStub.new do
      grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
      client = Google::Cloud::NetworkConnectivity.policy_based_routing_service do |config|
        config.credentials = grpc_channel
      end
      assert_kind_of Google::Cloud::NetworkConnectivity::V1::PolicyBasedRoutingService::Client, client
    end
  end
end
