# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networkconnectivity/v1alpha1/hub_pb"
require "google/cloud/network_connectivity/v1alpha1/hub_service"

class ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_hubs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1alpha1::ListHubsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_hubs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hubs, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::ListHubsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hubs_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hubs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hubs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hubs ::Google::Cloud::NetworkConnectivity::V1alpha1::ListHubsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hubs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hubs(::Google::Cloud::NetworkConnectivity::V1alpha1::ListHubsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hubs_client_stub.call_rpc_count
    end
  end

  def test_get_hub
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1alpha1::Hub.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hub_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hub, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::GetHubRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hub_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hub({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hub name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hub ::Google::Cloud::NetworkConnectivity::V1alpha1::GetHubRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hub({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hub(::Google::Cloud::NetworkConnectivity::V1alpha1::GetHubRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hub_client_stub.call_rpc_count
    end
  end

  def test_create_hub
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hub_id = "hello world"
    hub = {}
    request_id = "hello world"

    create_hub_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hub, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::CreateHubRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["hub_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1alpha1::Hub), request["hub"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hub_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hub({ parent: parent, hub_id: hub_id, hub: hub, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hub parent: parent, hub_id: hub_id, hub: hub, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hub ::Google::Cloud::NetworkConnectivity::V1alpha1::CreateHubRequest.new(parent: parent, hub_id: hub_id, hub: hub, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hub({ parent: parent, hub_id: hub_id, hub: hub, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hub(::Google::Cloud::NetworkConnectivity::V1alpha1::CreateHubRequest.new(parent: parent, hub_id: hub_id, hub: hub, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hub_client_stub.call_rpc_count
    end
  end

  def test_update_hub
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    hub = {}
    request_id = "hello world"

    update_hub_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_hub, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateHubRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1alpha1::Hub), request["hub"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_hub_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_hub({ update_mask: update_mask, hub: hub, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_hub update_mask: update_mask, hub: hub, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_hub ::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateHubRequest.new(update_mask: update_mask, hub: hub, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_hub({ update_mask: update_mask, hub: hub, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_hub(::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateHubRequest.new(update_mask: update_mask, hub: hub, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_hub_client_stub.call_rpc_count
    end
  end

  def test_delete_hub
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_hub_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_hub, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteHubRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_hub_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_hub({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_hub name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_hub ::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteHubRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_hub({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_hub(::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteHubRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_hub_client_stub.call_rpc_count
    end
  end

  def test_list_spokes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1alpha1::ListSpokesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_spokes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_spokes, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::ListSpokesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_spokes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_spokes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_spokes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_spokes ::Google::Cloud::NetworkConnectivity::V1alpha1::ListSpokesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_spokes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_spokes(::Google::Cloud::NetworkConnectivity::V1alpha1::ListSpokesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_spokes_client_stub.call_rpc_count
    end
  end

  def test_get_spoke
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_spoke_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_spoke, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::GetSpokeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_spoke_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_spoke({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_spoke name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_spoke ::Google::Cloud::NetworkConnectivity::V1alpha1::GetSpokeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_spoke({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_spoke(::Google::Cloud::NetworkConnectivity::V1alpha1::GetSpokeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_spoke_client_stub.call_rpc_count
    end
  end

  def test_create_spoke
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    spoke_id = "hello world"
    spoke = {}
    request_id = "hello world"

    create_spoke_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_spoke, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::CreateSpokeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["spoke_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke), request["spoke"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_spoke_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_spoke({ parent: parent, spoke_id: spoke_id, spoke: spoke, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_spoke parent: parent, spoke_id: spoke_id, spoke: spoke, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_spoke ::Google::Cloud::NetworkConnectivity::V1alpha1::CreateSpokeRequest.new(parent: parent, spoke_id: spoke_id, spoke: spoke, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_spoke({ parent: parent, spoke_id: spoke_id, spoke: spoke, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_spoke(::Google::Cloud::NetworkConnectivity::V1alpha1::CreateSpokeRequest.new(parent: parent, spoke_id: spoke_id, spoke: spoke, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_spoke_client_stub.call_rpc_count
    end
  end

  def test_update_spoke
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    spoke = {}
    request_id = "hello world"

    update_spoke_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_spoke, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateSpokeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke), request["spoke"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_spoke_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_spoke({ update_mask: update_mask, spoke: spoke, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_spoke update_mask: update_mask, spoke: spoke, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_spoke ::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateSpokeRequest.new(update_mask: update_mask, spoke: spoke, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_spoke({ update_mask: update_mask, spoke: spoke, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_spoke(::Google::Cloud::NetworkConnectivity::V1alpha1::UpdateSpokeRequest.new(update_mask: update_mask, spoke: spoke, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_spoke_client_stub.call_rpc_count
    end
  end

  def test_delete_spoke
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_spoke_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_spoke, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteSpokeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_spoke_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_spoke({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_spoke name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_spoke ::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteSpokeRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_spoke({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_spoke(::Google::Cloud::NetworkConnectivity::V1alpha1::DeleteSpokeRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_spoke_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Operations, client.operations_client
  end
end
