# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1alpha1
        # Network Connectivity Center is a hub-and-spoke abstraction for
        # network connectivity management in Google Cloud. It reduces
        # operational complexity through a simple, centralized connectivity management
        # model. Following is the resource message of a hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a Hub resource.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the Hub was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the Hub was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     Short description of the hub resource.
        # @!attribute [r] spokes
        #   @return [::Array<::String>]
        #     Output only. A list of the URIs of all attached spokes
        # @!attribute [r] unique_id
        #   @return [::String]
        #     Output only. Google-generated UUID for this resource. This is unique across all Hub
        #     resources. If a Hub resource is deleted and another with the same name is
        #     created, it gets a different unique_id.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::State]
        #     Output only. The current lifecycle state of this Hub.
        class Hub
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Spoke is an  abstraction of a network attachment being attached
        # to a Hub. A Spoke can be underlying a VPN tunnel, a
        # VLAN (interconnect) attachment, a Router appliance, etc.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a Spoke resource.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the Spoke was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the Spoke was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     Short description of the spoke resource
        # @!attribute [rw] hub
        #   @return [::String]
        #     The resource URL of the hub resource that the spoke is attached to
        # @!attribute [rw] linked_vpn_tunnels
        #   @return [::Array<::String>]
        #     The URIs of linked VPN tunnel resources
        # @!attribute [rw] linked_interconnect_attachments
        #   @return [::Array<::String>]
        #     The URIs of linked interconnect attachment resources
        # @!attribute [rw] linked_router_appliance_instances
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1alpha1::RouterApplianceInstance>]
        #     The URIs of linked Router appliance resources
        # @!attribute [r] unique_id
        #   @return [::String]
        #     Output only. Google-generated UUID for this resource. This is unique across all Spoke
        #     resources. If a Spoke resource is deleted and another with the same name is
        #     created, it gets a different unique_id.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::State]
        #     Output only. The current lifecycle state of this Hub.
        class Spoke
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#list_hubs HubService.ListHubs} method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListHubsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#list_hubs HubService.ListHubs} method.
        # @!attribute [rw] hubs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1alpha1::Hub>]
        #     Hubs to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListHubsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#get_hub HubService.GetHub} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Hub resource to get.
        class GetHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#create_hub HubService.CreateHub} method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name of the Hub.
        # @!attribute [rw] hub_id
        #   @return [::String]
        #     Optional. Unique id for the Hub to create.
        # @!attribute [rw] hub
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::Hub]
        #     Required. Initial values for a new Hub.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#update_hub HubService.UpdateHub} method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Hub resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] hub
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::Hub]
        #     Required. The state that the Hub should be in after the update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#delete_hub HubService.DeleteHub}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Hub to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#list_spokes HubService.ListSpokes}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent's resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListSpokesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#list_spokes HubService.ListSpokes}.
        # @!attribute [rw] spokes
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke>]
        #     Spokes to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListSpokesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#get_spoke HubService.GetSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of Spoke resource.
        class GetSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#create_spoke HubService.CreateSpoke}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent's resource name of the Spoke.
        # @!attribute [rw] spoke_id
        #   @return [::String]
        #     Optional. Unique id for the Spoke to create.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke]
        #     Required. Initial values for a new Hub.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#update_spoke HubService.UpdateSpoke} method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Spoke resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1alpha1::Spoke]
        #     Required. The state that the Spoke should be in after the update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for {::Google::Cloud::NetworkConnectivity::V1alpha1::HubService::Client#delete_spoke HubService.DeleteSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Spoke to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RouterAppliance represents a Router appliance which is specified by a VM URI
        # and a NIC address.
        # @!attribute [rw] virtual_machine
        #   @return [::String]
        #     The URI of the virtual machine resource
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     The IP address of the network interface to use for peering.
        # @!attribute [rw] network_interface
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        class RouterApplianceInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The State enum represents the lifecycle of a Network Connectivity Center
        # resource.
        module State
          # No state information available
          STATE_UNSPECIFIED = 0

          # The resource's create operation is in progress
          CREATING = 1

          # The resource is active
          ACTIVE = 2

          # The resource's Delete operation is in progress
          DELETING = 3
        end
      end
    end
  end
end
