# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networkconnectivity/v1/data_transfer_pb"
require "google/cloud/network_connectivity/v1/data_transfer_service"

class ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_multicloud_data_transfer_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    return_partial_success = true

    list_multicloud_data_transfer_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_multicloud_data_transfer_configs, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_multicloud_data_transfer_configs_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_multicloud_data_transfer_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_multicloud_data_transfer_configs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_multicloud_data_transfer_configs ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_multicloud_data_transfer_configs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_multicloud_data_transfer_configs(::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_multicloud_data_transfer_configs_client_stub.call_rpc_count
    end
  end

  def test_get_multicloud_data_transfer_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_multicloud_data_transfer_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_multicloud_data_transfer_config, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_multicloud_data_transfer_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_multicloud_data_transfer_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_multicloud_data_transfer_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_multicloud_data_transfer_config ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_multicloud_data_transfer_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_multicloud_data_transfer_config(::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_multicloud_data_transfer_config_client_stub.call_rpc_count
    end
  end

  def test_create_multicloud_data_transfer_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    multicloud_data_transfer_config_id = "hello world"
    multicloud_data_transfer_config = {}
    request_id = "hello world"

    create_multicloud_data_transfer_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_multicloud_data_transfer_config, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["multicloud_data_transfer_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig), request["multicloud_data_transfer_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_multicloud_data_transfer_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_multicloud_data_transfer_config({ parent: parent, multicloud_data_transfer_config_id: multicloud_data_transfer_config_id, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_multicloud_data_transfer_config parent: parent, multicloud_data_transfer_config_id: multicloud_data_transfer_config_id, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_multicloud_data_transfer_config ::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest.new(parent: parent, multicloud_data_transfer_config_id: multicloud_data_transfer_config_id, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_multicloud_data_transfer_config({ parent: parent, multicloud_data_transfer_config_id: multicloud_data_transfer_config_id, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_multicloud_data_transfer_config(::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest.new(parent: parent, multicloud_data_transfer_config_id: multicloud_data_transfer_config_id, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_multicloud_data_transfer_config_client_stub.call_rpc_count
    end
  end

  def test_update_multicloud_data_transfer_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    multicloud_data_transfer_config = {}
    request_id = "hello world"

    update_multicloud_data_transfer_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_multicloud_data_transfer_config, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig), request["multicloud_data_transfer_config"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_multicloud_data_transfer_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_multicloud_data_transfer_config({ update_mask: update_mask, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_multicloud_data_transfer_config update_mask: update_mask, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_multicloud_data_transfer_config ::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest.new(update_mask: update_mask, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_multicloud_data_transfer_config({ update_mask: update_mask, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_multicloud_data_transfer_config(::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest.new(update_mask: update_mask, multicloud_data_transfer_config: multicloud_data_transfer_config, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_multicloud_data_transfer_config_client_stub.call_rpc_count
    end
  end

  def test_delete_multicloud_data_transfer_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_multicloud_data_transfer_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_multicloud_data_transfer_config, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_multicloud_data_transfer_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_multicloud_data_transfer_config({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_multicloud_data_transfer_config name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_multicloud_data_transfer_config ::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_multicloud_data_transfer_config({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_multicloud_data_transfer_config(::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_multicloud_data_transfer_config_client_stub.call_rpc_count
    end
  end

  def test_list_destinations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListDestinationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    return_partial_success = true

    list_destinations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_destinations, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal true, request["return_partial_success"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_destinations_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_destinations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_destinations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_destinations ::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_destinations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_destinations(::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, return_partial_success: return_partial_success), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_destinations_client_stub.call_rpc_count
    end
  end

  def test_get_destination
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::Destination.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_destination_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_destination, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_destination_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_destination({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_destination name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_destination ::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_destination({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_destination(::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_destination_client_stub.call_rpc_count
    end
  end

  def test_create_destination
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    destination_id = "hello world"
    destination = {}
    request_id = "hello world"

    create_destination_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_destination, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["destination_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::Destination), request["destination"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_destination_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_destination({ parent: parent, destination_id: destination_id, destination: destination, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_destination parent: parent, destination_id: destination_id, destination: destination, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_destination ::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest.new(parent: parent, destination_id: destination_id, destination: destination, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_destination({ parent: parent, destination_id: destination_id, destination: destination, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_destination(::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest.new(parent: parent, destination_id: destination_id, destination: destination, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_destination_client_stub.call_rpc_count
    end
  end

  def test_update_destination
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    destination = {}
    request_id = "hello world"

    update_destination_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_destination, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::Destination), request["destination"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_destination_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_destination({ update_mask: update_mask, destination: destination, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_destination update_mask: update_mask, destination: destination, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_destination ::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest.new(update_mask: update_mask, destination: destination, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_destination({ update_mask: update_mask, destination: destination, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_destination(::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest.new(update_mask: update_mask, destination: destination, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_destination_client_stub.call_rpc_count
    end
  end

  def test_delete_destination
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_destination_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_destination, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_destination_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_destination({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_destination name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_destination ::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_destination({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_destination(::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_destination_client_stub.call_rpc_count
    end
  end

  def test_get_multicloud_data_transfer_supported_service
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_multicloud_data_transfer_supported_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_multicloud_data_transfer_supported_service, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_multicloud_data_transfer_supported_service_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_multicloud_data_transfer_supported_service({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_multicloud_data_transfer_supported_service name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_multicloud_data_transfer_supported_service ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_multicloud_data_transfer_supported_service({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_multicloud_data_transfer_supported_service(::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_multicloud_data_transfer_supported_service_client_stub.call_rpc_count
    end
  end

  def test_list_multicloud_data_transfer_supported_services
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_multicloud_data_transfer_supported_services_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_multicloud_data_transfer_supported_services, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_multicloud_data_transfer_supported_services_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_multicloud_data_transfer_supported_services({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_multicloud_data_transfer_supported_services parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_multicloud_data_transfer_supported_services ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_multicloud_data_transfer_supported_services({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_multicloud_data_transfer_supported_services(::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_multicloud_data_transfer_supported_services_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Operations, client.operations_client
  end
end
