# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/networkconnectivity/v1/cross_network_automation_pb"
require "google/cloud/network_connectivity/v1/cross_network_automation_service"

class ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_service_connection_maps
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_service_connection_maps_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_connection_maps, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_connection_maps_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_connection_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_connection_maps parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_connection_maps ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_connection_maps({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_connection_maps(::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_connection_maps_client_stub.call_rpc_count
    end
  end

  def test_get_service_connection_map
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_connection_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_connection_map, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_connection_map_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_connection_map({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_connection_map name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_connection_map ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_connection_map({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_connection_map(::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_connection_map_client_stub.call_rpc_count
    end
  end

  def test_create_service_connection_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_connection_map_id = "hello world"
    service_connection_map = {}
    request_id = "hello world"

    create_service_connection_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_connection_map, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["service_connection_map_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap), request["service_connection_map"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_connection_map_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_connection_map({ parent: parent, service_connection_map_id: service_connection_map_id, service_connection_map: service_connection_map, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_connection_map parent: parent, service_connection_map_id: service_connection_map_id, service_connection_map: service_connection_map, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_connection_map ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest.new(parent: parent, service_connection_map_id: service_connection_map_id, service_connection_map: service_connection_map, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_connection_map({ parent: parent, service_connection_map_id: service_connection_map_id, service_connection_map: service_connection_map, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_connection_map(::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest.new(parent: parent, service_connection_map_id: service_connection_map_id, service_connection_map: service_connection_map, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_connection_map_client_stub.call_rpc_count
    end
  end

  def test_update_service_connection_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_connection_map = {}
    request_id = "hello world"

    update_service_connection_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_connection_map, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap), request["service_connection_map"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_connection_map_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_connection_map({ update_mask: update_mask, service_connection_map: service_connection_map, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_connection_map update_mask: update_mask, service_connection_map: service_connection_map, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_connection_map ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest.new(update_mask: update_mask, service_connection_map: service_connection_map, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_connection_map({ update_mask: update_mask, service_connection_map: service_connection_map, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_connection_map(::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest.new(update_mask: update_mask, service_connection_map: service_connection_map, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_connection_map_client_stub.call_rpc_count
    end
  end

  def test_delete_service_connection_map
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_service_connection_map_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_connection_map, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert request.has_etag?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_connection_map_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_connection_map({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_connection_map name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_connection_map ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_connection_map({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_connection_map(::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_connection_map_client_stub.call_rpc_count
    end
  end

  def test_list_service_connection_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_service_connection_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_connection_policies, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_connection_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_connection_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_connection_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_connection_policies ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_connection_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_connection_policies(::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_connection_policies_client_stub.call_rpc_count
    end
  end

  def test_get_service_connection_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_connection_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_connection_policy, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_connection_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_connection_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_connection_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_connection_policy ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_connection_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_connection_policy(::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_connection_policy_client_stub.call_rpc_count
    end
  end

  def test_create_service_connection_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_connection_policy_id = "hello world"
    service_connection_policy = {}
    request_id = "hello world"

    create_service_connection_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_connection_policy, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["service_connection_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy), request["service_connection_policy"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_connection_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_connection_policy({ parent: parent, service_connection_policy_id: service_connection_policy_id, service_connection_policy: service_connection_policy, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_connection_policy parent: parent, service_connection_policy_id: service_connection_policy_id, service_connection_policy: service_connection_policy, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_connection_policy ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest.new(parent: parent, service_connection_policy_id: service_connection_policy_id, service_connection_policy: service_connection_policy, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_connection_policy({ parent: parent, service_connection_policy_id: service_connection_policy_id, service_connection_policy: service_connection_policy, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_connection_policy(::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest.new(parent: parent, service_connection_policy_id: service_connection_policy_id, service_connection_policy: service_connection_policy, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_connection_policy_client_stub.call_rpc_count
    end
  end

  def test_update_service_connection_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_connection_policy = {}
    request_id = "hello world"

    update_service_connection_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_connection_policy, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy), request["service_connection_policy"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_connection_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_connection_policy({ update_mask: update_mask, service_connection_policy: service_connection_policy, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_connection_policy update_mask: update_mask, service_connection_policy: service_connection_policy, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_connection_policy ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest.new(update_mask: update_mask, service_connection_policy: service_connection_policy, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_connection_policy({ update_mask: update_mask, service_connection_policy: service_connection_policy, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_connection_policy(::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest.new(update_mask: update_mask, service_connection_policy: service_connection_policy, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_connection_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_service_connection_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_service_connection_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_connection_policy, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert request.has_etag?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_connection_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_connection_policy({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_connection_policy name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_connection_policy ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_connection_policy({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_connection_policy(::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_connection_policy_client_stub.call_rpc_count
    end
  end

  def test_list_service_classes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_service_classes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_classes, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_classes_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_classes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_classes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_classes ::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_classes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_classes(::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_classes_client_stub.call_rpc_count
    end
  end

  def test_get_service_class
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ServiceClass.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_class, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_class_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_class({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_class name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_class ::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_class({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_class(::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_class_client_stub.call_rpc_count
    end
  end

  def test_update_service_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    service_class = {}
    request_id = "hello world"

    update_service_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_class, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceClass), request["service_class"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_class_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_class({ update_mask: update_mask, service_class: service_class, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_class update_mask: update_mask, service_class: service_class, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_class ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest.new(update_mask: update_mask, service_class: service_class, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_class({ update_mask: update_mask, service_class: service_class, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_class(::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest.new(update_mask: update_mask, service_class: service_class, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_class_client_stub.call_rpc_count
    end
  end

  def test_delete_service_class
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_service_class_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_class, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert request.has_etag?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_class_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_class({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_class name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_class ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_class({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_class(::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_class_client_stub.call_rpc_count
    end
  end

  def test_get_service_connection_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_connection_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_connection_token, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_connection_token_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_connection_token({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_connection_token name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_connection_token ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_connection_token({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_connection_token(::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_connection_token_client_stub.call_rpc_count
    end
  end

  def test_list_service_connection_tokens
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_service_connection_tokens_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_connection_tokens, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_connection_tokens_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_connection_tokens({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_connection_tokens parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_connection_tokens ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_connection_tokens({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_connection_tokens(::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_connection_tokens_client_stub.call_rpc_count
    end
  end

  def test_create_service_connection_token
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_connection_token_id = "hello world"
    service_connection_token = {}
    request_id = "hello world"

    create_service_connection_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_connection_token, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["service_connection_token_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken), request["service_connection_token"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_connection_token_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_connection_token({ parent: parent, service_connection_token_id: service_connection_token_id, service_connection_token: service_connection_token, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_connection_token parent: parent, service_connection_token_id: service_connection_token_id, service_connection_token: service_connection_token, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_connection_token ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest.new(parent: parent, service_connection_token_id: service_connection_token_id, service_connection_token: service_connection_token, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_connection_token({ parent: parent, service_connection_token_id: service_connection_token_id, service_connection_token: service_connection_token, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_connection_token(::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest.new(parent: parent, service_connection_token_id: service_connection_token_id, service_connection_token: service_connection_token, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_connection_token_client_stub.call_rpc_count
    end
  end

  def test_delete_service_connection_token
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_service_connection_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_connection_token, name
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      assert request.has_etag?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_connection_token_client_stub do
      # Create client
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_connection_token({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_connection_token name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_connection_token ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_connection_token({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_connection_token(::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_connection_token_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Operations, client.operations_client
  end
end
