# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        # The internal range resource for IPAM operations within a VPC network.
        # Used to represent a private address range along with behavioral
        # characteristics of that range (its usage and peering behavior).
        # Networking resources can link to this range if they are created
        # as belonging to it.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of an internal range.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/internalRanges/\\{internal_range}
        #     See: https://google.aip.dev/122#fields-representing-resource-names
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the internal range was created.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the internal range was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of this resource.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     Optional. The IP range that this internal range defines.
        #     NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and
        #     peering=FOR_SELF.
        #     NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must
        #     be specified explicitly.
        # @!attribute [rw] network
        #   @return [::String]
        #     Immutable. The URL or resource ID of the network in which to reserve the
        #     internal range. The network cannot be deleted if there are any reserved
        #     internal ranges referring to it. Legacy networks are not supported. For
        #     example:
        #       https://www.googleapis.com/compute/v1/projects/\\{project}/locations/global/networks/\\{network}
        #       projects/\\{project}/locations/global/networks/\\{network}
        #       \\{network}
        # @!attribute [rw] usage
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange::Usage]
        #     Optional. The type of usage set for this InternalRange.
        # @!attribute [rw] peering
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange::Peering]
        #     Optional. The type of peering set for this internal range.
        # @!attribute [rw] prefix_length
        #   @return [::Integer]
        #     Optional. An alternate to ip_cidr_range. Can be set when trying to create
        #     an IPv4 reservation that automatically finds a free range of the given
        #     size. If both ip_cidr_range and prefix_length are set, there is an error if
        #     the range sizes do not match. Can also be used during updates to change the
        #     range size.
        #     NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and
        #     both fields must match. In other words, with IPv6 this field only works as
        #     a redundant parameter.
        # @!attribute [rw] target_cidr_range
        #   @return [::Array<::String>]
        #     Optional. Can be set to narrow down or pick a different address space while
        #     searching for a free range. If not set, defaults to the "10.0.0.0/8"
        #     address space. This can be used to search in other rfc-1918 address
        #     spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918
        #     address spaces used in the VPC.
        # @!attribute [r] users
        #   @return [::Array<::String>]
        #     Output only. The list of resources that refer to this internal range.
        #     Resources that use the internal range for their range allocation
        #     are referred to as users of the range. Other resources mark themselves
        #     as users while doing so by creating a reference to this internal range.
        #     Having a user, based on this reference, prevents deletion of the
        #     internal range referred to. Can be empty.
        # @!attribute [rw] overlaps
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::InternalRange::Overlap>]
        #     Optional. Types of resources that are allowed to overlap with the current
        #     internal range.
        # @!attribute [rw] migration
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange::Migration]
        #     Optional. Must be present if usage is set to FOR_MIGRATION.
        # @!attribute [rw] immutable
        #   @return [::Boolean]
        #     Optional. Immutable ranges cannot have their fields modified, except for
        #     labels and description.
        # @!attribute [rw] allocation_options
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange::AllocationOptions]
        #     Optional. Range auto-allocation options, may be set only when
        #     auto-allocation is selected by not setting ip_cidr_range (and setting
        #     prefix_length).
        # @!attribute [rw] exclude_cidr_ranges
        #   @return [::Array<::String>]
        #     Optional. ExcludeCidrRanges flag. Specifies a set of CIDR blocks that
        #     allows exclusion of particular CIDR ranges from the auto-allocation
        #     process, without having to reserve these blocks
        class InternalRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specification for migration with source and target resource names.
          # @!attribute [rw] source
          #   @return [::String]
          #     Immutable. Resource path as an URI of the source resource, for example a
          #     subnet. The project for the source resource should match the project for
          #     the InternalRange. An example:
          #       /projects/\\{project}/regions/\\{region}/subnetworks/\\{subnet}
          # @!attribute [rw] target
          #   @return [::String]
          #     Immutable. Resource path of the target resource. The target project can
          #     be different, as in the cases when migrating to peer networks. For
          #     example:
          #       /projects/\\{project}/regions/\\{region}/subnetworks/\\{subnet}
          class Migration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Range auto-allocation options, to be optionally used when CIDR block is not
          # explicitly set.
          # @!attribute [rw] allocation_strategy
          #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange::AllocationStrategy]
          #     Optional. Allocation strategy Not setting this field when the allocation
          #     is requested means an implementation defined strategy is used.
          # @!attribute [rw] first_available_ranges_lookup_size
          #   @return [::Integer]
          #     Optional. This field must be set only when allocation_strategy is set to
          #     RANDOM_FIRST_N_AVAILABLE.
          #     The value should be the maximum expected parallelism of range creation
          #     requests issued to the same space of peered netwroks.
          class AllocationOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible usage of an internal range.
          module Usage
            # Unspecified usage is allowed in calls which identify the resource by
            # other fields and do not need Usage set to complete. These are, i.e.:
            # GetInternalRange and DeleteInternalRange.
            # Usage needs to be specified explicitly in CreateInternalRange
            # or UpdateInternalRange calls.
            USAGE_UNSPECIFIED = 0

            # A VPC resource can use the reserved CIDR block by associating it with the
            # internal range resource if usage is set to FOR_VPC.
            FOR_VPC = 1

            # Ranges created with EXTERNAL_TO_VPC cannot be associated with VPC
            # resources and are meant to block out address ranges for various use
            # cases, like for example, usage on-prem, with dynamic route announcements
            # via interconnect.
            EXTERNAL_TO_VPC = 2

            # Ranges created FOR_MIGRATION can be used to lock a CIDR range between a
            # source and target subnet. If usage is set to FOR_MIGRATION, the peering
            # value has to be set to FOR_SELF or default to FOR_SELF when unset.
            FOR_MIGRATION = 3
          end

          # Peering type.
          module Peering
            # If Peering is left unspecified in CreateInternalRange or
            # UpdateInternalRange, it will be defaulted to FOR_SELF.
            PEERING_UNSPECIFIED = 0

            # This is the default behavior and represents the case that this
            # internal range is intended to be used in the VPC in which it is created
            # and is accessible from its peers. This implies that peers or
            # peers-of-peers cannot use this range.
            FOR_SELF = 1

            # This behavior can be set when the internal range is being reserved for
            # usage by peers. This means that no resource within the VPC in which
            # it is being created can use this to associate with a VPC resource, but
            # one of the peers can. This represents donating a range for peers to
            # use.
            FOR_PEER = 2

            # This behavior can be set when the internal range is being reserved for
            # usage by the VPC in which it is created, but not shared with peers.
            # In a sense, it is local to the VPC. This can be used to create internal
            # ranges for various purposes like HTTP_INTERNAL_LOAD_BALANCER or for
            # Interconnect routes that are not shared with peers. This also implies
            # that peers cannot use this range in a way that is visible to this VPC,
            # but can re-use this range as long as it is NOT_SHARED from the peer VPC,
            # too.
            NOT_SHARED = 3
          end

          # Overlap specifications.
          module Overlap
            # No overlap overrides.
            OVERLAP_UNSPECIFIED = 0

            # Allow creation of static routes more specific that the current
            # internal range.
            OVERLAP_ROUTE_RANGE = 1

            # Allow creation of internal ranges that overlap with existing subnets.
            OVERLAP_EXISTING_SUBNET_RANGE = 2
          end

          # Enumeration of range auto-allocation strategies
          module AllocationStrategy
            # Unspecified is the only valid option when the range is specified
            # explicitly by ip_cidr_range field. Otherwise unspefified means using the
            # default strategy.
            ALLOCATION_STRATEGY_UNSPECIFIED = 0

            # Random strategy, the legacy algorithm, used for backwards compatibility.
            # This allocation strategy remains efficient in the case of concurrent
            # allocation requests in the same peered network space and doesn't require
            # providing the level of concurrency in an explicit parameter, but it is
            # prone to fragmenting available address space.
            RANDOM = 1

            # Pick the first available address range. This strategy is deterministic
            # and the result is easy to predict.
            FIRST_AVAILABLE = 2

            # Pick an arbitrary range out of the first N available ones. The N will be
            # set in the first_available_ranges_lookup_size field. This strategy should
            # be used when concurrent allocation requests are made in the same space of
            # peered networks while the fragmentation of the addrress space is reduced.
            RANDOM_FIRST_N_AVAILABLE = 3

            # Pick the smallest but fitting available range. This deterministic
            # strategy minimizes fragmentation of the address space.
            FIRST_SMALLEST_FITTING = 4
          end
        end

        # Request for InternalRangeService.ListInternalRanges
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListInternalRangesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for InternalRange.ListInternalRanges
        # @!attribute [rw] internal_ranges
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::InternalRange>]
        #     Internal ranges to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInternalRangesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for InternalRangeService.GetInternalRange
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the InternalRange to get.
        class GetInternalRangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for InternalRangeService.CreateInternalRange
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name of the internal range.
        # @!attribute [rw] internal_range_id
        #   @return [::String]
        #     Optional. Resource ID
        #     (i.e. 'foo' in '[...]/projects/p/locations/l/internalRanges/foo')
        #     See https://google.aip.dev/122#resource-id-segments
        #     Unique per location.
        # @!attribute [rw] internal_range
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange]
        #     Required. Initial values for a new internal range
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateInternalRangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for InternalRangeService.UpdateInternalRange
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     InternalRange resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] internal_range
        #   @return [::Google::Cloud::NetworkConnectivity::V1::InternalRange]
        #     Required. New values to be patched into the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateInternalRangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for InternalRangeService.DeleteInternalRange
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the internal range to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteInternalRangeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
