# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        # A Network Connectivity Center hub is a global management resource to which
        # you attach spokes. A single hub can contain spokes from multiple regions.
        # However, if any of a hub's spokes use the site-to-site data transfer feature,
        # the resources associated with those spokes must all be in the same VPC
        # network. Spokes that do not use site-to-site data transfer can be associated
        # with any VPC network in your project.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of the hub. Hub names must be unique. They use the
        #     following form:
        #         `projects/{project_number}/locations/global/hubs/{hub_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the hub was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the hub was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional labels in key-value pair format. For more information about
        #     labels, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of the hub.
        # @!attribute [r] unique_id
        #   @return [::String]
        #     Output only. The Google-generated UUID for the hub. This value is unique
        #     across all hub resources. If a hub is deleted and another with the same
        #     name is created, the new hub is assigned a different unique_id.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
        #     Output only. The current lifecycle state of this hub.
        # @!attribute [rw] routing_vpcs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::RoutingVPC>]
        #     The VPC networks associated with this hub's spokes.
        #
        #     This field is read-only. Network Connectivity Center automatically
        #     populates it based on the set of spokes attached to the hub.
        # @!attribute [r] route_tables
        #   @return [::Array<::String>]
        #     Output only. The route tables that belong to this hub. They use the
        #     following form:
        #        `projects/{project_number}/locations/global/hubs/{hub_id}/routeTables/{route_table_id}`
        #
        #     This field is read-only. Network Connectivity Center automatically
        #     populates it based on the route tables nested under the hub.
        # @!attribute [r] spoke_summary
        #   @return [::Google::Cloud::NetworkConnectivity::V1::SpokeSummary]
        #     Output only. A summary of the spokes associated with a hub. The
        #     summary includes a count of spokes according to type
        #     and according to state. If any spokes are inactive,
        #     the summary also lists the reasons they are inactive,
        #     including a count for each reason.
        # @!attribute [rw] policy_mode
        #   @return [::Google::Cloud::NetworkConnectivity::V1::PolicyMode]
        #     Optional. The policy mode of this hub. This field can be either
        #     PRESET or CUSTOM. If unspecified, the
        #     policy_mode defaults to PRESET.
        # @!attribute [rw] preset_topology
        #   @return [::Google::Cloud::NetworkConnectivity::V1::PresetTopology]
        #     Optional. The topology implemented in this hub. Currently, this field is
        #     only used when policy_mode = PRESET. The available preset topologies are
        #     MESH and STAR. If preset_topology is unspecified and policy_mode = PRESET,
        #     the preset_topology defaults to MESH. When policy_mode = CUSTOM,
        #     the preset_topology is set to PRESET_TOPOLOGY_UNSPECIFIED.
        # @!attribute [rw] export_psc
        #   @return [::Boolean]
        #     Optional. Whether Private Service Connect connection propagation is enabled
        #     for the hub. If true, Private Service Connect endpoints in VPC spokes
        #     attached to the hub are made accessible to other VPC spokes attached to the
        #     hub. The default value is false.
        class Hub
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # RoutingVPC contains information about the VPC networks associated
        # with the spokes of a Network Connectivity Center hub.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the VPC network.
        # @!attribute [r] required_for_new_site_to_site_data_transfer_spokes
        #   @return [::Boolean]
        #     Output only. If true, indicates that this VPC network is currently
        #     associated with spokes that use the data transfer feature (spokes where the
        #     site_to_site_data_transfer field is set to true). If you create new spokes
        #     that use data transfer, they must be associated with this VPC network. At
        #     most, one VPC network will have this field set to true.
        class RoutingVPC
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Network Connectivity Center spoke represents one or more network
        # connectivity resources.
        #
        # When you create a spoke, you associate it with a hub. You must also
        # identify a value for exactly one of the following fields:
        #
        # * linked_vpn_tunnels
        # * linked_interconnect_attachments
        # * linked_router_appliance_instances
        # * linked_vpc_network
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of the spoke. Spoke names must be unique. They use the
        #     following form:
        #         `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the spoke was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the spoke was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional labels in key-value pair format. For more information about
        #     labels, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of the spoke.
        # @!attribute [rw] hub
        #   @return [::String]
        #     Immutable. The name of the hub that this spoke is attached to.
        # @!attribute [rw] group
        #   @return [::String]
        #     Optional. The name of the group that this spoke is associated with.
        # @!attribute [rw] linked_vpn_tunnels
        #   @return [::Google::Cloud::NetworkConnectivity::V1::LinkedVpnTunnels]
        #     Optional. VPN tunnels that are associated with the spoke.
        # @!attribute [rw] linked_interconnect_attachments
        #   @return [::Google::Cloud::NetworkConnectivity::V1::LinkedInterconnectAttachments]
        #     Optional. VLAN attachments that are associated with the spoke.
        # @!attribute [rw] linked_router_appliance_instances
        #   @return [::Google::Cloud::NetworkConnectivity::V1::LinkedRouterApplianceInstances]
        #     Optional. Router appliance instances that are associated with the spoke.
        # @!attribute [rw] linked_vpc_network
        #   @return [::Google::Cloud::NetworkConnectivity::V1::LinkedVpcNetwork]
        #     Optional. VPC network that is associated with the spoke.
        # @!attribute [rw] linked_producer_vpc_network
        #   @return [::Google::Cloud::NetworkConnectivity::V1::LinkedProducerVpcNetwork]
        #     Optional. The linked producer VPC that is associated with the spoke.
        # @!attribute [r] unique_id
        #   @return [::String]
        #     Output only. The Google-generated UUID for the spoke. This value is unique
        #     across all spoke resources. If a spoke is deleted and another with the same
        #     name is created, the new spoke is assigned a different `unique_id`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
        #     Output only. The current lifecycle state of this spoke.
        # @!attribute [r] reasons
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Spoke::StateReason>]
        #     Output only. The reasons for current state of the spoke.
        # @!attribute [r] spoke_type
        #   @return [::Google::Cloud::NetworkConnectivity::V1::SpokeType]
        #     Output only. The type of resource associated with the spoke.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] field_paths_pending_update
        #   @return [::Array<::String>]
        #     Optional. The list of fields waiting for hub administration's approval.
        class Spoke
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The reason a spoke is inactive.
          # @!attribute [rw] code
          #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke::StateReason::Code]
          #     The code associated with this reason.
          # @!attribute [rw] message
          #   @return [::String]
          #     Human-readable details about this reason.
          # @!attribute [rw] user_details
          #   @return [::String]
          #     Additional information provided by the user in the RejectSpoke call.
          class StateReason
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The Code enum represents the various reasons a state can be `INACTIVE`.
            module Code
              # No information available.
              CODE_UNSPECIFIED = 0

              # The proposed spoke is pending review.
              PENDING_REVIEW = 1

              # The proposed spoke has been rejected by the hub administrator.
              REJECTED = 2

              # The spoke has been deactivated internally.
              PAUSED = 3

              # Network Connectivity Center encountered errors while accepting
              # the spoke.
              FAILED = 4

              # The proposed spoke update is pending review.
              UPDATE_PENDING_REVIEW = 5

              # The proposed spoke update has been rejected by the hub administrator.
              UPDATE_REJECTED = 6

              # Network Connectivity Center encountered errors while accepting
              # the spoke update.
              UPDATE_FAILED = 7
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of the route table. Route table names must be unique.
        #     They use the following form:
        #          `projects/{project_number}/locations/global/hubs/{hub}/routeTables/{route_table_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the route table was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the route table was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional labels in key-value pair format. For more information about
        #     labels, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of the route table.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The Google-generated UUID for the route table. This value is
        #     unique across all route table resources. If a route table is deleted and
        #     another with the same name is created, the new route table is assigned
        #     a different `uid`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
        #     Output only. The current lifecycle state of this route table.
        class RouteTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A route defines a path from VM instances within a spoke to a specific
        # destination resource. Only VPC spokes have routes.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of the route. Route names must be unique. Route names
        #     use the following form:
        #          `projects/{project_number}/locations/global/hubs/{hub}/routeTables/{route_table_id}/routes/{route_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the route was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the route was last updated.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The destination IP address range.
        # @!attribute [r] type
        #   @return [::Google::Cloud::NetworkConnectivity::V1::RouteType]
        #     Output only. The route's type. Its type is determined by the properties of
        #     its IP address range.
        # @!attribute [rw] next_hop_vpc_network
        #   @return [::Google::Cloud::NetworkConnectivity::V1::NextHopVpcNetwork]
        #     Immutable. The destination VPC network for packets on this route.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional labels in key-value pair format. For more information about
        #     labels, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        # @!attribute [rw] description
        #   @return [::String]
        #     An optional description of the route.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The Google-generated UUID for the route. This value is unique
        #     across all Network Connectivity Center route resources. If a
        #     route is deleted and another with the same name is created,
        #     the new route is assigned a different `uid`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
        #     Output only. The current lifecycle state of the route.
        # @!attribute [rw] spoke
        #   @return [::String]
        #     Immutable. The spoke that this route leads to.
        #     Example: projects/12345/locations/global/spokes/SPOKE
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. The origin location of the route.
        #     Uses the following form: "projects/\\{project}/locations/\\{location}"
        #     Example: projects/1234/locations/us-central1
        # @!attribute [r] priority
        #   @return [::Integer]
        #     Output only. The priority of this route. Priority is used to break ties in
        #     cases where a destination matches more than one route. In these cases the
        #     route with the lowest-numbered priority value wins.
        # @!attribute [rw] next_hop_vpn_tunnel
        #   @return [::Google::Cloud::NetworkConnectivity::V1::NextHopVPNTunnel]
        #     Immutable. The next-hop VPN tunnel for packets on this route.
        # @!attribute [rw] next_hop_router_appliance_instance
        #   @return [::Google::Cloud::NetworkConnectivity::V1::NextHopRouterApplianceInstance]
        #     Immutable. The next-hop Router appliance instance for packets on this
        #     route.
        # @!attribute [rw] next_hop_interconnect_attachment
        #   @return [::Google::Cloud::NetworkConnectivity::V1::NextHopInterconnectAttachment]
        #     Immutable. The next-hop VLAN attachment for packets on this route.
        class Route
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A group represents a subset of spokes attached to a hub.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of the group. Group names must be unique. They
        #     use the following form:
        #          `projects/{project_number}/locations/global/hubs/{hub}/groups/{group_id}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the group was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the group was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels in key-value pair format. For more information about
        #     labels, see [Requirements for
        #     labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the group.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The Google-generated UUID for the group. This value is unique
        #     across all group resources. If a group is deleted and
        #     another with the same name is created, the new route table is assigned
        #     a different unique_id.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
        #     Output only. The current lifecycle state of this group.
        # @!attribute [rw] auto_accept
        #   @return [::Google::Cloud::NetworkConnectivity::V1::AutoAccept]
        #     Optional. The auto-accept setting for this group.
        # @!attribute [r] route_table
        #   @return [::String]
        #     Output only. The name of the route table that corresponds to this group.
        #     They use the following form:
        #     `projects/{project_number}/locations/global/hubs/{hub_id}/routeTables/{route_table_id}`
        class Group
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The auto-accept setting for a group controls whether
        # proposed spokes are automatically attached to the hub. If auto-accept is
        # enabled, the spoke immediately is attached to the hub and becomes part of the
        # group. In this case, the new spoke is in the ACTIVE state.
        # If auto-accept is disabled, the spoke goes to the INACTIVE
        # state, and it must be reviewed and accepted by a hub
        # administrator.
        # @!attribute [rw] auto_accept_projects
        #   @return [::Array<::String>]
        #     Optional. A list of project ids or project numbers for which you want
        #     to enable auto-accept. The auto-accept setting is applied to
        #     spokes being created or updated in these projects.
        class AutoAccept
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_hubs HubService.ListHubs}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListHubsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_hubs HubService.ListHubs}
        # method.
        # @!attribute [rw] hubs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Hub>]
        #     The requested hubs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListHubsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#get_hub HubService.GetHub}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub resource to get.
        class GetHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#create_hub HubService.CreateHub}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource.
        # @!attribute [rw] hub_id
        #   @return [::String]
        #     Required. A unique identifier for the hub.
        # @!attribute [rw] hub
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Hub]
        #     Required. The initial values for a new hub.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#update_hub HubService.UpdateHub}
        # method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. In the case of an update to an existing hub, field mask is used
        #     to specify the fields to be overwritten. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field is
        #     overwritten if it is in the mask. If the user does not provide a mask, then
        #     all fields are overwritten.
        # @!attribute [rw] hub
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Hub]
        #     Required. The state that the hub should be in after the update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#delete_hub HubService.DeleteHub}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteHubRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_hub_spokes HubService.ListHubSpokes}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub.
        # @!attribute [rw] spoke_locations
        #   @return [::Array<::String>]
        #     A list of locations.
        #     Specify one of the following: `[global]`, a single region (for
        #     example, `[us-central1]`), or a combination of
        #     values (for example, `[global, us-central1, us-west1]`).
        #     If the spoke_locations field is populated, the list of results
        #     includes only spokes in the specified location.
        #     If the spoke_locations field is not populated, the list of results
        #     includes spokes in all locations.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by name or create_time.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ListHubSpokesRequest::SpokeView]
        #     The view of the spoke to return.
        #     The view that you use determines which spoke fields are included in the
        #     response.
        class ListHubSpokesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that controls which spoke fields are included in the response.
          module SpokeView
            # The spoke view is unspecified. When the spoke view is unspecified, the
            # API returns the same fields as the `BASIC` view.
            SPOKE_VIEW_UNSPECIFIED = 0

            # Includes `name`, `create_time`, `hub`, `unique_id`, `state`, `reasons`,
            # and `spoke_type`. This is the default value.
            BASIC = 1

            # Includes all spoke fields except `labels`.
            # You can use the `DETAILED` view only when you set the `spoke_locations`
            # field to `[global]`.
            DETAILED = 2
          end
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_hub_spokes HubService.ListHubSpokes}.
        # @!attribute [rw] spokes
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Spoke>]
        #     The requested spokes.
        #     The spoke fields can be partially populated based on the `view` field in
        #     the request message.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListHubSpokesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#query_hub_status HubService.QueryHubStatus}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the list of results.
        #     The filter can be used to filter the results by the following fields:
        #       * `psc_propagation_status.source_spoke`
        #       * `psc_propagation_status.source_group`
        #       * `psc_propagation_status.source_forwarding_rule`
        #       * `psc_propagation_status.target_spoke`
        #       * `psc_propagation_status.target_group`
        #       * `psc_propagation_status.code`
        #       * `psc_propagation_status.message`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Sort the results in ascending order by the specified fields.
        #     A comma-separated list of any of these fields:
        #       * `psc_propagation_status.source_spoke`
        #       * `psc_propagation_status.source_group`
        #       * `psc_propagation_status.source_forwarding_rule`
        #       * `psc_propagation_status.target_spoke`
        #       * `psc_propagation_status.target_group`
        #       * `psc_propagation_status.code`
        #     If `group_by` is set, the value of the `order_by` field must be the
        #     same as or a subset of the `group_by` field.
        # @!attribute [rw] group_by
        #   @return [::String]
        #     Optional. Aggregate the results by the specified fields.
        #     A comma-separated list of any of these fields:
        #       * `psc_propagation_status.source_spoke`
        #       * `psc_propagation_status.source_group`
        #       * `psc_propagation_status.source_forwarding_rule`
        #       * `psc_propagation_status.target_spoke`
        #       * `psc_propagation_status.target_group`
        #       * `psc_propagation_status.code`
        class QueryHubStatusRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#query_hub_status HubService.QueryHubStatus}.
        # @!attribute [rw] hub_status_entries
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::HubStatusEntry>]
        #     The list of hub status.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        class QueryHubStatusResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A hub status entry represents the status of a set of propagated Private
        # Service Connect connections grouped by certain fields.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     The number of propagated Private Service Connect connections with this
        #     status. If the `group_by` field was not set in the request message, the
        #     value of this field is 1.
        # @!attribute [rw] group_by
        #   @return [::String]
        #     The fields that this entry is grouped by. This has the same value as the
        #     `group_by` field in the request message.
        # @!attribute [rw] psc_propagation_status
        #   @return [::Google::Cloud::NetworkConnectivity::V1::PscPropagationStatus]
        #     The Private Service Connect propagation status.
        class HubStatusEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The status of one or more propagated Private Service Connect connections in a
        # hub.
        # @!attribute [rw] source_spoke
        #   @return [::String]
        #     The name of the spoke that the source forwarding rule belongs to.
        # @!attribute [rw] source_group
        #   @return [::String]
        #     The name of the group that the source spoke belongs to.
        # @!attribute [rw] source_forwarding_rule
        #   @return [::String]
        #     The name of the forwarding rule exported to the hub.
        # @!attribute [rw] target_spoke
        #   @return [::String]
        #     The name of the spoke that the source forwarding rule propagates to.
        # @!attribute [rw] target_group
        #   @return [::String]
        #     The name of the group that the target spoke belongs to.
        # @!attribute [rw] code
        #   @return [::Google::Cloud::NetworkConnectivity::V1::PscPropagationStatus::Code]
        #     The propagation status.
        # @!attribute [rw] message
        #   @return [::String]
        #     The human-readable summary of the Private Service Connect connection
        #     propagation status.
        class PscPropagationStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Code enum represents the state of the Private Service Connect
          # propagation.
          module Code
            # The code is unspecified.
            CODE_UNSPECIFIED = 0

            # The propagated Private Service Connect connection is ready.
            READY = 1

            # The Private Service Connect connection is propagating. This is a
            # transient state.
            PROPAGATING = 2

            # The Private Service Connect connection propagation failed because the VPC
            # network or the project of the target spoke has exceeded the connection
            # limit set by the producer.
            ERROR_PRODUCER_PROPAGATED_CONNECTION_LIMIT_EXCEEDED = 3

            # The Private Service Connect connection propagation failed because the NAT
            # IP subnet space has been exhausted. It is equivalent to the `Needs
            # attention` status of the Private Service Connect connection. See
            # https://cloud.google.com/vpc/docs/about-accessing-vpc-hosted-services-endpoints#connection-statuses.
            ERROR_PRODUCER_NAT_IP_SPACE_EXHAUSTED = 4

            # The Private Service Connect connection propagation failed because the
            # `PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK` quota in the
            # producer VPC network has been exceeded.
            ERROR_PRODUCER_QUOTA_EXCEEDED = 5

            # The Private Service Connect connection propagation failed because the
            # `PSC_PROPAGATED_CONNECTIONS_PER_VPC_NETWORK` quota in the consumer
            # VPC network has been exceeded.
            ERROR_CONSUMER_QUOTA_EXCEEDED = 6
          end
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_spokes HubService.ListSpokes}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListSpokesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_spokes HubService.ListSpokes}.
        # @!attribute [rw] spokes
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Spoke>]
        #     The requested spokes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListSpokesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#get_spoke HubService.GetSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spoke resource.
        class GetSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#create_spoke HubService.CreateSpoke}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource.
        # @!attribute [rw] spoke_id
        #   @return [::String]
        #     Required. Unique id for the spoke to create.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     Required. The initial values for a new spoke.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#update_spoke HubService.UpdateSpoke}
        # method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. In the case of an update to an existing spoke, field mask is used
        #     to specify the fields to be overwritten. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field is
        #     overwritten if it is in the mask. If the user does not provide a mask, then
        #     all fields are overwritten.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     Required. The state that the spoke should be in after the update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#delete_spoke HubService.DeleteSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the spoke to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#accept_hub_spoke HubService.AcceptHubSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub into which to accept the spoke.
        # @!attribute [rw] spoke_uri
        #   @return [::String]
        #     Required. The URI of the spoke to accept into the hub.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class AcceptHubSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#accept_hub_spoke HubService.AcceptHubSpoke}.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     The spoke that was operated on.
        class AcceptHubSpokeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#reject_hub_spoke HubService.RejectHubSpoke}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub from which to reject the spoke.
        # @!attribute [rw] spoke_uri
        #   @return [::String]
        #     Required. The URI of the spoke to reject from the hub.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] details
        #   @return [::String]
        #     Optional. Additional information provided by the hub administrator.
        class RejectHubSpokeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#reject_hub_spoke HubService.RejectHubSpoke}.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     The spoke that was operated on.
        class RejectHubSpokeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#accept_spoke_update HubService.AcceptSpokeUpdate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub to accept spoke update.
        # @!attribute [rw] spoke_uri
        #   @return [::String]
        #     Required. The URI of the spoke to accept update.
        # @!attribute [rw] spoke_etag
        #   @return [::String]
        #     Required. The etag of the spoke to accept update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class AcceptSpokeUpdateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#accept_spoke_update HubService.AcceptSpokeUpdate}.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     The spoke that was operated on.
        class AcceptSpokeUpdateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#reject_spoke_update HubService.RejectSpokeUpdate}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the hub to reject spoke update.
        # @!attribute [rw] spoke_uri
        #   @return [::String]
        #     Required. The URI of the spoke to reject update.
        # @!attribute [rw] spoke_etag
        #   @return [::String]
        #     Required. The etag of the spoke to reject update.
        # @!attribute [rw] details
        #   @return [::String]
        #     Optional. Additional information provided by the hub administrator.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class RejectSpokeUpdateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#reject_spoke_update HubService.RejectSpokeUpdate}.
        # @!attribute [rw] spoke
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke]
        #     The spoke that was operated on.
        class RejectSpokeUpdateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#get_route_table HubService.GetRouteTable}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the route table resource.
        class GetRouteTableRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#get_route HubService.GetRoute}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the route resource.
        class GetRouteRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_routes HubService.ListRoutes}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_routes HubService.ListRoutes}
        # method.
        # @!attribute [rw] routes
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Route>]
        #     The requested routes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     RouteTables that could not be reached.
        class ListRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_route_tables HubService.ListRouteTables}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListRouteTablesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_route_tables HubService.ListRouteTables}
        # method.
        # @!attribute [rw] route_tables
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::RouteTable>]
        #     The requested route tables.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Hubs that could not be reached.
        class ListRouteTablesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_groups HubService.ListGroups}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     An expression that filters the list of results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#list_groups HubService.ListGroups}
        # method.
        # @!attribute [rw] groups
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Group>]
        #     The requested groups.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token for the next page of the response. To see more results,
        #     use this value as the page_token for your next request. If this value
        #     is empty, there are no more results.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Hubs that could not be reached.
        class ListGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of Cloud VPN tunnel resources. These resources should be
        # redundant HA VPN tunnels that all advertise the same prefixes to Google
        # Cloud. Alternatively, in a passive/active configuration, all tunnels
        # should be capable of advertising the same prefixes.
        # @!attribute [rw] uris
        #   @return [::Array<::String>]
        #     The URIs of linked VPN tunnel resources.
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     A value that controls whether site-to-site data transfer is enabled for
        #     these resources. Data transfer is available only in [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        # @!attribute [r] vpc_network
        #   @return [::String]
        #     Output only. The VPC network where these VPN tunnels are located.
        # @!attribute [rw] include_import_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges allowed to be included during import from hub (does not
        #     control transit connectivity). The only allowed value for now is
        #     "ALL_IPV4_RANGES".
        class LinkedVpnTunnels
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of VLAN attachment resources. These resources should
        # be redundant attachments that all advertise the same prefixes to Google
        # Cloud. Alternatively, in active/passive configurations, all attachments
        # should be capable of advertising the same prefixes.
        # @!attribute [rw] uris
        #   @return [::Array<::String>]
        #     The URIs of linked interconnect attachment resources
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     A value that controls whether site-to-site data transfer is enabled for
        #     these resources. Data transfer is available only in [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        # @!attribute [r] vpc_network
        #   @return [::String]
        #     Output only. The VPC network where these VLAN attachments are located.
        # @!attribute [rw] include_import_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges allowed to be included during import from hub (does not
        #     control transit connectivity). The only allowed value for now is
        #     "ALL_IPV4_RANGES".
        class LinkedInterconnectAttachments
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of router appliance instances. If you configure multiple router
        # appliance instances to receive data from the same set of sites outside of
        # Google Cloud, we recommend that you associate those instances with the same
        # spoke.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::RouterApplianceInstance>]
        #     The list of router appliance instances.
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     A value that controls whether site-to-site data transfer is enabled for
        #     these resources. Data transfer is available only in [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        # @!attribute [r] vpc_network
        #   @return [::String]
        #     Output only. The VPC network where these router appliance instances are
        #     located.
        # @!attribute [rw] include_import_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges allowed to be included during import from hub (does not
        #     control transit connectivity). The only allowed value for now is
        #     "ALL_IPV4_RANGES".
        class LinkedRouterApplianceInstances
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An existing VPC network.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The URI of the VPC network resource.
        # @!attribute [rw] exclude_export_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges encompassing the subnets to be excluded from peering.
        # @!attribute [rw] include_export_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges allowed to be included from peering.
        # @!attribute [rw] proposed_include_export_ranges
        #   @return [::Array<::String>]
        #     Optional. The proposed include export IP ranges waiting for hub
        #     administration's approval.
        # @!attribute [r] proposed_exclude_export_ranges
        #   @return [::Array<::String>]
        #     Output only. The proposed exclude export IP ranges waiting for hub
        #     administration's approval.
        # @!attribute [r] producer_vpc_spokes
        #   @return [::Array<::String>]
        #     Output only. The list of Producer VPC spokes that this VPC spoke is a
        #     service consumer VPC spoke for. These producer VPCs are connected through
        #     VPC peering to this spoke's backing VPC network. Because they are directly
        #     connected throuh VPC peering, NCC export filters do not apply between the
        #     service consumer VPC spoke and any of its producer VPC spokes. This VPC
        #     spoke cannot be deleted as long as any of these producer VPC spokes are
        #     connected to the NCC Hub.
        class LinkedVpcNetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] network
        #   @return [::String]
        #     Immutable. The URI of the Service Consumer VPC that the Producer VPC is
        #     peered with.
        # @!attribute [r] service_consumer_vpc_spoke
        #   @return [::String]
        #     Output only. The Service Consumer Network spoke.
        # @!attribute [rw] peering
        #   @return [::String]
        #     Immutable. The name of the VPC peering between the Service Consumer VPC and
        #     the Producer VPC (defined in the Tenant project) which is added to the NCC
        #     hub. This peering must be in ACTIVE state.
        # @!attribute [r] producer_network
        #   @return [::String]
        #     Output only. The URI of the Producer VPC.
        # @!attribute [rw] exclude_export_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges encompassing the subnets to be excluded from peering.
        # @!attribute [rw] include_export_ranges
        #   @return [::Array<::String>]
        #     Optional. IP ranges allowed to be included from peering.
        # @!attribute [rw] proposed_include_export_ranges
        #   @return [::Array<::String>]
        #     Optional. The proposed include export IP ranges waiting for hub
        #     administration's approval.
        # @!attribute [r] proposed_exclude_export_ranges
        #   @return [::Array<::String>]
        #     Output only. The proposed exclude export IP ranges waiting for hub
        #     administration's approval.
        class LinkedProducerVpcNetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A router appliance instance is a Compute Engine virtual machine (VM) instance
        # that acts as a BGP speaker. A router appliance instance is specified by the
        # URI of the VM and the internal IP address of one of the VM's network
        # interfaces.
        # @!attribute [rw] virtual_machine
        #   @return [::String]
        #     The URI of the VM.
        # @!attribute [rw] ip_address
        #   @return [::String]
        #     The IP address on the VM to use for peering.
        class RouterApplianceInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about locations
        # @!attribute [rw] location_features
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::LocationFeature>]
        #     List of supported features
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the VPC network resource
        class NextHopVpcNetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A route next hop that leads to a VPN tunnel resource.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the VPN tunnel resource.
        # @!attribute [rw] vpc_network
        #   @return [::String]
        #     The VPC network where this VPN tunnel is located.
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     Indicates whether site-to-site data transfer is allowed for this VPN tunnel
        #     resource. Data transfer is available only in [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        class NextHopVPNTunnel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A route next hop that leads to a Router appliance instance.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the Router appliance instance.
        # @!attribute [rw] vpc_network
        #   @return [::String]
        #     The VPC network where this VM is located.
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     Indicates whether site-to-site data transfer is allowed for this Router
        #     appliance instance resource. Data transfer is available only in [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        class NextHopRouterApplianceInstance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A route next hop that leads to an interconnect attachment resource.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URI of the interconnect attachment resource.
        # @!attribute [rw] vpc_network
        #   @return [::String]
        #     The VPC network where this interconnect attachment is located.
        # @!attribute [rw] site_to_site_data_transfer
        #   @return [::Boolean]
        #     Indicates whether site-to-site data transfer is allowed for this
        #     interconnect attachment resource. Data transfer is available only in
        #     [supported
        #     locations](https://cloud.google.com/network-connectivity/docs/network-connectivity-center/concepts/locations).
        class NextHopInterconnectAttachment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Summarizes information about the spokes associated with a hub.
        # The summary includes a count of spokes according to type
        # and according to state. If any spokes are inactive,
        # the summary also lists the reasons they are inactive,
        # including a count for each reason.
        # @!attribute [r] spoke_type_counts
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::SpokeSummary::SpokeTypeCount>]
        #     Output only. Counts the number of spokes of each type that are
        #     associated with a specific hub.
        # @!attribute [r] spoke_state_counts
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::SpokeSummary::SpokeStateCount>]
        #     Output only. Counts the number of spokes that are in each state
        #     and associated with a given hub.
        # @!attribute [r] spoke_state_reason_counts
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::SpokeSummary::SpokeStateReasonCount>]
        #     Output only. Counts the number of spokes that are inactive for each
        #     possible reason and associated with a given hub.
        class SpokeSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The number of spokes of a given type that are associated
          # with a specific hub. The type indicates what kind of
          # resource is associated with the spoke.
          # @!attribute [r] spoke_type
          #   @return [::Google::Cloud::NetworkConnectivity::V1::SpokeType]
          #     Output only. The type of the spokes.
          # @!attribute [r] count
          #   @return [::Integer]
          #     Output only. The total number of spokes of this type that are
          #     associated with the hub.
          class SpokeTypeCount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The number of spokes that are in a particular state
          # and associated with a given hub.
          # @!attribute [r] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::State]
          #     Output only. The state of the spokes.
          # @!attribute [r] count
          #   @return [::Integer]
          #     Output only. The total number of spokes that are in this state
          #     and associated with a given hub.
          class SpokeStateCount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The number of spokes in the hub that are inactive for this reason.
          # @!attribute [r] state_reason_code
          #   @return [::Google::Cloud::NetworkConnectivity::V1::Spoke::StateReason::Code]
          #     Output only. The reason that a spoke is inactive.
          # @!attribute [r] count
          #   @return [::Integer]
          #     Output only. The total number of spokes that are inactive for a
          #     particular reason and associated with a given hub.
          class SpokeStateReasonCount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#get_group HubService.GetGroup}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the route table resource.
        class GetGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for
        # {::Google::Cloud::NetworkConnectivity::V1::HubService::Client#update_group HubService.UpdateGroup}
        # method.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. In the case of an update to an existing group, field mask is used
        #     to specify the fields to be overwritten. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field is
        #     overwritten if it is in the mask. If the user does not provide a mask, then
        #     all fields are overwritten.
        # @!attribute [rw] group
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Group]
        #     Required. The state that the group should be in after the update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID so
        #     that if you must retry your request, the server knows to ignore the request
        #     if it has already been completed. The server guarantees that a request
        #     doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check to see whether the original operation
        #     was received. If it was, the server ignores the second request. This
        #     behavior prevents clients from mistakenly creating duplicate commitments.
        #
        #     The request ID must be a valid UUID, with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Supported features for a location
        module LocationFeature
          # No publicly supported feature in this location
          LOCATION_FEATURE_UNSPECIFIED = 0

          # Site-to-cloud spokes are supported in this location
          SITE_TO_CLOUD_SPOKES = 1

          # Site-to-site spokes are supported in this location
          SITE_TO_SITE_SPOKES = 2
        end

        # The route's type
        module RouteType
          # No route type information specified
          ROUTE_TYPE_UNSPECIFIED = 0

          # The route leads to a destination within the primary address range of the
          # VPC network's subnet.
          VPC_PRIMARY_SUBNET = 1

          # The route leads to a destination within the secondary address range of the
          # VPC network's subnet.
          VPC_SECONDARY_SUBNET = 2

          # The route leads to a destination in a dynamic route. Dynamic routes are
          # derived from Border Gateway Protocol (BGP) advertisements received from an
          # NCC hybrid spoke.
          DYNAMIC_ROUTE = 3
        end

        # The State enum represents the lifecycle stage of a Network Connectivity
        # Center resource.
        module State
          # No state information available
          STATE_UNSPECIFIED = 0

          # The resource's create operation is in progress.
          CREATING = 1

          # The resource is active
          ACTIVE = 2

          # The resource's delete operation is in progress.
          DELETING = 3

          # The resource's accept operation is in progress.
          ACCEPTING = 8

          # The resource's reject operation is in progress.
          REJECTING = 9

          # The resource's update operation is in progress.
          UPDATING = 6

          # The resource is inactive.
          INACTIVE = 7

          # The hub associated with this spoke resource has been deleted.
          # This state applies to spoke resources only.
          OBSOLETE = 10

          # The resource is in an undefined state due to resource creation or deletion
          # failure. You can try to delete the resource later or contact support for
          # help.
          FAILED = 11
        end

        # The SpokeType enum represents the type of spoke. The type
        # reflects the kind of resource that a spoke is associated with.
        module SpokeType
          # Unspecified spoke type.
          SPOKE_TYPE_UNSPECIFIED = 0

          # Spokes associated with VPN tunnels.
          VPN_TUNNEL = 1

          # Spokes associated with VLAN attachments.
          INTERCONNECT_ATTACHMENT = 2

          # Spokes associated with router appliance instances.
          ROUTER_APPLIANCE = 3

          # Spokes associated with VPC networks.
          VPC_NETWORK = 4

          # Spokes that are backed by a producer VPC network.
          PRODUCER_VPC_NETWORK = 7
        end

        # This enum controls the policy mode used in a hub.
        module PolicyMode
          # Policy mode is unspecified. It defaults to PRESET
          # with preset_topology = MESH.
          POLICY_MODE_UNSPECIFIED = 0

          # Hub uses one of the preset topologies.
          PRESET = 1
        end

        # The list of available preset topologies.
        module PresetTopology
          # Preset topology is unspecified. When policy_mode = PRESET,
          # it defaults to MESH.
          PRESET_TOPOLOGY_UNSPECIFIED = 0

          # Mesh topology is implemented. Group `default` is automatically created.
          # All spokes in the hub are added to group `default`.
          MESH = 2

          # Star topology is implemented. Two groups, `center` and `edge`, are
          # automatically created along with hub creation. Spokes have to join one of
          # the groups during creation.
          STAR = 3
        end
      end
    end
  end
end
