# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        # The `MulticloudDataTransferConfig` resource. It lists the services that you
        # configure for Data Transfer Essentials billing and metering.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the `MulticloudDataTransferConfig` resource.
        #     Format:
        #     `projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the `MulticloudDataTransferConfig` resource was
        #     created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the `MulticloudDataTransferConfig` resource was
        #     updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The etag is computed by the server, and might be sent with update and
        #     delete requests so that the client has an up-to-date value before
        #     proceeding.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of this resource.
        # @!attribute [r] destinations_count
        #   @return [::Integer]
        #     Output only. The number of `Destination` resources configured for the
        #     `MulticloudDataTransferConfig` resource.
        # @!attribute [r] destinations_active_count
        #   @return [::Integer]
        #     Output only. The number of `Destination` resources in use with the
        #     `MulticloudDataTransferConfig` resource.
        # @!attribute [rw] services
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::NetworkConnectivity::V1::StateTimeline}]
        #     Optional. Maps services to their current or planned states. Service names
        #     are keys, and the associated values describe the state of the service. If a
        #     state change is expected, the value is either `ADDING` or `DELETING`,
        #     depending on the actions taken.
        #
        #     Sample output:
        #     "services": {
        #       "big-query": {
        #         "states": [
        #           {
        #             "effectiveTime": "2024-12-12T08:00:00Z"
        #             "state": "ADDING",
        #           },
        #         ]
        #       },
        #       "cloud-storage": {
        #         "states": [
        #           {
        #             "state": "ACTIVE",
        #           }
        #         ]
        #       }
        #     }
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The Google-generated unique ID for the
        #     `MulticloudDataTransferConfig` resource. This value is unique across all
        #     `MulticloudDataTransferConfig` resources. If a resource is deleted and
        #     another with the same name is created, the new resource is assigned a
        #     different and unique ID.
        class MulticloudDataTransferConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::NetworkConnectivity::V1::StateTimeline]
          class ServicesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message to list `MulticloudDataTransferConfig` resources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results listed per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The sort order of the results.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If `true`, allows partial responses for multi-regional aggregated
        #     list requests.
        class ListMulticloudDataTransferConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message to list `MulticloudDataTransferConfig` resources.
        # @!attribute [rw] multicloud_data_transfer_configs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig>]
        #     The list of `MulticloudDataTransferConfig` resources to be listed.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListMulticloudDataTransferConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to get the details of a `MulticloudDataTransferConfig`
        # resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `MulticloudDataTransferConfig` resource to get.
        class GetMulticloudDataTransferConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create a `MulticloudDataTransferConfig` resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] multicloud_data_transfer_config_id
        #   @return [::String]
        #     Required. The ID to use for the `MulticloudDataTransferConfig` resource,
        #     which becomes the final component of the `MulticloudDataTransferConfig`
        #     resource name.
        # @!attribute [rw] multicloud_data_transfer_config
        #   @return [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig]
        #     Required. The `MulticloudDataTransferConfig` resource to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request. This prevents
        #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
        #     resources.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        class CreateMulticloudDataTransferConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to update a `MulticloudDataTransferConfig` resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. `FieldMask` is used to specify the fields in the
        #     `MulticloudDataTransferConfig` resource to be overwritten by the update.
        #     The fields specified in `update_mask` are relative to the resource, not
        #     the full request. A field is overwritten if it is in the mask. If you
        #     don't specify a mask, all fields are overwritten.
        # @!attribute [rw] multicloud_data_transfer_config
        #   @return [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig]
        #     Required. The `MulticloudDataTransferConfig` resource to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request. This prevents
        #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
        #     resources.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        class UpdateMulticloudDataTransferConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a `MulticloudDataTransferConfig` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `MulticloudDataTransferConfig` resource to
        #     delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request. This prevents
        #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
        #     resources.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and might be sent with update
        #     and delete requests so that the client has an up-to-date value before
        #     proceeding.
        class DeleteMulticloudDataTransferConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `Destination` resource. It specifies the IP prefix and the associated
        # autonomous system numbers (ASN) that you want to include in a
        # `MulticloudDataTransferConfig` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the `Destination` resource.
        #     Format:
        #     `projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}/destinations/{destination}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the `Destination` resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the `Destination` resource was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The etag is computed by the server, and might be sent with update and
        #     delete requests so that the client has an up-to-date value before
        #     proceeding.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. A description of this resource.
        # @!attribute [rw] ip_prefix
        #   @return [::String]
        #     Required. Immutable. The IP prefix that represents your workload on another
        #     CSP.
        # @!attribute [rw] endpoints
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Destination::DestinationEndpoint>]
        #     Required. Unordered list. The list of `DestinationEndpoint` resources
        #     configured for the IP prefix.
        # @!attribute [r] state_timeline
        #   @return [::Google::Cloud::NetworkConnectivity::V1::StateTimeline]
        #     Output only. The timeline of the expected `Destination` states or the
        #     current rest state. If a state change is expected, the value is `ADDING`,
        #     `DELETING` or `SUSPENDING`, depending on the action specified.
        #
        #     Example:
        #     "state_timeline": {
        #       "states": [
        #         {
        #           // The time when the `Destination` resource will be activated.
        #           "effectiveTime": "2024-12-01T08:00:00Z",
        #           "state": "ADDING"
        #         },
        #         {
        #           // The time when the `Destination` resource will be suspended.
        #           "effectiveTime": "2024-12-01T20:00:00Z",
        #           "state": "SUSPENDING"
        #         }
        #       ]
        #     }
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. The Google-generated unique ID for the `Destination` resource.
        #     This value is unique across all `Destination` resources.
        #     If a resource is deleted and another with the same name is
        #     created, the new resource is assigned a different and unique ID.
        class Destination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The metadata for a `DestinationEndpoint` resource.
          # @!attribute [rw] asn
          #   @return [::Integer]
          #     Required. The ASN of the remote IP prefix.
          # @!attribute [rw] csp
          #   @return [::String]
          #     Required. The CSP of the remote IP prefix.
          # @!attribute [r] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::Destination::DestinationEndpoint::State]
          #     Output only. The state of the `DestinationEndpoint` resource.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Time when the `DestinationEndpoint` resource was updated.
          class DestinationEndpoint
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the `DestinationEndpoint` resource.
            module State
              # An invalid state, which is the default case.
              STATE_UNSPECIFIED = 0

              # The `DestinationEndpoint` resource is valid.
              VALID = 1

              # The `DestinationEndpoint` resource is invalid.
              INVALID = 2
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message to list `Destination` resources.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results listed per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. An expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The sort order of the results.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If `true`, allow partial responses for multi-regional aggregated
        #     list requests.
        class ListDestinationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message to list `Destination` resources.
        # @!attribute [rw] destinations
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::Destination>]
        #     The list of `Destination` resources to be listed.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDestinationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to get the details of a `Destination` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `Destination` resource to get.
        class GetDestinationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to create a `Destination` resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] destination_id
        #   @return [::String]
        #     Required. The ID to use for the `Destination` resource, which becomes the
        #     final component of the `Destination` resource name.
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Destination]
        #     Required. The `Destination` resource to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request. This prevents
        #     clients from accidentally creating duplicate `Destination`
        #     resources.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        class CreateDestinationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to update a `Destination` resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. `FieldMask is used to specify the fields to be overwritten in the
        #     `Destination` resource by the update.
        #     The fields specified in `update_mask` are relative to the resource, not
        #     the full request. A field is overwritten if it is in the mask. If you
        #     don't specify a mask, all fields are overwritten.
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Destination]
        #     Required. The `Destination` resource to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        class UpdateDestinationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to delete a `Destination` resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `Destination` resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server can ignore
        #     the request if it has already been completed. The server waits
        #     for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, can ignore the second request.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID
        #     (00000000-0000-0000-0000-000000000000) isn't supported.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and might be sent with update
        #     and delete requests so that the client has an up-to-date value before
        #     proceeding.
        class DeleteDestinationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The timeline of the pending states for a resource.
        # @!attribute [r] states
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::StateTimeline::StateMetadata>]
        #     Output only. The state and activation time details of the resource state.
        class StateTimeline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The state and activation time details of the resource state.
          # @!attribute [r] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::StateTimeline::StateMetadata::State]
          #     Output only. The state of the resource.
          # @!attribute [r] effective_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Accompanies only the transient states, which include
          #     `ADDING`, `DELETING`, and `SUSPENDING`, to denote the time until which
          #     the transient state of the resource will be effective. For instance, if
          #     the state is `ADDING`, this field shows the time when the resource state
          #     transitions to `ACTIVE`.
          class StateMetadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the resource.
            module State
              # An invalid state, which is the default case.
              STATE_UNSPECIFIED = 0

              # The resource is being added.
              ADDING = 1

              # The resource is in use.
              ACTIVE = 2

              # The resource is being deleted.
              DELETING = 3

              # The resource is being suspended.
              SUSPENDING = 4

              # The resource is suspended and not in use.
              SUSPENDED = 5
            end
          end
        end

        # A service in your project in a region that is eligible for Data Transfer
        # Essentials configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The name of the service.
        # @!attribute [r] service_configs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConfig>]
        #     Output only. The network service tier or regional endpoint supported for
        #     the service.
        class MulticloudDataTransferSupportedService
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies eligibility information for the service.
        # @!attribute [r] eligibility_criteria
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConfig::EligibilityCriteria]
        #     Output only. The eligibility criteria for the service.
        # @!attribute [r] support_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The end time for eligibility criteria support. If not
        #     specified, no planned end time is set.
        class ServiceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The eligibility information for the service.
          module EligibilityCriteria
            # The service is not eligible for Data Transfer Essentials configuration.
            # This is the default case.
            ELIGIBILITY_CRITERIA_UNSPECIFIED = 0

            # The service is eligible for Data Transfer Essentials configuration only
            # for Premium Tier.
            NETWORK_SERVICE_TIER_PREMIUM_ONLY = 1

            # The service is eligible for Data Transfer Essentials configuration only
            # for Standard Tier.
            NETWORK_SERVICE_TIER_STANDARD_ONLY = 2

            # The service is eligible for Data Transfer Essentials configuration only
            # for the regional endpoint.
            REQUEST_ENDPOINT_REGIONAL_ENDPOINT_ONLY = 3
          end
        end

        # Request message to check if a service in your project in a region is
        # eligible for Data Transfer Essentials configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the service.
        class GetMulticloudDataTransferSupportedServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message to list the services in your project that are eligible for
        # Data Transfer Essentials configuration.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the parent resource.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results listed per page.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token.
        class ListMulticloudDataTransferSupportedServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message to list the services in your project in regions that are
        # eligible for Data Transfer Essentials configuration.
        # @!attribute [rw] multicloud_data_transfer_supported_services
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService>]
        #     The list of supported services.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListMulticloudDataTransferSupportedServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
