# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        # The ServiceConnectionMap resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a ServiceConnectionMap.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/serviceConnectionMaps/\\{service_connection_map}
        #     See: https://google.aip.dev/122#fields-representing-resource-names
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionMap was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionMap was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of this resource.
        # @!attribute [rw] service_class
        #   @return [::String]
        #     The service class identifier this ServiceConnectionMap is for.
        #     The user of ServiceConnectionMap create API needs to have
        #     networkconnecitivty.serviceclasses.use iam permission for the service
        #     class.
        # @!attribute [r] service_class_uri
        #   @return [::String]
        #     Output only. The service class uri this ServiceConnectionMap is for.
        # @!attribute [r] infrastructure
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Infrastructure]
        #     Output only. The infrastructure used for connections between
        #     consumers/producers.
        # @!attribute [rw] producer_psc_configs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap::ProducerPscConfig>]
        #     The PSC configurations on producer side.
        # @!attribute [rw] consumer_psc_configs
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap::ConsumerPscConfig>]
        #     The PSC configurations on consumer side.
        # @!attribute [r] consumer_psc_connections
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap::ConsumerPscConnection>]
        #     Output only. PSC connection details on consumer side.
        # @!attribute [rw] token
        #   @return [::String]
        #     The token provided by the consumer. This token authenticates that the
        #     consumer can create a connection within the specified project and network.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class ServiceConnectionMap
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The PSC configurations on producer side.
          # @!attribute [rw] service_attachment_uri
          #   @return [::String]
          #     The resource path of a service attachment.
          #     Example:
          #     projects/\\{projectNumOrId}/regions/\\{region}/serviceAttachments/\\{resourceId}.
          class ProducerPscConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Allow the producer to specify which consumers can connect to it.
          # @!attribute [rw] project
          #   @return [::String]
          #     The consumer project where PSC connections are allowed to be created in.
          # @!attribute [rw] network
          #   @return [::String]
          #     The resource path of the consumer network where PSC connections are
          #     allowed to be created in. Note, this network does not need be in the
          #     ConsumerPscConfig.project in the case of SharedVPC.
          #     Example:
          #     projects/\\{projectNumOrId}/global/networks/\\{networkId}.
          # @!attribute [rw] disable_global_access
          #   @return [::Boolean]
          #     This is used in PSC consumer ForwardingRule to control whether the PSC
          #     endpoint can be accessed from another region.
          # @!attribute [r] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap::ConsumerPscConfig::State]
          #     Output only. Overall state of PSC Connections management for this
          #     consumer psc config.
          # @!attribute [rw] producer_instance_id
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Immutable. Deprecated. Use producer_instance_metadata instead.
          #     An immutable identifier for the producer instance.
          # @!attribute [r] service_attachment_ip_address_map
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Output only. A map to store mapping between customer vip and target
          #     service attachment. Only service attachment with producer specified ip
          #     addresses are stored here.
          # @!attribute [rw] consumer_instance_project
          #   @return [::String]
          #     Required. The project ID or project number of the consumer project. This
          #     project is the one that the consumer uses to interact with the producer
          #     instance. From the perspective of a consumer who's created a producer
          #     instance, this is the project of the producer instance. Format:
          #     'projects/<project_id_or_number>' Eg. 'projects/consumer-project' or
          #     'projects/1234'
          # @!attribute [rw] producer_instance_metadata
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Immutable. An immutable map for the producer instance metadata.
          # @!attribute [rw] ip_version
          #   @return [::Google::Cloud::NetworkConnectivity::V1::IPVersion]
          #     The requested IP version for the PSC connection.
          class ConsumerPscConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ServiceAttachmentIpAddressMapEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ProducerInstanceMetadataEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # PSC Consumer Config State.
            module State
              # Default state, when Connection Map is created initially.
              STATE_UNSPECIFIED = 0

              # Set when policy and map configuration is valid,
              # and their matching can lead to allowing creation of PSC Connections
              # subject to other constraints like connections limit.
              VALID = 1

              # No Service Connection Policy found for this network and Service
              # Class
              CONNECTION_POLICY_MISSING = 2

              # Service Connection Policy limit reached for this network and Service
              # Class
              POLICY_LIMIT_REACHED = 3

              # The consumer instance project is not in
              # AllowedGoogleProducersResourceHierarchyLevels of the matching
              # ServiceConnectionPolicy.
              CONSUMER_INSTANCE_PROJECT_NOT_ALLOWLISTED = 4
            end
          end

          # PSC connection details on consumer side.
          # @!attribute [rw] service_attachment_uri
          #   @return [::String]
          #     The URI of a service attachment which is the target of the PSC
          #     connection.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap::ConsumerPscConnection::State]
          #     The state of the PSC connection.
          # @!attribute [rw] project
          #   @return [::String]
          #     The consumer project whose PSC forwarding rule is connected to the
          #     service attachments in this service connection map.
          # @!attribute [rw] network
          #   @return [::String]
          #     The consumer network whose PSC forwarding rule is connected to the
          #     service attachments in this service connection map.
          #     Note that the network could be on a different project (shared VPC).
          # @!attribute [rw] psc_connection_id
          #   @return [::String]
          #     The PSC connection id of the PSC forwarding rule connected
          #     to the service attachments in this service connection map.
          # @!attribute [rw] ip
          #   @return [::String]
          #     The IP literal allocated on the consumer network for the PSC forwarding
          #     rule that is created to connect to the producer service attachment in
          #     this service connection map.
          # @!attribute [rw] error_type
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ConnectionErrorType]
          #     The error type indicates whether the error is consumer facing, producer
          #     facing or system internal.
          # @!attribute [rw] error
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Rpc::Status]
          #     The most recent error during operating this connection.
          # @!attribute [rw] gce_operation
          #   @return [::String]
          #     The last Compute Engine operation to setup PSC connection.
          # @!attribute [rw] forwarding_rule
          #   @return [::String]
          #     The URI of the consumer forwarding rule created.
          #     Example:
          #     projects/\\{projectNumOrId}/regions/us-east1/networks/\\{resourceId}.
          # @!attribute [r] error_info
          #   @return [::Google::Rpc::ErrorInfo]
          #     Output only. The error info for the latest error during operating this
          #     connection.
          # @!attribute [r] selected_subnetwork
          #   @return [::String]
          #     Output only. The URI of the selected subnetwork selected to allocate IP
          #     address for this connection.
          # @!attribute [rw] producer_instance_id
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Immutable. Deprecated. Use producer_instance_metadata instead.
          #     An immutable identifier for the producer instance.
          # @!attribute [rw] producer_instance_metadata
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Immutable. An immutable map for the producer instance metadata.
          # @!attribute [rw] ip_version
          #   @return [::Google::Cloud::NetworkConnectivity::V1::IPVersion]
          #     The requested IP version for the PSC connection.
          class ConsumerPscConnection
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ProducerInstanceMetadataEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The state of the PSC connection.
            # We reserve the right to add more states without notice in the future.
            # Users should not use exhaustive switch statements on this enum.
            # See https://google.aip.dev/216.
            module State
              # An invalid state as the default case.
              STATE_UNSPECIFIED = 0

              # The connection has been created successfully. However, for the
              # up-to-date connection status, please use the service attachment's
              # "ConnectedEndpoint.status" as the source of truth.
              ACTIVE = 1

              # The connection is not functional since some resources on the connection
              # fail to be created.
              FAILED = 2

              # The connection is being created.
              CREATING = 3

              # The connection is being deleted.
              DELETING = 4

              # The connection is being repaired to complete creation.
              CREATE_REPAIRING = 5

              # The connection is being repaired to complete deletion.
              DELETE_REPAIRING = 6
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for ListServiceConnectionMaps.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name. ex. projects/123/locations/us-east1
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListServiceConnectionMapsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServiceConnectionMaps.
        # @!attribute [rw] service_connection_maps
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap>]
        #     ServiceConnectionMaps to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServiceConnectionMapsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServiceConnectionMap.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ServiceConnectionMap to get.
        class GetServiceConnectionMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateServiceConnectionMap.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name of the ServiceConnectionMap. ex.
        #     projects/123/locations/us-east1
        # @!attribute [rw] service_connection_map_id
        #   @return [::String]
        #     Optional. Resource ID
        #     (i.e. 'foo' in '[...]/projects/p/locations/l/serviceConnectionMaps/foo')
        #     See https://google.aip.dev/122#resource-id-segments
        #     Unique per location.
        #     If one is not provided, one will be generated.
        # @!attribute [rw] service_connection_map
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap]
        #     Required. Initial values for a new ServiceConnectionMaps
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateServiceConnectionMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateServiceConnectionMap.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     ServiceConnectionMap resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] service_connection_map
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap]
        #     Required. New values to be patched into the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateServiceConnectionMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteServiceConnectionMap.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ServiceConnectionMap to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class DeleteServiceConnectionMapRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The ServiceConnectionPolicy resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a ServiceConnectionPolicy.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/serviceConnectionPolicies/\\{service_connection_policy}
        #     See: https://google.aip.dev/122#fields-representing-resource-names
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionPolicy was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionPolicy was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of this resource.
        # @!attribute [rw] network
        #   @return [::String]
        #     The resource path of the consumer network.
        #     Example:
        #     - projects/\\{projectNumOrId}/global/networks/\\{resourceId}.
        # @!attribute [rw] service_class
        #   @return [::String]
        #     The service class identifier for which this ServiceConnectionPolicy is for.
        #     The service class identifier is a unique, symbolic representation of a
        #     ServiceClass. It is provided by the Service Producer. Google services have
        #     a prefix of gcp or google-cloud. For example, gcp-memorystore-redis or
        #     google-cloud-sql. 3rd party services do not. For example,
        #     test-service-a3dfcx.
        # @!attribute [r] infrastructure
        #   @return [::Google::Cloud::NetworkConnectivity::V1::Infrastructure]
        #     Output only. The type of underlying resources used to create the
        #     connection.
        # @!attribute [rw] psc_config
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy::PscConfig]
        #     Configuration used for Private Service Connect connections. Used when
        #     Infrastructure is PSC.
        # @!attribute [r] psc_connections
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy::PscConnection>]
        #     Output only. [Output only] Information about each Private Service Connect
        #     connection.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class ServiceConnectionPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration used for Private Service Connect connections. Used when
          # Infrastructure is PSC.
          # @!attribute [rw] subnetworks
          #   @return [::Array<::String>]
          #     The resource paths of subnetworks to use for IP address management.
          #     Example:
          #     projects/\\{projectNumOrId}/regions/\\{region}/subnetworks/\\{resourceId}.
          # @!attribute [rw] limit
          #   @return [::Integer]
          #     Optional. Max number of PSC connections for this policy.
          # @!attribute [rw] producer_instance_location
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy::PscConfig::ProducerInstanceLocation]
          #     Required. ProducerInstanceLocation is used to specify which authorization
          #     mechanism to use to determine which projects the Producer instance can be
          #     within.
          # @!attribute [rw] allowed_google_producers_resource_hierarchy_level
          #   @return [::Array<::String>]
          #     Optional. List of Projects, Folders, or Organizations from where the
          #     Producer instance can be within. For example, a network administrator can
          #     provide both 'organizations/foo' and 'projects/bar' as
          #     allowed_google_producers_resource_hierarchy_levels. This allowlists this
          #     network to connect with any Producer instance within the 'foo'
          #     organization or the 'bar' project. By default,
          #     allowed_google_producers_resource_hierarchy_level is empty. The format
          #     for each allowed_google_producers_resource_hierarchy_level is <resource
          #     type>/<id> where <resource type> is one of 'projects', 'folders', or
          #     'organizations' and <id> is either the ID or the number of the resource
          #     type. Format for each allowed_google_producers_resource_hierarchy_level
          #     value: 'projects/<project_id_or_number>' or 'folders/<folder_id>' or
          #     'organizations/<organization_id>'
          #     Eg. [projects/my-project-id, projects/567, folders/891,
          #     organizations/123]
          class PscConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # ProducerInstanceLocation is used to specify which authorization mechanism
            # to use to determine which projects the Producer instance can be within.
            module ProducerInstanceLocation
              # Producer instance location is not specified. When this option is
              # chosen, then the PSC connections created by this
              # ServiceConnectionPolicy must be within the same project as the Producer
              # instance. This is the default ProducerInstanceLocation value.
              # To allow for PSC connections from this network to other networks, use
              # the CUSTOM_RESOURCE_HIERARCHY_LEVELS option.
              PRODUCER_INSTANCE_LOCATION_UNSPECIFIED = 0

              # Producer instance must be within one of the values provided in
              # allowed_google_producers_resource_hierarchy_level.
              CUSTOM_RESOURCE_HIERARCHY_LEVELS = 1
            end
          end

          # Information about a specific Private Service Connect connection.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy::State]
          #     State of the PSC Connection
          # @!attribute [rw] consumer_forwarding_rule
          #   @return [::String]
          #     The resource reference of the PSC Forwarding Rule within the consumer
          #     VPC.
          # @!attribute [rw] consumer_address
          #   @return [::String]
          #     The resource reference of the consumer address.
          # @!attribute [rw] error_type
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::NetworkConnectivity::V1::ConnectionErrorType]
          #     The error type indicates whether the error is consumer facing, producer
          #     facing or system internal.
          # @!attribute [rw] error
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Rpc::Status]
          #     The most recent error during operating this connection.
          #     Deprecated, please use error_info instead.
          # @!attribute [rw] gce_operation
          #   @return [::String]
          #     The last Compute Engine operation to setup PSC connection.
          # @!attribute [rw] consumer_target_project
          #   @return [::String]
          #     The project where the PSC connection is created.
          # @!attribute [rw] psc_connection_id
          #   @return [::String]
          #     The PSC connection id of the PSC forwarding rule.
          # @!attribute [r] error_info
          #   @return [::Google::Rpc::ErrorInfo]
          #     Output only. The error info for the latest error during operating this
          #     connection.
          # @!attribute [r] selected_subnetwork
          #   @return [::String]
          #     Output only. The URI of the subnetwork selected to allocate IP address
          #     for this connection.
          # @!attribute [rw] producer_instance_id
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Immutable. Deprecated. Use producer_instance_metadata instead.
          #     An immutable identifier for the producer instance.
          # @!attribute [rw] producer_instance_metadata
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Immutable. An immutable map for the producer instance metadata.
          # @!attribute [r] service_class
          #   @return [::String]
          #     Output only. [Output only] The service class associated with this PSC
          #     Connection. The value is derived from the SCPolicy and matches the
          #     service class name provided by the customer.
          # @!attribute [rw] ip_version
          #   @return [::Google::Cloud::NetworkConnectivity::V1::IPVersion]
          #     The requested IP version for the PSC connection.
          class PscConnection
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ProducerInstanceMetadataEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The state of the PSC connection.
          # We reserve the right to add more states without notice in the future.
          # Users should not use exhaustive switch statements on this enum.
          # See https://google.aip.dev/216.
          module State
            # An invalid state as the default case.
            STATE_UNSPECIFIED = 0

            # The connection has been created successfully. However, for the
            # up-to-date connection status, please use the created forwarding rule's
            # "PscConnectionStatus" as the source of truth.
            ACTIVE = 1

            # The connection is not functional since some resources on the connection
            # fail to be created.
            FAILED = 2

            # The connection is being created.
            CREATING = 3

            # The connection is being deleted.
            DELETING = 4

            # The connection is being repaired to complete creation.
            CREATE_REPAIRING = 5

            # The connection is being repaired to complete deletion.
            DELETE_REPAIRING = 6
          end
        end

        # Request for ListServiceConnectionPolicies.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name. ex. projects/123/locations/us-east1
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListServiceConnectionPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServiceConnectionPolicies.
        # @!attribute [rw] service_connection_policies
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy>]
        #     ServiceConnectionPolicies to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServiceConnectionPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServiceConnectionPolicy.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ServiceConnectionPolicy to get.
        class GetServiceConnectionPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateServiceConnectionPolicy.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name of the ServiceConnectionPolicy. ex.
        #     projects/123/locations/us-east1
        # @!attribute [rw] service_connection_policy_id
        #   @return [::String]
        #     Optional. Resource ID
        #     (i.e. 'foo' in
        #     '[...]/projects/p/locations/l/serviceConnectionPolicies/foo') See
        #     https://google.aip.dev/122#resource-id-segments Unique per location.
        # @!attribute [rw] service_connection_policy
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy]
        #     Required. Initial values for a new ServiceConnectionPolicies
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateServiceConnectionPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateServiceConnectionPolicy.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     ServiceConnectionPolicy resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] service_connection_policy
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy]
        #     Required. New values to be patched into the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateServiceConnectionPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteServiceConnectionPolicy.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ServiceConnectionPolicy to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class DeleteServiceConnectionPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The ServiceClass resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a ServiceClass resource.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/serviceClasses/\\{service_class}
        #     See: https://google.aip.dev/122#fields-representing-resource-names
        # @!attribute [r] service_class
        #   @return [::String]
        #     Output only. The generated service class name. Use this name to refer to
        #     the Service class in Service Connection Maps and Service Connection
        #     Policies.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceClass was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceClass was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of this resource.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class ServiceClass
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for ListServiceClasses.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name. ex. projects/123/locations/us-east1
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListServiceClassesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServiceClasses.
        # @!attribute [rw] service_classes
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceClass>]
        #     ServiceClasses to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServiceClassesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServiceClass.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ServiceClass to get.
        class GetServiceClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for UpdateServiceClass.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     ServiceClass resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] service_class
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceClass]
        #     Required. New values to be patched into the resource.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateServiceClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteServiceClass.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ServiceClass to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class DeleteServiceClassRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The ServiceConnectionToken resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The name of a ServiceConnectionToken.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/ServiceConnectionTokens/\\{service_connection_token}
        #     See: https://google.aip.dev/122#fields-representing-resource-names
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionToken was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the ServiceConnectionToken was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of this resource.
        # @!attribute [rw] network
        #   @return [::String]
        #     The resource path of the network associated with this token.
        #     Example:
        #     projects/\\{projectNumOrId}/global/networks/\\{resourceId}.
        # @!attribute [r] token
        #   @return [::String]
        #     Output only. The token generated by Automation.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time to which this token is valid.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class ServiceConnectionToken
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for ListServiceConnectionTokens.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name. ex. projects/123/locations/us-east1
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results per page that should be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that filters the results listed in the response.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort the results by a certain order.
        class ListServiceConnectionTokensRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServiceConnectionTokens.
        # @!attribute [rw] service_connection_tokens
        #   @return [::Array<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken>]
        #     ServiceConnectionTokens to be returned.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next pagination token in the List response. It should be used as
        #     page_token for the following request. An empty value means no more result.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListServiceConnectionTokensResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServiceConnectionToken.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the ServiceConnectionToken to get.
        class GetServiceConnectionTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for CreateServiceConnectionToken.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource's name of the ServiceConnectionToken. ex.
        #     projects/123/locations/us-east1
        # @!attribute [rw] service_connection_token_id
        #   @return [::String]
        #     Optional. Resource ID
        #     (i.e. 'foo' in '[...]/projects/p/locations/l/ServiceConnectionTokens/foo')
        #     See https://google.aip.dev/122#resource-id-segments
        #     Unique per location.
        #     If one is not provided, one will be generated.
        # @!attribute [rw] service_connection_token
        #   @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken]
        #     Required. Initial values for a new ServiceConnectionTokens
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateServiceConnectionTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for DeleteServiceConnectionToken.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ServiceConnectionToken to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag is computed by the server, and may be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        class DeleteServiceConnectionTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The infrastructure used for connections between consumers/producers.
        module Infrastructure
          # An invalid infrastructure as the default case.
          INFRASTRUCTURE_UNSPECIFIED = 0

          # Private Service Connect is used for connections.
          PSC = 1
        end

        # The error type indicates whether a connection error is consumer facing,
        # producer facing or system internal.
        module ConnectionErrorType
          # An invalid error type as the default case.
          CONNECTION_ERROR_TYPE_UNSPECIFIED = 0

          # The error is due to Service Automation system internal.
          ERROR_INTERNAL = 1

          # The error is due to the setup on consumer side.
          ERROR_CONSUMER_SIDE = 2

          # The error is due to the setup on producer side.
          ERROR_PRODUCER_SIDE = 3
        end

        # The requested IP version for the PSC connection.
        module IPVersion
          # Default value. We will use IPv4 or IPv6 depending on the IP version of
          # first available subnetwork.
          IP_VERSION_UNSPECIFIED = 0

          # Will use IPv4 only.
          IPV4 = 1

          # Will use IPv6 only.
          IPV6 = 2
        end
      end
    end
  end
end
