# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/networkconnectivity/v1/hub.proto for package 'Google.Cloud.NetworkConnectivity.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/networkconnectivity/v1/hub_pb'

module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module HubService
          # Network Connectivity Center is a hub-and-spoke abstraction for network
          # connectivity management in Google Cloud. It reduces operational complexity
          # through a simple, centralized connectivity management model.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.networkconnectivity.v1.HubService'

            # Lists the Network Connectivity Center hubs associated with a given project.
            rpc :ListHubs, ::Google::Cloud::NetworkConnectivity::V1::ListHubsRequest, ::Google::Cloud::NetworkConnectivity::V1::ListHubsResponse
            # Gets details about a Network Connectivity Center hub.
            rpc :GetHub, ::Google::Cloud::NetworkConnectivity::V1::GetHubRequest, ::Google::Cloud::NetworkConnectivity::V1::Hub
            # Creates a new Network Connectivity Center hub in the specified project.
            rpc :CreateHub, ::Google::Cloud::NetworkConnectivity::V1::CreateHubRequest, ::Google::Longrunning::Operation
            # Updates the description and/or labels of a Network Connectivity Center
            # hub.
            rpc :UpdateHub, ::Google::Cloud::NetworkConnectivity::V1::UpdateHubRequest, ::Google::Longrunning::Operation
            # Deletes a Network Connectivity Center hub.
            rpc :DeleteHub, ::Google::Cloud::NetworkConnectivity::V1::DeleteHubRequest, ::Google::Longrunning::Operation
            # Lists the Network Connectivity Center spokes associated with a
            # specified hub and location. The list includes both spokes that are attached
            # to the hub and spokes that have been proposed but not yet accepted.
            rpc :ListHubSpokes, ::Google::Cloud::NetworkConnectivity::V1::ListHubSpokesRequest, ::Google::Cloud::NetworkConnectivity::V1::ListHubSpokesResponse
            # Query the Private Service Connect propagation status of a Network
            # Connectivity Center hub.
            rpc :QueryHubStatus, ::Google::Cloud::NetworkConnectivity::V1::QueryHubStatusRequest, ::Google::Cloud::NetworkConnectivity::V1::QueryHubStatusResponse
            # Lists the Network Connectivity Center spokes in a specified project and
            # location.
            rpc :ListSpokes, ::Google::Cloud::NetworkConnectivity::V1::ListSpokesRequest, ::Google::Cloud::NetworkConnectivity::V1::ListSpokesResponse
            # Gets details about a Network Connectivity Center spoke.
            rpc :GetSpoke, ::Google::Cloud::NetworkConnectivity::V1::GetSpokeRequest, ::Google::Cloud::NetworkConnectivity::V1::Spoke
            # Creates a Network Connectivity Center spoke.
            rpc :CreateSpoke, ::Google::Cloud::NetworkConnectivity::V1::CreateSpokeRequest, ::Google::Longrunning::Operation
            # Updates the parameters of a Network Connectivity Center spoke.
            rpc :UpdateSpoke, ::Google::Cloud::NetworkConnectivity::V1::UpdateSpokeRequest, ::Google::Longrunning::Operation
            # Rejects a Network Connectivity Center spoke from being attached to a hub.
            # If the spoke was previously in the `ACTIVE` state, it
            # transitions to the `INACTIVE` state and is no longer able to
            # connect to other spokes that are attached to the hub.
            rpc :RejectHubSpoke, ::Google::Cloud::NetworkConnectivity::V1::RejectHubSpokeRequest, ::Google::Longrunning::Operation
            # Accepts a proposal to attach a Network Connectivity Center spoke
            # to a hub.
            rpc :AcceptHubSpoke, ::Google::Cloud::NetworkConnectivity::V1::AcceptHubSpokeRequest, ::Google::Longrunning::Operation
            # Accepts a proposal to update a Network Connectivity Center spoke in a hub.
            rpc :AcceptSpokeUpdate, ::Google::Cloud::NetworkConnectivity::V1::AcceptSpokeUpdateRequest, ::Google::Longrunning::Operation
            # Rejects a proposal to update a Network Connectivity Center spoke in a hub.
            rpc :RejectSpokeUpdate, ::Google::Cloud::NetworkConnectivity::V1::RejectSpokeUpdateRequest, ::Google::Longrunning::Operation
            # Deletes a Network Connectivity Center spoke.
            rpc :DeleteSpoke, ::Google::Cloud::NetworkConnectivity::V1::DeleteSpokeRequest, ::Google::Longrunning::Operation
            # Gets details about a Network Connectivity Center route table.
            rpc :GetRouteTable, ::Google::Cloud::NetworkConnectivity::V1::GetRouteTableRequest, ::Google::Cloud::NetworkConnectivity::V1::RouteTable
            # Gets details about the specified route.
            rpc :GetRoute, ::Google::Cloud::NetworkConnectivity::V1::GetRouteRequest, ::Google::Cloud::NetworkConnectivity::V1::Route
            # Lists routes in a given route table.
            rpc :ListRoutes, ::Google::Cloud::NetworkConnectivity::V1::ListRoutesRequest, ::Google::Cloud::NetworkConnectivity::V1::ListRoutesResponse
            # Lists route tables in a given hub.
            rpc :ListRouteTables, ::Google::Cloud::NetworkConnectivity::V1::ListRouteTablesRequest, ::Google::Cloud::NetworkConnectivity::V1::ListRouteTablesResponse
            # Gets details about a Network Connectivity Center group.
            rpc :GetGroup, ::Google::Cloud::NetworkConnectivity::V1::GetGroupRequest, ::Google::Cloud::NetworkConnectivity::V1::Group
            # Lists groups in a given hub.
            rpc :ListGroups, ::Google::Cloud::NetworkConnectivity::V1::ListGroupsRequest, ::Google::Cloud::NetworkConnectivity::V1::ListGroupsResponse
            # Updates the parameters of a Network Connectivity Center group.
            rpc :UpdateGroup, ::Google::Cloud::NetworkConnectivity::V1::UpdateGroupRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
