# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module PolicyBasedRoutingService
          # Path helper methods for the PolicyBasedRoutingService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{resource_id}`
            #
            # @param project [String]
            # @param resource_id [String]
            #
            # @return [::String]
            def network_path project:, resource_id:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{resource_id}"
            end

            ##
            # Create a fully-qualified PolicyBasedRoute resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/global/PolicyBasedRoutes/{policy_based_route}`
            #
            # @param project [String]
            # @param policy_based_route [String]
            #
            # @return [::String]
            def policy_based_route_path project:, policy_based_route:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/global/PolicyBasedRoutes/#{policy_based_route}"
            end

            extend self
          end
        end
      end
    end
  end
end
