# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/network_connectivity/v1/version"

require "google/cloud/network_connectivity/v1/policy_based_routing_service/credentials"
require "google/cloud/network_connectivity/v1/policy_based_routing_service/paths"
require "google/cloud/network_connectivity/v1/policy_based_routing_service/operations"
require "google/cloud/network_connectivity/v1/policy_based_routing_service/client"

module Google
  module Cloud
    module NetworkConnectivity
      module V1
        ##
        # Policy-Based Routing allows GCP customers to specify flexibile routing
        # policies for Layer 4 traffic traversing through the connected service.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/network_connectivity/v1/policy_based_routing_service"
        #     client = ::Google::Cloud::NetworkConnectivity::V1::PolicyBasedRoutingService::Client.new
        #
        module PolicyBasedRoutingService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "policy_based_routing_service", "helpers.rb"
require "google/cloud/network_connectivity/v1/policy_based_routing_service/helpers" if ::File.file? helper_path
