# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module DataTransferService
          # Path helper methods for the DataTransferService API.
          module Paths
            ##
            # Create a fully-qualified Destination resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}/destinations/{destination}`
            #
            # @param project [String]
            # @param location [String]
            # @param multicloud_data_transfer_config [String]
            # @param destination [String]
            #
            # @return [::String]
            def destination_path project:, location:, multicloud_data_transfer_config:, destination:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "multicloud_data_transfer_config cannot contain /" if multicloud_data_transfer_config.to_s.include? "/"

              "projects/#{project}/locations/#{location}/multicloudDataTransferConfigs/#{multicloud_data_transfer_config}/destinations/#{destination}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified MulticloudDataTransferConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param multicloud_data_transfer_config [String]
            #
            # @return [::String]
            def multicloud_data_transfer_config_path project:, location:, multicloud_data_transfer_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/multicloudDataTransferConfigs/#{multicloud_data_transfer_config}"
            end

            ##
            # Create a fully-qualified MulticloudDataTransferSupportedService resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/multicloudDataTransferSupportedServices/{multicloud_data_transfer_supported_service}`
            #
            # @param project [String]
            # @param location [String]
            # @param multicloud_data_transfer_supported_service [String]
            #
            # @return [::String]
            def multicloud_data_transfer_supported_service_path project:, location:, multicloud_data_transfer_supported_service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/multicloudDataTransferSupportedServices/#{multicloud_data_transfer_supported_service}"
            end

            extend self
          end
        end
      end
    end
  end
end
