# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkconnectivity/v1/data_transfer_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module DataTransferService
          ##
          # Client for the DataTransferService service.
          #
          # DataTransferService is the service for the Data Transfer API.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networkconnectivity.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :data_transfer_service_stub

            ##
            # Configure the DataTransferService Client class.
            #
            # See {::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DataTransferService clients
            #   ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkConnectivity", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 60.0
                default_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_multicloud_data_transfer_configs.timeout = 60.0

                default_config.rpcs.get_multicloud_data_transfer_config.timeout = 60.0

                default_config.rpcs.create_multicloud_data_transfer_config.timeout = 60.0

                default_config.rpcs.update_multicloud_data_transfer_config.timeout = 60.0

                default_config.rpcs.delete_multicloud_data_transfer_config.timeout = 60.0

                default_config.rpcs.list_destinations.timeout = 60.0

                default_config.rpcs.get_destination.timeout = 60.0

                default_config.rpcs.create_destination.timeout = 60.0

                default_config.rpcs.update_destination.timeout = 60.0

                default_config.rpcs.delete_destination.timeout = 60.0

                default_config.rpcs.get_multicloud_data_transfer_supported_service.timeout = 60.0

                default_config.rpcs.list_multicloud_data_transfer_supported_services.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DataTransferService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @data_transfer_service_stub.universe_domain
            end

            ##
            # Create a new DataTransferService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DataTransferService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networkconnectivity/v1/data_transfer_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @data_transfer_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @data_transfer_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_transfer_service_stub.endpoint
                config.universe_domain = @data_transfer_service_stub.universe_domain
                config.logger = @data_transfer_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @data_transfer_service_stub.endpoint
                config.universe_domain = @data_transfer_service_stub.universe_domain
                config.logger = @data_transfer_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @data_transfer_service_stub.logger
            end

            # Service calls

            ##
            # Lists the `MulticloudDataTransferConfig` resources in a specified project
            # and location.
            #
            # @overload list_multicloud_data_transfer_configs(request, options = nil)
            #   Pass arguments to `list_multicloud_data_transfer_configs` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_multicloud_data_transfer_configs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, return_partial_success: nil)
            #   Pass arguments to `list_multicloud_data_transfer_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results listed per page.
            #   @param page_token [::String]
            #     Optional. The page token.
            #   @param filter [::String]
            #     Optional. An expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Optional. The sort order of the results.
            #   @param return_partial_success [::Boolean]
            #     Optional. If `true`, allows partial responses for multi-regional aggregated
            #     list requests.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest.new
            #
            #   # Call the list_multicloud_data_transfer_configs method.
            #   result = client.list_multicloud_data_transfer_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig.
            #     p item
            #   end
            #
            def list_multicloud_data_transfer_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_multicloud_data_transfer_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_multicloud_data_transfer_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_multicloud_data_transfer_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :list_multicloud_data_transfer_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_transfer_service_stub, :list_multicloud_data_transfer_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a `MulticloudDataTransferConfig` resource.
            #
            # @overload get_multicloud_data_transfer_config(request, options = nil)
            #   Pass arguments to `get_multicloud_data_transfer_config` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_multicloud_data_transfer_config(name: nil)
            #   Pass arguments to `get_multicloud_data_transfer_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the `MulticloudDataTransferConfig` resource to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest.new
            #
            #   # Call the get_multicloud_data_transfer_config method.
            #   result = client.get_multicloud_data_transfer_config request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig.
            #   p result
            #
            def get_multicloud_data_transfer_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_multicloud_data_transfer_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_multicloud_data_transfer_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_multicloud_data_transfer_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :get_multicloud_data_transfer_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a `MulticloudDataTransferConfig` resource in a specified project
            # and location.
            #
            # @overload create_multicloud_data_transfer_config(request, options = nil)
            #   Pass arguments to `create_multicloud_data_transfer_config` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_multicloud_data_transfer_config(parent: nil, multicloud_data_transfer_config_id: nil, multicloud_data_transfer_config: nil, request_id: nil)
            #   Pass arguments to `create_multicloud_data_transfer_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource.
            #   @param multicloud_data_transfer_config_id [::String]
            #     Required. The ID to use for the `MulticloudDataTransferConfig` resource,
            #     which becomes the final component of the `MulticloudDataTransferConfig`
            #     resource name.
            #   @param multicloud_data_transfer_config [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig, ::Hash]
            #     Required. The `MulticloudDataTransferConfig` resource to create.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request. This prevents
            #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
            #     resources.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest.new
            #
            #   # Call the create_multicloud_data_transfer_config method.
            #   result = client.create_multicloud_data_transfer_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_multicloud_data_transfer_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::CreateMulticloudDataTransferConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_multicloud_data_transfer_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_multicloud_data_transfer_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_multicloud_data_transfer_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :create_multicloud_data_transfer_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a `MulticloudDataTransferConfig` resource in a specified project
            # and location.
            #
            # @overload update_multicloud_data_transfer_config(request, options = nil)
            #   Pass arguments to `update_multicloud_data_transfer_config` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_multicloud_data_transfer_config(update_mask: nil, multicloud_data_transfer_config: nil, request_id: nil)
            #   Pass arguments to `update_multicloud_data_transfer_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. `FieldMask` is used to specify the fields in the
            #     `MulticloudDataTransferConfig` resource to be overwritten by the update.
            #     The fields specified in `update_mask` are relative to the resource, not
            #     the full request. A field is overwritten if it is in the mask. If you
            #     don't specify a mask, all fields are overwritten.
            #   @param multicloud_data_transfer_config [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferConfig, ::Hash]
            #     Required. The `MulticloudDataTransferConfig` resource to update.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request. This prevents
            #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
            #     resources.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest.new
            #
            #   # Call the update_multicloud_data_transfer_config method.
            #   result = client.update_multicloud_data_transfer_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_multicloud_data_transfer_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::UpdateMulticloudDataTransferConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_multicloud_data_transfer_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.multicloud_data_transfer_config&.name
                header_params["multicloud_data_transfer_config.name"] = request.multicloud_data_transfer_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_multicloud_data_transfer_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_multicloud_data_transfer_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :update_multicloud_data_transfer_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `MulticloudDataTransferConfig` resource.
            #
            # @overload delete_multicloud_data_transfer_config(request, options = nil)
            #   Pass arguments to `delete_multicloud_data_transfer_config` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_multicloud_data_transfer_config(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_multicloud_data_transfer_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the `MulticloudDataTransferConfig` resource to
            #     delete.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request. This prevents
            #     clients from accidentally creating duplicate `MulticloudDataTransferConfig`
            #     resources.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and might be sent with update
            #     and delete requests so that the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest.new
            #
            #   # Call the delete_multicloud_data_transfer_config method.
            #   result = client.delete_multicloud_data_transfer_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_multicloud_data_transfer_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteMulticloudDataTransferConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_multicloud_data_transfer_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_multicloud_data_transfer_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_multicloud_data_transfer_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :delete_multicloud_data_transfer_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the `Destination` resources in a specified project and location.
            #
            # @overload list_destinations(request, options = nil)
            #   Pass arguments to `list_destinations` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_destinations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil, return_partial_success: nil)
            #   Pass arguments to `list_destinations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results listed per page.
            #   @param page_token [::String]
            #     Optional. The page token.
            #   @param filter [::String]
            #     Optional. An expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Optional. The sort order of the results.
            #   @param return_partial_success [::Boolean]
            #     Optional. If `true`, allow partial responses for multi-regional aggregated
            #     list requests.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::Destination>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::Destination>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest.new
            #
            #   # Call the list_destinations method.
            #   result = client.list_destinations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::Destination.
            #     p item
            #   end
            #
            def list_destinations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListDestinationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_destinations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_destinations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_destinations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :list_destinations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_transfer_service_stub, :list_destinations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a `Destination` resource.
            #
            # @overload get_destination(request, options = nil)
            #   Pass arguments to `get_destination` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_destination(name: nil)
            #   Pass arguments to `get_destination` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the `Destination` resource to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::Destination]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::Destination]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest.new
            #
            #   # Call the get_destination method.
            #   result = client.get_destination request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::Destination.
            #   p result
            #
            def get_destination request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetDestinationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_destination.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_destination.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_destination.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :get_destination, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a `Destination` resource in a specified project and location.
            #
            # @overload create_destination(request, options = nil)
            #   Pass arguments to `create_destination` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_destination(parent: nil, destination_id: nil, destination: nil, request_id: nil)
            #   Pass arguments to `create_destination` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource.
            #   @param destination_id [::String]
            #     Required. The ID to use for the `Destination` resource, which becomes the
            #     final component of the `Destination` resource name.
            #   @param destination [::Google::Cloud::NetworkConnectivity::V1::Destination, ::Hash]
            #     Required. The `Destination` resource to create.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request. This prevents
            #     clients from accidentally creating duplicate `Destination`
            #     resources.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest.new
            #
            #   # Call the create_destination method.
            #   result = client.create_destination request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_destination request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::CreateDestinationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_destination.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_destination.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_destination.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :create_destination, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a `Destination` resource in a specified project and location.
            #
            # @overload update_destination(request, options = nil)
            #   Pass arguments to `update_destination` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_destination(update_mask: nil, destination: nil, request_id: nil)
            #   Pass arguments to `update_destination` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. `FieldMask is used to specify the fields to be overwritten in the
            #     `Destination` resource by the update.
            #     The fields specified in `update_mask` are relative to the resource, not
            #     the full request. A field is overwritten if it is in the mask. If you
            #     don't specify a mask, all fields are overwritten.
            #   @param destination [::Google::Cloud::NetworkConnectivity::V1::Destination, ::Hash]
            #     Required. The `Destination` resource to update.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest.new
            #
            #   # Call the update_destination method.
            #   result = client.update_destination request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_destination request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::UpdateDestinationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_destination.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.destination&.name
                header_params["destination.name"] = request.destination.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_destination.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_destination.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :update_destination, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `Destination` resource.
            #
            # @overload delete_destination(request, options = nil)
            #   Pass arguments to `delete_destination` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_destination(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_destination` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the `Destination` resource to delete.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server can ignore
            #     the request if it has already been completed. The server waits
            #     for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, can ignore the second request.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID
            #     (00000000-0000-0000-0000-000000000000) isn't supported.
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and might be sent with update
            #     and delete requests so that the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest.new
            #
            #   # Call the delete_destination method.
            #   result = client.delete_destination request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_destination request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteDestinationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_destination.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_destination.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_destination.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :delete_destination, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a service that is supported for Data Transfer
            # Essentials.
            #
            # @overload get_multicloud_data_transfer_supported_service(request, options = nil)
            #   Pass arguments to `get_multicloud_data_transfer_supported_service` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_multicloud_data_transfer_supported_service(name: nil)
            #   Pass arguments to `get_multicloud_data_transfer_supported_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the service.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest.new
            #
            #   # Call the get_multicloud_data_transfer_supported_service method.
            #   result = client.get_multicloud_data_transfer_supported_service request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService.
            #   p result
            #
            def get_multicloud_data_transfer_supported_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetMulticloudDataTransferSupportedServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_multicloud_data_transfer_supported_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_multicloud_data_transfer_supported_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_multicloud_data_transfer_supported_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :get_multicloud_data_transfer_supported_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the services in the project for a region that are supported for
            # Data Transfer Essentials.
            #
            # @overload list_multicloud_data_transfer_supported_services(request, options = nil)
            #   Pass arguments to `list_multicloud_data_transfer_supported_services` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_multicloud_data_transfer_supported_services(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_multicloud_data_transfer_supported_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The name of the parent resource.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results listed per page.
            #   @param page_token [::String]
            #     Optional. The page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest.new
            #
            #   # Call the list_multicloud_data_transfer_supported_services method.
            #   result = client.list_multicloud_data_transfer_supported_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::MulticloudDataTransferSupportedService.
            #     p item
            #   end
            #
            def list_multicloud_data_transfer_supported_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListMulticloudDataTransferSupportedServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_multicloud_data_transfer_supported_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_multicloud_data_transfer_supported_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_multicloud_data_transfer_supported_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @data_transfer_service_stub.call_rpc :list_multicloud_data_transfer_supported_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @data_transfer_service_stub, :list_multicloud_data_transfer_supported_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DataTransferService API.
            #
            # This class represents the configuration for DataTransferService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_multicloud_data_transfer_configs to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_multicloud_data_transfer_configs.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_multicloud_data_transfer_configs.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkConnectivity::V1::DataTransferService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networkconnectivity.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DataTransferService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_multicloud_data_transfer_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_multicloud_data_transfer_configs
                ##
                # RPC-specific configuration for `get_multicloud_data_transfer_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_multicloud_data_transfer_config
                ##
                # RPC-specific configuration for `create_multicloud_data_transfer_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_multicloud_data_transfer_config
                ##
                # RPC-specific configuration for `update_multicloud_data_transfer_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_multicloud_data_transfer_config
                ##
                # RPC-specific configuration for `delete_multicloud_data_transfer_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_multicloud_data_transfer_config
                ##
                # RPC-specific configuration for `list_destinations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_destinations
                ##
                # RPC-specific configuration for `get_destination`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_destination
                ##
                # RPC-specific configuration for `create_destination`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_destination
                ##
                # RPC-specific configuration for `update_destination`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_destination
                ##
                # RPC-specific configuration for `delete_destination`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_destination
                ##
                # RPC-specific configuration for `get_multicloud_data_transfer_supported_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_multicloud_data_transfer_supported_service
                ##
                # RPC-specific configuration for `list_multicloud_data_transfer_supported_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_multicloud_data_transfer_supported_services

                # @private
                def initialize parent_rpcs = nil
                  list_multicloud_data_transfer_configs_config = parent_rpcs.list_multicloud_data_transfer_configs if parent_rpcs.respond_to? :list_multicloud_data_transfer_configs
                  @list_multicloud_data_transfer_configs = ::Gapic::Config::Method.new list_multicloud_data_transfer_configs_config
                  get_multicloud_data_transfer_config_config = parent_rpcs.get_multicloud_data_transfer_config if parent_rpcs.respond_to? :get_multicloud_data_transfer_config
                  @get_multicloud_data_transfer_config = ::Gapic::Config::Method.new get_multicloud_data_transfer_config_config
                  create_multicloud_data_transfer_config_config = parent_rpcs.create_multicloud_data_transfer_config if parent_rpcs.respond_to? :create_multicloud_data_transfer_config
                  @create_multicloud_data_transfer_config = ::Gapic::Config::Method.new create_multicloud_data_transfer_config_config
                  update_multicloud_data_transfer_config_config = parent_rpcs.update_multicloud_data_transfer_config if parent_rpcs.respond_to? :update_multicloud_data_transfer_config
                  @update_multicloud_data_transfer_config = ::Gapic::Config::Method.new update_multicloud_data_transfer_config_config
                  delete_multicloud_data_transfer_config_config = parent_rpcs.delete_multicloud_data_transfer_config if parent_rpcs.respond_to? :delete_multicloud_data_transfer_config
                  @delete_multicloud_data_transfer_config = ::Gapic::Config::Method.new delete_multicloud_data_transfer_config_config
                  list_destinations_config = parent_rpcs.list_destinations if parent_rpcs.respond_to? :list_destinations
                  @list_destinations = ::Gapic::Config::Method.new list_destinations_config
                  get_destination_config = parent_rpcs.get_destination if parent_rpcs.respond_to? :get_destination
                  @get_destination = ::Gapic::Config::Method.new get_destination_config
                  create_destination_config = parent_rpcs.create_destination if parent_rpcs.respond_to? :create_destination
                  @create_destination = ::Gapic::Config::Method.new create_destination_config
                  update_destination_config = parent_rpcs.update_destination if parent_rpcs.respond_to? :update_destination
                  @update_destination = ::Gapic::Config::Method.new update_destination_config
                  delete_destination_config = parent_rpcs.delete_destination if parent_rpcs.respond_to? :delete_destination
                  @delete_destination = ::Gapic::Config::Method.new delete_destination_config
                  get_multicloud_data_transfer_supported_service_config = parent_rpcs.get_multicloud_data_transfer_supported_service if parent_rpcs.respond_to? :get_multicloud_data_transfer_supported_service
                  @get_multicloud_data_transfer_supported_service = ::Gapic::Config::Method.new get_multicloud_data_transfer_supported_service_config
                  list_multicloud_data_transfer_supported_services_config = parent_rpcs.list_multicloud_data_transfer_supported_services if parent_rpcs.respond_to? :list_multicloud_data_transfer_supported_services
                  @list_multicloud_data_transfer_supported_services = ::Gapic::Config::Method.new list_multicloud_data_transfer_supported_services_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
