# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module CrossNetworkAutomationService
          # Path helper methods for the CrossNetworkAutomationService API.
          module Paths
            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{resource_id}`
            #
            # @param project [String]
            # @param resource_id [String]
            #
            # @return [::String]
            def network_path project:, resource_id:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{resource_id}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified ServiceAttachment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/serviceAttachments/{service_attachment}`
            #
            # @param project [String]
            # @param region [String]
            # @param service_attachment [String]
            #
            # @return [::String]
            def service_attachment_path project:, region:, service_attachment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/serviceAttachments/#{service_attachment}"
            end

            ##
            # Create a fully-qualified ServiceClass resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceClasses/{service_class}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_class [String]
            #
            # @return [::String]
            def service_class_path project:, location:, service_class:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceClasses/#{service_class}"
            end

            ##
            # Create a fully-qualified ServiceConnectionMap resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceConnectionMaps/{service_connection_map}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_connection_map [String]
            #
            # @return [::String]
            def service_connection_map_path project:, location:, service_connection_map:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceConnectionMaps/#{service_connection_map}"
            end

            ##
            # Create a fully-qualified ServiceConnectionPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_connection_policy [String]
            #
            # @return [::String]
            def service_connection_policy_path project:, location:, service_connection_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceConnectionPolicies/#{service_connection_policy}"
            end

            ##
            # Create a fully-qualified ServiceConnectionToken resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/serviceConnectionTokens/{service_connection_token}`
            #
            # @param project [String]
            # @param location [String]
            # @param service_connection_token [String]
            #
            # @return [::String]
            def service_connection_token_path project:, location:, service_connection_token:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/serviceConnectionTokens/#{service_connection_token}"
            end

            ##
            # Create a fully-qualified Subnetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
            #
            # @param project [String]
            # @param region [String]
            # @param subnetwork [String]
            #
            # @return [::String]
            def subnetwork_path project:, region:, subnetwork:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/subnetworks/#{subnetwork}"
            end

            extend self
          end
        end
      end
    end
  end
end
