# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/networkconnectivity/v1/cross_network_automation_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module NetworkConnectivity
      module V1
        module CrossNetworkAutomationService
          ##
          # Client for the CrossNetworkAutomationService service.
          #
          # The service for CrossNetworkAutomation resources.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "networkconnectivity.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :cross_network_automation_service_stub

            ##
            # Configure the CrossNetworkAutomationService Client class.
            #
            # See {::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CrossNetworkAutomationService clients
            #   ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "NetworkConnectivity", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CrossNetworkAutomationService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @cross_network_automation_service_stub.universe_domain
            end

            ##
            # Create a new CrossNetworkAutomationService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CrossNetworkAutomationService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/networkconnectivity/v1/cross_network_automation_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @cross_network_automation_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @cross_network_automation_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @cross_network_automation_service_stub.endpoint
                config.universe_domain = @cross_network_automation_service_stub.universe_domain
                config.logger = @cross_network_automation_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @cross_network_automation_service_stub.endpoint
                config.universe_domain = @cross_network_automation_service_stub.universe_domain
                config.logger = @cross_network_automation_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @cross_network_automation_service_stub.logger
            end

            # Service calls

            ##
            # Lists ServiceConnectionMaps in a given project and location.
            #
            # @overload list_service_connection_maps(request, options = nil)
            #   Pass arguments to `list_service_connection_maps` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_connection_maps(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_service_connection_maps` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name. ex. projects/123/locations/us-east1
            #   @param page_size [::Integer]
            #     The maximum number of results per page that should be returned.
            #   @param page_token [::String]
            #     The page token.
            #   @param filter [::String]
            #     A filter expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Sort the results by a certain order.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest.new
            #
            #   # Call the list_service_connection_maps method.
            #   result = client.list_service_connection_maps request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap.
            #     p item
            #   end
            #
            def list_service_connection_maps request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionMapsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_connection_maps.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_connection_maps.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_connection_maps.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :list_service_connection_maps, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cross_network_automation_service_stub, :list_service_connection_maps, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceConnectionMap.
            #
            # @overload get_service_connection_map(request, options = nil)
            #   Pass arguments to `get_service_connection_map` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_connection_map(name: nil)
            #   Pass arguments to `get_service_connection_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ServiceConnectionMap to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest.new
            #
            #   # Call the get_service_connection_map method.
            #   result = client.get_service_connection_map request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap.
            #   p result
            #
            def get_service_connection_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_connection_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_connection_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_connection_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :get_service_connection_map, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServiceConnectionMap in a given project and location.
            #
            # @overload create_service_connection_map(request, options = nil)
            #   Pass arguments to `create_service_connection_map` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_connection_map(parent: nil, service_connection_map_id: nil, service_connection_map: nil, request_id: nil)
            #   Pass arguments to `create_service_connection_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name of the ServiceConnectionMap. ex.
            #     projects/123/locations/us-east1
            #   @param service_connection_map_id [::String]
            #     Optional. Resource ID
            #     (i.e. 'foo' in '[...]/projects/p/locations/l/serviceConnectionMaps/foo')
            #     See https://google.aip.dev/122#resource-id-segments
            #     Unique per location.
            #     If one is not provided, one will be generated.
            #   @param service_connection_map [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap, ::Hash]
            #     Required. Initial values for a new ServiceConnectionMaps
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest.new
            #
            #   # Call the create_service_connection_map method.
            #   result = client.create_service_connection_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_connection_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_connection_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_connection_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_connection_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :create_service_connection_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServiceConnectionMap.
            #
            # @overload update_service_connection_map(request, options = nil)
            #   Pass arguments to `update_service_connection_map` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_connection_map(update_mask: nil, service_connection_map: nil, request_id: nil)
            #   Pass arguments to `update_service_connection_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServiceConnectionMap resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param service_connection_map [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionMap, ::Hash]
            #     Required. New values to be patched into the resource.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest.new
            #
            #   # Call the update_service_connection_map method.
            #   result = client.update_service_connection_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service_connection_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_connection_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_connection_map&.name
                header_params["service_connection_map.name"] = request.service_connection_map.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_connection_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_connection_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :update_service_connection_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceConnectionMap.
            #
            # @overload delete_service_connection_map(request, options = nil)
            #   Pass arguments to `delete_service_connection_map` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_connection_map(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_service_connection_map` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ServiceConnectionMap to delete.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and may be sent on update and
            #     delete requests to ensure the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest.new
            #
            #   # Call the delete_service_connection_map method.
            #   result = client.delete_service_connection_map request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_connection_map request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionMapRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_connection_map.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_connection_map.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_connection_map.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :delete_service_connection_map, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServiceConnectionPolicies in a given project and location.
            #
            # @overload list_service_connection_policies(request, options = nil)
            #   Pass arguments to `list_service_connection_policies` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_connection_policies(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_service_connection_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name. ex. projects/123/locations/us-east1
            #   @param page_size [::Integer]
            #     The maximum number of results per page that should be returned.
            #   @param page_token [::String]
            #     The page token.
            #   @param filter [::String]
            #     A filter expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Sort the results by a certain order.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest.new
            #
            #   # Call the list_service_connection_policies method.
            #   result = client.list_service_connection_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy.
            #     p item
            #   end
            #
            def list_service_connection_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_connection_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_connection_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_connection_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :list_service_connection_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cross_network_automation_service_stub, :list_service_connection_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceConnectionPolicy.
            #
            # @overload get_service_connection_policy(request, options = nil)
            #   Pass arguments to `get_service_connection_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_connection_policy(name: nil)
            #   Pass arguments to `get_service_connection_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ServiceConnectionPolicy to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest.new
            #
            #   # Call the get_service_connection_policy method.
            #   result = client.get_service_connection_policy request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy.
            #   p result
            #
            def get_service_connection_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_connection_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_connection_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_connection_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :get_service_connection_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServiceConnectionPolicy in a given project and location.
            #
            # @overload create_service_connection_policy(request, options = nil)
            #   Pass arguments to `create_service_connection_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_connection_policy(parent: nil, service_connection_policy_id: nil, service_connection_policy: nil, request_id: nil)
            #   Pass arguments to `create_service_connection_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name of the ServiceConnectionPolicy. ex.
            #     projects/123/locations/us-east1
            #   @param service_connection_policy_id [::String]
            #     Optional. Resource ID
            #     (i.e. 'foo' in
            #     '[...]/projects/p/locations/l/serviceConnectionPolicies/foo') See
            #     https://google.aip.dev/122#resource-id-segments Unique per location.
            #   @param service_connection_policy [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy, ::Hash]
            #     Required. Initial values for a new ServiceConnectionPolicies
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest.new
            #
            #   # Call the create_service_connection_policy method.
            #   result = client.create_service_connection_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_connection_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_connection_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_connection_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_connection_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :create_service_connection_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServiceConnectionPolicy.
            #
            # @overload update_service_connection_policy(request, options = nil)
            #   Pass arguments to `update_service_connection_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_connection_policy(update_mask: nil, service_connection_policy: nil, request_id: nil)
            #   Pass arguments to `update_service_connection_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServiceConnectionPolicy resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param service_connection_policy [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionPolicy, ::Hash]
            #     Required. New values to be patched into the resource.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest.new
            #
            #   # Call the update_service_connection_policy method.
            #   result = client.update_service_connection_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service_connection_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceConnectionPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_connection_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_connection_policy&.name
                header_params["service_connection_policy.name"] = request.service_connection_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_connection_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_connection_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :update_service_connection_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceConnectionPolicy.
            #
            # @overload delete_service_connection_policy(request, options = nil)
            #   Pass arguments to `delete_service_connection_policy` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_connection_policy(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_service_connection_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ServiceConnectionPolicy to delete.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and may be sent on update and
            #     delete requests to ensure the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest.new
            #
            #   # Call the delete_service_connection_policy method.
            #   result = client.delete_service_connection_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_connection_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_connection_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_connection_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_connection_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :delete_service_connection_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServiceClasses in a given project and location.
            #
            # @overload list_service_classes(request, options = nil)
            #   Pass arguments to `list_service_classes` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_classes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_service_classes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name. ex. projects/123/locations/us-east1
            #   @param page_size [::Integer]
            #     The maximum number of results per page that should be returned.
            #   @param page_token [::String]
            #     The page token.
            #   @param filter [::String]
            #     A filter expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Sort the results by a certain order.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceClass>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceClass>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest.new
            #
            #   # Call the list_service_classes method.
            #   result = client.list_service_classes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::ServiceClass.
            #     p item
            #   end
            #
            def list_service_classes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListServiceClassesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_classes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_classes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_classes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :list_service_classes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cross_network_automation_service_stub, :list_service_classes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceClass.
            #
            # @overload get_service_class(request, options = nil)
            #   Pass arguments to `get_service_class` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_class(name: nil)
            #   Pass arguments to `get_service_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ServiceClass to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::ServiceClass]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::ServiceClass]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest.new
            #
            #   # Call the get_service_class method.
            #   result = client.get_service_class request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::ServiceClass.
            #   p result
            #
            def get_service_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetServiceClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :get_service_class, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single ServiceClass.
            #
            # @overload update_service_class(request, options = nil)
            #   Pass arguments to `update_service_class` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_class(update_mask: nil, service_class: nil, request_id: nil)
            #   Pass arguments to `update_service_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. Field mask is used to specify the fields to be overwritten in the
            #     ServiceClass resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param service_class [::Google::Cloud::NetworkConnectivity::V1::ServiceClass, ::Hash]
            #     Required. New values to be patched into the resource.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest.new
            #
            #   # Call the update_service_class method.
            #   result = client.update_service_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_service_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::UpdateServiceClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_class&.name
                header_params["service_class.name"] = request.service_class.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :update_service_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceClass.
            #
            # @overload delete_service_class(request, options = nil)
            #   Pass arguments to `delete_service_class` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_class(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_service_class` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ServiceClass to delete.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and may be sent on update and
            #     delete requests to ensure the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest.new
            #
            #   # Call the delete_service_class method.
            #   result = client.delete_service_class request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_class request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceClassRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_class.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_class.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_class.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :delete_service_class, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single ServiceConnectionToken.
            #
            # @overload get_service_connection_token(request, options = nil)
            #   Pass arguments to `get_service_connection_token` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_connection_token(name: nil)
            #   Pass arguments to `get_service_connection_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the ServiceConnectionToken to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest.new
            #
            #   # Call the get_service_connection_token method.
            #   result = client.get_service_connection_token request
            #
            #   # The returned object is of type Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken.
            #   p result
            #
            def get_service_connection_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::GetServiceConnectionTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_connection_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_connection_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_connection_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :get_service_connection_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists ServiceConnectionTokens in a given project and location.
            #
            # @overload list_service_connection_tokens(request, options = nil)
            #   Pass arguments to `list_service_connection_tokens` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_connection_tokens(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_service_connection_tokens` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name. ex. projects/123/locations/us-east1
            #   @param page_size [::Integer]
            #     The maximum number of results per page that should be returned.
            #   @param page_token [::String]
            #     The page token.
            #   @param filter [::String]
            #     A filter expression that filters the results listed in the response.
            #   @param order_by [::String]
            #     Sort the results by a certain order.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest.new
            #
            #   # Call the list_service_connection_tokens method.
            #   result = client.list_service_connection_tokens request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken.
            #     p item
            #   end
            #
            def list_service_connection_tokens request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::ListServiceConnectionTokensRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_connection_tokens.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_connection_tokens.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_connection_tokens.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :list_service_connection_tokens, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cross_network_automation_service_stub, :list_service_connection_tokens, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new ServiceConnectionToken in a given project and location.
            #
            # @overload create_service_connection_token(request, options = nil)
            #   Pass arguments to `create_service_connection_token` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_connection_token(parent: nil, service_connection_token_id: nil, service_connection_token: nil, request_id: nil)
            #   Pass arguments to `create_service_connection_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource's name of the ServiceConnectionToken. ex.
            #     projects/123/locations/us-east1
            #   @param service_connection_token_id [::String]
            #     Optional. Resource ID
            #     (i.e. 'foo' in '[...]/projects/p/locations/l/ServiceConnectionTokens/foo')
            #     See https://google.aip.dev/122#resource-id-segments
            #     Unique per location.
            #     If one is not provided, one will be generated.
            #   @param service_connection_token [::Google::Cloud::NetworkConnectivity::V1::ServiceConnectionToken, ::Hash]
            #     Required. Initial values for a new ServiceConnectionTokens
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest.new
            #
            #   # Call the create_service_connection_token method.
            #   result = client.create_service_connection_token request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_service_connection_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::CreateServiceConnectionTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_connection_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_connection_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_connection_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :create_service_connection_token, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single ServiceConnectionToken.
            #
            # @overload delete_service_connection_token(request, options = nil)
            #   Pass arguments to `delete_service_connection_token` via a request object, either of type
            #   {::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_connection_token(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_service_connection_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the ServiceConnectionToken to delete.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and
            #     the request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param etag [::String]
            #     Optional. The etag is computed by the server, and may be sent on update and
            #     delete requests to ensure the client has an up-to-date value before
            #     proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/network_connectivity/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest.new
            #
            #   # Call the delete_service_connection_token method.
            #   result = client.delete_service_connection_token request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_service_connection_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetworkConnectivity::V1::DeleteServiceConnectionTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_connection_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::NetworkConnectivity::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_connection_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_connection_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cross_network_automation_service_stub.call_rpc :delete_service_connection_token, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CrossNetworkAutomationService API.
            #
            # This class represents the configuration for CrossNetworkAutomationService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_service_connection_maps to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_service_connection_maps.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_service_connection_maps.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::NetworkConnectivity::V1::CrossNetworkAutomationService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "networkconnectivity.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CrossNetworkAutomationService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_service_connection_maps`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_connection_maps
                ##
                # RPC-specific configuration for `get_service_connection_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_connection_map
                ##
                # RPC-specific configuration for `create_service_connection_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_connection_map
                ##
                # RPC-specific configuration for `update_service_connection_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_connection_map
                ##
                # RPC-specific configuration for `delete_service_connection_map`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_connection_map
                ##
                # RPC-specific configuration for `list_service_connection_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_connection_policies
                ##
                # RPC-specific configuration for `get_service_connection_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_connection_policy
                ##
                # RPC-specific configuration for `create_service_connection_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_connection_policy
                ##
                # RPC-specific configuration for `update_service_connection_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_connection_policy
                ##
                # RPC-specific configuration for `delete_service_connection_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_connection_policy
                ##
                # RPC-specific configuration for `list_service_classes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_classes
                ##
                # RPC-specific configuration for `get_service_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_class
                ##
                # RPC-specific configuration for `update_service_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_class
                ##
                # RPC-specific configuration for `delete_service_class`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_class
                ##
                # RPC-specific configuration for `get_service_connection_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_connection_token
                ##
                # RPC-specific configuration for `list_service_connection_tokens`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_connection_tokens
                ##
                # RPC-specific configuration for `create_service_connection_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_connection_token
                ##
                # RPC-specific configuration for `delete_service_connection_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_connection_token

                # @private
                def initialize parent_rpcs = nil
                  list_service_connection_maps_config = parent_rpcs.list_service_connection_maps if parent_rpcs.respond_to? :list_service_connection_maps
                  @list_service_connection_maps = ::Gapic::Config::Method.new list_service_connection_maps_config
                  get_service_connection_map_config = parent_rpcs.get_service_connection_map if parent_rpcs.respond_to? :get_service_connection_map
                  @get_service_connection_map = ::Gapic::Config::Method.new get_service_connection_map_config
                  create_service_connection_map_config = parent_rpcs.create_service_connection_map if parent_rpcs.respond_to? :create_service_connection_map
                  @create_service_connection_map = ::Gapic::Config::Method.new create_service_connection_map_config
                  update_service_connection_map_config = parent_rpcs.update_service_connection_map if parent_rpcs.respond_to? :update_service_connection_map
                  @update_service_connection_map = ::Gapic::Config::Method.new update_service_connection_map_config
                  delete_service_connection_map_config = parent_rpcs.delete_service_connection_map if parent_rpcs.respond_to? :delete_service_connection_map
                  @delete_service_connection_map = ::Gapic::Config::Method.new delete_service_connection_map_config
                  list_service_connection_policies_config = parent_rpcs.list_service_connection_policies if parent_rpcs.respond_to? :list_service_connection_policies
                  @list_service_connection_policies = ::Gapic::Config::Method.new list_service_connection_policies_config
                  get_service_connection_policy_config = parent_rpcs.get_service_connection_policy if parent_rpcs.respond_to? :get_service_connection_policy
                  @get_service_connection_policy = ::Gapic::Config::Method.new get_service_connection_policy_config
                  create_service_connection_policy_config = parent_rpcs.create_service_connection_policy if parent_rpcs.respond_to? :create_service_connection_policy
                  @create_service_connection_policy = ::Gapic::Config::Method.new create_service_connection_policy_config
                  update_service_connection_policy_config = parent_rpcs.update_service_connection_policy if parent_rpcs.respond_to? :update_service_connection_policy
                  @update_service_connection_policy = ::Gapic::Config::Method.new update_service_connection_policy_config
                  delete_service_connection_policy_config = parent_rpcs.delete_service_connection_policy if parent_rpcs.respond_to? :delete_service_connection_policy
                  @delete_service_connection_policy = ::Gapic::Config::Method.new delete_service_connection_policy_config
                  list_service_classes_config = parent_rpcs.list_service_classes if parent_rpcs.respond_to? :list_service_classes
                  @list_service_classes = ::Gapic::Config::Method.new list_service_classes_config
                  get_service_class_config = parent_rpcs.get_service_class if parent_rpcs.respond_to? :get_service_class
                  @get_service_class = ::Gapic::Config::Method.new get_service_class_config
                  update_service_class_config = parent_rpcs.update_service_class if parent_rpcs.respond_to? :update_service_class
                  @update_service_class = ::Gapic::Config::Method.new update_service_class_config
                  delete_service_class_config = parent_rpcs.delete_service_class if parent_rpcs.respond_to? :delete_service_class
                  @delete_service_class = ::Gapic::Config::Method.new delete_service_class_config
                  get_service_connection_token_config = parent_rpcs.get_service_connection_token if parent_rpcs.respond_to? :get_service_connection_token
                  @get_service_connection_token = ::Gapic::Config::Method.new get_service_connection_token_config
                  list_service_connection_tokens_config = parent_rpcs.list_service_connection_tokens if parent_rpcs.respond_to? :list_service_connection_tokens
                  @list_service_connection_tokens = ::Gapic::Config::Method.new list_service_connection_tokens_config
                  create_service_connection_token_config = parent_rpcs.create_service_connection_token if parent_rpcs.respond_to? :create_service_connection_token
                  @create_service_connection_token = ::Gapic::Config::Method.new create_service_connection_token_config
                  delete_service_connection_token_config = parent_rpcs.delete_service_connection_token if parent_rpcs.respond_to? :delete_service_connection_token
                  @delete_service_connection_token = ::Gapic::Config::Method.new delete_service_connection_token_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
