# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/netapp/v1/cloud_netapp_service_pb"
require "google/cloud/netapp/v1/netapp"

class ::Google::Cloud::NetApp::V1::NetApp::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_storage_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListStoragePoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_storage_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_storage_pools, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListStoragePoolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_storage_pools_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_storage_pools({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_storage_pools parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_storage_pools ::Google::Cloud::NetApp::V1::ListStoragePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_storage_pools({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_storage_pools(::Google::Cloud::NetApp::V1::ListStoragePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_storage_pools_client_stub.call_rpc_count
    end
  end

  def test_create_storage_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    storage_pool_id = "hello world"
    storage_pool = {}

    create_storage_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_storage_pool, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateStoragePoolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["storage_pool_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::StoragePool), request["storage_pool"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_storage_pool_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_storage_pool({ parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_storage_pool parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_storage_pool ::Google::Cloud::NetApp::V1::CreateStoragePoolRequest.new(parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_storage_pool({ parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_storage_pool(::Google::Cloud::NetApp::V1::CreateStoragePoolRequest.new(parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_storage_pool_client_stub.call_rpc_count
    end
  end

  def test_get_storage_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::StoragePool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_storage_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_storage_pool, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetStoragePoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_storage_pool_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_storage_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_storage_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_storage_pool ::Google::Cloud::NetApp::V1::GetStoragePoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_storage_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_storage_pool(::Google::Cloud::NetApp::V1::GetStoragePoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_storage_pool_client_stub.call_rpc_count
    end
  end

  def test_update_storage_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    storage_pool = {}

    update_storage_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_storage_pool, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::StoragePool), request["storage_pool"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_storage_pool_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_storage_pool({ update_mask: update_mask, storage_pool: storage_pool }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_storage_pool update_mask: update_mask, storage_pool: storage_pool do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_storage_pool ::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest.new(update_mask: update_mask, storage_pool: storage_pool) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_storage_pool({ update_mask: update_mask, storage_pool: storage_pool }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_storage_pool(::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest.new(update_mask: update_mask, storage_pool: storage_pool), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_storage_pool_client_stub.call_rpc_count
    end
  end

  def test_delete_storage_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_storage_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_storage_pool, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_storage_pool_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_storage_pool({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_storage_pool name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_storage_pool ::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_storage_pool({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_storage_pool(::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_storage_pool_client_stub.call_rpc_count
    end
  end

  def test_validate_directory_service
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    directory_service_type = :DIRECTORY_SERVICE_TYPE_UNSPECIFIED

    validate_directory_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :validate_directory_service, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :DIRECTORY_SERVICE_TYPE_UNSPECIFIED, request["directory_service_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, validate_directory_service_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.validate_directory_service({ name: name, directory_service_type: directory_service_type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.validate_directory_service name: name, directory_service_type: directory_service_type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.validate_directory_service ::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest.new(name: name, directory_service_type: directory_service_type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.validate_directory_service({ name: name, directory_service_type: directory_service_type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.validate_directory_service(::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest.new(name: name, directory_service_type: directory_service_type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, validate_directory_service_client_stub.call_rpc_count
    end
  end

  def test_switch_active_replica_zone
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    switch_active_replica_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :switch_active_replica_zone, name
      assert_kind_of ::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, switch_active_replica_zone_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.switch_active_replica_zone({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.switch_active_replica_zone name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.switch_active_replica_zone ::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.switch_active_replica_zone({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.switch_active_replica_zone(::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, switch_active_replica_zone_client_stub.call_rpc_count
    end
  end

  def test_list_volumes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListVolumesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_volumes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_volumes, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListVolumesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_volumes_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_volumes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_volumes ::Google::Cloud::NetApp::V1::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_volumes(::Google::Cloud::NetApp::V1::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_volumes_client_stub.call_rpc_count
    end
  end

  def test_get_volume
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::Volume.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_volume, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetVolumeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_volume_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_volume({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_volume name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_volume ::Google::Cloud::NetApp::V1::GetVolumeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_volume({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_volume(::Google::Cloud::NetApp::V1::GetVolumeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_volume_client_stub.call_rpc_count
    end
  end

  def test_create_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    volume_id = "hello world"
    volume = {}

    create_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_volume, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateVolumeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["volume_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Volume), request["volume"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_volume_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_volume({ parent: parent, volume_id: volume_id, volume: volume }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_volume parent: parent, volume_id: volume_id, volume: volume do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_volume ::Google::Cloud::NetApp::V1::CreateVolumeRequest.new(parent: parent, volume_id: volume_id, volume: volume) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_volume({ parent: parent, volume_id: volume_id, volume: volume }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_volume(::Google::Cloud::NetApp::V1::CreateVolumeRequest.new(parent: parent, volume_id: volume_id, volume: volume), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_volume_client_stub.call_rpc_count
    end
  end

  def test_update_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    volume = {}

    update_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_volume, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateVolumeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Volume), request["volume"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_volume_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_volume({ update_mask: update_mask, volume: volume }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_volume update_mask: update_mask, volume: volume do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_volume ::Google::Cloud::NetApp::V1::UpdateVolumeRequest.new(update_mask: update_mask, volume: volume) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_volume({ update_mask: update_mask, volume: volume }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_volume(::Google::Cloud::NetApp::V1::UpdateVolumeRequest.new(update_mask: update_mask, volume: volume), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_volume_client_stub.call_rpc_count
    end
  end

  def test_delete_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_volume, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteVolumeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_volume_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_volume({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_volume name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_volume ::Google::Cloud::NetApp::V1::DeleteVolumeRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_volume({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_volume(::Google::Cloud::NetApp::V1::DeleteVolumeRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_volume_client_stub.call_rpc_count
    end
  end

  def test_revert_volume
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    snapshot_id = "hello world"

    revert_volume_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :revert_volume, name
      assert_kind_of ::Google::Cloud::NetApp::V1::RevertVolumeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["snapshot_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, revert_volume_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.revert_volume({ name: name, snapshot_id: snapshot_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.revert_volume name: name, snapshot_id: snapshot_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.revert_volume ::Google::Cloud::NetApp::V1::RevertVolumeRequest.new(name: name, snapshot_id: snapshot_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.revert_volume({ name: name, snapshot_id: snapshot_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.revert_volume(::Google::Cloud::NetApp::V1::RevertVolumeRequest.new(name: name, snapshot_id: snapshot_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, revert_volume_client_stub.call_rpc_count
    end
  end

  def test_list_snapshots
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListSnapshotsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_snapshots_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_snapshots, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListSnapshotsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_snapshots_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_snapshots({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_snapshots parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_snapshots ::Google::Cloud::NetApp::V1::ListSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_snapshots({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_snapshots(::Google::Cloud::NetApp::V1::ListSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_snapshots_client_stub.call_rpc_count
    end
  end

  def test_get_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::Snapshot.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_snapshot, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetSnapshotRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_snapshot({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_snapshot name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_snapshot ::Google::Cloud::NetApp::V1::GetSnapshotRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_snapshot({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_snapshot(::Google::Cloud::NetApp::V1::GetSnapshotRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_snapshot_client_stub.call_rpc_count
    end
  end

  def test_create_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    snapshot = {}
    snapshot_id = "hello world"

    create_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_snapshot, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateSnapshotRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Snapshot), request["snapshot"]
      assert_equal "hello world", request["snapshot_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_snapshot({ parent: parent, snapshot: snapshot, snapshot_id: snapshot_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_snapshot parent: parent, snapshot: snapshot, snapshot_id: snapshot_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_snapshot ::Google::Cloud::NetApp::V1::CreateSnapshotRequest.new(parent: parent, snapshot: snapshot, snapshot_id: snapshot_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_snapshot({ parent: parent, snapshot: snapshot, snapshot_id: snapshot_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_snapshot(::Google::Cloud::NetApp::V1::CreateSnapshotRequest.new(parent: parent, snapshot: snapshot, snapshot_id: snapshot_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_snapshot_client_stub.call_rpc_count
    end
  end

  def test_delete_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_snapshot, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteSnapshotRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_snapshot({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_snapshot name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_snapshot ::Google::Cloud::NetApp::V1::DeleteSnapshotRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_snapshot({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_snapshot(::Google::Cloud::NetApp::V1::DeleteSnapshotRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_snapshot_client_stub.call_rpc_count
    end
  end

  def test_update_snapshot
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    snapshot = {}

    update_snapshot_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_snapshot, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateSnapshotRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Snapshot), request["snapshot"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_snapshot_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_snapshot({ update_mask: update_mask, snapshot: snapshot }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_snapshot update_mask: update_mask, snapshot: snapshot do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_snapshot ::Google::Cloud::NetApp::V1::UpdateSnapshotRequest.new(update_mask: update_mask, snapshot: snapshot) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_snapshot({ update_mask: update_mask, snapshot: snapshot }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_snapshot(::Google::Cloud::NetApp::V1::UpdateSnapshotRequest.new(update_mask: update_mask, snapshot: snapshot), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_snapshot_client_stub.call_rpc_count
    end
  end

  def test_list_active_directories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListActiveDirectoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_active_directories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_active_directories, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_active_directories_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_active_directories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_active_directories parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_active_directories ::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_active_directories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_active_directories(::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_active_directories_client_stub.call_rpc_count
    end
  end

  def test_get_active_directory
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ActiveDirectory.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_active_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_active_directory, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_active_directory_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_active_directory({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_active_directory name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_active_directory ::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_active_directory({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_active_directory(::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_active_directory_client_stub.call_rpc_count
    end
  end

  def test_create_active_directory
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    active_directory = {}
    active_directory_id = "hello world"

    create_active_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_active_directory, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::ActiveDirectory), request["active_directory"]
      assert_equal "hello world", request["active_directory_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_active_directory_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_active_directory({ parent: parent, active_directory: active_directory, active_directory_id: active_directory_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_active_directory parent: parent, active_directory: active_directory, active_directory_id: active_directory_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_active_directory ::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest.new(parent: parent, active_directory: active_directory, active_directory_id: active_directory_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_active_directory({ parent: parent, active_directory: active_directory, active_directory_id: active_directory_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_active_directory(::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest.new(parent: parent, active_directory: active_directory, active_directory_id: active_directory_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_active_directory_client_stub.call_rpc_count
    end
  end

  def test_update_active_directory
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    active_directory = {}

    update_active_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_active_directory, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::ActiveDirectory), request["active_directory"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_active_directory_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_active_directory({ update_mask: update_mask, active_directory: active_directory }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_active_directory update_mask: update_mask, active_directory: active_directory do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_active_directory ::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest.new(update_mask: update_mask, active_directory: active_directory) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_active_directory({ update_mask: update_mask, active_directory: active_directory }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_active_directory(::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest.new(update_mask: update_mask, active_directory: active_directory), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_active_directory_client_stub.call_rpc_count
    end
  end

  def test_delete_active_directory
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_active_directory_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_active_directory, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_active_directory_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_active_directory({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_active_directory name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_active_directory ::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_active_directory({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_active_directory(::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_active_directory_client_stub.call_rpc_count
    end
  end

  def test_list_kms_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListKmsConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_kms_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_kms_configs, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListKmsConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_kms_configs_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_kms_configs({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_kms_configs parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_kms_configs ::Google::Cloud::NetApp::V1::ListKmsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_kms_configs({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_kms_configs(::Google::Cloud::NetApp::V1::ListKmsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_kms_configs_client_stub.call_rpc_count
    end
  end

  def test_create_kms_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    kms_config_id = "hello world"
    kms_config = {}

    create_kms_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_kms_config, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateKmsConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["kms_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::KmsConfig), request["kms_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_kms_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_kms_config({ parent: parent, kms_config_id: kms_config_id, kms_config: kms_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_kms_config parent: parent, kms_config_id: kms_config_id, kms_config: kms_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_kms_config ::Google::Cloud::NetApp::V1::CreateKmsConfigRequest.new(parent: parent, kms_config_id: kms_config_id, kms_config: kms_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_kms_config({ parent: parent, kms_config_id: kms_config_id, kms_config: kms_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_kms_config(::Google::Cloud::NetApp::V1::CreateKmsConfigRequest.new(parent: parent, kms_config_id: kms_config_id, kms_config: kms_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_kms_config_client_stub.call_rpc_count
    end
  end

  def test_get_kms_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::KmsConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_kms_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_kms_config, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetKmsConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_kms_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_kms_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_kms_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_kms_config ::Google::Cloud::NetApp::V1::GetKmsConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_kms_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_kms_config(::Google::Cloud::NetApp::V1::GetKmsConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_kms_config_client_stub.call_rpc_count
    end
  end

  def test_update_kms_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    kms_config = {}

    update_kms_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_kms_config, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::KmsConfig), request["kms_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_kms_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_kms_config({ update_mask: update_mask, kms_config: kms_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_kms_config update_mask: update_mask, kms_config: kms_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_kms_config ::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest.new(update_mask: update_mask, kms_config: kms_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_kms_config({ update_mask: update_mask, kms_config: kms_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_kms_config(::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest.new(update_mask: update_mask, kms_config: kms_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_kms_config_client_stub.call_rpc_count
    end
  end

  def test_encrypt_volumes
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    encrypt_volumes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :encrypt_volumes, name
      assert_kind_of ::Google::Cloud::NetApp::V1::EncryptVolumesRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, encrypt_volumes_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.encrypt_volumes({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.encrypt_volumes name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.encrypt_volumes ::Google::Cloud::NetApp::V1::EncryptVolumesRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.encrypt_volumes({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.encrypt_volumes(::Google::Cloud::NetApp::V1::EncryptVolumesRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, encrypt_volumes_client_stub.call_rpc_count
    end
  end

  def test_verify_kms_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::VerifyKmsConfigResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    verify_kms_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :verify_kms_config, name
      assert_kind_of ::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, verify_kms_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.verify_kms_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.verify_kms_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.verify_kms_config ::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.verify_kms_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.verify_kms_config(::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, verify_kms_config_client_stub.call_rpc_count
    end
  end

  def test_delete_kms_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_kms_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_kms_config, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_kms_config_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_kms_config({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_kms_config name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_kms_config ::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_kms_config({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_kms_config(::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_kms_config_client_stub.call_rpc_count
    end
  end

  def test_list_replications
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListReplicationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_replications_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_replications, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListReplicationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_replications_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_replications({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_replications parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_replications ::Google::Cloud::NetApp::V1::ListReplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_replications({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_replications(::Google::Cloud::NetApp::V1::ListReplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_replications_client_stub.call_rpc_count
    end
  end

  def test_get_replication
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::Replication.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetReplicationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_replication({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_replication name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_replication ::Google::Cloud::NetApp::V1::GetReplicationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_replication({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_replication(::Google::Cloud::NetApp::V1::GetReplicationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_replication_client_stub.call_rpc_count
    end
  end

  def test_create_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    replication = {}
    replication_id = "hello world"

    create_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateReplicationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Replication), request["replication"]
      assert_equal "hello world", request["replication_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_replication({ parent: parent, replication: replication, replication_id: replication_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_replication parent: parent, replication: replication, replication_id: replication_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_replication ::Google::Cloud::NetApp::V1::CreateReplicationRequest.new(parent: parent, replication: replication, replication_id: replication_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_replication({ parent: parent, replication: replication, replication_id: replication_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_replication(::Google::Cloud::NetApp::V1::CreateReplicationRequest.new(parent: parent, replication: replication, replication_id: replication_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_replication_client_stub.call_rpc_count
    end
  end

  def test_delete_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteReplicationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_replication({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_replication name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_replication ::Google::Cloud::NetApp::V1::DeleteReplicationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_replication({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_replication(::Google::Cloud::NetApp::V1::DeleteReplicationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_replication_client_stub.call_rpc_count
    end
  end

  def test_update_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    replication = {}

    update_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateReplicationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Replication), request["replication"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_replication({ update_mask: update_mask, replication: replication }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_replication update_mask: update_mask, replication: replication do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_replication ::Google::Cloud::NetApp::V1::UpdateReplicationRequest.new(update_mask: update_mask, replication: replication) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_replication({ update_mask: update_mask, replication: replication }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_replication(::Google::Cloud::NetApp::V1::UpdateReplicationRequest.new(update_mask: update_mask, replication: replication), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_replication_client_stub.call_rpc_count
    end
  end

  def test_stop_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    stop_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::StopReplicationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_replication({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_replication name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_replication ::Google::Cloud::NetApp::V1::StopReplicationRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_replication({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_replication(::Google::Cloud::NetApp::V1::StopReplicationRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_replication_client_stub.call_rpc_count
    end
  end

  def test_resume_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ResumeReplicationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_replication({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_replication name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_replication ::Google::Cloud::NetApp::V1::ResumeReplicationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_replication({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_replication(::Google::Cloud::NetApp::V1::ResumeReplicationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_replication_client_stub.call_rpc_count
    end
  end

  def test_reverse_replication_direction
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reverse_replication_direction_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reverse_replication_direction, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reverse_replication_direction_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reverse_replication_direction({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reverse_replication_direction name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reverse_replication_direction ::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reverse_replication_direction({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reverse_replication_direction(::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reverse_replication_direction_client_stub.call_rpc_count
    end
  end

  def test_establish_peering
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    peer_cluster_name = "hello world"
    peer_svm_name = "hello world"
    peer_ip_addresses = ["hello world"]
    peer_volume_name = "hello world"

    establish_peering_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :establish_peering, name
      assert_kind_of ::Google::Cloud::NetApp::V1::EstablishPeeringRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["peer_cluster_name"]
      assert_equal "hello world", request["peer_svm_name"]
      assert_equal ["hello world"], request["peer_ip_addresses"]
      assert_equal "hello world", request["peer_volume_name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, establish_peering_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.establish_peering({ name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.establish_peering name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.establish_peering ::Google::Cloud::NetApp::V1::EstablishPeeringRequest.new(name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.establish_peering({ name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.establish_peering(::Google::Cloud::NetApp::V1::EstablishPeeringRequest.new(name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, establish_peering_client_stub.call_rpc_count
    end
  end

  def test_sync_replication
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    sync_replication_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :sync_replication, name
      assert_kind_of ::Google::Cloud::NetApp::V1::SyncReplicationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, sync_replication_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.sync_replication({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.sync_replication name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.sync_replication ::Google::Cloud::NetApp::V1::SyncReplicationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.sync_replication({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.sync_replication(::Google::Cloud::NetApp::V1::SyncReplicationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, sync_replication_client_stub.call_rpc_count
    end
  end

  def test_create_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_vault_id = "hello world"
    backup_vault = {}

    create_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup_vault, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateBackupVaultRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_vault_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::BackupVault), request["backup_vault"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup_vault parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup_vault ::Google::Cloud::NetApp::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup_vault(::Google::Cloud::NetApp::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_get_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::BackupVault.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_vault, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetBackupVaultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_vault({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_vault name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_vault ::Google::Cloud::NetApp::V1::GetBackupVaultRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_vault({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_vault(::Google::Cloud::NetApp::V1::GetBackupVaultRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_list_backup_vaults
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListBackupVaultsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_backup_vaults_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_vaults, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListBackupVaultsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_vaults_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_vaults parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_vaults ::Google::Cloud::NetApp::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_vaults(::Google::Cloud::NetApp::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_vaults_client_stub.call_rpc_count
    end
  end

  def test_update_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_vault = {}

    update_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup_vault, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::BackupVault), request["backup_vault"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup_vault update_mask: update_mask, backup_vault: backup_vault do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup_vault ::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup_vault(::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_delete_backup_vault
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_vault_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup_vault, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_vault_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup_vault({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup_vault name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup_vault ::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup_vault({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup_vault(::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_vault_client_stub.call_rpc_count
    end
  end

  def test_create_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_id = "hello world"
    backup = {}

    create_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateBackupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["backup_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Backup), request["backup"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup({ parent: parent, backup_id: backup_id, backup: backup }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup parent: parent, backup_id: backup_id, backup: backup do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup ::Google::Cloud::NetApp::V1::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup({ parent: parent, backup_id: backup_id, backup: backup }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup(::Google::Cloud::NetApp::V1::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_client_stub.call_rpc_count
    end
  end

  def test_get_backup
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::Backup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetBackupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup ::Google::Cloud::NetApp::V1::GetBackupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup(::Google::Cloud::NetApp::V1::GetBackupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_client_stub.call_rpc_count
    end
  end

  def test_list_backups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListBackupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_backups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backups, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListBackupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backups_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backups parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backups ::Google::Cloud::NetApp::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backups(::Google::Cloud::NetApp::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backups_client_stub.call_rpc_count
    end
  end

  def test_delete_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteBackupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup ::Google::Cloud::NetApp::V1::DeleteBackupRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup(::Google::Cloud::NetApp::V1::DeleteBackupRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_client_stub.call_rpc_count
    end
  end

  def test_update_backup
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup = {}

    update_backup_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateBackupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::Backup), request["backup"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup({ update_mask: update_mask, backup: backup }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup update_mask: update_mask, backup: backup do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup ::Google::Cloud::NetApp::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup({ update_mask: update_mask, backup: backup }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup(::Google::Cloud::NetApp::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_client_stub.call_rpc_count
    end
  end

  def test_create_backup_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_policy = {}
    backup_policy_id = "hello world"

    create_backup_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_backup_policy, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::BackupPolicy), request["backup_policy"]
      assert_equal "hello world", request["backup_policy_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_backup_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_backup_policy({ parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_backup_policy parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_backup_policy ::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest.new(parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_backup_policy({ parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_backup_policy(::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest.new(parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_backup_policy_client_stub.call_rpc_count
    end
  end

  def test_get_backup_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::BackupPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_backup_policy, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetBackupPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_backup_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_backup_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_backup_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_backup_policy ::Google::Cloud::NetApp::V1::GetBackupPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_backup_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_backup_policy(::Google::Cloud::NetApp::V1::GetBackupPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_backup_policy_client_stub.call_rpc_count
    end
  end

  def test_list_backup_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListBackupPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_backup_policies, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_backup_policies_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_backup_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_backup_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_backup_policies ::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_backup_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_backup_policies(::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_backup_policies_client_stub.call_rpc_count
    end
  end

  def test_update_backup_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_policy = {}

    update_backup_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_backup_policy, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::BackupPolicy), request["backup_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_backup_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_backup_policy({ update_mask: update_mask, backup_policy: backup_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_backup_policy update_mask: update_mask, backup_policy: backup_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_backup_policy ::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest.new(update_mask: update_mask, backup_policy: backup_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_backup_policy({ update_mask: update_mask, backup_policy: backup_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_backup_policy(::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest.new(update_mask: update_mask, backup_policy: backup_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_backup_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_backup_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_backup_policy, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_backup_policy_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_backup_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_backup_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_backup_policy ::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_backup_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_backup_policy(::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_backup_policy_client_stub.call_rpc_count
    end
  end

  def test_list_quota_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::ListQuotaRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_quota_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_quota_rules, name
      assert_kind_of ::Google::Cloud::NetApp::V1::ListQuotaRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_quota_rules_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_quota_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_quota_rules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_quota_rules ::Google::Cloud::NetApp::V1::ListQuotaRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_quota_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_quota_rules(::Google::Cloud::NetApp::V1::ListQuotaRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_quota_rules_client_stub.call_rpc_count
    end
  end

  def test_get_quota_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::NetApp::V1::QuotaRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_quota_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_quota_rule, name
      assert_kind_of ::Google::Cloud::NetApp::V1::GetQuotaRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_quota_rule_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_quota_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_quota_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_quota_rule ::Google::Cloud::NetApp::V1::GetQuotaRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_quota_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_quota_rule(::Google::Cloud::NetApp::V1::GetQuotaRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_quota_rule_client_stub.call_rpc_count
    end
  end

  def test_create_quota_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    quota_rule = {}
    quota_rule_id = "hello world"

    create_quota_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_quota_rule, name
      assert_kind_of ::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::QuotaRule), request["quota_rule"]
      assert_equal "hello world", request["quota_rule_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_quota_rule_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_quota_rule({ parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_quota_rule parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_quota_rule ::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest.new(parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_quota_rule({ parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_quota_rule(::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest.new(parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_quota_rule_client_stub.call_rpc_count
    end
  end

  def test_update_quota_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    quota_rule = {}

    update_quota_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_quota_rule, name
      assert_kind_of ::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::NetApp::V1::QuotaRule), request["quota_rule"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_quota_rule_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_quota_rule({ update_mask: update_mask, quota_rule: quota_rule }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_quota_rule update_mask: update_mask, quota_rule: quota_rule do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_quota_rule ::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest.new(update_mask: update_mask, quota_rule: quota_rule) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_quota_rule({ update_mask: update_mask, quota_rule: quota_rule }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_quota_rule(::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest.new(update_mask: update_mask, quota_rule: quota_rule), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_quota_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_quota_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_quota_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_quota_rule, name
      assert_kind_of ::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_quota_rule_client_stub do
      # Create client
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_quota_rule({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_quota_rule name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_quota_rule ::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_quota_rule({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_quota_rule(::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_quota_rule_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetApp::V1::NetApp::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::NetApp::V1::NetApp::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetApp::V1::NetApp::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::NetApp::V1::NetApp::Operations, client.operations_client
  end
end
