# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/netapp/v1/cloud_netapp_service_pb"
require "google/cloud/netapp/v1/netapp/rest"


class ::Google::Cloud::NetApp::V1::NetApp::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_storage_pools
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListStoragePoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_storage_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_storage_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_storage_pools_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_storage_pools({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_storage_pools parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_storage_pools ::Google::Cloud::NetApp::V1::ListStoragePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_storage_pools({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_storage_pools(::Google::Cloud::NetApp::V1::ListStoragePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_storage_pools_client_stub.call_count
      end
    end
  end

  def test_create_storage_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    storage_pool_id = "hello world"
    storage_pool = {}

    create_storage_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_storage_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_storage_pool_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_storage_pool({ parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_storage_pool parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_storage_pool ::Google::Cloud::NetApp::V1::CreateStoragePoolRequest.new(parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_storage_pool({ parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_storage_pool(::Google::Cloud::NetApp::V1::CreateStoragePoolRequest.new(parent: parent, storage_pool_id: storage_pool_id, storage_pool: storage_pool), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_storage_pool_client_stub.call_count
      end
    end
  end

  def test_get_storage_pool
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::StoragePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_storage_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_storage_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_storage_pool_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_storage_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_storage_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_storage_pool ::Google::Cloud::NetApp::V1::GetStoragePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_storage_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_storage_pool(::Google::Cloud::NetApp::V1::GetStoragePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_storage_pool_client_stub.call_count
      end
    end
  end

  def test_update_storage_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    storage_pool = {}

    update_storage_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_storage_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_storage_pool_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_storage_pool({ update_mask: update_mask, storage_pool: storage_pool }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_storage_pool update_mask: update_mask, storage_pool: storage_pool do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_storage_pool ::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest.new(update_mask: update_mask, storage_pool: storage_pool) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_storage_pool({ update_mask: update_mask, storage_pool: storage_pool }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_storage_pool(::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest.new(update_mask: update_mask, storage_pool: storage_pool), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_storage_pool_client_stub.call_count
      end
    end
  end

  def test_delete_storage_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_storage_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_storage_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_storage_pool_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_storage_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_storage_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_storage_pool ::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_storage_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_storage_pool(::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_storage_pool_client_stub.call_count
      end
    end
  end

  def test_validate_directory_service
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    directory_service_type = :DIRECTORY_SERVICE_TYPE_UNSPECIFIED

    validate_directory_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_validate_directory_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, validate_directory_service_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.validate_directory_service({ name: name, directory_service_type: directory_service_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.validate_directory_service name: name, directory_service_type: directory_service_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.validate_directory_service ::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest.new(name: name, directory_service_type: directory_service_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.validate_directory_service({ name: name, directory_service_type: directory_service_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.validate_directory_service(::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest.new(name: name, directory_service_type: directory_service_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, validate_directory_service_client_stub.call_count
      end
    end
  end

  def test_switch_active_replica_zone
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    switch_active_replica_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_switch_active_replica_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, switch_active_replica_zone_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.switch_active_replica_zone({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.switch_active_replica_zone name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.switch_active_replica_zone ::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.switch_active_replica_zone({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.switch_active_replica_zone(::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, switch_active_replica_zone_client_stub.call_count
      end
    end
  end

  def test_list_volumes
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListVolumesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_volumes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_volumes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_volumes_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_volumes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_volumes ::Google::Cloud::NetApp::V1::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_volumes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_volumes(::Google::Cloud::NetApp::V1::ListVolumesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_volumes_client_stub.call_count
      end
    end
  end

  def test_get_volume
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::Volume.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_volume_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_volume({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_volume name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_volume ::Google::Cloud::NetApp::V1::GetVolumeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_volume({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_volume(::Google::Cloud::NetApp::V1::GetVolumeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_volume_client_stub.call_count
      end
    end
  end

  def test_create_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    volume_id = "hello world"
    volume = {}

    create_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_volume_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_volume({ parent: parent, volume_id: volume_id, volume: volume }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_volume parent: parent, volume_id: volume_id, volume: volume do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_volume ::Google::Cloud::NetApp::V1::CreateVolumeRequest.new(parent: parent, volume_id: volume_id, volume: volume) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_volume({ parent: parent, volume_id: volume_id, volume: volume }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_volume(::Google::Cloud::NetApp::V1::CreateVolumeRequest.new(parent: parent, volume_id: volume_id, volume: volume), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_volume_client_stub.call_count
      end
    end
  end

  def test_update_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    volume = {}

    update_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_volume_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_volume({ update_mask: update_mask, volume: volume }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_volume update_mask: update_mask, volume: volume do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_volume ::Google::Cloud::NetApp::V1::UpdateVolumeRequest.new(update_mask: update_mask, volume: volume) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_volume({ update_mask: update_mask, volume: volume }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_volume(::Google::Cloud::NetApp::V1::UpdateVolumeRequest.new(update_mask: update_mask, volume: volume), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_volume_client_stub.call_count
      end
    end
  end

  def test_delete_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_volume_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_volume({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_volume name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_volume ::Google::Cloud::NetApp::V1::DeleteVolumeRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_volume({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_volume(::Google::Cloud::NetApp::V1::DeleteVolumeRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_volume_client_stub.call_count
      end
    end
  end

  def test_revert_volume
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    snapshot_id = "hello world"

    revert_volume_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_revert_volume_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, revert_volume_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.revert_volume({ name: name, snapshot_id: snapshot_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.revert_volume name: name, snapshot_id: snapshot_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.revert_volume ::Google::Cloud::NetApp::V1::RevertVolumeRequest.new(name: name, snapshot_id: snapshot_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.revert_volume({ name: name, snapshot_id: snapshot_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.revert_volume(::Google::Cloud::NetApp::V1::RevertVolumeRequest.new(name: name, snapshot_id: snapshot_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, revert_volume_client_stub.call_count
      end
    end
  end

  def test_list_snapshots
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListSnapshotsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_snapshots_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_snapshots_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_snapshots_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_snapshots({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_snapshots parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_snapshots ::Google::Cloud::NetApp::V1::ListSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_snapshots({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_snapshots(::Google::Cloud::NetApp::V1::ListSnapshotsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_snapshots_client_stub.call_count
      end
    end
  end

  def test_get_snapshot
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::Snapshot.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_snapshot({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_snapshot name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_snapshot ::Google::Cloud::NetApp::V1::GetSnapshotRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_snapshot({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_snapshot(::Google::Cloud::NetApp::V1::GetSnapshotRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_snapshot_client_stub.call_count
      end
    end
  end

  def test_create_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    snapshot = {}
    snapshot_id = "hello world"

    create_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_snapshot({ parent: parent, snapshot: snapshot, snapshot_id: snapshot_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_snapshot parent: parent, snapshot: snapshot, snapshot_id: snapshot_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_snapshot ::Google::Cloud::NetApp::V1::CreateSnapshotRequest.new(parent: parent, snapshot: snapshot, snapshot_id: snapshot_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_snapshot({ parent: parent, snapshot: snapshot, snapshot_id: snapshot_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_snapshot(::Google::Cloud::NetApp::V1::CreateSnapshotRequest.new(parent: parent, snapshot: snapshot, snapshot_id: snapshot_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_snapshot_client_stub.call_count
      end
    end
  end

  def test_delete_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_snapshot({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_snapshot name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_snapshot ::Google::Cloud::NetApp::V1::DeleteSnapshotRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_snapshot({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_snapshot(::Google::Cloud::NetApp::V1::DeleteSnapshotRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_snapshot_client_stub.call_count
      end
    end
  end

  def test_update_snapshot
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    snapshot = {}

    update_snapshot_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_snapshot_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_snapshot_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_snapshot({ update_mask: update_mask, snapshot: snapshot }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_snapshot update_mask: update_mask, snapshot: snapshot do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_snapshot ::Google::Cloud::NetApp::V1::UpdateSnapshotRequest.new(update_mask: update_mask, snapshot: snapshot) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_snapshot({ update_mask: update_mask, snapshot: snapshot }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_snapshot(::Google::Cloud::NetApp::V1::UpdateSnapshotRequest.new(update_mask: update_mask, snapshot: snapshot), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_snapshot_client_stub.call_count
      end
    end
  end

  def test_list_active_directories
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListActiveDirectoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_active_directories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_active_directories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_active_directories_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_active_directories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_active_directories parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_active_directories ::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_active_directories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_active_directories(::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_active_directories_client_stub.call_count
      end
    end
  end

  def test_get_active_directory
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ActiveDirectory.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_active_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_active_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_active_directory_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_active_directory({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_active_directory name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_active_directory ::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_active_directory({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_active_directory(::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_active_directory_client_stub.call_count
      end
    end
  end

  def test_create_active_directory
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    active_directory = {}
    active_directory_id = "hello world"

    create_active_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_active_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_active_directory_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_active_directory({ parent: parent, active_directory: active_directory, active_directory_id: active_directory_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_active_directory parent: parent, active_directory: active_directory, active_directory_id: active_directory_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_active_directory ::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest.new(parent: parent, active_directory: active_directory, active_directory_id: active_directory_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_active_directory({ parent: parent, active_directory: active_directory, active_directory_id: active_directory_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_active_directory(::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest.new(parent: parent, active_directory: active_directory, active_directory_id: active_directory_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_active_directory_client_stub.call_count
      end
    end
  end

  def test_update_active_directory
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    active_directory = {}

    update_active_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_active_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_active_directory_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_active_directory({ update_mask: update_mask, active_directory: active_directory }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_active_directory update_mask: update_mask, active_directory: active_directory do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_active_directory ::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest.new(update_mask: update_mask, active_directory: active_directory) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_active_directory({ update_mask: update_mask, active_directory: active_directory }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_active_directory(::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest.new(update_mask: update_mask, active_directory: active_directory), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_active_directory_client_stub.call_count
      end
    end
  end

  def test_delete_active_directory
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_active_directory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_active_directory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_active_directory_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_active_directory({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_active_directory name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_active_directory ::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_active_directory({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_active_directory(::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_active_directory_client_stub.call_count
      end
    end
  end

  def test_list_kms_configs
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListKmsConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_kms_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_kms_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_kms_configs_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_kms_configs({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_kms_configs parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_kms_configs ::Google::Cloud::NetApp::V1::ListKmsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_kms_configs({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_kms_configs(::Google::Cloud::NetApp::V1::ListKmsConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_kms_configs_client_stub.call_count
      end
    end
  end

  def test_create_kms_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    kms_config_id = "hello world"
    kms_config = {}

    create_kms_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_kms_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_kms_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_kms_config({ parent: parent, kms_config_id: kms_config_id, kms_config: kms_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_kms_config parent: parent, kms_config_id: kms_config_id, kms_config: kms_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_kms_config ::Google::Cloud::NetApp::V1::CreateKmsConfigRequest.new(parent: parent, kms_config_id: kms_config_id, kms_config: kms_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_kms_config({ parent: parent, kms_config_id: kms_config_id, kms_config: kms_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_kms_config(::Google::Cloud::NetApp::V1::CreateKmsConfigRequest.new(parent: parent, kms_config_id: kms_config_id, kms_config: kms_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_kms_config_client_stub.call_count
      end
    end
  end

  def test_get_kms_config
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::KmsConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_kms_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_kms_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_kms_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_kms_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_kms_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_kms_config ::Google::Cloud::NetApp::V1::GetKmsConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_kms_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_kms_config(::Google::Cloud::NetApp::V1::GetKmsConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_kms_config_client_stub.call_count
      end
    end
  end

  def test_update_kms_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    kms_config = {}

    update_kms_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_kms_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_kms_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_kms_config({ update_mask: update_mask, kms_config: kms_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_kms_config update_mask: update_mask, kms_config: kms_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_kms_config ::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest.new(update_mask: update_mask, kms_config: kms_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_kms_config({ update_mask: update_mask, kms_config: kms_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_kms_config(::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest.new(update_mask: update_mask, kms_config: kms_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_kms_config_client_stub.call_count
      end
    end
  end

  def test_encrypt_volumes
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    encrypt_volumes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_encrypt_volumes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, encrypt_volumes_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.encrypt_volumes({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.encrypt_volumes name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.encrypt_volumes ::Google::Cloud::NetApp::V1::EncryptVolumesRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.encrypt_volumes({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.encrypt_volumes(::Google::Cloud::NetApp::V1::EncryptVolumesRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, encrypt_volumes_client_stub.call_count
      end
    end
  end

  def test_verify_kms_config
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::VerifyKmsConfigResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    verify_kms_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_verify_kms_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, verify_kms_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.verify_kms_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.verify_kms_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.verify_kms_config ::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.verify_kms_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.verify_kms_config(::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, verify_kms_config_client_stub.call_count
      end
    end
  end

  def test_delete_kms_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_kms_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_kms_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_kms_config_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_kms_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_kms_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_kms_config ::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_kms_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_kms_config(::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_kms_config_client_stub.call_count
      end
    end
  end

  def test_list_replications
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListReplicationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_replications_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_replications_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_replications_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_replications({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_replications parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_replications ::Google::Cloud::NetApp::V1::ListReplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_replications({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_replications(::Google::Cloud::NetApp::V1::ListReplicationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_replications_client_stub.call_count
      end
    end
  end

  def test_get_replication
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::Replication.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_replication({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_replication name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_replication ::Google::Cloud::NetApp::V1::GetReplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_replication({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_replication(::Google::Cloud::NetApp::V1::GetReplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_replication_client_stub.call_count
      end
    end
  end

  def test_create_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    replication = {}
    replication_id = "hello world"

    create_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_replication({ parent: parent, replication: replication, replication_id: replication_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_replication parent: parent, replication: replication, replication_id: replication_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_replication ::Google::Cloud::NetApp::V1::CreateReplicationRequest.new(parent: parent, replication: replication, replication_id: replication_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_replication({ parent: parent, replication: replication, replication_id: replication_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_replication(::Google::Cloud::NetApp::V1::CreateReplicationRequest.new(parent: parent, replication: replication, replication_id: replication_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_replication_client_stub.call_count
      end
    end
  end

  def test_delete_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_replication({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_replication name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_replication ::Google::Cloud::NetApp::V1::DeleteReplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_replication({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_replication(::Google::Cloud::NetApp::V1::DeleteReplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_replication_client_stub.call_count
      end
    end
  end

  def test_update_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    replication = {}

    update_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_replication({ update_mask: update_mask, replication: replication }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_replication update_mask: update_mask, replication: replication do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_replication ::Google::Cloud::NetApp::V1::UpdateReplicationRequest.new(update_mask: update_mask, replication: replication) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_replication({ update_mask: update_mask, replication: replication }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_replication(::Google::Cloud::NetApp::V1::UpdateReplicationRequest.new(update_mask: update_mask, replication: replication), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_replication_client_stub.call_count
      end
    end
  end

  def test_stop_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    stop_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_stop_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_replication({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_replication name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_replication ::Google::Cloud::NetApp::V1::StopReplicationRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_replication({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_replication(::Google::Cloud::NetApp::V1::StopReplicationRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_replication_client_stub.call_count
      end
    end
  end

  def test_resume_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_resume_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_replication({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_replication name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_replication ::Google::Cloud::NetApp::V1::ResumeReplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_replication({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_replication(::Google::Cloud::NetApp::V1::ResumeReplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_replication_client_stub.call_count
      end
    end
  end

  def test_reverse_replication_direction
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reverse_replication_direction_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_reverse_replication_direction_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reverse_replication_direction_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reverse_replication_direction({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reverse_replication_direction name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reverse_replication_direction ::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reverse_replication_direction({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reverse_replication_direction(::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reverse_replication_direction_client_stub.call_count
      end
    end
  end

  def test_establish_peering
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    peer_cluster_name = "hello world"
    peer_svm_name = "hello world"
    peer_ip_addresses = ["hello world"]
    peer_volume_name = "hello world"

    establish_peering_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_establish_peering_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, establish_peering_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.establish_peering({ name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.establish_peering name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.establish_peering ::Google::Cloud::NetApp::V1::EstablishPeeringRequest.new(name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.establish_peering({ name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.establish_peering(::Google::Cloud::NetApp::V1::EstablishPeeringRequest.new(name: name, peer_cluster_name: peer_cluster_name, peer_svm_name: peer_svm_name, peer_ip_addresses: peer_ip_addresses, peer_volume_name: peer_volume_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, establish_peering_client_stub.call_count
      end
    end
  end

  def test_sync_replication
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    sync_replication_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_sync_replication_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, sync_replication_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.sync_replication({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.sync_replication name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.sync_replication ::Google::Cloud::NetApp::V1::SyncReplicationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.sync_replication({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.sync_replication(::Google::Cloud::NetApp::V1::SyncReplicationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, sync_replication_client_stub.call_count
      end
    end
  end

  def test_create_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_vault_id = "hello world"
    backup_vault = {}

    create_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_vault parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_vault ::Google::Cloud::NetApp::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_vault({ parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_vault(::Google::Cloud::NetApp::V1::CreateBackupVaultRequest.new(parent: parent, backup_vault_id: backup_vault_id, backup_vault: backup_vault), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_vault_client_stub.call_count
      end
    end
  end

  def test_get_backup_vault
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::BackupVault.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_vault({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_vault name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_vault ::Google::Cloud::NetApp::V1::GetBackupVaultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_vault({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_vault(::Google::Cloud::NetApp::V1::GetBackupVaultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_vault_client_stub.call_count
      end
    end
  end

  def test_list_backup_vaults
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListBackupVaultsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_backup_vaults_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_backup_vaults_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_vaults_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_vaults parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_vaults ::Google::Cloud::NetApp::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_vaults({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_vaults(::Google::Cloud::NetApp::V1::ListBackupVaultsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_vaults_client_stub.call_count
      end
    end
  end

  def test_update_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_vault = {}

    update_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_vault update_mask: update_mask, backup_vault: backup_vault do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_vault ::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_vault({ update_mask: update_mask, backup_vault: backup_vault }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_vault(::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest.new(update_mask: update_mask, backup_vault: backup_vault), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_vault_client_stub.call_count
      end
    end
  end

  def test_delete_backup_vault
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_vault_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_backup_vault_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_vault_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_vault({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_vault name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_vault ::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_vault({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_vault(::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_vault_client_stub.call_count
      end
    end
  end

  def test_create_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_id = "hello world"
    backup = {}

    create_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup({ parent: parent, backup_id: backup_id, backup: backup }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup parent: parent, backup_id: backup_id, backup: backup do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup ::Google::Cloud::NetApp::V1::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup({ parent: parent, backup_id: backup_id, backup: backup }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup(::Google::Cloud::NetApp::V1::CreateBackupRequest.new(parent: parent, backup_id: backup_id, backup: backup), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_client_stub.call_count
      end
    end
  end

  def test_get_backup
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::Backup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup ::Google::Cloud::NetApp::V1::GetBackupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup(::Google::Cloud::NetApp::V1::GetBackupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_client_stub.call_count
      end
    end
  end

  def test_list_backups
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListBackupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_backups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_backups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backups_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backups parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backups ::Google::Cloud::NetApp::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backups({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backups(::Google::Cloud::NetApp::V1::ListBackupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backups_client_stub.call_count
      end
    end
  end

  def test_delete_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup ::Google::Cloud::NetApp::V1::DeleteBackupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup(::Google::Cloud::NetApp::V1::DeleteBackupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_client_stub.call_count
      end
    end
  end

  def test_update_backup
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup = {}

    update_backup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_backup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup({ update_mask: update_mask, backup: backup }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup update_mask: update_mask, backup: backup do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup ::Google::Cloud::NetApp::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup({ update_mask: update_mask, backup: backup }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup(::Google::Cloud::NetApp::V1::UpdateBackupRequest.new(update_mask: update_mask, backup: backup), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_client_stub.call_count
      end
    end
  end

  def test_create_backup_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    backup_policy = {}
    backup_policy_id = "hello world"

    create_backup_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_backup_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_backup_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_backup_policy({ parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_backup_policy parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_backup_policy ::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest.new(parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_backup_policy({ parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_backup_policy(::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest.new(parent: parent, backup_policy: backup_policy, backup_policy_id: backup_policy_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_backup_policy_client_stub.call_count
      end
    end
  end

  def test_get_backup_policy
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::BackupPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_backup_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_backup_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_backup_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_backup_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_backup_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_backup_policy ::Google::Cloud::NetApp::V1::GetBackupPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_backup_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_backup_policy(::Google::Cloud::NetApp::V1::GetBackupPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_backup_policy_client_stub.call_count
      end
    end
  end

  def test_list_backup_policies
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListBackupPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_backup_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_backup_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_backup_policies_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_backup_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_backup_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_backup_policies ::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_backup_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_backup_policies(::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_backup_policies_client_stub.call_count
      end
    end
  end

  def test_update_backup_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    backup_policy = {}

    update_backup_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_backup_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_backup_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_backup_policy({ update_mask: update_mask, backup_policy: backup_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_backup_policy update_mask: update_mask, backup_policy: backup_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_backup_policy ::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest.new(update_mask: update_mask, backup_policy: backup_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_backup_policy({ update_mask: update_mask, backup_policy: backup_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_backup_policy(::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest.new(update_mask: update_mask, backup_policy: backup_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_backup_policy_client_stub.call_count
      end
    end
  end

  def test_delete_backup_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_backup_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_backup_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_backup_policy_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_backup_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_backup_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_backup_policy ::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_backup_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_backup_policy(::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_backup_policy_client_stub.call_count
      end
    end
  end

  def test_list_quota_rules
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::ListQuotaRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_quota_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_list_quota_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_quota_rules_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_quota_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_quota_rules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_quota_rules ::Google::Cloud::NetApp::V1::ListQuotaRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_quota_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_quota_rules(::Google::Cloud::NetApp::V1::ListQuotaRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_quota_rules_client_stub.call_count
      end
    end
  end

  def test_get_quota_rule
    # Create test objects.
    client_result = ::Google::Cloud::NetApp::V1::QuotaRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_quota_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_get_quota_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_quota_rule_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_quota_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_quota_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_quota_rule ::Google::Cloud::NetApp::V1::GetQuotaRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_quota_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_quota_rule(::Google::Cloud::NetApp::V1::GetQuotaRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_quota_rule_client_stub.call_count
      end
    end
  end

  def test_create_quota_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    quota_rule = {}
    quota_rule_id = "hello world"

    create_quota_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_create_quota_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_quota_rule_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_quota_rule({ parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_quota_rule parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_quota_rule ::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest.new(parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_quota_rule({ parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_quota_rule(::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest.new(parent: parent, quota_rule: quota_rule, quota_rule_id: quota_rule_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_quota_rule_client_stub.call_count
      end
    end
  end

  def test_update_quota_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    quota_rule = {}

    update_quota_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_update_quota_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_quota_rule_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_quota_rule({ update_mask: update_mask, quota_rule: quota_rule }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_quota_rule update_mask: update_mask, quota_rule: quota_rule do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_quota_rule ::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest.new(update_mask: update_mask, quota_rule: quota_rule) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_quota_rule({ update_mask: update_mask, quota_rule: quota_rule }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_quota_rule(::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest.new(update_mask: update_mask, quota_rule: quota_rule), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_quota_rule_client_stub.call_count
      end
    end
  end

  def test_delete_quota_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_quota_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.stub :transcode_delete_quota_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_quota_rule_client_stub do
        # Create client
        client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_quota_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_quota_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_quota_rule ::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_quota_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_quota_rule(::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_quota_rule_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::NetApp::V1::NetApp::Rest::Client::Configuration, config
  end
end
