# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        # GetStoragePoolRequest gets a Storage Pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the storage pool
        class GetStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListStoragePoolsRequest lists Storage Pools.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The next_page_token value to use if there are additional
        #     results to retrieve for this list request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Sort results. Supported values are "name", "name desc" or ""
        #     (unsorted).
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. List filter.
        class ListStoragePoolsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListStoragePoolsResponse is the response to a ListStoragePoolsRequest.
        # @!attribute [rw] storage_pools
        #   @return [::Array<::Google::Cloud::NetApp::V1::StoragePool>]
        #     The list of StoragePools
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListStoragePoolsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateStoragePoolRequest creates a Storage Pool.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Value for parent.
        # @!attribute [rw] storage_pool_id
        #   @return [::String]
        #     Required. Id of the requesting storage pool. Must be unique within the
        #     parent resource. Must contain only letters, numbers and hyphen, with the
        #     first character a letter, the last a letter or a number, and a 63 character
        #     maximum.
        # @!attribute [rw] storage_pool
        #   @return [::Google::Cloud::NetApp::V1::StoragePool]
        #     Required. The required parameters to create a new storage pool.
        class CreateStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateStoragePoolRequest updates a Storage Pool.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     StoragePool resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] storage_pool
        #   @return [::Google::Cloud::NetApp::V1::StoragePool]
        #     Required. The pool being updated
        class UpdateStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteStoragePoolRequest deletes a Storage Pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the storage pool
        class DeleteStoragePoolRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SwitchActiveReplicaZoneRequest switch the active/replica zone for a regional
        # storagePool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the storage pool
        class SwitchActiveReplicaZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # StoragePool is a container for volumes with a service level and capacity.
        # Volumes can be created in a pool of sufficient available capacity.
        # StoragePool capacity is what you are billed for.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the storage pool
        # @!attribute [rw] service_level
        #   @return [::Google::Cloud::NetApp::V1::ServiceLevel]
        #     Required. Service level of the storage pool
        # @!attribute [rw] capacity_gib
        #   @return [::Integer]
        #     Required. Capacity in GIB of the pool
        # @!attribute [r] volume_capacity_gib
        #   @return [::Integer]
        #     Output only. Allocated size of all volumes in GIB in the storage pool
        # @!attribute [r] volume_count
        #   @return [::Integer]
        #     Output only. Volume count of the storage pool
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetApp::V1::StoragePool::State]
        #     Output only. State of the storage pool
        # @!attribute [r] state_details
        #   @return [::String]
        #     Output only. State details of the storage pool
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time of the storage pool
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the storage pool
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels as key value pairs
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. VPC Network name.
        #     Format: projects/\\{project}/global/networks/\\{network}
        # @!attribute [rw] active_directory
        #   @return [::String]
        #     Optional. Specifies the Active Directory to be used for creating a SMB
        #     volume.
        # @!attribute [rw] kms_config
        #   @return [::String]
        #     Optional. Specifies the KMS config to be used for volume encryption.
        # @!attribute [rw] ldap_enabled
        #   @return [::Boolean]
        #     Optional. Flag indicating if the pool is NFS LDAP enabled or not.
        # @!attribute [rw] psa_range
        #   @return [::String]
        #     Optional. This field is not implemented. The values provided in this field
        #     are ignored.
        # @!attribute [r] encryption_type
        #   @return [::Google::Cloud::NetApp::V1::EncryptionType]
        #     Output only. Specifies the current pool encryption key source.
        # @!attribute [rw] global_access_allowed
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Deprecated. Used to allow SO pool to access AD or DNS server from other
        #     regions.
        # @!attribute [rw] allow_auto_tiering
        #   @return [::Boolean]
        #     Optional. True if the storage pool supports Auto Tiering enabled volumes.
        #     Default is false. Auto-tiering can be enabled after storage pool creation
        #     but it can't be disabled once enabled.
        # @!attribute [rw] replica_zone
        #   @return [::String]
        #     Optional. Specifies the replica zone for regional storagePool.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Optional. Specifies the active zone for regional storagePool.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use
        # @!attribute [rw] custom_performance_enabled
        #   @return [::Boolean]
        #     Optional. True if using Independent Scaling of capacity and performance
        #     (Hyperdisk) By default set to false
        # @!attribute [rw] total_throughput_mibps
        #   @return [::Integer]
        #     Optional. Custom Performance Total Throughput of the pool (in MiBps)
        # @!attribute [rw] total_iops
        #   @return [::Integer]
        #     Optional. Custom Performance Total IOPS of the pool
        #     if not provided, it will be calculated based on the total_throughput_mibps
        # @!attribute [rw] hot_tier_size_gib
        #   @return [::Integer]
        #     Optional. Total hot tier capacity for the Storage Pool. It is applicable
        #     only to Flex service level. It should be less than the minimum storage pool
        #     size and cannot be more than the current storage pool size. It cannot be
        #     decreased once set.
        # @!attribute [rw] enable_hot_tier_auto_resize
        #   @return [::Boolean]
        #     Optional. Flag indicating that the hot-tier threshold will be
        #     auto-increased by 10% of the hot-tier when it hits 100%. Default is true.
        #     The increment will kick in only if the new size after increment is
        #     still less than or equal to storage pool size.
        # @!attribute [rw] qos_type
        #   @return [::Google::Cloud::NetApp::V1::QosType]
        #     Optional. QoS (Quality of Service) Type of the storage pool
        # @!attribute [r] available_throughput_mibps
        #   @return [::Float]
        #     Output only. Available throughput of the storage pool (in MiB/s).
        # @!attribute [r] cold_tier_size_used_gib
        #   @return [::Integer]
        #     Output only. Total cold tier data rounded down to the nearest GiB used by
        #     the storage pool.
        # @!attribute [r] hot_tier_size_used_gib
        #   @return [::Integer]
        #     Output only. Total hot tier data rounded down to the nearest GiB used by
        #     the storage pool.
        class StoragePool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Storage Pool States
          module State
            # Unspecified Storage Pool State
            STATE_UNSPECIFIED = 0

            # Storage Pool State is Ready
            READY = 1

            # Storage Pool State is Creating
            CREATING = 2

            # Storage Pool State is Deleting
            DELETING = 3

            # Storage Pool State is Updating
            UPDATING = 4

            # Storage Pool State is Restoring
            RESTORING = 5

            # Storage Pool State is Disabled
            DISABLED = 6

            # Storage Pool State is Error
            ERROR = 7
          end
        end

        # ValidateDirectoryServiceRequest validates the directory service policy
        # attached to the storage pool.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the storage pool
        # @!attribute [rw] directory_service_type
        #   @return [::Google::Cloud::NetApp::V1::DirectoryServiceType]
        #     Type of directory service policy attached to the storage pool.
        class ValidateDirectoryServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
