# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        # ListQuotaRulesRequest for listing quota rules.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListQuotaRulesRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Requested page size. Server may return fewer items than
        #     requested. If unspecified, the server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Hint for how to order the results
        class ListQuotaRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListQuotaRulesResponse is the response to a ListQuotaRulesRequest.
        # @!attribute [rw] quota_rules
        #   @return [::Array<::Google::Cloud::NetApp::V1::QuotaRule>]
        #     List of quota rules
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListQuotaRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetQuotaRuleRequest for getting a quota rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the quota rule
        class GetQuotaRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateQuotaRuleRequest for creating a quota rule.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for CreateQuotaRuleRequest
        # @!attribute [rw] quota_rule
        #   @return [::Google::Cloud::NetApp::V1::QuotaRule]
        #     Required. Fields of the to be created quota rule.
        # @!attribute [rw] quota_rule_id
        #   @return [::String]
        #     Required. ID of the quota rule to create. Must be unique within the parent
        #     resource. Must contain only letters, numbers, underscore and hyphen, with
        #     the first character a letter or underscore, the last a letter or underscore
        #     or a number, and a 63 character maximum.
        class CreateQuotaRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateQuotaRuleRequest for updating a quota rule.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Quota Rule resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] quota_rule
        #   @return [::Google::Cloud::NetApp::V1::QuotaRule]
        #     Required. The quota rule being updated
        class UpdateQuotaRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteQuotaRuleRequest for deleting a single quota rule.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the quota rule.
        class DeleteQuotaRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # QuotaRule specifies the maximum disk space a user or group can use within a
        # volume. They can be used for creating default and individual quota rules.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the quota rule.
        #     Format:
        #     `projects/{project_number}/locations/{location_id}/volumes/volumes/{volume_id}/quotaRules/{quota_rule_id}`.
        # @!attribute [rw] target
        #   @return [::String]
        #     Optional. The quota rule applies to the specified user or group, identified
        #     by a Unix UID/GID, Windows SID, or null for default.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::NetApp::V1::QuotaRule::Type]
        #     Required. The type of quota rule.
        # @!attribute [rw] disk_limit_mib
        #   @return [::Integer]
        #     Required. The maximum allowed disk space in MiB.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetApp::V1::QuotaRule::State]
        #     Output only. State of the quota rule
        # @!attribute [r] state_details
        #   @return [::String]
        #     Output only. State details of the quota rule
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time of the quota rule
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the quota rule
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels of the quota rule
        class QuotaRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Types of Quota Rule
          module Type
            # Unspecified type for quota rule
            TYPE_UNSPECIFIED = 0

            # Individual user quota rule
            INDIVIDUAL_USER_QUOTA = 1

            # Individual group quota rule
            INDIVIDUAL_GROUP_QUOTA = 2

            # Default user quota rule
            DEFAULT_USER_QUOTA = 3

            # Default group quota rule
            DEFAULT_GROUP_QUOTA = 4
          end

          # Quota Rule states
          module State
            # Unspecified state for quota rule
            STATE_UNSPECIFIED = 0

            # Quota rule is creating
            CREATING = 1

            # Quota rule is updating
            UPDATING = 2

            # Quota rule is deleting
            DELETING = 3

            # Quota rule is ready
            READY = 4

            # Quota rule is in error state.
            ERROR = 5
          end
        end
      end
    end
  end
end
