# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        # Metadata for a given
        # [google.cloud.location.Location][google.cloud.location.Location].
        # @!attribute [r] supported_service_levels
        #   @return [::Array<::Google::Cloud::NetApp::V1::ServiceLevel>]
        #     Output only. Supported service levels in a location.
        # @!attribute [r] supported_flex_performance
        #   @return [::Array<::Google::Cloud::NetApp::V1::FlexPerformance>]
        #     Output only. Supported flex performance in a location.
        # @!attribute [r] has_vcp
        #   @return [::Boolean]
        #     Output only. Indicates if the location has VCP support.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UserCommands contains the commands to be executed by the customer.
        # @!attribute [r] commands
        #   @return [::Array<::String>]
        #     Output only. List of commands to be executed by the customer.
        class UserCommands
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The service level of a storage pool and its volumes.
        module ServiceLevel
          # Unspecified service level.
          SERVICE_LEVEL_UNSPECIFIED = 0

          # Premium service level.
          PREMIUM = 1

          # Extreme service level.
          EXTREME = 2

          # Standard service level.
          STANDARD = 3

          # Flex service level.
          FLEX = 4
        end

        # Flex Storage Pool performance.
        module FlexPerformance
          # Unspecified flex performance.
          FLEX_PERFORMANCE_UNSPECIFIED = 0

          # Flex Storage Pool with default performance.
          FLEX_PERFORMANCE_DEFAULT = 1

          # Flex Storage Pool with custom performance.
          FLEX_PERFORMANCE_CUSTOM = 2
        end

        # The volume encryption key source.
        module EncryptionType
          # The source of the encryption key is not specified.
          ENCRYPTION_TYPE_UNSPECIFIED = 0

          # Google managed encryption key.
          SERVICE_MANAGED = 1

          # Customer managed encryption key, which is stored in KMS.
          CLOUD_KMS = 2
        end

        # Type of directory service
        module DirectoryServiceType
          # Directory service type is not specified.
          DIRECTORY_SERVICE_TYPE_UNSPECIFIED = 0

          # Active directory policy attached to the storage pool.
          ACTIVE_DIRECTORY = 1
        end

        # Schedule for Hybrid Replication.
        # New enum values may be added in future to support different frequency of
        # replication.
        module HybridReplicationSchedule
          # Unspecified HybridReplicationSchedule
          HYBRID_REPLICATION_SCHEDULE_UNSPECIFIED = 0

          # Replication happens once every 10 minutes.
          EVERY_10_MINUTES = 1

          # Replication happens once every hour.
          HOURLY = 2

          # Replication happens once every day.
          DAILY = 3
        end

        # QoS (Quality of Service) Types of the storage pool
        module QosType
          # Unspecified QoS Type
          QOS_TYPE_UNSPECIFIED = 0

          # QoS Type is Auto
          AUTO = 1

          # QoS Type is Manual
          MANUAL = 2
        end
      end
    end
  end
end
