# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        # A NetApp BackupVault.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the backup vault.
        #     Format:
        #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetApp::V1::BackupVault::State]
        #     Output only. The backup vault state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Create time of the backup vault.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the backup vault.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource labels to represent user provided metadata.
        # @!attribute [rw] backup_vault_type
        #   @return [::Google::Cloud::NetApp::V1::BackupVault::BackupVaultType]
        #     Optional. Type of backup vault to be created.
        #     Default is IN_REGION.
        # @!attribute [r] source_region
        #   @return [::String]
        #     Output only. Region in which the backup vault is created.
        #     Format: `projects/{project_id}/locations/{location}`
        # @!attribute [rw] backup_region
        #   @return [::String]
        #     Optional. Region where the backups are stored.
        #     Format: `projects/{project_id}/locations/{location}`
        # @!attribute [r] source_backup_vault
        #   @return [::String]
        #     Output only. Name of the Backup vault created in source region.
        #     Format:
        #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
        # @!attribute [r] destination_backup_vault
        #   @return [::String]
        #     Output only. Name of the Backup vault created in backup region.
        #     Format:
        #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
        # @!attribute [rw] backup_retention_policy
        #   @return [::Google::Cloud::NetApp::V1::BackupVault::BackupRetentionPolicy]
        #     Optional. Backup retention policy defining the retenton of backups.
        class BackupVault
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Retention policy for backups in the backup vault
          # @!attribute [rw] backup_minimum_enforced_retention_days
          #   @return [::Integer]
          #     Required. Minimum retention duration in days for backups in the backup
          #     vault.
          # @!attribute [rw] daily_backup_immutable
          #   @return [::Boolean]
          #     Optional. Indicates if the daily backups are immutable.
          #     At least one of daily_backup_immutable, weekly_backup_immutable,
          #     monthly_backup_immutable and manual_backup_immutable must be true.
          # @!attribute [rw] weekly_backup_immutable
          #   @return [::Boolean]
          #     Optional. Indicates if the weekly backups are immutable.
          #     At least one of daily_backup_immutable, weekly_backup_immutable,
          #     monthly_backup_immutable and manual_backup_immutable must be true.
          # @!attribute [rw] monthly_backup_immutable
          #   @return [::Boolean]
          #     Optional. Indicates if the monthly backups are immutable.
          #     At least one of daily_backup_immutable, weekly_backup_immutable,
          #     monthly_backup_immutable and manual_backup_immutable must be true.
          # @!attribute [rw] manual_backup_immutable
          #   @return [::Boolean]
          #     Optional. Indicates if the manual backups are immutable.
          #     At least one of daily_backup_immutable, weekly_backup_immutable,
          #     monthly_backup_immutable and manual_backup_immutable must be true.
          class BackupRetentionPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Backup Vault States
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # BackupVault is being created.
            CREATING = 1

            # BackupVault is available for use.
            READY = 2

            # BackupVault is being deleted.
            DELETING = 3

            # BackupVault is not valid and cannot be used.
            ERROR = 4

            # BackupVault is being updated.
            UPDATING = 5
          end

          # Backup Vault Type.
          module BackupVaultType
            # BackupVault type not set.
            BACKUP_VAULT_TYPE_UNSPECIFIED = 0

            # BackupVault type is IN_REGION.
            IN_REGION = 1

            # BackupVault type is CROSS_REGION.
            CROSS_REGION = 2
          end
        end

        # GetBackupVaultRequest gets the state of a backupVault.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backupVault resource name, in the format
        #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
        class GetBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupVaultsRequest lists backupVaults.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location for which to retrieve backupVault information,
        #     in the format
        #     `projects/{project_id}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value to use if there are additional
        #     results to retrieve for this list request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        class ListBackupVaultsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupVaultsResponse is the result of ListBackupVaultsRequest.
        # @!attribute [rw] backup_vaults
        #   @return [::Array<::Google::Cloud::NetApp::V1::BackupVault>]
        #     A list of backupVaults in the project for the specified location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token you can use to retrieve the next page of results. Not returned
        #     if there are no more results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupVaultsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateBackupVaultRequest creates a backup vault.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location to create the backup vaults, in the format
        #     `projects/{project_id}/locations/{location}`
        # @!attribute [rw] backup_vault_id
        #   @return [::String]
        #     Required. The ID to use for the backupVault.
        #     The ID must be unique within the specified location.
        #     Must contain only letters, numbers and hyphen, with the first
        #     character a letter, the last a letter or a
        #     number, and a 63 character maximum.
        # @!attribute [rw] backup_vault
        #   @return [::Google::Cloud::NetApp::V1::BackupVault]
        #     Required. A backupVault resource
        class CreateBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteBackupVaultRequest deletes a backupVault.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backupVault resource name, in the format
        #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
        class DeleteBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateBackupVaultRequest updates description and/or labels for a backupVault.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Backup resource to be updated.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] backup_vault
        #   @return [::Google::Cloud::NetApp::V1::BackupVault]
        #     Required. The backupVault being updated
        class UpdateBackupVaultRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
