# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        # Backup Policy.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the backup policy.
        #     Format:
        #     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`.
        # @!attribute [rw] daily_backup_limit
        #   @return [::Integer]
        #     Number of daily backups to keep. Note that the minimum daily backup limit
        #     is 2.
        # @!attribute [rw] weekly_backup_limit
        #   @return [::Integer]
        #     Number of weekly backups to keep. Note that the sum of daily, weekly and
        #     monthly backups should be greater than 1.
        # @!attribute [rw] monthly_backup_limit
        #   @return [::Integer]
        #     Number of monthly backups to keep. Note that the sum of daily, weekly and
        #     monthly backups should be greater than 1.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the backup policy.
        # @!attribute [rw] enabled
        #   @return [::Boolean]
        #     If enabled, make backups automatically according to the schedules.
        #     This will be applied to all volumes that have this policy attached and
        #     enforced on volume level. If not specified, default is true.
        # @!attribute [r] assigned_volume_count
        #   @return [::Integer]
        #     Output only. The total number of volumes assigned by this backup policy.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup policy was created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource labels to represent user provided metadata.
        # @!attribute [r] state
        #   @return [::Google::Cloud::NetApp::V1::BackupPolicy::State]
        #     Output only. The backup policy state.
        class BackupPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # BackupPolicy is being created.
            CREATING = 1

            # BackupPolicy is available for use.
            READY = 2

            # BackupPolicy is being deleted.
            DELETING = 3

            # BackupPolicy is not valid and cannot be used.
            ERROR = 4

            # BackupPolicy is being updated.
            UPDATING = 5
          end
        end

        # CreateBackupPolicyRequest creates a backupPolicy.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location to create the backup policies of, in the format
        #     `projects/{project_id}/locations/{location}`
        # @!attribute [rw] backup_policy
        #   @return [::Google::Cloud::NetApp::V1::BackupPolicy]
        #     Required. A backupPolicy resource
        # @!attribute [rw] backup_policy_id
        #   @return [::String]
        #     Required. The ID to use for the backup policy.
        #     The ID must be unique within the specified location.
        #     Must contain only letters, numbers and hyphen, with the first
        #     character a letter, the last a letter or a
        #     number, and a 63 character maximum.
        class CreateBackupPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetBackupPolicyRequest gets the state of a backupPolicy.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backupPolicy resource name, in the format
        #     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`
        class GetBackupPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupPoliciesRequest for requesting multiple backup policies.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent value for ListBackupPoliciesRequest
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Requested page size. Server may return fewer items than requested.
        #     If unspecified, the server will pick an appropriate default.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filtering results
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Hint for how to order the results
        class ListBackupPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupPoliciesResponse contains all the backup policies requested.
        # @!attribute [rw] backup_policies
        #   @return [::Array<::Google::Cloud::NetApp::V1::BackupPolicy>]
        #     The list of backup policies.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token identifying a page of results the server should return.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListBackupPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateBackupPolicyRequest for updating a backup policy.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Backup Policy resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] backup_policy
        #   @return [::Google::Cloud::NetApp::V1::BackupPolicy]
        #     Required. The backup policy being updated
        class UpdateBackupPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteBackupPolicyRequest deletes a backup policy.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backup policy resource name, in the format
        #     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`
        class DeleteBackupPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
