# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/netapp/v1/cloud_netapp_service_pb"
require "google/cloud/netapp/v1/netapp/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module NetApp
      module V1
        module NetApp
          module Rest
            ##
            # REST client for the NetApp service.
            #
            # NetApp Files Google Cloud Service
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "netapp.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :net_app_stub

              ##
              # Configure the NetApp Client class.
              #
              # See {::Google::Cloud::NetApp::V1::NetApp::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all NetApp clients
              #   ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "NetApp", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_storage_pools.timeout = 60.0
                  default_config.rpcs.list_storage_pools.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_storage_pool.timeout = 60.0

                  default_config.rpcs.get_storage_pool.timeout = 60.0
                  default_config.rpcs.get_storage_pool.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_storage_pool.timeout = 60.0

                  default_config.rpcs.delete_storage_pool.timeout = 60.0

                  default_config.rpcs.list_volumes.timeout = 60.0
                  default_config.rpcs.list_volumes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_volume.timeout = 60.0
                  default_config.rpcs.get_volume.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_volume.timeout = 60.0

                  default_config.rpcs.update_volume.timeout = 60.0

                  default_config.rpcs.delete_volume.timeout = 60.0

                  default_config.rpcs.revert_volume.timeout = 60.0

                  default_config.rpcs.list_snapshots.timeout = 60.0
                  default_config.rpcs.list_snapshots.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_snapshot.timeout = 60.0
                  default_config.rpcs.get_snapshot.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_snapshot.timeout = 60.0

                  default_config.rpcs.delete_snapshot.timeout = 60.0

                  default_config.rpcs.update_snapshot.timeout = 60.0

                  default_config.rpcs.list_active_directories.timeout = 60.0
                  default_config.rpcs.list_active_directories.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_active_directory.timeout = 60.0
                  default_config.rpcs.get_active_directory.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_active_directory.timeout = 60.0

                  default_config.rpcs.update_active_directory.timeout = 60.0

                  default_config.rpcs.delete_active_directory.timeout = 60.0

                  default_config.rpcs.list_kms_configs.timeout = 60.0
                  default_config.rpcs.list_kms_configs.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_kms_config.timeout = 60.0

                  default_config.rpcs.get_kms_config.timeout = 60.0
                  default_config.rpcs.get_kms_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_kms_config.timeout = 60.0

                  default_config.rpcs.encrypt_volumes.timeout = 60.0

                  default_config.rpcs.verify_kms_config.timeout = 60.0

                  default_config.rpcs.delete_kms_config.timeout = 60.0

                  default_config.rpcs.list_replications.timeout = 60.0
                  default_config.rpcs.list_replications.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_replication.timeout = 60.0
                  default_config.rpcs.get_replication.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_replication.timeout = 60.0

                  default_config.rpcs.delete_replication.timeout = 60.0

                  default_config.rpcs.update_replication.timeout = 60.0

                  default_config.rpcs.stop_replication.timeout = 60.0

                  default_config.rpcs.resume_replication.timeout = 60.0

                  default_config.rpcs.reverse_replication_direction.timeout = 60.0

                  default_config.rpcs.create_backup_vault.timeout = 60.0

                  default_config.rpcs.get_backup_vault.timeout = 60.0
                  default_config.rpcs.get_backup_vault.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_backup_vaults.timeout = 60.0
                  default_config.rpcs.list_backup_vaults.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_backup_vault.timeout = 60.0

                  default_config.rpcs.delete_backup_vault.timeout = 60.0

                  default_config.rpcs.create_backup.timeout = 60.0

                  default_config.rpcs.get_backup.timeout = 60.0
                  default_config.rpcs.get_backup.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_backups.timeout = 60.0
                  default_config.rpcs.list_backups.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_backup.timeout = 60.0

                  default_config.rpcs.update_backup.timeout = 60.0

                  default_config.rpcs.create_backup_policy.timeout = 60.0

                  default_config.rpcs.get_backup_policy.timeout = 60.0
                  default_config.rpcs.get_backup_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_backup_policies.timeout = 60.0
                  default_config.rpcs.list_backup_policies.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_backup_policy.timeout = 60.0

                  default_config.rpcs.delete_backup_policy.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the NetApp Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::NetApp::V1::NetApp::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @net_app_stub.universe_domain
              end

              ##
              # Create a new NetApp REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the NetApp client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @net_app_stub = ::Google::Cloud::NetApp::V1::NetApp::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @net_app_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @net_app_stub.endpoint
                  config.universe_domain = @net_app_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @net_app_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::NetApp::V1::NetApp::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @net_app_stub.logger
              end

              # Service calls

              ##
              # Returns descriptions of all storage pools owned by the caller.
              #
              # @overload list_storage_pools(request, options = nil)
              #   Pass arguments to `list_storage_pools` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListStoragePoolsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListStoragePoolsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_storage_pools(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_storage_pools` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value
              #   @param page_size [::Integer]
              #     Optional. The maximum number of items to return.
              #   @param page_token [::String]
              #     Optional. The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Optional. Sort results. Supported values are "name", "name desc" or ""
              #     (unsorted).
              #   @param filter [::String]
              #     Optional. List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::StoragePool>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::StoragePool>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListStoragePoolsRequest.new
              #
              #   # Call the list_storage_pools method.
              #   result = client.list_storage_pools request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::StoragePool.
              #     p item
              #   end
              #
              def list_storage_pools request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListStoragePoolsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_storage_pools.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_storage_pools.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_storage_pools.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_storage_pools request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_storage_pools, "storage_pools", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new storage pool.
              #
              # @overload create_storage_pool(request, options = nil)
              #   Pass arguments to `create_storage_pool` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateStoragePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateStoragePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_storage_pool(parent: nil, storage_pool_id: nil, storage_pool: nil)
              #   Pass arguments to `create_storage_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param storage_pool_id [::String]
              #     Required. Id of the requesting storage pool. Must be unique within the
              #     parent resource. Must contain only letters, numbers and hyphen, with the
              #     first character a letter, the last a letter or a number, and a 63 character
              #     maximum.
              #   @param storage_pool [::Google::Cloud::NetApp::V1::StoragePool, ::Hash]
              #     Required. The required parameters to create a new storage pool.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateStoragePoolRequest.new
              #
              #   # Call the create_storage_pool method.
              #   result = client.create_storage_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_storage_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateStoragePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_storage_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_storage_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_storage_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_storage_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the description of the specified storage pool by poolId.
              #
              # @overload get_storage_pool(request, options = nil)
              #   Pass arguments to `get_storage_pool` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetStoragePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetStoragePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_storage_pool(name: nil)
              #   Pass arguments to `get_storage_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the storage pool
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::StoragePool]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::StoragePool]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetStoragePoolRequest.new
              #
              #   # Call the get_storage_pool method.
              #   result = client.get_storage_pool request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::StoragePool.
              #   p result
              #
              def get_storage_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetStoragePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_storage_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_storage_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_storage_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_storage_pool request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the storage pool properties with the full spec
              #
              # @overload update_storage_pool(request, options = nil)
              #   Pass arguments to `update_storage_pool` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_storage_pool(update_mask: nil, storage_pool: nil)
              #   Pass arguments to `update_storage_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     StoragePool resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param storage_pool [::Google::Cloud::NetApp::V1::StoragePool, ::Hash]
              #     Required. The pool being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateStoragePoolRequest.new
              #
              #   # Call the update_storage_pool method.
              #   result = client.update_storage_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_storage_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateStoragePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_storage_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_storage_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_storage_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_storage_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Warning! This operation will permanently delete the storage pool.
              #
              # @overload delete_storage_pool(request, options = nil)
              #   Pass arguments to `delete_storage_pool` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_storage_pool(name: nil)
              #   Pass arguments to `delete_storage_pool` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the storage pool
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteStoragePoolRequest.new
              #
              #   # Call the delete_storage_pool method.
              #   result = client.delete_storage_pool request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_storage_pool request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteStoragePoolRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_storage_pool.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_storage_pool.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_storage_pool.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_storage_pool request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # ValidateDirectoryService does a connectivity check for a directory service
              # policy attached to the storage pool.
              #
              # @overload validate_directory_service(request, options = nil)
              #   Pass arguments to `validate_directory_service` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload validate_directory_service(name: nil, directory_service_type: nil)
              #   Pass arguments to `validate_directory_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the storage pool
              #   @param directory_service_type [::Google::Cloud::NetApp::V1::DirectoryServiceType]
              #     Type of directory service policy attached to the storage pool.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest.new
              #
              #   # Call the validate_directory_service method.
              #   result = client.validate_directory_service request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def validate_directory_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ValidateDirectoryServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.validate_directory_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.validate_directory_service.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.validate_directory_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.validate_directory_service request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # This operation will switch the active/replica zone for a regional
              # storagePool.
              #
              # @overload switch_active_replica_zone(request, options = nil)
              #   Pass arguments to `switch_active_replica_zone` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload switch_active_replica_zone(name: nil)
              #   Pass arguments to `switch_active_replica_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the storage pool
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest.new
              #
              #   # Call the switch_active_replica_zone method.
              #   result = client.switch_active_replica_zone request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def switch_active_replica_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::SwitchActiveReplicaZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.switch_active_replica_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.switch_active_replica_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.switch_active_replica_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.switch_active_replica_zone request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Volumes in a given project.
              #
              # @overload list_volumes(request, options = nil)
              #   Pass arguments to `list_volumes` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListVolumesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListVolumesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_volumes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_volumes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListVolumesRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Volume>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Volume>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListVolumesRequest.new
              #
              #   # Call the list_volumes method.
              #   result = client.list_volumes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::Volume.
              #     p item
              #   end
              #
              def list_volumes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListVolumesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_volumes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_volumes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_volumes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_volumes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_volumes, "volumes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Volume.
              #
              # @overload get_volume(request, options = nil)
              #   Pass arguments to `get_volume` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_volume(name: nil)
              #   Pass arguments to `get_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the volume
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::Volume]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::Volume]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetVolumeRequest.new
              #
              #   # Call the get_volume method.
              #   result = client.get_volume request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::Volume.
              #   p result
              #
              def get_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_volume request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Volume in a given project and location.
              #
              # @overload create_volume(request, options = nil)
              #   Pass arguments to `create_volume` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_volume(parent: nil, volume_id: nil, volume: nil)
              #   Pass arguments to `create_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param volume_id [::String]
              #     Required. Id of the requesting volume. Must be unique within the parent
              #     resource. Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a number,
              #     and a 63 character maximum.
              #   @param volume [::Google::Cloud::NetApp::V1::Volume, ::Hash]
              #     Required. The volume being created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateVolumeRequest.new
              #
              #   # Call the create_volume method.
              #   result = client.create_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Volume.
              #
              # @overload update_volume(request, options = nil)
              #   Pass arguments to `update_volume` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_volume(update_mask: nil, volume: nil)
              #   Pass arguments to `update_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Volume resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param volume [::Google::Cloud::NetApp::V1::Volume, ::Hash]
              #     Required. The volume being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateVolumeRequest.new
              #
              #   # Call the update_volume method.
              #   result = client.update_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Volume.
              #
              # @overload delete_volume(request, options = nil)
              #   Pass arguments to `delete_volume` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_volume(name: nil, force: nil)
              #   Pass arguments to `delete_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the volume
              #   @param force [::Boolean]
              #     If this field is set as true, CCFE will not block the volume resource
              #     deletion even if it has any snapshots resource. (Otherwise, the request
              #     will only work if the volume has no snapshots.)
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteVolumeRequest.new
              #
              #   # Call the delete_volume method.
              #   result = client.delete_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Revert an existing volume to a specified snapshot.
              # Warning! This operation will permanently revert all changes made after the
              # snapshot was created.
              #
              # @overload revert_volume(request, options = nil)
              #   Pass arguments to `revert_volume` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::RevertVolumeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::RevertVolumeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload revert_volume(name: nil, snapshot_id: nil)
              #   Pass arguments to `revert_volume` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the volume, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}.
              #   @param snapshot_id [::String]
              #     Required. The snapshot resource ID, in the format 'my-snapshot', where the
              #     specified ID is the \\{snapshot_id} of the fully qualified name like
              #     projects/\\{project_id}/locations/\\{location_id}/volumes/\\{volume_id}/snapshots/\\{snapshot_id}
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::RevertVolumeRequest.new
              #
              #   # Call the revert_volume method.
              #   result = client.revert_volume request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def revert_volume request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::RevertVolumeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.revert_volume.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.revert_volume.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.revert_volume.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.revert_volume request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns descriptions of all snapshots for a volume.
              #
              # @overload list_snapshots(request, options = nil)
              #   Pass arguments to `list_snapshots` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListSnapshotsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListSnapshotsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_snapshots(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_snapshots` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The volume for which to retrieve snapshot information,
              #     in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Snapshot>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Snapshot>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListSnapshotsRequest.new
              #
              #   # Call the list_snapshots method.
              #   result = client.list_snapshots request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::Snapshot.
              #     p item
              #   end
              #
              def list_snapshots request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListSnapshotsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_snapshots.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_snapshots.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_snapshots.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_snapshots request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_snapshots, "snapshots", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Describe a snapshot for a volume.
              #
              # @overload get_snapshot(request, options = nil)
              #   Pass arguments to `get_snapshot` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_snapshot(name: nil)
              #   Pass arguments to `get_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The snapshot resource name, in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}/snapshots/{snapshot_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::Snapshot]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::Snapshot]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetSnapshotRequest.new
              #
              #   # Call the get_snapshot method.
              #   result = client.get_snapshot request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::Snapshot.
              #   p result
              #
              def get_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_snapshot request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a new snapshot for a volume.
              #
              # @overload create_snapshot(request, options = nil)
              #   Pass arguments to `create_snapshot` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_snapshot(parent: nil, snapshot: nil, snapshot_id: nil)
              #   Pass arguments to `create_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The NetApp volume to create the snapshots of, in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}`
              #   @param snapshot [::Google::Cloud::NetApp::V1::Snapshot, ::Hash]
              #     Required. A snapshot resource
              #   @param snapshot_id [::String]
              #     Required. ID of the snapshot to create. Must be unique within the parent
              #     resource. Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateSnapshotRequest.new
              #
              #   # Call the create_snapshot method.
              #   result = client.create_snapshot request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_snapshot request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a snapshot.
              #
              # @overload delete_snapshot(request, options = nil)
              #   Pass arguments to `delete_snapshot` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_snapshot(name: nil)
              #   Pass arguments to `delete_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The snapshot resource name, in the format
              #     `projects/*/locations/*/volumes/*/snapshots/{snapshot_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteSnapshotRequest.new
              #
              #   # Call the delete_snapshot method.
              #   result = client.delete_snapshot request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_snapshot request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the settings of a specific snapshot.
              #
              # @overload update_snapshot(request, options = nil)
              #   Pass arguments to `update_snapshot` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateSnapshotRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateSnapshotRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_snapshot(update_mask: nil, snapshot: nil)
              #   Pass arguments to `update_snapshot` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.  At least one path must be supplied in
              #     this field.
              #   @param snapshot [::Google::Cloud::NetApp::V1::Snapshot, ::Hash]
              #     Required. A snapshot resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateSnapshotRequest.new
              #
              #   # Call the update_snapshot method.
              #   result = client.update_snapshot request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_snapshot request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateSnapshotRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_snapshot.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_snapshot.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_snapshot.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_snapshot request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists active directories.
              #
              # @overload list_active_directories(request, options = nil)
              #   Pass arguments to `list_active_directories` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_active_directories(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_active_directories` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListActiveDirectoriesRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::ActiveDirectory>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::ActiveDirectory>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest.new
              #
              #   # Call the list_active_directories method.
              #   result = client.list_active_directories request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::ActiveDirectory.
              #     p item
              #   end
              #
              def list_active_directories request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListActiveDirectoriesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_active_directories.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_active_directories.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_active_directories.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_active_directories request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_active_directories, "active_directories", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Describes a specified active directory.
              #
              # @overload get_active_directory(request, options = nil)
              #   Pass arguments to `get_active_directory` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_active_directory(name: nil)
              #   Pass arguments to `get_active_directory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the active directory.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::ActiveDirectory]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::ActiveDirectory]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetActiveDirectoryRequest.new
              #
              #   # Call the get_active_directory method.
              #   result = client.get_active_directory request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::ActiveDirectory.
              #   p result
              #
              def get_active_directory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetActiveDirectoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_active_directory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_active_directory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_active_directory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_active_directory request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # CreateActiveDirectory
              # Creates the active directory specified in the request.
              #
              # @overload create_active_directory(request, options = nil)
              #   Pass arguments to `create_active_directory` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_active_directory(parent: nil, active_directory: nil, active_directory_id: nil)
              #   Pass arguments to `create_active_directory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param active_directory [::Google::Cloud::NetApp::V1::ActiveDirectory, ::Hash]
              #     Required. Fields of the to be created active directory.
              #   @param active_directory_id [::String]
              #     Required. ID of the active directory to create. Must be unique within the
              #     parent resource. Must contain only letters, numbers and hyphen, with the
              #     first character a letter , the last a letter or a number, and a 63
              #     character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest.new
              #
              #   # Call the create_active_directory method.
              #   result = client.create_active_directory request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_active_directory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateActiveDirectoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_active_directory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_active_directory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_active_directory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_active_directory request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update the parameters of an active directories.
              #
              # @overload update_active_directory(request, options = nil)
              #   Pass arguments to `update_active_directory` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_active_directory(update_mask: nil, active_directory: nil)
              #   Pass arguments to `update_active_directory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Active Directory resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param active_directory [::Google::Cloud::NetApp::V1::ActiveDirectory, ::Hash]
              #     Required. The volume being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest.new
              #
              #   # Call the update_active_directory method.
              #   result = client.update_active_directory request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_active_directory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateActiveDirectoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_active_directory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_active_directory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_active_directory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_active_directory request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete the active directory specified in the request.
              #
              # @overload delete_active_directory(request, options = nil)
              #   Pass arguments to `delete_active_directory` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_active_directory(name: nil)
              #   Pass arguments to `delete_active_directory` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the active directory.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest.new
              #
              #   # Call the delete_active_directory method.
              #   result = client.delete_active_directory request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_active_directory request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteActiveDirectoryRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_active_directory.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_active_directory.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_active_directory.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_active_directory request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns descriptions of all KMS configs owned by the caller.
              #
              # @overload list_kms_configs(request, options = nil)
              #   Pass arguments to `list_kms_configs` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListKmsConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListKmsConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_kms_configs(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_kms_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::KmsConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::KmsConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListKmsConfigsRequest.new
              #
              #   # Call the list_kms_configs method.
              #   result = client.list_kms_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::KmsConfig.
              #     p item
              #   end
              #
              def list_kms_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListKmsConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_kms_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_kms_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_kms_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_kms_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_kms_configs, "kms_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new KMS config.
              #
              # @overload create_kms_config(request, options = nil)
              #   Pass arguments to `create_kms_config` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateKmsConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateKmsConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_kms_config(parent: nil, kms_config_id: nil, kms_config: nil)
              #   Pass arguments to `create_kms_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param kms_config_id [::String]
              #     Required. Id of the requesting KmsConfig. Must be unique within the parent
              #     resource. Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              #   @param kms_config [::Google::Cloud::NetApp::V1::KmsConfig, ::Hash]
              #     Required. The required parameters to create a new KmsConfig.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateKmsConfigRequest.new
              #
              #   # Call the create_kms_config method.
              #   result = client.create_kms_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_kms_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateKmsConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_kms_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_kms_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_kms_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_kms_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the description of the specified KMS config by kms_config_id.
              #
              # @overload get_kms_config(request, options = nil)
              #   Pass arguments to `get_kms_config` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetKmsConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetKmsConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_kms_config(name: nil)
              #   Pass arguments to `get_kms_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the KmsConfig
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::KmsConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::KmsConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetKmsConfigRequest.new
              #
              #   # Call the get_kms_config method.
              #   result = client.get_kms_config request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::KmsConfig.
              #   p result
              #
              def get_kms_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetKmsConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_kms_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_kms_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_kms_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_kms_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the Kms config properties with the full spec
              #
              # @overload update_kms_config(request, options = nil)
              #   Pass arguments to `update_kms_config` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_kms_config(update_mask: nil, kms_config: nil)
              #   Pass arguments to `update_kms_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     KmsConfig resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param kms_config [::Google::Cloud::NetApp::V1::KmsConfig, ::Hash]
              #     Required. The KmsConfig being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateKmsConfigRequest.new
              #
              #   # Call the update_kms_config method.
              #   result = client.update_kms_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_kms_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateKmsConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_kms_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_kms_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_kms_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_kms_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Encrypt the existing volumes without CMEK encryption with the desired the
              # KMS config for the whole region.
              #
              # @overload encrypt_volumes(request, options = nil)
              #   Pass arguments to `encrypt_volumes` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::EncryptVolumesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::EncryptVolumesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload encrypt_volumes(name: nil)
              #   Pass arguments to `encrypt_volumes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the KmsConfig.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::EncryptVolumesRequest.new
              #
              #   # Call the encrypt_volumes method.
              #   result = client.encrypt_volumes request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def encrypt_volumes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::EncryptVolumesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.encrypt_volumes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.encrypt_volumes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.encrypt_volumes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.encrypt_volumes request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Verifies KMS config reachability.
              #
              # @overload verify_kms_config(request, options = nil)
              #   Pass arguments to `verify_kms_config` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload verify_kms_config(name: nil)
              #   Pass arguments to `verify_kms_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the KMS Config to be verified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::VerifyKmsConfigResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::VerifyKmsConfigResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::VerifyKmsConfigRequest.new
              #
              #   # Call the verify_kms_config method.
              #   result = client.verify_kms_config request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::VerifyKmsConfigResponse.
              #   p result
              #
              def verify_kms_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::VerifyKmsConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.verify_kms_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.verify_kms_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.verify_kms_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.verify_kms_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Warning! This operation will permanently delete the Kms config.
              #
              # @overload delete_kms_config(request, options = nil)
              #   Pass arguments to `delete_kms_config` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_kms_config(name: nil)
              #   Pass arguments to `delete_kms_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the KmsConfig.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteKmsConfigRequest.new
              #
              #   # Call the delete_kms_config method.
              #   result = client.delete_kms_config request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_kms_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteKmsConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_kms_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_kms_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_kms_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_kms_config request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns descriptions of all replications for a volume.
              #
              # @overload list_replications(request, options = nil)
              #   Pass arguments to `list_replications` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListReplicationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListReplicationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_replications(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_replications` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The volume for which to retrieve replication information,
              #     in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Replication>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Replication>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListReplicationsRequest.new
              #
              #   # Call the list_replications method.
              #   result = client.list_replications request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::Replication.
              #     p item
              #   end
              #
              def list_replications request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListReplicationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_replications.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_replications.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_replications.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_replications request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_replications, "replications", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Describe a replication for a volume.
              #
              # @overload get_replication(request, options = nil)
              #   Pass arguments to `get_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_replication(name: nil)
              #   Pass arguments to `get_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The replication resource name, in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}/replications/{replication_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::Replication]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::Replication]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetReplicationRequest.new
              #
              #   # Call the get_replication method.
              #   result = client.get_replication request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::Replication.
              #   p result
              #
              def get_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_replication request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a new replication for a volume.
              #
              # @overload create_replication(request, options = nil)
              #   Pass arguments to `create_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_replication(parent: nil, replication: nil, replication_id: nil)
              #   Pass arguments to `create_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The NetApp volume to create the replications of, in the format
              #     `projects/{project_id}/locations/{location}/volumes/{volume_id}`
              #   @param replication [::Google::Cloud::NetApp::V1::Replication, ::Hash]
              #     Required. A replication resource
              #   @param replication_id [::String]
              #     Required. ID of the replication to create. Must be unique within the parent
              #     resource. Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateReplicationRequest.new
              #
              #   # Call the create_replication method.
              #   result = client.create_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a replication.
              #
              # @overload delete_replication(request, options = nil)
              #   Pass arguments to `delete_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_replication(name: nil)
              #   Pass arguments to `delete_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The replication resource name, in the format
              #     `projects/*/locations/*/volumes/*/replications/{replication_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteReplicationRequest.new
              #
              #   # Call the delete_replication method.
              #   result = client.delete_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the settings of a specific replication.
              #
              # @overload update_replication(request, options = nil)
              #   Pass arguments to `update_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_replication(update_mask: nil, replication: nil)
              #   Pass arguments to `update_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.  At least one path must be supplied in
              #     this field.
              #   @param replication [::Google::Cloud::NetApp::V1::Replication, ::Hash]
              #     Required. A replication resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateReplicationRequest.new
              #
              #   # Call the update_replication method.
              #   result = client.update_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stop Cross Region Replication.
              #
              # @overload stop_replication(request, options = nil)
              #   Pass arguments to `stop_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::StopReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::StopReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_replication(name: nil, force: nil)
              #   Pass arguments to `stop_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the replication, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}/replications/\\{replication_id}.
              #   @param force [::Boolean]
              #     Indicates whether to stop replication forcefully while data transfer is in
              #     progress.
              #     Warning! if force is true, this will abort any current transfers
              #     and can lead to data loss due to partial transfer.
              #     If force is false, stop replication will fail while data transfer is in
              #     progress and you will need to retry later.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::StopReplicationRequest.new
              #
              #   # Call the stop_replication method.
              #   result = client.stop_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::StopReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.stop_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resume Cross Region Replication.
              #
              # @overload resume_replication(request, options = nil)
              #   Pass arguments to `resume_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ResumeReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ResumeReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload resume_replication(name: nil)
              #   Pass arguments to `resume_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the replication, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}/replications/\\{replication_id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ResumeReplicationRequest.new
              #
              #   # Call the resume_replication method.
              #   result = client.resume_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def resume_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ResumeReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.resume_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.resume_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.resume_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.resume_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reverses direction of replication. Source becomes destination and
              # destination becomes source.
              #
              # @overload reverse_replication_direction(request, options = nil)
              #   Pass arguments to `reverse_replication_direction` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reverse_replication_direction(name: nil)
              #   Pass arguments to `reverse_replication_direction` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the replication, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}/replications/\\{replication_id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest.new
              #
              #   # Call the reverse_replication_direction method.
              #   result = client.reverse_replication_direction request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def reverse_replication_direction request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ReverseReplicationDirectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reverse_replication_direction.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reverse_replication_direction.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reverse_replication_direction.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.reverse_replication_direction request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Establish replication peering.
              #
              # @overload establish_peering(request, options = nil)
              #   Pass arguments to `establish_peering` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::EstablishPeeringRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::EstablishPeeringRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload establish_peering(name: nil, peer_cluster_name: nil, peer_svm_name: nil, peer_ip_addresses: nil, peer_volume_name: nil)
              #   Pass arguments to `establish_peering` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the replication, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}/replications/\\{replication_id}.
              #   @param peer_cluster_name [::String]
              #     Required. Name of the user's local source cluster to be peered with the
              #     destination cluster.
              #   @param peer_svm_name [::String]
              #     Required. Name of the user's local source vserver svm to be peered with the
              #     destination vserver svm.
              #   @param peer_ip_addresses [::Array<::String>]
              #     Optional. List of IPv4 ip addresses to be used for peering.
              #   @param peer_volume_name [::String]
              #     Required. Name of the user's local source volume to be peered with the
              #     destination volume.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::EstablishPeeringRequest.new
              #
              #   # Call the establish_peering method.
              #   result = client.establish_peering request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def establish_peering request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::EstablishPeeringRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.establish_peering.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.establish_peering.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.establish_peering.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.establish_peering request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Syncs the replication. This will invoke one time volume data transfer from
              # source to destination.
              #
              # @overload sync_replication(request, options = nil)
              #   Pass arguments to `sync_replication` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::SyncReplicationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::SyncReplicationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload sync_replication(name: nil)
              #   Pass arguments to `sync_replication` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the replication, in the format of
              #     projects/\\{project_id}/locations/\\{location}/volumes/\\{volume_id}/replications/\\{replication_id}.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::SyncReplicationRequest.new
              #
              #   # Call the sync_replication method.
              #   result = client.sync_replication request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def sync_replication request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::SyncReplicationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.sync_replication.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.sync_replication.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.sync_replication.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.sync_replication request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates new backup vault
              #
              # @overload create_backup_vault(request, options = nil)
              #   Pass arguments to `create_backup_vault` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateBackupVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateBackupVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_backup_vault(parent: nil, backup_vault_id: nil, backup_vault: nil)
              #   Pass arguments to `create_backup_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location to create the backup vaults, in the format
              #     `projects/{project_id}/locations/{location}`
              #   @param backup_vault_id [::String]
              #     Required. The ID to use for the backupVault.
              #     The ID must be unique within the specified location.
              #     Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              #   @param backup_vault [::Google::Cloud::NetApp::V1::BackupVault, ::Hash]
              #     Required. A backupVault resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateBackupVaultRequest.new
              #
              #   # Call the create_backup_vault method.
              #   result = client.create_backup_vault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateBackupVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_backup_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_backup_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_backup_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_backup_vault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the description of the specified backup vault
              #
              # @overload get_backup_vault(request, options = nil)
              #   Pass arguments to `get_backup_vault` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetBackupVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetBackupVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_backup_vault(name: nil)
              #   Pass arguments to `get_backup_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backupVault resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::BackupVault]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::BackupVault]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetBackupVaultRequest.new
              #
              #   # Call the get_backup_vault method.
              #   result = client.get_backup_vault request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::BackupVault.
              #   p result
              #
              def get_backup_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetBackupVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_backup_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_backup_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_backup_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_backup_vault request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns list of all available backup vaults.
              #
              # @overload list_backup_vaults(request, options = nil)
              #   Pass arguments to `list_backup_vaults` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListBackupVaultsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListBackupVaultsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_backup_vaults(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_backup_vaults` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location for which to retrieve backupVault information,
              #     in the format
              #     `projects/{project_id}/locations/{location}`.
              #   @param page_size [::Integer]
              #     The maximum number of items to return.
              #   @param page_token [::String]
              #     The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
              #   @param filter [::String]
              #     List filter.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::BackupVault>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::BackupVault>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListBackupVaultsRequest.new
              #
              #   # Call the list_backup_vaults method.
              #   result = client.list_backup_vaults request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::BackupVault.
              #     p item
              #   end
              #
              def list_backup_vaults request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListBackupVaultsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_backup_vaults.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_backup_vaults.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_backup_vaults.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_backup_vaults request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_backup_vaults, "backup_vaults", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the settings of a specific backup vault.
              #
              # @overload update_backup_vault(request, options = nil)
              #   Pass arguments to `update_backup_vault` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_backup_vault(update_mask: nil, backup_vault: nil)
              #   Pass arguments to `update_backup_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Backup resource to be updated.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param backup_vault [::Google::Cloud::NetApp::V1::BackupVault, ::Hash]
              #     Required. The backupVault being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateBackupVaultRequest.new
              #
              #   # Call the update_backup_vault method.
              #   result = client.update_backup_vault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_backup_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateBackupVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_backup_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_backup_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_backup_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_backup_vault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Warning! This operation will permanently delete the backup vault.
              #
              # @overload delete_backup_vault(request, options = nil)
              #   Pass arguments to `delete_backup_vault` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_backup_vault(name: nil)
              #   Pass arguments to `delete_backup_vault` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backupVault resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteBackupVaultRequest.new
              #
              #   # Call the delete_backup_vault method.
              #   result = client.delete_backup_vault request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup_vault request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteBackupVaultRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_backup_vault.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_backup_vault.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_backup_vault.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_backup_vault request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a backup from the volume specified in the request
              # The backup can be created from the given snapshot if specified in the
              # request. If no snapshot specified, there'll be a new snapshot taken to
              # initiate the backup creation.
              #
              # @overload create_backup(request, options = nil)
              #   Pass arguments to `create_backup` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_backup(parent: nil, backup_id: nil, backup: nil)
              #   Pass arguments to `create_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The NetApp backupVault to create the backups of, in the format
              #     `projects/*/locations/*/backupVaults/{backup_vault_id}`
              #   @param backup_id [::String]
              #     Required. The ID to use for the backup.
              #     The ID must be unique within the specified backupVault.
              #     Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              #   @param backup [::Google::Cloud::NetApp::V1::Backup, ::Hash]
              #     Required. A backup resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateBackupRequest.new
              #
              #   # Call the create_backup method.
              #   result = client.create_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the description of the specified backup
              #
              # @overload get_backup(request, options = nil)
              #   Pass arguments to `get_backup` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_backup(name: nil)
              #   Pass arguments to `get_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backup resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::Backup]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::Backup]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetBackupRequest.new
              #
              #   # Call the get_backup method.
              #   result = client.get_backup request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::Backup.
              #   p result
              #
              def get_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_backup request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns descriptions of all backups for a backupVault.
              #
              # @overload list_backups(request, options = nil)
              #   Pass arguments to `list_backups` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListBackupsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListBackupsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_backups(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_backups` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The backupVault for which to retrieve backup information,
              #     in the format
              #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}`.
              #     To retrieve backup information for all locations, use "-" for the
              #     `{location}` value.
              #     To retrieve backup information for all backupVaults, use "-" for the
              #     `{backup_vault_id}` value.
              #     To retrieve backup information for a volume, use "-" for the
              #     `{backup_vault_id}` value and specify volume full name with the filter.
              #   @param page_size [::Integer]
              #     The maximum number of items to return. The service may return fewer
              #     than this value. The maximum value
              #     is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     The next_page_token value to use if there are additional
              #     results to retrieve for this list request.
              #   @param order_by [::String]
              #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
              #   @param filter [::String]
              #     The standard list filter.
              #     If specified, backups will be returned based on the attribute name that
              #     matches the filter expression. If empty, then no backups are filtered out.
              #     See https://google.aip.dev/160
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Backup>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::Backup>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListBackupsRequest.new
              #
              #   # Call the list_backups method.
              #   result = client.list_backups request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::Backup.
              #     p item
              #   end
              #
              def list_backups request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListBackupsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_backups.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_backups.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_backups request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_backups, "backups", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Warning! This operation will permanently delete the backup.
              #
              # @overload delete_backup(request, options = nil)
              #   Pass arguments to `delete_backup` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_backup(name: nil)
              #   Pass arguments to `delete_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backup resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupVaults/{backup_vault_id}/backups/{backup_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteBackupRequest.new
              #
              #   # Call the delete_backup method.
              #   result = client.delete_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update backup with full spec.
              #
              # @overload update_backup(request, options = nil)
              #   Pass arguments to `update_backup` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateBackupRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateBackupRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_backup(update_mask: nil, backup: nil)
              #   Pass arguments to `update_backup` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Backup resource to be updated.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param backup [::Google::Cloud::NetApp::V1::Backup, ::Hash]
              #     Required. The backup being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateBackupRequest.new
              #
              #   # Call the update_backup method.
              #   result = client.update_backup request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_backup request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateBackupRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_backup.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_backup.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_backup request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates new backup policy
              #
              # @overload create_backup_policy(request, options = nil)
              #   Pass arguments to `create_backup_policy` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_backup_policy(parent: nil, backup_policy: nil, backup_policy_id: nil)
              #   Pass arguments to `create_backup_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The location to create the backup policies of, in the format
              #     `projects/{project_id}/locations/{location}`
              #   @param backup_policy [::Google::Cloud::NetApp::V1::BackupPolicy, ::Hash]
              #     Required. A backupPolicy resource
              #   @param backup_policy_id [::String]
              #     Required. The ID to use for the backup policy.
              #     The ID must be unique within the specified location.
              #     Must contain only letters, numbers and hyphen, with the first
              #     character a letter, the last a letter or a
              #     number, and a 63 character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateBackupPolicyRequest.new
              #
              #   # Call the create_backup_policy method.
              #   result = client.create_backup_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_backup_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateBackupPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_backup_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_backup_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_backup_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_backup_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the description of the specified backup policy by backup_policy_id.
              #
              # @overload get_backup_policy(request, options = nil)
              #   Pass arguments to `get_backup_policy` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetBackupPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetBackupPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_backup_policy(name: nil)
              #   Pass arguments to `get_backup_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backupPolicy resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::BackupPolicy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::BackupPolicy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetBackupPolicyRequest.new
              #
              #   # Call the get_backup_policy method.
              #   result = client.get_backup_policy request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::BackupPolicy.
              #   p result
              #
              def get_backup_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetBackupPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_backup_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_backup_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_backup_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_backup_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns list of all available backup policies.
              #
              # @overload list_backup_policies(request, options = nil)
              #   Pass arguments to `list_backup_policies` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_backup_policies(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_backup_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListBackupPoliciesRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::BackupPolicy>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::BackupPolicy>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListBackupPoliciesRequest.new
              #
              #   # Call the list_backup_policies method.
              #   result = client.list_backup_policies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::BackupPolicy.
              #     p item
              #   end
              #
              def list_backup_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListBackupPoliciesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_backup_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_backup_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_backup_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_backup_policies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_backup_policies, "backup_policies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates settings of a specific backup policy.
              #
              # @overload update_backup_policy(request, options = nil)
              #   Pass arguments to `update_backup_policy` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_backup_policy(update_mask: nil, backup_policy: nil)
              #   Pass arguments to `update_backup_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Backup Policy resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param backup_policy [::Google::Cloud::NetApp::V1::BackupPolicy, ::Hash]
              #     Required. The backup policy being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest.new
              #
              #   # Call the update_backup_policy method.
              #   result = client.update_backup_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_backup_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateBackupPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_backup_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_backup_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_backup_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_backup_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Warning! This operation will permanently delete the backup policy.
              #
              # @overload delete_backup_policy(request, options = nil)
              #   Pass arguments to `delete_backup_policy` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_backup_policy(name: nil)
              #   Pass arguments to `delete_backup_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The backup policy resource name, in the format
              #     `projects/{project_id}/locations/{location}/backupPolicies/{backup_policy_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest.new
              #
              #   # Call the delete_backup_policy method.
              #   result = client.delete_backup_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_backup_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteBackupPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_backup_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_backup_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_backup_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_backup_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns list of all quota rules in a location.
              #
              # @overload list_quota_rules(request, options = nil)
              #   Pass arguments to `list_quota_rules` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::ListQuotaRulesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::ListQuotaRulesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_quota_rules(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_quota_rules` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListQuotaRulesRequest
              #   @param page_size [::Integer]
              #     Optional. Requested page size. Server may return fewer items than
              #     requested. If unspecified, the server will pick an appropriate default.
              #   @param page_token [::String]
              #     Optional. A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Optional. Filtering results
              #   @param order_by [::String]
              #     Optional. Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::QuotaRule>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::NetApp::V1::QuotaRule>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::ListQuotaRulesRequest.new
              #
              #   # Call the list_quota_rules method.
              #   result = client.list_quota_rules request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::NetApp::V1::QuotaRule.
              #     p item
              #   end
              #
              def list_quota_rules request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::ListQuotaRulesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_quota_rules.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_quota_rules.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_quota_rules.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.list_quota_rules request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @net_app_stub, :list_quota_rules, "quota_rules", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns details of the specified quota rule.
              #
              # @overload get_quota_rule(request, options = nil)
              #   Pass arguments to `get_quota_rule` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::GetQuotaRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::GetQuotaRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_quota_rule(name: nil)
              #   Pass arguments to `get_quota_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the quota rule
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::NetApp::V1::QuotaRule]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::NetApp::V1::QuotaRule]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::GetQuotaRuleRequest.new
              #
              #   # Call the get_quota_rule method.
              #   result = client.get_quota_rule request
              #
              #   # The returned object is of type Google::Cloud::NetApp::V1::QuotaRule.
              #   p result
              #
              def get_quota_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::GetQuotaRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_quota_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_quota_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_quota_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.get_quota_rule request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new quota rule.
              #
              # @overload create_quota_rule(request, options = nil)
              #   Pass arguments to `create_quota_rule` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_quota_rule(parent: nil, quota_rule: nil, quota_rule_id: nil)
              #   Pass arguments to `create_quota_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for CreateQuotaRuleRequest
              #   @param quota_rule [::Google::Cloud::NetApp::V1::QuotaRule, ::Hash]
              #     Required. Fields of the to be created quota rule.
              #   @param quota_rule_id [::String]
              #     Required. ID of the quota rule to create. Must be unique within the parent
              #     resource. Must contain only letters, numbers, underscore and hyphen, with
              #     the first character a letter or underscore, the last a letter or underscore
              #     or a number, and a 63 character maximum.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::CreateQuotaRuleRequest.new
              #
              #   # Call the create_quota_rule method.
              #   result = client.create_quota_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_quota_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::CreateQuotaRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_quota_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_quota_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_quota_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.create_quota_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a quota rule.
              #
              # @overload update_quota_rule(request, options = nil)
              #   Pass arguments to `update_quota_rule` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_quota_rule(update_mask: nil, quota_rule: nil)
              #   Pass arguments to `update_quota_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     Quota Rule resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param quota_rule [::Google::Cloud::NetApp::V1::QuotaRule, ::Hash]
              #     Required. The quota rule being updated
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest.new
              #
              #   # Call the update_quota_rule method.
              #   result = client.update_quota_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_quota_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::UpdateQuotaRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_quota_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_quota_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_quota_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.update_quota_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a quota rule.
              #
              # @overload delete_quota_rule(request, options = nil)
              #   Pass arguments to `delete_quota_rule` via a request object, either of type
              #   {::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_quota_rule(name: nil)
              #   Pass arguments to `delete_quota_rule` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the quota rule.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/netapp/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::NetApp::V1::NetApp::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest.new
              #
              #   # Call the delete_quota_rule method.
              #   result = client.delete_quota_rule request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_quota_rule request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::NetApp::V1::DeleteQuotaRuleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_quota_rule.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::NetApp::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_quota_rule.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_quota_rule.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @net_app_stub.delete_quota_rule request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the NetApp REST API.
              #
              # This class represents the configuration for NetApp REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::NetApp::V1::NetApp::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_storage_pools to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_storage_pools.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::NetApp::V1::NetApp::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_storage_pools.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "netapp.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the NetApp API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_storage_pools`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_storage_pools
                  ##
                  # RPC-specific configuration for `create_storage_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_storage_pool
                  ##
                  # RPC-specific configuration for `get_storage_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_storage_pool
                  ##
                  # RPC-specific configuration for `update_storage_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_storage_pool
                  ##
                  # RPC-specific configuration for `delete_storage_pool`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_storage_pool
                  ##
                  # RPC-specific configuration for `validate_directory_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :validate_directory_service
                  ##
                  # RPC-specific configuration for `switch_active_replica_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :switch_active_replica_zone
                  ##
                  # RPC-specific configuration for `list_volumes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_volumes
                  ##
                  # RPC-specific configuration for `get_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_volume
                  ##
                  # RPC-specific configuration for `create_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_volume
                  ##
                  # RPC-specific configuration for `update_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_volume
                  ##
                  # RPC-specific configuration for `delete_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_volume
                  ##
                  # RPC-specific configuration for `revert_volume`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :revert_volume
                  ##
                  # RPC-specific configuration for `list_snapshots`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_snapshots
                  ##
                  # RPC-specific configuration for `get_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_snapshot
                  ##
                  # RPC-specific configuration for `create_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_snapshot
                  ##
                  # RPC-specific configuration for `delete_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_snapshot
                  ##
                  # RPC-specific configuration for `update_snapshot`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_snapshot
                  ##
                  # RPC-specific configuration for `list_active_directories`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_active_directories
                  ##
                  # RPC-specific configuration for `get_active_directory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_active_directory
                  ##
                  # RPC-specific configuration for `create_active_directory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_active_directory
                  ##
                  # RPC-specific configuration for `update_active_directory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_active_directory
                  ##
                  # RPC-specific configuration for `delete_active_directory`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_active_directory
                  ##
                  # RPC-specific configuration for `list_kms_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_kms_configs
                  ##
                  # RPC-specific configuration for `create_kms_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_kms_config
                  ##
                  # RPC-specific configuration for `get_kms_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_kms_config
                  ##
                  # RPC-specific configuration for `update_kms_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_kms_config
                  ##
                  # RPC-specific configuration for `encrypt_volumes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :encrypt_volumes
                  ##
                  # RPC-specific configuration for `verify_kms_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :verify_kms_config
                  ##
                  # RPC-specific configuration for `delete_kms_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_kms_config
                  ##
                  # RPC-specific configuration for `list_replications`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_replications
                  ##
                  # RPC-specific configuration for `get_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_replication
                  ##
                  # RPC-specific configuration for `create_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_replication
                  ##
                  # RPC-specific configuration for `delete_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_replication
                  ##
                  # RPC-specific configuration for `update_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_replication
                  ##
                  # RPC-specific configuration for `stop_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_replication
                  ##
                  # RPC-specific configuration for `resume_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :resume_replication
                  ##
                  # RPC-specific configuration for `reverse_replication_direction`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reverse_replication_direction
                  ##
                  # RPC-specific configuration for `establish_peering`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :establish_peering
                  ##
                  # RPC-specific configuration for `sync_replication`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :sync_replication
                  ##
                  # RPC-specific configuration for `create_backup_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup_vault
                  ##
                  # RPC-specific configuration for `get_backup_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup_vault
                  ##
                  # RPC-specific configuration for `list_backup_vaults`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backup_vaults
                  ##
                  # RPC-specific configuration for `update_backup_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_backup_vault
                  ##
                  # RPC-specific configuration for `delete_backup_vault`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup_vault
                  ##
                  # RPC-specific configuration for `create_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup
                  ##
                  # RPC-specific configuration for `get_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup
                  ##
                  # RPC-specific configuration for `list_backups`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backups
                  ##
                  # RPC-specific configuration for `delete_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup
                  ##
                  # RPC-specific configuration for `update_backup`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_backup
                  ##
                  # RPC-specific configuration for `create_backup_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_backup_policy
                  ##
                  # RPC-specific configuration for `get_backup_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_backup_policy
                  ##
                  # RPC-specific configuration for `list_backup_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_backup_policies
                  ##
                  # RPC-specific configuration for `update_backup_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_backup_policy
                  ##
                  # RPC-specific configuration for `delete_backup_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_backup_policy
                  ##
                  # RPC-specific configuration for `list_quota_rules`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_quota_rules
                  ##
                  # RPC-specific configuration for `get_quota_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_quota_rule
                  ##
                  # RPC-specific configuration for `create_quota_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_quota_rule
                  ##
                  # RPC-specific configuration for `update_quota_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_quota_rule
                  ##
                  # RPC-specific configuration for `delete_quota_rule`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_quota_rule

                  # @private
                  def initialize parent_rpcs = nil
                    list_storage_pools_config = parent_rpcs.list_storage_pools if parent_rpcs.respond_to? :list_storage_pools
                    @list_storage_pools = ::Gapic::Config::Method.new list_storage_pools_config
                    create_storage_pool_config = parent_rpcs.create_storage_pool if parent_rpcs.respond_to? :create_storage_pool
                    @create_storage_pool = ::Gapic::Config::Method.new create_storage_pool_config
                    get_storage_pool_config = parent_rpcs.get_storage_pool if parent_rpcs.respond_to? :get_storage_pool
                    @get_storage_pool = ::Gapic::Config::Method.new get_storage_pool_config
                    update_storage_pool_config = parent_rpcs.update_storage_pool if parent_rpcs.respond_to? :update_storage_pool
                    @update_storage_pool = ::Gapic::Config::Method.new update_storage_pool_config
                    delete_storage_pool_config = parent_rpcs.delete_storage_pool if parent_rpcs.respond_to? :delete_storage_pool
                    @delete_storage_pool = ::Gapic::Config::Method.new delete_storage_pool_config
                    validate_directory_service_config = parent_rpcs.validate_directory_service if parent_rpcs.respond_to? :validate_directory_service
                    @validate_directory_service = ::Gapic::Config::Method.new validate_directory_service_config
                    switch_active_replica_zone_config = parent_rpcs.switch_active_replica_zone if parent_rpcs.respond_to? :switch_active_replica_zone
                    @switch_active_replica_zone = ::Gapic::Config::Method.new switch_active_replica_zone_config
                    list_volumes_config = parent_rpcs.list_volumes if parent_rpcs.respond_to? :list_volumes
                    @list_volumes = ::Gapic::Config::Method.new list_volumes_config
                    get_volume_config = parent_rpcs.get_volume if parent_rpcs.respond_to? :get_volume
                    @get_volume = ::Gapic::Config::Method.new get_volume_config
                    create_volume_config = parent_rpcs.create_volume if parent_rpcs.respond_to? :create_volume
                    @create_volume = ::Gapic::Config::Method.new create_volume_config
                    update_volume_config = parent_rpcs.update_volume if parent_rpcs.respond_to? :update_volume
                    @update_volume = ::Gapic::Config::Method.new update_volume_config
                    delete_volume_config = parent_rpcs.delete_volume if parent_rpcs.respond_to? :delete_volume
                    @delete_volume = ::Gapic::Config::Method.new delete_volume_config
                    revert_volume_config = parent_rpcs.revert_volume if parent_rpcs.respond_to? :revert_volume
                    @revert_volume = ::Gapic::Config::Method.new revert_volume_config
                    list_snapshots_config = parent_rpcs.list_snapshots if parent_rpcs.respond_to? :list_snapshots
                    @list_snapshots = ::Gapic::Config::Method.new list_snapshots_config
                    get_snapshot_config = parent_rpcs.get_snapshot if parent_rpcs.respond_to? :get_snapshot
                    @get_snapshot = ::Gapic::Config::Method.new get_snapshot_config
                    create_snapshot_config = parent_rpcs.create_snapshot if parent_rpcs.respond_to? :create_snapshot
                    @create_snapshot = ::Gapic::Config::Method.new create_snapshot_config
                    delete_snapshot_config = parent_rpcs.delete_snapshot if parent_rpcs.respond_to? :delete_snapshot
                    @delete_snapshot = ::Gapic::Config::Method.new delete_snapshot_config
                    update_snapshot_config = parent_rpcs.update_snapshot if parent_rpcs.respond_to? :update_snapshot
                    @update_snapshot = ::Gapic::Config::Method.new update_snapshot_config
                    list_active_directories_config = parent_rpcs.list_active_directories if parent_rpcs.respond_to? :list_active_directories
                    @list_active_directories = ::Gapic::Config::Method.new list_active_directories_config
                    get_active_directory_config = parent_rpcs.get_active_directory if parent_rpcs.respond_to? :get_active_directory
                    @get_active_directory = ::Gapic::Config::Method.new get_active_directory_config
                    create_active_directory_config = parent_rpcs.create_active_directory if parent_rpcs.respond_to? :create_active_directory
                    @create_active_directory = ::Gapic::Config::Method.new create_active_directory_config
                    update_active_directory_config = parent_rpcs.update_active_directory if parent_rpcs.respond_to? :update_active_directory
                    @update_active_directory = ::Gapic::Config::Method.new update_active_directory_config
                    delete_active_directory_config = parent_rpcs.delete_active_directory if parent_rpcs.respond_to? :delete_active_directory
                    @delete_active_directory = ::Gapic::Config::Method.new delete_active_directory_config
                    list_kms_configs_config = parent_rpcs.list_kms_configs if parent_rpcs.respond_to? :list_kms_configs
                    @list_kms_configs = ::Gapic::Config::Method.new list_kms_configs_config
                    create_kms_config_config = parent_rpcs.create_kms_config if parent_rpcs.respond_to? :create_kms_config
                    @create_kms_config = ::Gapic::Config::Method.new create_kms_config_config
                    get_kms_config_config = parent_rpcs.get_kms_config if parent_rpcs.respond_to? :get_kms_config
                    @get_kms_config = ::Gapic::Config::Method.new get_kms_config_config
                    update_kms_config_config = parent_rpcs.update_kms_config if parent_rpcs.respond_to? :update_kms_config
                    @update_kms_config = ::Gapic::Config::Method.new update_kms_config_config
                    encrypt_volumes_config = parent_rpcs.encrypt_volumes if parent_rpcs.respond_to? :encrypt_volumes
                    @encrypt_volumes = ::Gapic::Config::Method.new encrypt_volumes_config
                    verify_kms_config_config = parent_rpcs.verify_kms_config if parent_rpcs.respond_to? :verify_kms_config
                    @verify_kms_config = ::Gapic::Config::Method.new verify_kms_config_config
                    delete_kms_config_config = parent_rpcs.delete_kms_config if parent_rpcs.respond_to? :delete_kms_config
                    @delete_kms_config = ::Gapic::Config::Method.new delete_kms_config_config
                    list_replications_config = parent_rpcs.list_replications if parent_rpcs.respond_to? :list_replications
                    @list_replications = ::Gapic::Config::Method.new list_replications_config
                    get_replication_config = parent_rpcs.get_replication if parent_rpcs.respond_to? :get_replication
                    @get_replication = ::Gapic::Config::Method.new get_replication_config
                    create_replication_config = parent_rpcs.create_replication if parent_rpcs.respond_to? :create_replication
                    @create_replication = ::Gapic::Config::Method.new create_replication_config
                    delete_replication_config = parent_rpcs.delete_replication if parent_rpcs.respond_to? :delete_replication
                    @delete_replication = ::Gapic::Config::Method.new delete_replication_config
                    update_replication_config = parent_rpcs.update_replication if parent_rpcs.respond_to? :update_replication
                    @update_replication = ::Gapic::Config::Method.new update_replication_config
                    stop_replication_config = parent_rpcs.stop_replication if parent_rpcs.respond_to? :stop_replication
                    @stop_replication = ::Gapic::Config::Method.new stop_replication_config
                    resume_replication_config = parent_rpcs.resume_replication if parent_rpcs.respond_to? :resume_replication
                    @resume_replication = ::Gapic::Config::Method.new resume_replication_config
                    reverse_replication_direction_config = parent_rpcs.reverse_replication_direction if parent_rpcs.respond_to? :reverse_replication_direction
                    @reverse_replication_direction = ::Gapic::Config::Method.new reverse_replication_direction_config
                    establish_peering_config = parent_rpcs.establish_peering if parent_rpcs.respond_to? :establish_peering
                    @establish_peering = ::Gapic::Config::Method.new establish_peering_config
                    sync_replication_config = parent_rpcs.sync_replication if parent_rpcs.respond_to? :sync_replication
                    @sync_replication = ::Gapic::Config::Method.new sync_replication_config
                    create_backup_vault_config = parent_rpcs.create_backup_vault if parent_rpcs.respond_to? :create_backup_vault
                    @create_backup_vault = ::Gapic::Config::Method.new create_backup_vault_config
                    get_backup_vault_config = parent_rpcs.get_backup_vault if parent_rpcs.respond_to? :get_backup_vault
                    @get_backup_vault = ::Gapic::Config::Method.new get_backup_vault_config
                    list_backup_vaults_config = parent_rpcs.list_backup_vaults if parent_rpcs.respond_to? :list_backup_vaults
                    @list_backup_vaults = ::Gapic::Config::Method.new list_backup_vaults_config
                    update_backup_vault_config = parent_rpcs.update_backup_vault if parent_rpcs.respond_to? :update_backup_vault
                    @update_backup_vault = ::Gapic::Config::Method.new update_backup_vault_config
                    delete_backup_vault_config = parent_rpcs.delete_backup_vault if parent_rpcs.respond_to? :delete_backup_vault
                    @delete_backup_vault = ::Gapic::Config::Method.new delete_backup_vault_config
                    create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                    @create_backup = ::Gapic::Config::Method.new create_backup_config
                    get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                    @get_backup = ::Gapic::Config::Method.new get_backup_config
                    list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                    @list_backups = ::Gapic::Config::Method.new list_backups_config
                    delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                    @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                    update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                    @update_backup = ::Gapic::Config::Method.new update_backup_config
                    create_backup_policy_config = parent_rpcs.create_backup_policy if parent_rpcs.respond_to? :create_backup_policy
                    @create_backup_policy = ::Gapic::Config::Method.new create_backup_policy_config
                    get_backup_policy_config = parent_rpcs.get_backup_policy if parent_rpcs.respond_to? :get_backup_policy
                    @get_backup_policy = ::Gapic::Config::Method.new get_backup_policy_config
                    list_backup_policies_config = parent_rpcs.list_backup_policies if parent_rpcs.respond_to? :list_backup_policies
                    @list_backup_policies = ::Gapic::Config::Method.new list_backup_policies_config
                    update_backup_policy_config = parent_rpcs.update_backup_policy if parent_rpcs.respond_to? :update_backup_policy
                    @update_backup_policy = ::Gapic::Config::Method.new update_backup_policy_config
                    delete_backup_policy_config = parent_rpcs.delete_backup_policy if parent_rpcs.respond_to? :delete_backup_policy
                    @delete_backup_policy = ::Gapic::Config::Method.new delete_backup_policy_config
                    list_quota_rules_config = parent_rpcs.list_quota_rules if parent_rpcs.respond_to? :list_quota_rules
                    @list_quota_rules = ::Gapic::Config::Method.new list_quota_rules_config
                    get_quota_rule_config = parent_rpcs.get_quota_rule if parent_rpcs.respond_to? :get_quota_rule
                    @get_quota_rule = ::Gapic::Config::Method.new get_quota_rule_config
                    create_quota_rule_config = parent_rpcs.create_quota_rule if parent_rpcs.respond_to? :create_quota_rule
                    @create_quota_rule = ::Gapic::Config::Method.new create_quota_rule_config
                    update_quota_rule_config = parent_rpcs.update_quota_rule if parent_rpcs.respond_to? :update_quota_rule
                    @update_quota_rule = ::Gapic::Config::Method.new update_quota_rule_config
                    delete_quota_rule_config = parent_rpcs.delete_quota_rule if parent_rpcs.respond_to? :delete_quota_rule
                    @delete_quota_rule = ::Gapic::Config::Method.new delete_quota_rule_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
