# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module NetApp
      module V1
        module NetApp
          # Path helper methods for the NetApp API.
          module Paths
            ##
            # Create a fully-qualified ActiveDirectory resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/activeDirectories/{active_directory}`
            #
            # @param project [String]
            # @param location [String]
            # @param active_directory [String]
            #
            # @return [::String]
            def active_directory_path project:, location:, active_directory:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/activeDirectories/#{active_directory}"
            end

            ##
            # Create a fully-qualified Backup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupVaults/{backup_vault}/backups/{backup}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_vault [String]
            # @param backup [String]
            #
            # @return [::String]
            def backup_path project:, location:, backup_vault:, backup:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "backup_vault cannot contain /" if backup_vault.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupVaults/#{backup_vault}/backups/#{backup}"
            end

            ##
            # Create a fully-qualified BackupPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupPolicies/{backup_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_policy [String]
            #
            # @return [::String]
            def backup_policy_path project:, location:, backup_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupPolicies/#{backup_policy}"
            end

            ##
            # Create a fully-qualified BackupVault resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/backupVaults/{backup_vault}`
            #
            # @param project [String]
            # @param location [String]
            # @param backup_vault [String]
            #
            # @return [::String]
            def backup_vault_path project:, location:, backup_vault:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/backupVaults/#{backup_vault}"
            end

            ##
            # Create a fully-qualified KmsConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/kmsConfigs/{kms_config}`
            #
            # @param project [String]
            # @param location [String]
            # @param kms_config [String]
            #
            # @return [::String]
            def kms_config_path project:, location:, kms_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/kmsConfigs/#{kms_config}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified QuotaRule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}/quotaRules/{quota_rule}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            # @param quota_rule [String]
            #
            # @return [::String]
            def quota_rule_path project:, location:, volume:, quota_rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "volume cannot contain /" if volume.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}/quotaRules/#{quota_rule}"
            end

            ##
            # Create a fully-qualified Replication resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}/replications/{replication}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            # @param replication [String]
            #
            # @return [::String]
            def replication_path project:, location:, volume:, replication:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "volume cannot contain /" if volume.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}/replications/#{replication}"
            end

            ##
            # Create a fully-qualified Snapshot resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            # @param snapshot [String]
            #
            # @return [::String]
            def snapshot_path project:, location:, volume:, snapshot:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "volume cannot contain /" if volume.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}/snapshots/#{snapshot}"
            end

            ##
            # Create a fully-qualified StoragePool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/storagePools/{storage_pool}`
            #
            # @param project [String]
            # @param location [String]
            # @param storage_pool [String]
            #
            # @return [::String]
            def storage_pool_path project:, location:, storage_pool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/storagePools/#{storage_pool}"
            end

            ##
            # Create a fully-qualified Volume resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/volumes/{volume}`
            #
            # @param project [String]
            # @param location [String]
            # @param volume [String]
            #
            # @return [::String]
            def volume_path project:, location:, volume:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/volumes/#{volume}"
            end

            extend self
          end
        end
      end
    end
  end
end
