# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/monitoring/v3/snooze_service_pb"
require "google/cloud/monitoring/v3/snooze_service"

class ::Google::Cloud::Monitoring::V3::SnoozeService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_snooze
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::Snooze.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    snooze = {}

    create_snooze_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_snooze, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::CreateSnoozeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Monitoring::V3::Snooze), request["snooze"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_snooze_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_snooze({ parent: parent, snooze: snooze }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_snooze parent: parent, snooze: snooze do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_snooze ::Google::Cloud::Monitoring::V3::CreateSnoozeRequest.new(parent: parent, snooze: snooze) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_snooze({ parent: parent, snooze: snooze }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_snooze(::Google::Cloud::Monitoring::V3::CreateSnoozeRequest.new(parent: parent, snooze: snooze), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_snooze_client_stub.call_rpc_count
    end
  end

  def test_list_snoozes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::ListSnoozesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"

    list_snoozes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_snoozes, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::ListSnoozesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_snoozes_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_snoozes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_snoozes parent: parent, filter: filter, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_snoozes ::Google::Cloud::Monitoring::V3::ListSnoozesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_snoozes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_snoozes(::Google::Cloud::Monitoring::V3::ListSnoozesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_snoozes_client_stub.call_rpc_count
    end
  end

  def test_get_snooze
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::Snooze.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_snooze_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_snooze, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::GetSnoozeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_snooze_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_snooze({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_snooze name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_snooze ::Google::Cloud::Monitoring::V3::GetSnoozeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_snooze({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_snooze(::Google::Cloud::Monitoring::V3::GetSnoozeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_snooze_client_stub.call_rpc_count
    end
  end

  def test_update_snooze
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::Snooze.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    snooze = {}
    update_mask = {}

    update_snooze_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_snooze, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::UpdateSnoozeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Monitoring::V3::Snooze), request["snooze"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_snooze_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_snooze({ snooze: snooze, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_snooze snooze: snooze, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_snooze ::Google::Cloud::Monitoring::V3::UpdateSnoozeRequest.new(snooze: snooze, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_snooze({ snooze: snooze, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_snooze(::Google::Cloud::Monitoring::V3::UpdateSnoozeRequest.new(snooze: snooze, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_snooze_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Monitoring::V3::SnoozeService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Monitoring::V3::SnoozeService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
