# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/monitoring/v3/snooze_service"

class ::Google::Cloud::Monitoring::V3::SnoozeService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_alert_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.alert_policy_path project: "value0", alert_policy: "value1"
      assert_equal "projects/value0/alertPolicies/value1", path

      path = client.alert_policy_path organization: "value0", alert_policy: "value1"
      assert_equal "organizations/value0/alertPolicies/value1", path

      path = client.alert_policy_path folder: "value0", alert_policy: "value1"
      assert_equal "folders/value0/alertPolicies/value1", path
    end
  end

  def test_project_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.project_path project: "value0"
      assert_equal "projects/value0", path
    end
  end

  def test_snooze_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.snooze_path project: "value0", snooze: "value1"
      assert_equal "projects/value0/snoozes/value1", path
    end
  end

  def test_workspace_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Monitoring::V3::SnoozeService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workspace_path project: "value0"
      assert_equal "projects/value0", path

      path = client.workspace_path workspace: "value0"
      assert_equal "workspaces/value0", path
    end
  end
end
