# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/monitoring/v3/alert_service_pb"
require "google/cloud/monitoring/v3/alert_policy_service"

class ::Google::Cloud::Monitoring::V3::AlertPolicyService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_alert_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::ListAlertPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    filter = "hello world"
    order_by = "hello world"
    page_size = 42
    page_token = "hello world"

    list_alert_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_alert_policies, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_alert_policies_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_alert_policies({ name: name, filter: filter, order_by: order_by, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_alert_policies name: name, filter: filter, order_by: order_by, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_alert_policies ::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest.new(name: name, filter: filter, order_by: order_by, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_alert_policies({ name: name, filter: filter, order_by: order_by, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_alert_policies(::Google::Cloud::Monitoring::V3::ListAlertPoliciesRequest.new(name: name, filter: filter, order_by: order_by, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_alert_policies_client_stub.call_rpc_count
    end
  end

  def test_get_alert_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::AlertPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_alert_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_alert_policy, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_alert_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_alert_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_alert_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_alert_policy ::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_alert_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_alert_policy(::Google::Cloud::Monitoring::V3::GetAlertPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_alert_policy_client_stub.call_rpc_count
    end
  end

  def test_create_alert_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::AlertPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    alert_policy = {}

    create_alert_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_alert_policy, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Monitoring::V3::AlertPolicy), request["alert_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_alert_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_alert_policy({ name: name, alert_policy: alert_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_alert_policy name: name, alert_policy: alert_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_alert_policy ::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest.new(name: name, alert_policy: alert_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_alert_policy({ name: name, alert_policy: alert_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_alert_policy(::Google::Cloud::Monitoring::V3::CreateAlertPolicyRequest.new(name: name, alert_policy: alert_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_alert_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_alert_policy
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_alert_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_alert_policy, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_alert_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_alert_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_alert_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_alert_policy ::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_alert_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_alert_policy(::Google::Cloud::Monitoring::V3::DeleteAlertPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_alert_policy_client_stub.call_rpc_count
    end
  end

  def test_update_alert_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Monitoring::V3::AlertPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    alert_policy = {}

    update_alert_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_alert_policy, name
      assert_kind_of ::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Monitoring::V3::AlertPolicy), request["alert_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_alert_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_alert_policy({ update_mask: update_mask, alert_policy: alert_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_alert_policy update_mask: update_mask, alert_policy: alert_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_alert_policy ::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest.new(update_mask: update_mask, alert_policy: alert_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_alert_policy({ update_mask: update_mask, alert_policy: alert_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_alert_policy(::Google::Cloud::Monitoring::V3::UpdateAlertPolicyRequest.new(update_mask: update_mask, alert_policy: alert_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_alert_policy_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Monitoring::V3::AlertPolicyService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
