# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        # The message definition for creating a `Snooze`. Users must provide the body
        # of the `Snooze` to be created but must omit the `Snooze` field, `name`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The
        #     [project](https://cloud.google.com/monitoring/api/v3#project_name) in which
        #     a `Snooze` should be created. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]
        # @!attribute [rw] snooze
        #   @return [::Google::Cloud::Monitoring::V3::Snooze]
        #     Required. The `Snooze` to create. Omit the `name` field, as it will be
        #     filled in by the API.
        class CreateSnoozeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message definition for listing `Snooze`s associated with the given
        # `parent`, satisfying the optional `filter`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The
        #     [project](https://cloud.google.com/monitoring/api/v3#project_name) whose
        #     `Snooze`s should be listed. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Optional filter to restrict results to the given criteria. The
        #     following fields are supported.
        #
        #       * `interval.start_time`
        #       * `interval.end_time`
        #
        #     For example:
        #
        #         interval.start_time > "2022-03-11T00:00:00-08:00" AND
        #             interval.end_time < "2022-03-12T00:00:00-08:00"
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of results to return for a single query. The
        #     server may further constrain the maximum number of results returned in a
        #     single page. The value should be in the range [1, 1000]. If the value given
        #     is outside this range, the server will decide the number of results to be
        #     returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The `next_page_token` from a previous call to
        #     `ListSnoozesRequest` to get the next page of results.
        class ListSnoozesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The results of a successful `ListSnoozes` call, containing the matching
        # `Snooze`s.
        # @!attribute [rw] snoozes
        #   @return [::Array<::Google::Cloud::Monitoring::V3::Snooze>]
        #     `Snooze`s matching this list call.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Page token for repeated calls to `ListSnoozes`, to fetch additional pages
        #     of results. If this is empty or missing, there are no more pages.
        class ListSnoozesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message definition for retrieving a `Snooze`. Users must specify the
        # field, `name`, which identifies the `Snooze`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ID of the `Snooze` to retrieve. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
        class GetSnoozeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The message definition for updating a `Snooze`. The field, `snooze.name`
        # identifies the `Snooze` to be updated. The remainder of `snooze` gives the
        # content the `Snooze` in question will be assigned.
        #
        # What fields can be updated depends on the start time and end time of the
        # `Snooze`.
        #
        #   * end time is in the past: These `Snooze`s are considered
        #     read-only and cannot be updated.
        #   * start time is in the past and end time is in the future: `display_name`
        #     and `interval.end_time` can be updated.
        #   * start time is in the future: `display_name`, `interval.start_time` and
        #     `interval.end_time` can be updated.
        # @!attribute [rw] snooze
        #   @return [::Google::Cloud::Monitoring::V3::Snooze]
        #     Required. The `Snooze` to update. Must have the name field present.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The fields to update.
        #
        #     For each field listed in `update_mask`:
        #
        #       * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
        #         value for that field, the value of the field in the existing `Snooze`
        #         will be set to the value of the field in the supplied `Snooze`.
        #       * If the field does not have a value in the supplied `Snooze`, the field
        #         in the existing `Snooze` is set to its default value.
        #
        #     Fields not listed retain their existing value.
        #
        #     The following are the field names that are accepted in `update_mask`:
        #
        #       * `display_name`
        #       * `interval.start_time`
        #       * `interval.end_time`
        #
        #     That said, the start time and end time of the `Snooze` determines which
        #     fields can legally be updated. Before attempting an update, users should
        #     consult the documentation for `UpdateSnoozeRequest`, which talks about
        #     which fields can be updated.
        class UpdateSnoozeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
