# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        # The `CreateService` request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource
        #     [name](https://cloud.google.com/monitoring/api/v3#project_name) of the
        #     parent Metrics Scope. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]
        # @!attribute [rw] service_id
        #   @return [::String]
        #     Optional. The Service id to use for this Service. If omitted, an id will be
        #     generated instead. Must match the pattern `[a-z0-9\-]+`
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Monitoring::V3::Service]
        #     Required. The `Service` to create.
        class CreateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `GetService` request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the `Service`. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
        class GetServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ListServices` request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent containing the listed services,
        #     either a [project](https://cloud.google.com/monitoring/api/v3#project_name)
        #     or a Monitoring Metrics Scope. The formats are:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]
        #         workspaces/[HOST_PROJECT_ID_OR_NUMBER]
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter specifying what `Service`s to return. The filter supports
        #     filtering on a particular service-identifier type or one of its attributes.
        #
        #     To filter on a particular service-identifier type, the `identifier_case`
        #     refers to which option in the `identifier` field is populated. For example,
        #     the filter `identifier_case = "CUSTOM"` would match all services with a
        #     value for the `custom` field. Valid options include "CUSTOM", "APP_ENGINE",
        #     "MESH_ISTIO", and the other options listed at
        #     https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services#Service
        #
        #     To filter on an attribute of a service-identifier type, apply the filter
        #     name by using the snake case of the service-identifier type and the
        #     attribute of that service-identifier type, and join the two with a period.
        #     For example, to filter by the `meshUid` field of the `MeshIstio`
        #     service-identifier type, you must filter on `mesh_istio.mesh_uid =
        #     "123"` to match all services with mesh UID "123". Service-identifier types
        #     and their attributes are described at
        #     https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services#Service
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     A non-negative number that is the maximum number of results to return.
        #     When 0, use default page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     If this field is not empty then it must contain the `nextPageToken` value
        #     returned by a previous call to this method.  Using this field causes the
        #     method to return additional results from the previous method call.
        class ListServicesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ListServices` response.
        # @!attribute [rw] services
        #   @return [::Array<::Google::Cloud::Monitoring::V3::Service>]
        #     The `Service`s matching the specified filter.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there are more results than have been returned, then this field is set
        #     to a non-empty value.  To see the additional results,
        #     use that value as `page_token` in the next call to this method.
        class ListServicesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `UpdateService` request.
        # @!attribute [rw] service
        #   @return [::Google::Cloud::Monitoring::V3::Service]
        #     Required. The `Service` to draw updates from.
        #     The given `name` specifies the resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A set of field paths defining which fields to use for the update.
        class UpdateServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `DeleteService` request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the `Service` to delete. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
        class DeleteServiceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `CreateServiceLevelObjective` request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent `Service`. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
        # @!attribute [rw] service_level_objective_id
        #   @return [::String]
        #     Optional. The ServiceLevelObjective id to use for this
        #     ServiceLevelObjective. If omitted, an id will be generated instead. Must
        #     match the pattern `^[a-zA-Z0-9-_:.]+$`
        # @!attribute [rw] service_level_objective
        #   @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
        #     Required. The `ServiceLevelObjective` to create.
        #     The provided `name` will be respected if no `ServiceLevelObjective` exists
        #     with this name.
        class CreateServiceLevelObjectiveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `GetServiceLevelObjective` request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the `ServiceLevelObjective` to get. The format
        #     is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective::View]
        #     View of the `ServiceLevelObjective` to return. If `DEFAULT`, return the
        #     `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
        #     `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
        #     `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
        class GetServiceLevelObjectiveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ListServiceLevelObjectives` request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the parent containing the listed SLOs, either a
        #     project or a Monitoring Metrics Scope. The formats are:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
        #         workspaces/[HOST_PROJECT_ID_OR_NUMBER]/services/-
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter specifying what `ServiceLevelObjective`s to return.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     A non-negative number that is the maximum number of results to return.
        #     When 0, use default page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     If this field is not empty then it must contain the `nextPageToken` value
        #     returned by a previous call to this method.  Using this field causes the
        #     method to return additional results from the previous method call.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective::View]
        #     View of the `ServiceLevelObjective`s to return. If `DEFAULT`, return each
        #     `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
        #     `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
        #     `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
        class ListServiceLevelObjectivesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `ListServiceLevelObjectives` response.
        # @!attribute [rw] service_level_objectives
        #   @return [::Array<::Google::Cloud::Monitoring::V3::ServiceLevelObjective>]
        #     The `ServiceLevelObjective`s matching the specified filter.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If there are more results than have been returned, then this field is set
        #     to a non-empty value.  To see the additional results,
        #     use that value as `page_token` in the next call to this method.
        class ListServiceLevelObjectivesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `UpdateServiceLevelObjective` request.
        # @!attribute [rw] service_level_objective
        #   @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
        #     Required. The `ServiceLevelObjective` to draw updates from.
        #     The given `name` specifies the resource to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     A set of field paths defining which fields to use for the update.
        class UpdateServiceLevelObjectiveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `DeleteServiceLevelObjective` request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the `ServiceLevelObjective` to delete. The
        #     format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        class DeleteServiceLevelObjectiveRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
