# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        # A `Service` is a discrete, autonomous, and network-accessible unit, designed
        # to solve an individual concern
        # ([Wikipedia](https://en.wikipedia.org/wiki/Service-orientation)). In
        # Cloud Monitoring, a `Service` acts as the root resource under which
        # operational aspects of the service are accessible.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name for this Service. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Name used for UI elements listing this Service.
        # @!attribute [rw] custom
        #   @return [::Google::Cloud::Monitoring::V3::Service::Custom]
        #     Custom service type.
        #
        #     Note: The following fields are mutually exclusive: `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] app_engine
        #   @return [::Google::Cloud::Monitoring::V3::Service::AppEngine]
        #     Type used for App Engine services.
        #
        #     Note: The following fields are mutually exclusive: `app_engine`, `custom`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_endpoints
        #   @return [::Google::Cloud::Monitoring::V3::Service::CloudEndpoints]
        #     Type used for Cloud Endpoints services.
        #
        #     Note: The following fields are mutually exclusive: `cloud_endpoints`, `custom`, `app_engine`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cluster_istio
        #   @return [::Google::Cloud::Monitoring::V3::Service::ClusterIstio]
        #     Type used for Istio services that live in a Kubernetes cluster.
        #
        #     Note: The following fields are mutually exclusive: `cluster_istio`, `custom`, `app_engine`, `cloud_endpoints`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mesh_istio
        #   @return [::Google::Cloud::Monitoring::V3::Service::MeshIstio]
        #     Type used for Istio services scoped to an Istio mesh.
        #
        #     Note: The following fields are mutually exclusive: `mesh_istio`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] istio_canonical_service
        #   @return [::Google::Cloud::Monitoring::V3::Service::IstioCanonicalService]
        #     Type used for canonical services scoped to an Istio mesh.
        #     Metrics for Istio are
        #     [documented here](https://istio.io/latest/docs/reference/config/metrics/)
        #
        #     Note: The following fields are mutually exclusive: `istio_canonical_service`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `cloud_run`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_run
        #   @return [::Google::Cloud::Monitoring::V3::Service::CloudRun]
        #     Type used for Cloud Run services.
        #
        #     Note: The following fields are mutually exclusive: `cloud_run`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `gke_namespace`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gke_namespace
        #   @return [::Google::Cloud::Monitoring::V3::Service::GkeNamespace]
        #     Type used for GKE Namespaces.
        #
        #     Note: The following fields are mutually exclusive: `gke_namespace`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_workload`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gke_workload
        #   @return [::Google::Cloud::Monitoring::V3::Service::GkeWorkload]
        #     Type used for GKE Workloads.
        #
        #     Note: The following fields are mutually exclusive: `gke_workload`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gke_service
        #   @return [::Google::Cloud::Monitoring::V3::Service::GkeService]
        #     Type used for GKE Services (the Kubernetes concept of a service).
        #
        #     Note: The following fields are mutually exclusive: `gke_service`, `custom`, `app_engine`, `cloud_endpoints`, `cluster_istio`, `mesh_istio`, `istio_canonical_service`, `cloud_run`, `gke_namespace`, `gke_workload`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] basic_service
        #   @return [::Google::Cloud::Monitoring::V3::Service::BasicService]
        #     Message that contains the service type and service labels of this service
        #     if it is a basic service.
        #     Documentation and examples
        #     [here](https://cloud.google.com/stackdriver/docs/solutions/slo-monitoring/api/api-structures#basic-svc-w-basic-sli).
        # @!attribute [rw] telemetry
        #   @return [::Google::Cloud::Monitoring::V3::Service::Telemetry]
        #     Configuration for how to query telemetry on a Service.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels which have been used to annotate the service. Label keys must start
        #     with a letter. Label keys and values may contain lowercase letters,
        #     numbers, underscores, and dashes. Label keys and values have a maximum
        #     length of 63 characters, and must be less than 128 bytes in size. Up to 64
        #     label entries may be stored. For labels which do not have a semantic value,
        #     the empty string may be supplied for the label value.
        class Service
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Use a custom service to designate a service that you want to monitor
          # when none of the other service types (like App Engine, Cloud Run, or
          # a GKE type) matches your intended service.
          class Custom
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # App Engine service. Learn more at https://cloud.google.com/appengine.
          # @!attribute [rw] module_id
          #   @return [::String]
          #     The ID of the App Engine module underlying this service. Corresponds to
          #     the `module_id` resource label in the [`gae_app` monitored
          #     resource](https://cloud.google.com/monitoring/api/resources#tag_gae_app).
          class AppEngine
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Cloud Endpoints service. Learn more at https://cloud.google.com/endpoints.
          # @!attribute [rw] service
          #   @return [::String]
          #     The name of the Cloud Endpoints service underlying this service.
          #     Corresponds to the `service` resource label in the [`api` monitored
          #     resource](https://cloud.google.com/monitoring/api/resources#tag_api).
          class CloudEndpoints
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Istio service scoped to a single Kubernetes cluster. Learn more at
          # https://istio.io. Clusters running OSS Istio will have their services
          # ingested as this type.
          # @!attribute [rw] location
          #   @return [::String]
          #     The location of the Kubernetes cluster in which this Istio service is
          #     defined. Corresponds to the `location` resource label in `k8s_cluster`
          #     resources.
          # @!attribute [rw] cluster_name
          #   @return [::String]
          #     The name of the Kubernetes cluster in which this Istio service is
          #     defined. Corresponds to the `cluster_name` resource label in
          #     `k8s_cluster` resources.
          # @!attribute [rw] service_namespace
          #   @return [::String]
          #     The namespace of the Istio service underlying this service. Corresponds
          #     to the `destination_service_namespace` metric label in Istio metrics.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     The name of the Istio service underlying this service. Corresponds to the
          #     `destination_service_name` metric label in Istio metrics.
          class ClusterIstio
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Istio service scoped to an Istio mesh. Anthos clusters running ASM < 1.6.8
          # will have their services ingested as this type.
          # @!attribute [rw] mesh_uid
          #   @return [::String]
          #     Identifier for the mesh in which this Istio service is defined.
          #     Corresponds to the `mesh_uid` metric label in Istio metrics.
          # @!attribute [rw] service_namespace
          #   @return [::String]
          #     The namespace of the Istio service underlying this service. Corresponds
          #     to the `destination_service_namespace` metric label in Istio metrics.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     The name of the Istio service underlying this service. Corresponds to the
          #     `destination_service_name` metric label in Istio metrics.
          class MeshIstio
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Canonical service scoped to an Istio mesh. Anthos clusters running ASM >=
          # 1.6.8 will have their services ingested as this type.
          # @!attribute [rw] mesh_uid
          #   @return [::String]
          #     Identifier for the Istio mesh in which this canonical service is defined.
          #     Corresponds to the `mesh_uid` metric label in
          #     [Istio metrics](https://cloud.google.com/monitoring/api/metrics_istio).
          # @!attribute [rw] canonical_service_namespace
          #   @return [::String]
          #     The namespace of the canonical service underlying this service.
          #     Corresponds to the `destination_canonical_service_namespace` metric
          #     label in [Istio
          #     metrics](https://cloud.google.com/monitoring/api/metrics_istio).
          # @!attribute [rw] canonical_service
          #   @return [::String]
          #     The name of the canonical service underlying this service.
          #     Corresponds to the `destination_canonical_service_name` metric label in
          #     label in [Istio
          #     metrics](https://cloud.google.com/monitoring/api/metrics_istio).
          class IstioCanonicalService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Cloud Run service. Learn more at https://cloud.google.com/run.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     The name of the Cloud Run service. Corresponds to the `service_name`
          #     resource label in the [`cloud_run_revision` monitored
          #     resource](https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
          # @!attribute [rw] location
          #   @return [::String]
          #     The location the service is run. Corresponds to the `location`
          #     resource label in the [`cloud_run_revision` monitored
          #     resource](https://cloud.google.com/monitoring/api/resources#tag_cloud_run_revision).
          class CloudRun
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # GKE Namespace. The field names correspond to the resource metadata labels
          # on monitored resources that fall under a namespace (for example,
          # `k8s_container` or `k8s_pod`).
          # @!attribute [r] project_id
          #   @return [::String]
          #     Output only. The project this resource lives in. For legacy services
          #     migrated from the `Custom` type, this may be a distinct project from the
          #     one parenting the service itself.
          # @!attribute [rw] location
          #   @return [::String]
          #     The location of the parent cluster. This may be a zone or region.
          # @!attribute [rw] cluster_name
          #   @return [::String]
          #     The name of the parent cluster.
          # @!attribute [rw] namespace_name
          #   @return [::String]
          #     The name of this namespace.
          class GkeNamespace
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A GKE Workload (Deployment, StatefulSet, etc). The field names correspond
          # to the metadata labels on monitored resources that fall under a workload
          # (for example, `k8s_container` or `k8s_pod`).
          # @!attribute [r] project_id
          #   @return [::String]
          #     Output only. The project this resource lives in. For legacy services
          #     migrated from the `Custom` type, this may be a distinct project from the
          #     one parenting the service itself.
          # @!attribute [rw] location
          #   @return [::String]
          #     The location of the parent cluster. This may be a zone or region.
          # @!attribute [rw] cluster_name
          #   @return [::String]
          #     The name of the parent cluster.
          # @!attribute [rw] namespace_name
          #   @return [::String]
          #     The name of the parent namespace.
          # @!attribute [rw] top_level_controller_type
          #   @return [::String]
          #     The type of this workload (for example, "Deployment" or "DaemonSet")
          # @!attribute [rw] top_level_controller_name
          #   @return [::String]
          #     The name of this workload.
          class GkeWorkload
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # GKE Service. The "service" here represents a
          # [Kubernetes service
          # object](https://kubernetes.io/docs/concepts/services-networking/service).
          # The field names correspond to the resource labels on [`k8s_service`
          # monitored
          # resources](https://cloud.google.com/monitoring/api/resources#tag_k8s_service).
          # @!attribute [r] project_id
          #   @return [::String]
          #     Output only. The project this resource lives in. For legacy services
          #     migrated from the `Custom` type, this may be a distinct project from the
          #     one parenting the service itself.
          # @!attribute [rw] location
          #   @return [::String]
          #     The location of the parent cluster. This may be a zone or region.
          # @!attribute [rw] cluster_name
          #   @return [::String]
          #     The name of the parent cluster.
          # @!attribute [rw] namespace_name
          #   @return [::String]
          #     The name of the parent namespace.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     The name of this service.
          class GkeService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A well-known service type, defined by its service type and service labels.
          # Documentation and examples
          # [here](https://cloud.google.com/stackdriver/docs/solutions/slo-monitoring/api/api-structures#basic-svc-w-basic-sli).
          # @!attribute [rw] service_type
          #   @return [::String]
          #     The type of service that this basic service defines, e.g.
          #     APP_ENGINE service type.
          #     Documentation and valid values
          #     [here](https://cloud.google.com/stackdriver/docs/solutions/slo-monitoring/api/api-structures#basic-svc-w-basic-sli).
          # @!attribute [rw] service_labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Labels that specify the resource that emits the monitoring data which
          #     is used for SLO reporting of this `Service`.
          #     Documentation and valid values for given service types
          #     [here](https://cloud.google.com/stackdriver/docs/solutions/slo-monitoring/api/api-structures#basic-svc-w-basic-sli).
          class BasicService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ServiceLabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Configuration for how to query telemetry on a Service.
          # @!attribute [rw] resource_name
          #   @return [::String]
          #     The full name of the resource that defines this service. Formatted as
          #     described in https://cloud.google.com/apis/design/resource_names.
          class Telemetry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Service-Level Objective (SLO) describes a level of desired good service. It
        # consists of a service-level indicator (SLI), a performance goal, and a period
        # over which the objective is to be evaluated against that goal. The SLO can
        # use SLIs defined in a number of different manners. Typical SLOs might include
        # "99% of requests in each rolling week have latency below 200 milliseconds" or
        # "99.5% of requests in each calendar month return successfully."
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name for this `ServiceLevelObjective`. The format is:
        #
        #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Name used for UI elements listing this SLO.
        # @!attribute [rw] service_level_indicator
        #   @return [::Google::Cloud::Monitoring::V3::ServiceLevelIndicator]
        #     The definition of good service, used to measure and calculate the quality
        #     of the `Service`'s performance with respect to a single aspect of service
        #     quality.
        # @!attribute [rw] goal
        #   @return [::Float]
        #     The fraction of service that must be good in order for this objective to be
        #     met. `0 < goal <= 0.9999`.
        # @!attribute [rw] rolling_period
        #   @return [::Google::Protobuf::Duration]
        #     A rolling time period, semantically "in the past `<rolling_period>`".
        #     Must be an integer multiple of 1 day no larger than 30 days.
        #
        #     Note: The following fields are mutually exclusive: `rolling_period`, `calendar_period`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] calendar_period
        #   @return [::Google::Type::CalendarPeriod]
        #     A calendar period, semantically "since the start of the current
        #     `<calendar_period>`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
        #     `MONTH` are supported.
        #
        #     Note: The following fields are mutually exclusive: `calendar_period`, `rolling_period`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] user_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels which have been used to annotate the service-level objective. Label
        #     keys must start with a letter. Label keys and values may contain lowercase
        #     letters, numbers, underscores, and dashes. Label keys and values have a
        #     maximum length of 63 characters, and must be less than 128 bytes in size.
        #     Up to 64 label entries may be stored. For labels which do not have a
        #     semantic value, the empty string may be supplied for the label value.
        class ServiceLevelObjective
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `ServiceLevelObjective.View` determines what form of
          # `ServiceLevelObjective` is returned from `GetServiceLevelObjective`,
          # `ListServiceLevelObjectives`, and `ListServiceLevelObjectiveVersions` RPCs.
          module View
            # Same as FULL.
            VIEW_UNSPECIFIED = 0

            # Return the embedded `ServiceLevelIndicator` in the form in which it was
            # defined. If it was defined using a `BasicSli`, return that `BasicSli`.
            FULL = 2

            # For `ServiceLevelIndicator`s using `BasicSli` articulation, instead
            # return the `ServiceLevelIndicator` with its mode of computation fully
            # spelled out as a `RequestBasedSli`. For `ServiceLevelIndicator`s using
            # `RequestBasedSli` or `WindowsBasedSli`, return the
            # `ServiceLevelIndicator` as it was provided.
            EXPLICIT = 1
          end
        end

        # A Service-Level Indicator (SLI) describes the "performance" of a service. For
        # some services, the SLI is well-defined. In such cases, the SLI can be
        # described easily by referencing the well-known SLI and providing the needed
        # parameters. Alternatively, a "custom" SLI can be defined with a query to the
        # underlying metric store. An SLI is defined to be `good_service /
        # total_service` over any queried time interval. The value of performance
        # always falls into the range `0 <= performance <= 1`. A custom SLI describes
        # how to compute this ratio, whether this is by dividing values from a pair of
        # time series, cutting a `Distribution` into good and bad counts, or counting
        # time windows in which the service complies with a criterion. For separation
        # of concerns, a single Service-Level Indicator measures performance for only
        # one aspect of service quality, such as fraction of successful queries or
        # fast-enough queries.
        # @!attribute [rw] basic_sli
        #   @return [::Google::Cloud::Monitoring::V3::BasicSli]
        #     Basic SLI on a well-known service type.
        #
        #     Note: The following fields are mutually exclusive: `basic_sli`, `request_based`, `windows_based`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] request_based
        #   @return [::Google::Cloud::Monitoring::V3::RequestBasedSli]
        #     Request-based SLIs
        #
        #     Note: The following fields are mutually exclusive: `request_based`, `basic_sli`, `windows_based`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] windows_based
        #   @return [::Google::Cloud::Monitoring::V3::WindowsBasedSli]
        #     Windows-based SLIs
        #
        #     Note: The following fields are mutually exclusive: `windows_based`, `basic_sli`, `request_based`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ServiceLevelIndicator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An SLI measuring performance on a well-known service type. Performance will
        # be computed on the basis of pre-defined metrics. The type of the
        # `service_resource` determines the metrics to use and the
        # `service_resource.labels` and `metric_labels` are used to construct a
        # monitoring filter to filter that metric down to just the data relevant to
        # this service.
        # @!attribute [rw] method
        #   @return [::Array<::String>]
        #     OPTIONAL: The set of RPCs to which this SLI is relevant. Telemetry from
        #     other methods will not be used to calculate performance for this SLI. If
        #     omitted, this SLI applies to all the Service's methods. For service types
        #     that don't support breaking down by method, setting this field will result
        #     in an error.
        # @!attribute [rw] location
        #   @return [::Array<::String>]
        #     OPTIONAL: The set of locations to which this SLI is relevant. Telemetry
        #     from other locations will not be used to calculate performance for this
        #     SLI. If omitted, this SLI applies to all locations in which the Service has
        #     activity. For service types that don't support breaking down by location,
        #     setting this field will result in an error.
        # @!attribute [rw] version
        #   @return [::Array<::String>]
        #     OPTIONAL: The set of API versions to which this SLI is relevant. Telemetry
        #     from other API versions will not be used to calculate performance for this
        #     SLI. If omitted, this SLI applies to all API versions. For service types
        #     that don't support breaking down by version, setting this field will result
        #     in an error.
        # @!attribute [rw] availability
        #   @return [::Google::Cloud::Monitoring::V3::BasicSli::AvailabilityCriteria]
        #     Good service is defined to be the count of requests made to this service
        #     that return successfully.
        #
        #     Note: The following fields are mutually exclusive: `availability`, `latency`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] latency
        #   @return [::Google::Cloud::Monitoring::V3::BasicSli::LatencyCriteria]
        #     Good service is defined to be the count of requests made to this service
        #     that are fast enough with respect to `latency.threshold`.
        #
        #     Note: The following fields are mutually exclusive: `latency`, `availability`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BasicSli
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Future parameters for the availability SLI.
          class AvailabilityCriteria
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters for a latency threshold SLI.
          # @!attribute [rw] threshold
          #   @return [::Google::Protobuf::Duration]
          #     Good service is defined to be the count of requests made to this service
          #     that return in no more than `threshold`.
          class LatencyCriteria
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Range of numerical values within `min` and `max`.
        # @!attribute [rw] min
        #   @return [::Float]
        #     Range minimum.
        # @!attribute [rw] max
        #   @return [::Float]
        #     Range maximum.
        class Range
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Service Level Indicators for which atomic units of service are counted
        # directly.
        # @!attribute [rw] good_total_ratio
        #   @return [::Google::Cloud::Monitoring::V3::TimeSeriesRatio]
        #     `good_total_ratio` is used when the ratio of `good_service` to
        #     `total_service` is computed from two `TimeSeries`.
        #
        #     Note: The following fields are mutually exclusive: `good_total_ratio`, `distribution_cut`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] distribution_cut
        #   @return [::Google::Cloud::Monitoring::V3::DistributionCut]
        #     `distribution_cut` is used when `good_service` is a count of values
        #     aggregated in a `Distribution` that fall into a good range. The
        #     `total_service` is the total count of all values aggregated in the
        #     `Distribution`.
        #
        #     Note: The following fields are mutually exclusive: `distribution_cut`, `good_total_ratio`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RequestBasedSli
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `TimeSeriesRatio` specifies two `TimeSeries` to use for computing the
        # `good_service / total_service` ratio. The specified `TimeSeries` must have
        # `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
        # DELTA` or `MetricKind = CUMULATIVE`. The `TimeSeriesRatio` must specify
        # exactly two of good, bad, and total, and the relationship `good_service +
        # bad_service = total_service` will be assumed.
        # @!attribute [rw] good_service_filter
        #   @return [::String]
        #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        #     specifying a `TimeSeries` quantifying good service provided. Must have
        #     `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
        #     DELTA` or `MetricKind = CUMULATIVE`.
        # @!attribute [rw] bad_service_filter
        #   @return [::String]
        #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        #     specifying a `TimeSeries` quantifying bad service, either demanded service
        #     that was not provided or demanded service that was of inadequate quality.
        #     Must have `ValueType = DOUBLE` or `ValueType = INT64` and must have
        #     `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
        # @!attribute [rw] total_service_filter
        #   @return [::String]
        #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        #     specifying a `TimeSeries` quantifying total demanded service. Must have
        #     `ValueType = DOUBLE` or `ValueType = INT64` and must have `MetricKind =
        #     DELTA` or `MetricKind = CUMULATIVE`.
        class TimeSeriesRatio
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `DistributionCut` defines a `TimeSeries` and thresholds used for measuring
        # good service and total service. The `TimeSeries` must have `ValueType =
        # DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`. The
        # computed `good_service` will be the estimated count of values in the
        # `Distribution` that fall within the specified `min` and `max`.
        # @!attribute [rw] distribution_filter
        #   @return [::String]
        #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        #     specifying a `TimeSeries` aggregating values. Must have `ValueType =
        #     DISTRIBUTION` and `MetricKind = DELTA` or `MetricKind = CUMULATIVE`.
        # @!attribute [rw] range
        #   @return [::Google::Cloud::Monitoring::V3::Range]
        #     Range of values considered "good." For a one-sided range, set one bound to
        #     an infinite value.
        class DistributionCut
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `WindowsBasedSli` defines `good_service` as the count of time windows for
        # which the provided service was of good quality. Criteria for determining
        # if service was good are embedded in the `window_criterion`.
        # @!attribute [rw] good_bad_metric_filter
        #   @return [::String]
        #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
        #     specifying a `TimeSeries` with `ValueType = BOOL`. The window is good if
        #     any `true` values appear in the window.
        #
        #     Note: The following fields are mutually exclusive: `good_bad_metric_filter`, `good_total_ratio_threshold`, `metric_mean_in_range`, `metric_sum_in_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] good_total_ratio_threshold
        #   @return [::Google::Cloud::Monitoring::V3::WindowsBasedSli::PerformanceThreshold]
        #     A window is good if its `performance` is high enough.
        #
        #     Note: The following fields are mutually exclusive: `good_total_ratio_threshold`, `good_bad_metric_filter`, `metric_mean_in_range`, `metric_sum_in_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metric_mean_in_range
        #   @return [::Google::Cloud::Monitoring::V3::WindowsBasedSli::MetricRange]
        #     A window is good if the metric's value is in a good range, averaged
        #     across returned streams.
        #
        #     Note: The following fields are mutually exclusive: `metric_mean_in_range`, `good_bad_metric_filter`, `good_total_ratio_threshold`, `metric_sum_in_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metric_sum_in_range
        #   @return [::Google::Cloud::Monitoring::V3::WindowsBasedSli::MetricRange]
        #     A window is good if the metric's value is in a good range, summed across
        #     returned streams.
        #
        #     Note: The following fields are mutually exclusive: `metric_sum_in_range`, `good_bad_metric_filter`, `good_total_ratio_threshold`, `metric_mean_in_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] window_period
        #   @return [::Google::Protobuf::Duration]
        #     Duration over which window quality is evaluated. Must be an integer
        #     fraction of a day and at least `60s`.
        class WindowsBasedSli
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A `PerformanceThreshold` is used when each window is good when that window
          # has a sufficiently high `performance`.
          # @!attribute [rw] performance
          #   @return [::Google::Cloud::Monitoring::V3::RequestBasedSli]
          #     `RequestBasedSli` to evaluate to judge window quality.
          #
          #     Note: The following fields are mutually exclusive: `performance`, `basic_sli_performance`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] basic_sli_performance
          #   @return [::Google::Cloud::Monitoring::V3::BasicSli]
          #     `BasicSli` to evaluate to judge window quality.
          #
          #     Note: The following fields are mutually exclusive: `basic_sli_performance`, `performance`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] threshold
          #   @return [::Float]
          #     If window `performance >= threshold`, the window is counted as good.
          class PerformanceThreshold
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A `MetricRange` is used when each window is good when the value x of a
          # single `TimeSeries` satisfies `range.min <= x <= range.max`. The provided
          # `TimeSeries` must have `ValueType = INT64` or `ValueType = DOUBLE` and
          # `MetricKind = GAUGE`.
          # @!attribute [rw] time_series
          #   @return [::String]
          #     A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
          #     specifying the `TimeSeries` to use for evaluating window quality.
          # @!attribute [rw] range
          #   @return [::Google::Cloud::Monitoring::V3::Range]
          #     Range of values considered "good." For a one-sided range, set one bound
          #     to an infinite value.
          class MetricRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
