# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        # A single data point in a time series.
        # @!attribute [rw] interval
        #   @return [::Google::Cloud::Monitoring::V3::TimeInterval]
        #     The time interval to which the data point applies.  For `GAUGE` metrics,
        #     the start time is optional, but if it is supplied, it must equal the
        #     end time.  For `DELTA` metrics, the start
        #     and end time should specify a non-zero interval, with subsequent points
        #     specifying contiguous and non-overlapping intervals.  For `CUMULATIVE`
        #     metrics, the start and end time should specify a non-zero interval, with
        #     subsequent points specifying the same start time and increasing end times,
        #     until an event resets the cumulative value to zero and sets a new start
        #     time for the following points.
        # @!attribute [rw] value
        #   @return [::Google::Cloud::Monitoring::V3::TypedValue]
        #     The value of the data point.
        class Point
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of data points that describes the time-varying values
        # of a metric. A time series is identified by a combination of a
        # fully-specified monitored resource and a fully-specified metric.
        # This type is used for both listing and creating time series.
        # @!attribute [rw] metric
        #   @return [::Google::Api::Metric]
        #     The associated metric. A fully-specified metric used to identify the time
        #     series.
        # @!attribute [rw] resource
        #   @return [::Google::Api::MonitoredResource]
        #     The associated monitored resource.  Custom metrics can use only certain
        #     monitored resource types in their time series data. For more information,
        #     see [Monitored resources for custom
        #     metrics](https://cloud.google.com/monitoring/custom-metrics/creating-metrics#custom-metric-resources).
        # @!attribute [rw] metadata
        #   @return [::Google::Api::MonitoredResourceMetadata]
        #     Output only. The associated monitored resource metadata. When reading a
        #     time series, this field will include metadata labels that are explicitly
        #     named in the reduction. When creating a time series, this field is ignored.
        # @!attribute [rw] metric_kind
        #   @return [::Google::Api::MetricDescriptor::MetricKind]
        #     The metric kind of the time series. When listing time series, this metric
        #     kind might be different from the metric kind of the associated metric if
        #     this time series is an alignment or reduction of other time series.
        #
        #     When creating a time series, this field is optional. If present, it must be
        #     the same as the metric kind of the associated metric. If the associated
        #     metric's descriptor must be auto-created, then this field specifies the
        #     metric kind of the new descriptor and must be either `GAUGE` (the default)
        #     or `CUMULATIVE`.
        # @!attribute [rw] value_type
        #   @return [::Google::Api::MetricDescriptor::ValueType]
        #     The value type of the time series. When listing time series, this value
        #     type might be different from the value type of the associated metric if
        #     this time series is an alignment or reduction of other time series.
        #
        #     When creating a time series, this field is optional. If present, it must be
        #     the same as the type of the data in the `points` field.
        # @!attribute [rw] points
        #   @return [::Array<::Google::Cloud::Monitoring::V3::Point>]
        #     The data points of this time series. When listing time series, points are
        #     returned in reverse time order.
        #
        #     When creating a time series, this field must contain exactly one point and
        #     the point's type must be the same as the value type of the associated
        #     metric. If the associated metric's descriptor must be auto-created, then
        #     the value type of the descriptor is determined by the point's type, which
        #     must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
        # @!attribute [rw] unit
        #   @return [::String]
        #     The units in which the metric value is reported. It is only applicable
        #     if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit`
        #     defines the representation of the stored metric values. This field can only
        #     be changed through CreateTimeSeries when it is empty.
        # @!attribute [rw] description
        #   @return [::String]
        #     Input only. A detailed description of the time series that will be
        #     associated with the
        #     {::Google::Api::MetricDescriptor google.api.MetricDescriptor} for the metric.
        #     Once set, this field cannot be changed through CreateTimeSeries.
        class TimeSeries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A descriptor for the labels and points in a time series.
        # @!attribute [rw] label_descriptors
        #   @return [::Array<::Google::Api::LabelDescriptor>]
        #     Descriptors for the labels.
        # @!attribute [rw] point_descriptors
        #   @return [::Array<::Google::Cloud::Monitoring::V3::TimeSeriesDescriptor::ValueDescriptor>]
        #     Descriptors for the point data value columns.
        class TimeSeriesDescriptor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A descriptor for the value columns in a data point.
          # @!attribute [rw] key
          #   @return [::String]
          #     The value key.
          # @!attribute [rw] value_type
          #   @return [::Google::Api::MetricDescriptor::ValueType]
          #     The value type.
          # @!attribute [rw] metric_kind
          #   @return [::Google::Api::MetricDescriptor::MetricKind]
          #     The value stream kind.
          # @!attribute [rw] unit
          #   @return [::String]
          #     The unit in which `time_series` point values are reported. `unit`
          #     follows the UCUM format for units as seen in
          #     https://unitsofmeasure.org/ucum.html.
          #     `unit` is only valid if `value_type` is INTEGER, DOUBLE, DISTRIBUTION.
          class ValueDescriptor
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents the values of a time series associated with a
        # TimeSeriesDescriptor.
        # @!attribute [rw] label_values
        #   @return [::Array<::Google::Cloud::Monitoring::V3::LabelValue>]
        #     The values of the labels in the time series identifier, given in the same
        #     order as the `label_descriptors` field of the TimeSeriesDescriptor
        #     associated with this object. Each value must have a value of the type
        #     given in the corresponding entry of `label_descriptors`.
        # @!attribute [rw] point_data
        #   @return [::Array<::Google::Cloud::Monitoring::V3::TimeSeriesData::PointData>]
        #     The points in the time series.
        class TimeSeriesData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A point's value columns and time interval. Each point has one or more
          # point values corresponding to the entries in `point_descriptors` field in
          # the TimeSeriesDescriptor associated with this object.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::Monitoring::V3::TypedValue>]
          #     The values that make up the point.
          # @!attribute [rw] time_interval
          #   @return [::Google::Cloud::Monitoring::V3::TimeInterval]
          #     The time interval associated with the point.
          class PointData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A label value.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     A bool label value.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `int64_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] int64_value
        #   @return [::Integer]
        #     An int64 label value.
        #
        #     Note: The following fields are mutually exclusive: `int64_value`, `bool_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     A string label value.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `bool_value`, `int64_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class LabelValue
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An error associated with a query in the time series query language format.
        # @!attribute [rw] locator
        #   @return [::Google::Cloud::Monitoring::V3::TextLocator]
        #     The location of the time series query language text that this error applies
        #     to.
        # @!attribute [rw] message
        #   @return [::String]
        #     The error message.
        class QueryError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A locator for text. Indicates a particular part of the text of a request or
        # of an object referenced in the request.
        #
        # For example, suppose the request field `text` contains:
        #
        #   text: "The quick brown fox jumps over the lazy dog."
        #
        # Then the locator:
        #
        #   source: "text"
        #   start_position {
        #     line: 1
        #     column: 17
        #   }
        #   end_position {
        #     line: 1
        #     column: 19
        #   }
        #
        # refers to the part of the text: "fox".
        # @!attribute [rw] source
        #   @return [::String]
        #     The source of the text. The source may be a field in the request, in which
        #     case its format is the format of the
        #     google.rpc.BadRequest.FieldViolation.field field in
        #     https://cloud.google.com/apis/design/errors#error_details. It may also be
        #     be a source other than the request field (e.g. a macro definition
        #     referenced in the text of the query), in which case this is the name of
        #     the source (e.g. the macro name).
        # @!attribute [rw] start_position
        #   @return [::Google::Cloud::Monitoring::V3::TextLocator::Position]
        #     The position of the first byte within the text.
        # @!attribute [rw] end_position
        #   @return [::Google::Cloud::Monitoring::V3::TextLocator::Position]
        #     The position of the last byte within the text.
        # @!attribute [rw] nested_locator
        #   @return [::Google::Cloud::Monitoring::V3::TextLocator]
        #     If `source`, `start_position`, and `end_position` describe a call on
        #     some object (e.g. a macro in the time series query language text) and a
        #     location is to be designated in that object's text, `nested_locator`
        #     identifies the location within that object.
        # @!attribute [rw] nesting_reason
        #   @return [::String]
        #     When `nested_locator` is set, this field gives the reason for the nesting.
        #     Usually, the reason is a macro invocation. In that case, the macro name
        #     (including the leading '@') signals the location of the macro call
        #     in the text and a macro argument name (including the leading '$') signals
        #     the location of the macro argument inside the macro body that got
        #     substituted away.
        class TextLocator
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The position of a byte within the text.
          # @!attribute [rw] line
          #   @return [::Integer]
          #     The line, starting with 1, where the byte is positioned.
          # @!attribute [rw] column
          #   @return [::Integer]
          #     The column within the line, starting with 1, where the byte is
          #     positioned. This is a byte index even though the text is UTF-8.
          class Position
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
