# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        module ServiceMonitoringService
          # Path helper methods for the ServiceMonitoringService API.
          module Paths
            ##
            # Create a fully-qualified Folder resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}`
            #
            # @param folder [String]
            #
            # @return [::String]
            def folder_path folder:
              "folders/#{folder}"
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # @overload service_path(project:, service:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/services/{service}`
            #
            #   @param project [String]
            #   @param service [String]
            #
            # @overload service_path(organization:, service:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/services/{service}`
            #
            #   @param organization [String]
            #   @param service [String]
            #
            # @overload service_path(folder:, service:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/services/{service}`
            #
            #   @param folder [String]
            #   @param service [String]
            #
            # @return [::String]
            def service_path **args
              resources = {
                "project:service" => (proc do |project:, service:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/services/#{service}"
                end),
                "organization:service" => (proc do |organization:, service:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/services/#{service}"
                end),
                "folder:service" => (proc do |folder:, service:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/services/#{service}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified ServiceLevelObjective resource string.
            #
            # @overload service_level_objective_path(project:, service:, service_level_objective:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/services/{service}/serviceLevelObjectives/{service_level_objective}`
            #
            #   @param project [String]
            #   @param service [String]
            #   @param service_level_objective [String]
            #
            # @overload service_level_objective_path(organization:, service:, service_level_objective:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/services/{service}/serviceLevelObjectives/{service_level_objective}`
            #
            #   @param organization [String]
            #   @param service [String]
            #   @param service_level_objective [String]
            #
            # @overload service_level_objective_path(folder:, service:, service_level_objective:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/services/{service}/serviceLevelObjectives/{service_level_objective}`
            #
            #   @param folder [String]
            #   @param service [String]
            #   @param service_level_objective [String]
            #
            # @return [::String]
            def service_level_objective_path **args
              resources = {
                "project:service:service_level_objective" => (proc do |project:, service:, service_level_objective:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "projects/#{project}/services/#{service}/serviceLevelObjectives/#{service_level_objective}"
                end),
                "organization:service:service_level_objective" => (proc do |organization:, service:, service_level_objective:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "organizations/#{organization}/services/#{service}/serviceLevelObjectives/#{service_level_objective}"
                end),
                "folder:service:service_level_objective" => (proc do |folder:, service:, service_level_objective:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"
                  raise ::ArgumentError, "service cannot contain /" if service.to_s.include? "/"

                  "folders/#{folder}/services/#{service}/serviceLevelObjectives/#{service_level_objective}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Workspace resource string.
            #
            # @overload workspace_path(project:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}`
            #
            #   @param project [String]
            #
            # @overload workspace_path(workspace:)
            #   The resource will be in the following format:
            #
            #   `workspaces/{workspace}`
            #
            #   @param workspace [String]
            #
            # @return [::String]
            def workspace_path **args
              resources = {
                "project" => (proc do |project:|
                  "projects/#{project}"
                end),
                "workspace" => (proc do |workspace:|
                  "workspaces/#{workspace}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
