# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/monitoring/v3/service_service_pb"

module Google
  module Cloud
    module Monitoring
      module V3
        module ServiceMonitoringService
          ##
          # Client for the ServiceMonitoringService service.
          #
          # The Cloud Monitoring Service-Oriented Monitoring API has endpoints for
          # managing and querying aspects of a Metrics Scope's services. These include
          # the `Service`'s monitored resources, its Service-Level Objectives, and a
          # taxonomy of categorized Health Metrics.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "monitoring.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :service_monitoring_service_stub

            ##
            # Configure the ServiceMonitoringService Client class.
            #
            # See {::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all ServiceMonitoringService clients
            #   ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Monitoring", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_service.timeout = 30.0

                default_config.rpcs.get_service.timeout = 30.0
                default_config.rpcs.get_service.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_services.timeout = 30.0
                default_config.rpcs.list_services.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_service.timeout = 30.0

                default_config.rpcs.delete_service.timeout = 30.0
                default_config.rpcs.delete_service.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_service_level_objective.timeout = 30.0

                default_config.rpcs.get_service_level_objective.timeout = 30.0
                default_config.rpcs.get_service_level_objective.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_service_level_objectives.timeout = 30.0
                default_config.rpcs.list_service_level_objectives.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_service_level_objective.timeout = 30.0

                default_config.rpcs.delete_service_level_objective.timeout = 30.0
                default_config.rpcs.delete_service_level_objective.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the ServiceMonitoringService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @service_monitoring_service_stub.universe_domain
            end

            ##
            # Create a new ServiceMonitoringService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the ServiceMonitoringService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/monitoring/v3/service_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @service_monitoring_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @service_monitoring_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @service_monitoring_service_stub.logger
            end

            # Service calls

            ##
            # Create a `Service`.
            #
            # @overload create_service(request, options = nil)
            #   Pass arguments to `create_service` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service(parent: nil, service_id: nil, service: nil)
            #   Pass arguments to `create_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource
            #     [name](https://cloud.google.com/monitoring/api/v3#project_name) of the
            #     parent Metrics Scope. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param service_id [::String]
            #     Optional. The Service id to use for this Service. If omitted, an id will be
            #     generated instead. Must match the pattern `[a-z0-9\-]+`
            #   @param service [::Google::Cloud::Monitoring::V3::Service, ::Hash]
            #     Required. The `Service` to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Service]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Service]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateServiceRequest.new
            #
            #   # Call the create_service method.
            #   result = client.create_service request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Service.
            #   p result
            #
            def create_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :create_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get the named `Service`.
            #
            # @overload get_service(request, options = nil)
            #   Pass arguments to `get_service` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service(name: nil)
            #   Pass arguments to `get_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the `Service`. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Service]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Service]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetServiceRequest.new
            #
            #   # Call the get_service method.
            #   result = client.get_service request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Service.
            #   p result
            #
            def get_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :get_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List `Service`s for this Metrics Scope.
            #
            # @overload list_services(request, options = nil)
            #   Pass arguments to `list_services` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListServicesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListServicesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_services(parent: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_services` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent containing the listed services,
            #     either a [project](https://cloud.google.com/monitoring/api/v3#project_name)
            #     or a Monitoring Metrics Scope. The formats are:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #         workspaces/[HOST_PROJECT_ID_OR_NUMBER]
            #   @param filter [::String]
            #     A filter specifying what `Service`s to return. The filter supports
            #     filtering on a particular service-identifier type or one of its attributes.
            #
            #     To filter on a particular service-identifier type, the `identifier_case`
            #     refers to which option in the `identifier` field is populated. For example,
            #     the filter `identifier_case = "CUSTOM"` would match all services with a
            #     value for the `custom` field. Valid options include "CUSTOM", "APP_ENGINE",
            #     "MESH_ISTIO", and the other options listed at
            #     https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services#Service
            #
            #     To filter on an attribute of a service-identifier type, apply the filter
            #     name by using the snake case of the service-identifier type and the
            #     attribute of that service-identifier type, and join the two with a period.
            #     For example, to filter by the `meshUid` field of the `MeshIstio`
            #     service-identifier type, you must filter on `mesh_istio.mesh_uid =
            #     "123"` to match all services with mesh UID "123". Service-identifier types
            #     and their attributes are described at
            #     https://cloud.google.com/monitoring/api/ref_v3/rest/v3/services#Service
            #   @param page_size [::Integer]
            #     A non-negative number that is the maximum number of results to return.
            #     When 0, use default page size.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `nextPageToken` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::Service>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::Service>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListServicesRequest.new
            #
            #   # Call the list_services method.
            #   result = client.list_services request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::Service.
            #     p item
            #   end
            #
            def list_services request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListServicesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_services.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_services.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_services.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :list_services, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @service_monitoring_service_stub, :list_services, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update this `Service`.
            #
            # @overload update_service(request, options = nil)
            #   Pass arguments to `update_service` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::UpdateServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::UpdateServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service(service: nil, update_mask: nil)
            #   Pass arguments to `update_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param service [::Google::Cloud::Monitoring::V3::Service, ::Hash]
            #     Required. The `Service` to draw updates from.
            #     The given `name` specifies the resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     A set of field paths defining which fields to use for the update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::Service]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::Service]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::UpdateServiceRequest.new
            #
            #   # Call the update_service method.
            #   result = client.update_service request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::Service.
            #   p result
            #
            def update_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::UpdateServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service&.name
                header_params["service.name"] = request.service.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :update_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Soft delete this `Service`.
            #
            # @overload delete_service(request, options = nil)
            #   Pass arguments to `delete_service` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteServiceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteServiceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service(name: nil)
            #   Pass arguments to `delete_service` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the `Service` to delete. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteServiceRequest.new
            #
            #   # Call the delete_service method.
            #   result = client.delete_service request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_service request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteServiceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :delete_service, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a `ServiceLevelObjective` for the given `Service`.
            #
            # @overload create_service_level_objective(request, options = nil)
            #   Pass arguments to `create_service_level_objective` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateServiceLevelObjectiveRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateServiceLevelObjectiveRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_level_objective(parent: nil, service_level_objective_id: nil, service_level_objective: nil)
            #   Pass arguments to `create_service_level_objective` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent `Service`. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
            #   @param service_level_objective_id [::String]
            #     Optional. The ServiceLevelObjective id to use for this
            #     ServiceLevelObjective. If omitted, an id will be generated instead. Must
            #     match the pattern `^[a-zA-Z0-9-_:.]+$`
            #   @param service_level_objective [::Google::Cloud::Monitoring::V3::ServiceLevelObjective, ::Hash]
            #     Required. The `ServiceLevelObjective` to create.
            #     The provided `name` will be respected if no `ServiceLevelObjective` exists
            #     with this name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateServiceLevelObjectiveRequest.new
            #
            #   # Call the create_service_level_objective method.
            #   result = client.create_service_level_objective request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::ServiceLevelObjective.
            #   p result
            #
            def create_service_level_objective request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateServiceLevelObjectiveRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_level_objective.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_level_objective.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_level_objective.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :create_service_level_objective, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a `ServiceLevelObjective` by name.
            #
            # @overload get_service_level_objective(request, options = nil)
            #   Pass arguments to `get_service_level_objective` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetServiceLevelObjectiveRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetServiceLevelObjectiveRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_service_level_objective(name: nil, view: nil)
            #   Pass arguments to `get_service_level_objective` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the `ServiceLevelObjective` to get. The format
            #     is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
            #   @param view [::Google::Cloud::Monitoring::V3::ServiceLevelObjective::View]
            #     View of the `ServiceLevelObjective` to return. If `DEFAULT`, return the
            #     `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
            #     `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
            #     `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetServiceLevelObjectiveRequest.new
            #
            #   # Call the get_service_level_objective method.
            #   result = client.get_service_level_objective request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::ServiceLevelObjective.
            #   p result
            #
            def get_service_level_objective request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetServiceLevelObjectiveRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_service_level_objective.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_service_level_objective.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_service_level_objective.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :get_service_level_objective, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List the `ServiceLevelObjective`s for the given `Service`.
            #
            # @overload list_service_level_objectives(request, options = nil)
            #   Pass arguments to `list_service_level_objectives` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListServiceLevelObjectivesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListServiceLevelObjectivesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_service_level_objectives(parent: nil, filter: nil, page_size: nil, page_token: nil, view: nil)
            #   Pass arguments to `list_service_level_objectives` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Resource name of the parent containing the listed SLOs, either a
            #     project or a Monitoring Metrics Scope. The formats are:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]
            #         workspaces/[HOST_PROJECT_ID_OR_NUMBER]/services/-
            #   @param filter [::String]
            #     A filter specifying what `ServiceLevelObjective`s to return.
            #   @param page_size [::Integer]
            #     A non-negative number that is the maximum number of results to return.
            #     When 0, use default page size.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `nextPageToken` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #   @param view [::Google::Cloud::Monitoring::V3::ServiceLevelObjective::View]
            #     View of the `ServiceLevelObjective`s to return. If `DEFAULT`, return each
            #     `ServiceLevelObjective` as originally defined. If `EXPLICIT` and the
            #     `ServiceLevelObjective` is defined in terms of a `BasicSli`, replace the
            #     `BasicSli` with a `RequestBasedSli` spelling out how the SLI is computed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::ServiceLevelObjective>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::ServiceLevelObjective>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListServiceLevelObjectivesRequest.new
            #
            #   # Call the list_service_level_objectives method.
            #   result = client.list_service_level_objectives request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::ServiceLevelObjective.
            #     p item
            #   end
            #
            def list_service_level_objectives request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListServiceLevelObjectivesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_service_level_objectives.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_service_level_objectives.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_service_level_objectives.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :list_service_level_objectives, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @service_monitoring_service_stub, :list_service_level_objectives, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update the given `ServiceLevelObjective`.
            #
            # @overload update_service_level_objective(request, options = nil)
            #   Pass arguments to `update_service_level_objective` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::UpdateServiceLevelObjectiveRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::UpdateServiceLevelObjectiveRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_service_level_objective(service_level_objective: nil, update_mask: nil)
            #   Pass arguments to `update_service_level_objective` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param service_level_objective [::Google::Cloud::Monitoring::V3::ServiceLevelObjective, ::Hash]
            #     Required. The `ServiceLevelObjective` to draw updates from.
            #     The given `name` specifies the resource to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     A set of field paths defining which fields to use for the update.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::ServiceLevelObjective]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::UpdateServiceLevelObjectiveRequest.new
            #
            #   # Call the update_service_level_objective method.
            #   result = client.update_service_level_objective request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::ServiceLevelObjective.
            #   p result
            #
            def update_service_level_objective request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::UpdateServiceLevelObjectiveRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_service_level_objective.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.service_level_objective&.name
                header_params["service_level_objective.name"] = request.service_level_objective.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_service_level_objective.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_service_level_objective.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :update_service_level_objective, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete the given `ServiceLevelObjective`.
            #
            # @overload delete_service_level_objective(request, options = nil)
            #   Pass arguments to `delete_service_level_objective` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteServiceLevelObjectiveRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteServiceLevelObjectiveRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_service_level_objective(name: nil)
            #   Pass arguments to `delete_service_level_objective` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Resource name of the `ServiceLevelObjective` to delete. The
            #     format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteServiceLevelObjectiveRequest.new
            #
            #   # Call the delete_service_level_objective method.
            #   result = client.delete_service_level_objective request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_service_level_objective request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteServiceLevelObjectiveRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_service_level_objective.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_service_level_objective.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_service_level_objective.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @service_monitoring_service_stub.call_rpc :delete_service_level_objective, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the ServiceMonitoringService API.
            #
            # This class represents the configuration for ServiceMonitoringService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_service to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_service.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_service.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Monitoring::V3::ServiceMonitoringService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "monitoring.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the ServiceMonitoringService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service
                ##
                # RPC-specific configuration for `get_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service
                ##
                # RPC-specific configuration for `list_services`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_services
                ##
                # RPC-specific configuration for `update_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service
                ##
                # RPC-specific configuration for `delete_service`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service
                ##
                # RPC-specific configuration for `create_service_level_objective`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_level_objective
                ##
                # RPC-specific configuration for `get_service_level_objective`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_service_level_objective
                ##
                # RPC-specific configuration for `list_service_level_objectives`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_service_level_objectives
                ##
                # RPC-specific configuration for `update_service_level_objective`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_service_level_objective
                ##
                # RPC-specific configuration for `delete_service_level_objective`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_service_level_objective

                # @private
                def initialize parent_rpcs = nil
                  create_service_config = parent_rpcs.create_service if parent_rpcs.respond_to? :create_service
                  @create_service = ::Gapic::Config::Method.new create_service_config
                  get_service_config = parent_rpcs.get_service if parent_rpcs.respond_to? :get_service
                  @get_service = ::Gapic::Config::Method.new get_service_config
                  list_services_config = parent_rpcs.list_services if parent_rpcs.respond_to? :list_services
                  @list_services = ::Gapic::Config::Method.new list_services_config
                  update_service_config = parent_rpcs.update_service if parent_rpcs.respond_to? :update_service
                  @update_service = ::Gapic::Config::Method.new update_service_config
                  delete_service_config = parent_rpcs.delete_service if parent_rpcs.respond_to? :delete_service
                  @delete_service = ::Gapic::Config::Method.new delete_service_config
                  create_service_level_objective_config = parent_rpcs.create_service_level_objective if parent_rpcs.respond_to? :create_service_level_objective
                  @create_service_level_objective = ::Gapic::Config::Method.new create_service_level_objective_config
                  get_service_level_objective_config = parent_rpcs.get_service_level_objective if parent_rpcs.respond_to? :get_service_level_objective
                  @get_service_level_objective = ::Gapic::Config::Method.new get_service_level_objective_config
                  list_service_level_objectives_config = parent_rpcs.list_service_level_objectives if parent_rpcs.respond_to? :list_service_level_objectives
                  @list_service_level_objectives = ::Gapic::Config::Method.new list_service_level_objectives_config
                  update_service_level_objective_config = parent_rpcs.update_service_level_objective if parent_rpcs.respond_to? :update_service_level_objective
                  @update_service_level_objective = ::Gapic::Config::Method.new update_service_level_objective_config
                  delete_service_level_objective_config = parent_rpcs.delete_service_level_objective if parent_rpcs.respond_to? :delete_service_level_objective
                  @delete_service_level_objective = ::Gapic::Config::Method.new delete_service_level_objective_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
