# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Monitoring
      module V3
        module NotificationChannelService
          # Path helper methods for the NotificationChannelService API.
          module Paths
            ##
            # Create a fully-qualified Folder resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}`
            #
            # @param folder [String]
            #
            # @return [::String]
            def folder_path folder:
              "folders/#{folder}"
            end

            ##
            # Create a fully-qualified NotificationChannel resource string.
            #
            # @overload notification_channel_path(project:, notification_channel:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/notificationChannels/{notification_channel}`
            #
            #   @param project [String]
            #   @param notification_channel [String]
            #
            # @overload notification_channel_path(organization:, notification_channel:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/notificationChannels/{notification_channel}`
            #
            #   @param organization [String]
            #   @param notification_channel [String]
            #
            # @overload notification_channel_path(folder:, notification_channel:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/notificationChannels/{notification_channel}`
            #
            #   @param folder [String]
            #   @param notification_channel [String]
            #
            # @return [::String]
            def notification_channel_path **args
              resources = {
                "notification_channel:project" => (proc do |project:, notification_channel:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/notificationChannels/#{notification_channel}"
                end),
                "notification_channel:organization" => (proc do |organization:, notification_channel:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/notificationChannels/#{notification_channel}"
                end),
                "folder:notification_channel" => (proc do |folder:, notification_channel:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/notificationChannels/#{notification_channel}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified NotificationChannelDescriptor resource string.
            #
            # @overload notification_channel_descriptor_path(project:, channel_descriptor:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/notificationChannelDescriptors/{channel_descriptor}`
            #
            #   @param project [String]
            #   @param channel_descriptor [String]
            #
            # @overload notification_channel_descriptor_path(organization:, channel_descriptor:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/notificationChannelDescriptors/{channel_descriptor}`
            #
            #   @param organization [String]
            #   @param channel_descriptor [String]
            #
            # @overload notification_channel_descriptor_path(folder:, channel_descriptor:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/notificationChannelDescriptors/{channel_descriptor}`
            #
            #   @param folder [String]
            #   @param channel_descriptor [String]
            #
            # @return [::String]
            def notification_channel_descriptor_path **args
              resources = {
                "channel_descriptor:project" => (proc do |project:, channel_descriptor:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/notificationChannelDescriptors/#{channel_descriptor}"
                end),
                "channel_descriptor:organization" => (proc do |organization:, channel_descriptor:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/notificationChannelDescriptors/#{channel_descriptor}"
                end),
                "channel_descriptor:folder" => (proc do |folder:, channel_descriptor:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/notificationChannelDescriptors/#{channel_descriptor}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified Workspace resource string.
            #
            # @overload workspace_path(project:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}`
            #
            #   @param project [String]
            #
            # @overload workspace_path(workspace:)
            #   The resource will be in the following format:
            #
            #   `workspaces/{workspace}`
            #
            #   @param workspace [String]
            #
            # @return [::String]
            def workspace_path **args
              resources = {
                "project" => (proc do |project:|
                  "projects/#{project}"
                end),
                "workspace" => (proc do |workspace:|
                  "workspaces/#{workspace}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            extend self
          end
        end
      end
    end
  end
end
