# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/monitoring/v3/notification_service_pb"

module Google
  module Cloud
    module Monitoring
      module V3
        module NotificationChannelService
          ##
          # Client for the NotificationChannelService service.
          #
          # The Notification Channel API provides access to configuration that
          # controls how messages related to incidents are sent.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "monitoring.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :notification_channel_service_stub

            ##
            # Configure the NotificationChannelService Client class.
            #
            # See {::Google::Cloud::Monitoring::V3::NotificationChannelService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all NotificationChannelService clients
            #   ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Monitoring", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_notification_channel_descriptors.timeout = 30.0
                default_config.rpcs.list_notification_channel_descriptors.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_notification_channel_descriptor.timeout = 30.0
                default_config.rpcs.get_notification_channel_descriptor.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_notification_channels.timeout = 30.0
                default_config.rpcs.list_notification_channels.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_notification_channel.timeout = 30.0
                default_config.rpcs.get_notification_channel.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_notification_channel.timeout = 30.0

                default_config.rpcs.update_notification_channel.timeout = 30.0

                default_config.rpcs.delete_notification_channel.timeout = 30.0
                default_config.rpcs.delete_notification_channel.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.send_notification_channel_verification_code.timeout = 30.0

                default_config.rpcs.get_notification_channel_verification_code.timeout = 30.0
                default_config.rpcs.get_notification_channel_verification_code.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.verify_notification_channel.timeout = 30.0
                default_config.rpcs.verify_notification_channel.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the NotificationChannelService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Monitoring::V3::NotificationChannelService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @notification_channel_service_stub.universe_domain
            end

            ##
            # Create a new NotificationChannelService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the NotificationChannelService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/monitoring/v3/notification_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @notification_channel_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Monitoring::V3::NotificationChannelService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @notification_channel_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @notification_channel_service_stub.logger
            end

            # Service calls

            ##
            # Lists the descriptors for supported channel types. The use of descriptors
            # makes it possible for new channel types to be dynamically added.
            #
            # @overload list_notification_channel_descriptors(request, options = nil)
            #   Pass arguments to `list_notification_channel_descriptors` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListNotificationChannelDescriptorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListNotificationChannelDescriptorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_notification_channel_descriptors(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_notification_channel_descriptors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The REST resource name of the parent from which to retrieve
            #     the notification channel descriptors. The expected syntax is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #
            #     Note that this
            #     [names](https://cloud.google.com/monitoring/api/v3#project_name) the parent
            #     container in which to look for the descriptors; to retrieve a single
            #     descriptor by name, use the
            #     {::Google::Cloud::Monitoring::V3::NotificationChannelService::Client#get_notification_channel_descriptor GetNotificationChannelDescriptor}
            #     operation, instead.
            #   @param page_size [::Integer]
            #     The maximum number of results to return in a single response. If
            #     not set to a positive number, a reasonable value will be chosen by the
            #     service.
            #   @param page_token [::String]
            #     If non-empty, `page_token` must contain a value returned as the
            #     `next_page_token` in a previous response to request the next set
            #     of results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::NotificationChannelDescriptor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::NotificationChannelDescriptor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListNotificationChannelDescriptorsRequest.new
            #
            #   # Call the list_notification_channel_descriptors method.
            #   result = client.list_notification_channel_descriptors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::NotificationChannelDescriptor.
            #     p item
            #   end
            #
            def list_notification_channel_descriptors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListNotificationChannelDescriptorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_notification_channel_descriptors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_notification_channel_descriptors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_notification_channel_descriptors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :list_notification_channel_descriptors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @notification_channel_service_stub, :list_notification_channel_descriptors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single channel descriptor. The descriptor indicates which fields
            # are expected / permitted for a notification channel of the given type.
            #
            # @overload get_notification_channel_descriptor(request, options = nil)
            #   Pass arguments to `get_notification_channel_descriptor` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetNotificationChannelDescriptorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetNotificationChannelDescriptorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_notification_channel_descriptor(name: nil)
            #   Pass arguments to `get_notification_channel_descriptor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The channel type for which to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/notificationChannelDescriptors/[CHANNEL_TYPE]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::NotificationChannelDescriptor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::NotificationChannelDescriptor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetNotificationChannelDescriptorRequest.new
            #
            #   # Call the get_notification_channel_descriptor method.
            #   result = client.get_notification_channel_descriptor request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::NotificationChannelDescriptor.
            #   p result
            #
            def get_notification_channel_descriptor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetNotificationChannelDescriptorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_notification_channel_descriptor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_notification_channel_descriptor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_notification_channel_descriptor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :get_notification_channel_descriptor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the notification channels that have been created for the project.
            # To list the types of notification channels that are supported, use
            # the `ListNotificationChannelDescriptors` method.
            #
            # @overload list_notification_channels(request, options = nil)
            #   Pass arguments to `list_notification_channels` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListNotificationChannelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListNotificationChannelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_notification_channels(name: nil, filter: nil, order_by: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_notification_channels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #
            #     This names the container
            #     in which to look for the notification channels; it does not name a
            #     specific channel. To query a specific channel by REST resource name, use
            #     the
            #     {::Google::Cloud::Monitoring::V3::NotificationChannelService::Client#get_notification_channel `GetNotificationChannel`}
            #     operation.
            #   @param filter [::String]
            #     Optional. If provided, this field specifies the criteria that must be met
            #     by notification channels to be included in the response.
            #
            #     For more details, see [sorting and
            #     filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
            #   @param order_by [::String]
            #     Optional. A comma-separated list of fields by which to sort the result.
            #     Supports the same set of fields as in `filter`. Entries can be prefixed
            #     with a minus sign to sort in descending rather than ascending order.
            #
            #     For more details, see [sorting and
            #     filtering](https://cloud.google.com/monitoring/api/v3/sorting-and-filtering).
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return in a single response. If
            #     not set to a positive number, a reasonable value will be chosen by the
            #     service.
            #   @param page_token [::String]
            #     Optional. If non-empty, `page_token` must contain a value returned as the
            #     `next_page_token` in a previous response to request the next set
            #     of results.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::NotificationChannel>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::NotificationChannel>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListNotificationChannelsRequest.new
            #
            #   # Call the list_notification_channels method.
            #   result = client.list_notification_channels request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::NotificationChannel.
            #     p item
            #   end
            #
            def list_notification_channels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListNotificationChannelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_notification_channels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_notification_channels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_notification_channels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :list_notification_channels, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @notification_channel_service_stub, :list_notification_channels, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single notification channel. The channel includes the relevant
            # configuration details with which the channel was created. However, the
            # response may truncate or omit passwords, API keys, or other private key
            # matter and thus the response may not be 100% identical to the information
            # that was supplied in the call to the create method.
            #
            # @overload get_notification_channel(request, options = nil)
            #   Pass arguments to `get_notification_channel` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetNotificationChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetNotificationChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_notification_channel(name: nil)
            #   Pass arguments to `get_notification_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The channel for which to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::NotificationChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::NotificationChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetNotificationChannelRequest.new
            #
            #   # Call the get_notification_channel method.
            #   result = client.get_notification_channel request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::NotificationChannel.
            #   p result
            #
            def get_notification_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetNotificationChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_notification_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_notification_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_notification_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :get_notification_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new notification channel, representing a single notification
            # endpoint such as an email address, SMS number, or PagerDuty service.
            #
            # Design your application to single-thread API calls that modify the state of
            # notification channels in a single project. This includes calls to
            # CreateNotificationChannel, DeleteNotificationChannel and
            # UpdateNotificationChannel.
            #
            # @overload create_notification_channel(request, options = nil)
            #   Pass arguments to `create_notification_channel` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateNotificationChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateNotificationChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_notification_channel(name: nil, notification_channel: nil)
            #   Pass arguments to `create_notification_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #
            #     This names the container into which the channel will be
            #     written, this does not name the newly created channel. The resulting
            #     channel's name will have a normalized version of this field as a prefix,
            #     but will add `/notificationChannels/[CHANNEL_ID]` to identify the channel.
            #   @param notification_channel [::Google::Cloud::Monitoring::V3::NotificationChannel, ::Hash]
            #     Required. The definition of the `NotificationChannel` to create.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::NotificationChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::NotificationChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateNotificationChannelRequest.new
            #
            #   # Call the create_notification_channel method.
            #   result = client.create_notification_channel request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::NotificationChannel.
            #   p result
            #
            def create_notification_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateNotificationChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_notification_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_notification_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_notification_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :create_notification_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a notification channel. Fields not specified in the field mask
            # remain unchanged.
            #
            # Design your application to single-thread API calls that modify the state of
            # notification channels in a single project. This includes calls to
            # CreateNotificationChannel, DeleteNotificationChannel and
            # UpdateNotificationChannel.
            #
            # @overload update_notification_channel(request, options = nil)
            #   Pass arguments to `update_notification_channel` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::UpdateNotificationChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::UpdateNotificationChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_notification_channel(update_mask: nil, notification_channel: nil)
            #   Pass arguments to `update_notification_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The fields to update.
            #   @param notification_channel [::Google::Cloud::Monitoring::V3::NotificationChannel, ::Hash]
            #     Required. A description of the changes to be applied to the specified
            #     notification channel. The description must provide a definition for
            #     fields to be updated; the names of these fields should also be
            #     included in the `update_mask`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::NotificationChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::NotificationChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::UpdateNotificationChannelRequest.new
            #
            #   # Call the update_notification_channel method.
            #   result = client.update_notification_channel request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::NotificationChannel.
            #   p result
            #
            def update_notification_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::UpdateNotificationChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_notification_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.notification_channel&.name
                header_params["notification_channel.name"] = request.notification_channel.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_notification_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_notification_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :update_notification_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a notification channel.
            #
            # Design your application to single-thread API calls that modify the state of
            # notification channels in a single project. This includes calls to
            # CreateNotificationChannel, DeleteNotificationChannel and
            # UpdateNotificationChannel.
            #
            # @overload delete_notification_channel(request, options = nil)
            #   Pass arguments to `delete_notification_channel` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteNotificationChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteNotificationChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_notification_channel(name: nil, force: nil)
            #   Pass arguments to `delete_notification_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The channel for which to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
            #   @param force [::Boolean]
            #     If true, the notification channel will be deleted regardless of its
            #     use in alert policies (the policies will be updated to remove the
            #     channel). If false, this operation will fail if the notification channel
            #     is referenced by existing alerting policies.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteNotificationChannelRequest.new
            #
            #   # Call the delete_notification_channel method.
            #   result = client.delete_notification_channel request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_notification_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteNotificationChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_notification_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_notification_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_notification_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :delete_notification_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Causes a verification code to be delivered to the channel. The code
            # can then be supplied in `VerifyNotificationChannel` to verify the channel.
            #
            # @overload send_notification_channel_verification_code(request, options = nil)
            #   Pass arguments to `send_notification_channel_verification_code` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::SendNotificationChannelVerificationCodeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::SendNotificationChannelVerificationCodeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload send_notification_channel_verification_code(name: nil)
            #   Pass arguments to `send_notification_channel_verification_code` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The notification channel to which to send a verification code.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::SendNotificationChannelVerificationCodeRequest.new
            #
            #   # Call the send_notification_channel_verification_code method.
            #   result = client.send_notification_channel_verification_code request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def send_notification_channel_verification_code request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::SendNotificationChannelVerificationCodeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.send_notification_channel_verification_code.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.send_notification_channel_verification_code.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.send_notification_channel_verification_code.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :send_notification_channel_verification_code, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Requests a verification code for an already verified channel that can then
            # be used in a call to VerifyNotificationChannel() on a different channel
            # with an equivalent identity in the same or in a different project. This
            # makes it possible to copy a channel between projects without requiring
            # manual reverification of the channel. If the channel is not in the
            # verified state, this method will fail (in other words, this may only be
            # used if the SendNotificationChannelVerificationCode and
            # VerifyNotificationChannel paths have already been used to put the given
            # channel into the verified state).
            #
            # There is no guarantee that the verification codes returned by this method
            # will be of a similar structure or form as the ones that are delivered
            # to the channel via SendNotificationChannelVerificationCode; while
            # VerifyNotificationChannel() will recognize both the codes delivered via
            # SendNotificationChannelVerificationCode() and returned from
            # GetNotificationChannelVerificationCode(), it is typically the case that
            # the verification codes delivered via
            # SendNotificationChannelVerificationCode() will be shorter and also
            # have a shorter expiration (e.g. codes such as "G-123456") whereas
            # GetVerificationCode() will typically return a much longer, websafe base
            # 64 encoded string that has a longer expiration time.
            #
            # @overload get_notification_channel_verification_code(request, options = nil)
            #   Pass arguments to `get_notification_channel_verification_code` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_notification_channel_verification_code(name: nil, expire_time: nil)
            #   Pass arguments to `get_notification_channel_verification_code` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The notification channel for which a verification code is to be
            #     generated and retrieved. This must name a channel that is already verified;
            #     if the specified channel is not verified, the request will fail.
            #   @param expire_time [::Google::Protobuf::Timestamp, ::Hash]
            #     The desired expiration time. If specified, the API will guarantee that
            #     the returned code will not be valid after the specified timestamp;
            #     however, the API cannot guarantee that the returned code will be
            #     valid for at least as long as the requested time (the API puts an upper
            #     bound on the amount of time for which a code may be valid). If omitted,
            #     a default expiration will be used, which may be less than the max
            #     permissible expiration (so specifying an expiration may extend the
            #     code's lifetime over omitting an expiration, even though the API does
            #     impose an upper limit on the maximum expiration that is permitted).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeRequest.new
            #
            #   # Call the get_notification_channel_verification_code method.
            #   result = client.get_notification_channel_verification_code request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeResponse.
            #   p result
            #
            def get_notification_channel_verification_code request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetNotificationChannelVerificationCodeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_notification_channel_verification_code.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_notification_channel_verification_code.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_notification_channel_verification_code.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :get_notification_channel_verification_code, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Verifies a `NotificationChannel` by proving receipt of the code
            # delivered to the channel as a result of calling
            # `SendNotificationChannelVerificationCode`.
            #
            # @overload verify_notification_channel(request, options = nil)
            #   Pass arguments to `verify_notification_channel` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::VerifyNotificationChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::VerifyNotificationChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload verify_notification_channel(name: nil, code: nil)
            #   Pass arguments to `verify_notification_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The notification channel to verify.
            #   @param code [::String]
            #     Required. The verification code that was delivered to the channel as
            #     a result of invoking the `SendNotificationChannelVerificationCode` API
            #     method or that was retrieved from a verified channel via
            #     `GetNotificationChannelVerificationCode`. For example, one might have
            #     "G-123456" or "TKNZGhhd2EyN3I1MnRnMjRv" (in general, one is only
            #     guaranteed that the code is valid UTF-8; one should not
            #     make any assumptions regarding the structure or format of the code).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Monitoring::V3::NotificationChannel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Monitoring::V3::NotificationChannel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::VerifyNotificationChannelRequest.new
            #
            #   # Call the verify_notification_channel method.
            #   result = client.verify_notification_channel request
            #
            #   # The returned object is of type Google::Cloud::Monitoring::V3::NotificationChannel.
            #   p result
            #
            def verify_notification_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::VerifyNotificationChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.verify_notification_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.verify_notification_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.verify_notification_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @notification_channel_service_stub.call_rpc :verify_notification_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the NotificationChannelService API.
            #
            # This class represents the configuration for NotificationChannelService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Monitoring::V3::NotificationChannelService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_notification_channel_descriptors to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_notification_channel_descriptors.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_notification_channel_descriptors.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Monitoring::V3::NotificationChannelService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "monitoring.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the NotificationChannelService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_notification_channel_descriptors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_notification_channel_descriptors
                ##
                # RPC-specific configuration for `get_notification_channel_descriptor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_notification_channel_descriptor
                ##
                # RPC-specific configuration for `list_notification_channels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_notification_channels
                ##
                # RPC-specific configuration for `get_notification_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_notification_channel
                ##
                # RPC-specific configuration for `create_notification_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_notification_channel
                ##
                # RPC-specific configuration for `update_notification_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_notification_channel
                ##
                # RPC-specific configuration for `delete_notification_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_notification_channel
                ##
                # RPC-specific configuration for `send_notification_channel_verification_code`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :send_notification_channel_verification_code
                ##
                # RPC-specific configuration for `get_notification_channel_verification_code`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_notification_channel_verification_code
                ##
                # RPC-specific configuration for `verify_notification_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :verify_notification_channel

                # @private
                def initialize parent_rpcs = nil
                  list_notification_channel_descriptors_config = parent_rpcs.list_notification_channel_descriptors if parent_rpcs.respond_to? :list_notification_channel_descriptors
                  @list_notification_channel_descriptors = ::Gapic::Config::Method.new list_notification_channel_descriptors_config
                  get_notification_channel_descriptor_config = parent_rpcs.get_notification_channel_descriptor if parent_rpcs.respond_to? :get_notification_channel_descriptor
                  @get_notification_channel_descriptor = ::Gapic::Config::Method.new get_notification_channel_descriptor_config
                  list_notification_channels_config = parent_rpcs.list_notification_channels if parent_rpcs.respond_to? :list_notification_channels
                  @list_notification_channels = ::Gapic::Config::Method.new list_notification_channels_config
                  get_notification_channel_config = parent_rpcs.get_notification_channel if parent_rpcs.respond_to? :get_notification_channel
                  @get_notification_channel = ::Gapic::Config::Method.new get_notification_channel_config
                  create_notification_channel_config = parent_rpcs.create_notification_channel if parent_rpcs.respond_to? :create_notification_channel
                  @create_notification_channel = ::Gapic::Config::Method.new create_notification_channel_config
                  update_notification_channel_config = parent_rpcs.update_notification_channel if parent_rpcs.respond_to? :update_notification_channel
                  @update_notification_channel = ::Gapic::Config::Method.new update_notification_channel_config
                  delete_notification_channel_config = parent_rpcs.delete_notification_channel if parent_rpcs.respond_to? :delete_notification_channel
                  @delete_notification_channel = ::Gapic::Config::Method.new delete_notification_channel_config
                  send_notification_channel_verification_code_config = parent_rpcs.send_notification_channel_verification_code if parent_rpcs.respond_to? :send_notification_channel_verification_code
                  @send_notification_channel_verification_code = ::Gapic::Config::Method.new send_notification_channel_verification_code_config
                  get_notification_channel_verification_code_config = parent_rpcs.get_notification_channel_verification_code if parent_rpcs.respond_to? :get_notification_channel_verification_code
                  @get_notification_channel_verification_code = ::Gapic::Config::Method.new get_notification_channel_verification_code_config
                  verify_notification_channel_config = parent_rpcs.verify_notification_channel if parent_rpcs.respond_to? :verify_notification_channel
                  @verify_notification_channel = ::Gapic::Config::Method.new verify_notification_channel_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
