# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/monitoring/v3/metric_service_pb"

module Google
  module Cloud
    module Monitoring
      module V3
        module MetricService
          ##
          # Client for the MetricService service.
          #
          # Manages metric descriptors, monitored resource descriptors, and
          # time series data.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "monitoring.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :metric_service_stub

            ##
            # Configure the MetricService Client class.
            #
            # See {::Google::Cloud::Monitoring::V3::MetricService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all MetricService clients
            #   ::Google::Cloud::Monitoring::V3::MetricService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Monitoring", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_monitored_resource_descriptors.timeout = 30.0
                default_config.rpcs.list_monitored_resource_descriptors.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_monitored_resource_descriptor.timeout = 30.0
                default_config.rpcs.get_monitored_resource_descriptor.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_metric_descriptors.timeout = 30.0
                default_config.rpcs.list_metric_descriptors.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_metric_descriptor.timeout = 30.0
                default_config.rpcs.get_metric_descriptor.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_metric_descriptor.timeout = 12.0

                default_config.rpcs.delete_metric_descriptor.timeout = 30.0
                default_config.rpcs.delete_metric_descriptor.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_time_series.timeout = 90.0
                default_config.rpcs.list_time_series.retry_policy = {
                  initial_delay: 0.1, max_delay: 30.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_time_series.timeout = 12.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the MetricService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Monitoring::V3::MetricService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @metric_service_stub.universe_domain
            end

            ##
            # Create a new MetricService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Monitoring::V3::MetricService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the MetricService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/monitoring/v3/metric_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @metric_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Monitoring::V3::MetricService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @metric_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @metric_service_stub.logger
            end

            # Service calls

            ##
            # Lists monitored resource descriptors that match a filter.
            #
            # @overload list_monitored_resource_descriptors(request, options = nil)
            #   Pass arguments to `list_monitored_resource_descriptors` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListMonitoredResourceDescriptorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListMonitoredResourceDescriptorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_monitored_resource_descriptors(name: nil, filter: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_monitored_resource_descriptors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param filter [::String]
            #     An optional [filter](https://cloud.google.com/monitoring/api/v3/filters)
            #     describing the descriptors to be returned.  The filter can reference the
            #     descriptor's type and labels. For example, the following filter returns
            #     only Google Compute Engine descriptors that have an `id` label:
            #
            #         resource.type = starts_with("gce_") AND resource.label:id
            #   @param page_size [::Integer]
            #     A positive number that is the maximum number of results to return.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `nextPageToken` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Api::MonitoredResourceDescriptor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Api::MonitoredResourceDescriptor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListMonitoredResourceDescriptorsRequest.new
            #
            #   # Call the list_monitored_resource_descriptors method.
            #   result = client.list_monitored_resource_descriptors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Api::MonitoredResourceDescriptor.
            #     p item
            #   end
            #
            def list_monitored_resource_descriptors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListMonitoredResourceDescriptorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_monitored_resource_descriptors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_monitored_resource_descriptors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_monitored_resource_descriptors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :list_monitored_resource_descriptors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metric_service_stub, :list_monitored_resource_descriptors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single monitored resource descriptor.
            #
            # @overload get_monitored_resource_descriptor(request, options = nil)
            #   Pass arguments to `get_monitored_resource_descriptor` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetMonitoredResourceDescriptorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetMonitoredResourceDescriptorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_monitored_resource_descriptor(name: nil)
            #   Pass arguments to `get_monitored_resource_descriptor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The monitored resource descriptor to get.  The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/monitoredResourceDescriptors/[RESOURCE_TYPE]
            #
            #     The `[RESOURCE_TYPE]` is a predefined type, such as
            #     `cloudsql_database`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Api::MonitoredResourceDescriptor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Api::MonitoredResourceDescriptor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetMonitoredResourceDescriptorRequest.new
            #
            #   # Call the get_monitored_resource_descriptor method.
            #   result = client.get_monitored_resource_descriptor request
            #
            #   # The returned object is of type Google::Api::MonitoredResourceDescriptor.
            #   p result
            #
            def get_monitored_resource_descriptor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetMonitoredResourceDescriptorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_monitored_resource_descriptor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_monitored_resource_descriptor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_monitored_resource_descriptor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :get_monitored_resource_descriptor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists metric descriptors that match a filter.
            #
            # @overload list_metric_descriptors(request, options = nil)
            #   Pass arguments to `list_metric_descriptors` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListMetricDescriptorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListMetricDescriptorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_metric_descriptors(name: nil, filter: nil, page_size: nil, page_token: nil, active_only: nil)
            #   Pass arguments to `list_metric_descriptors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param filter [::String]
            #     Optional. If this field is empty, all custom and
            #     system-defined metric descriptors are returned.
            #     Otherwise, the [filter](https://cloud.google.com/monitoring/api/v3/filters)
            #     specifies which metric descriptors are to be
            #     returned. For example, the following filter matches all
            #     [custom metrics](https://cloud.google.com/monitoring/custom-metrics):
            #
            #         metric.type = starts_with("custom.googleapis.com/")
            #   @param page_size [::Integer]
            #     Optional. A positive number that is the maximum number of results to
            #     return. The default and maximum value is 10,000. If a page_size <= 0 or >
            #     10,000 is submitted, will instead return a maximum of 10,000 results.
            #   @param page_token [::String]
            #     Optional. If this field is not empty then it must contain the
            #     `nextPageToken` value returned by a previous call to this method.  Using
            #     this field causes the method to return additional results from the previous
            #     method call.
            #   @param active_only [::Boolean]
            #     Optional. If true, only metrics and monitored resource types that have
            #     recent data (within roughly 25 hours) will be included in the response.
            #      - If a metric descriptor enumerates monitored resource types, only the
            #        monitored resource types for which the metric type has recent data will
            #        be included in the returned metric descriptor, and if none of them have
            #        recent data, the metric descriptor will not be returned.
            #      - If a metric descriptor does not enumerate the compatible monitored
            #        resource types, it will be returned only if the metric type has recent
            #        data for some monitored resource type. The returned descriptor will not
            #        enumerate any monitored resource types.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Api::MetricDescriptor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Api::MetricDescriptor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListMetricDescriptorsRequest.new
            #
            #   # Call the list_metric_descriptors method.
            #   result = client.list_metric_descriptors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Api::MetricDescriptor.
            #     p item
            #   end
            #
            def list_metric_descriptors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListMetricDescriptorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_metric_descriptors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_metric_descriptors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_metric_descriptors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :list_metric_descriptors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metric_service_stub, :list_metric_descriptors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a single metric descriptor.
            #
            # @overload get_metric_descriptor(request, options = nil)
            #   Pass arguments to `get_metric_descriptor` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::GetMetricDescriptorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::GetMetricDescriptorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_metric_descriptor(name: nil)
            #   Pass arguments to `get_metric_descriptor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The metric descriptor on which to execute the request. The format
            #     is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
            #
            #     An example value of `[METRIC_ID]` is
            #     `"compute.googleapis.com/instance/disk/read_bytes_count"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Api::MetricDescriptor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Api::MetricDescriptor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::GetMetricDescriptorRequest.new
            #
            #   # Call the get_metric_descriptor method.
            #   result = client.get_metric_descriptor request
            #
            #   # The returned object is of type Google::Api::MetricDescriptor.
            #   p result
            #
            def get_metric_descriptor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::GetMetricDescriptorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_metric_descriptor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_metric_descriptor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_metric_descriptor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :get_metric_descriptor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new metric descriptor.
            # The creation is executed asynchronously.
            # User-created metric descriptors define
            # [custom metrics](https://cloud.google.com/monitoring/custom-metrics).
            # The metric descriptor is updated if it already exists,
            # except that metric labels are never removed.
            #
            # @overload create_metric_descriptor(request, options = nil)
            #   Pass arguments to `create_metric_descriptor` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateMetricDescriptorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateMetricDescriptorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_metric_descriptor(name: nil, metric_descriptor: nil)
            #   Pass arguments to `create_metric_descriptor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #     4
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param metric_descriptor [::Google::Api::MetricDescriptor, ::Hash]
            #     Required. The new [custom
            #     metric](https://cloud.google.com/monitoring/custom-metrics) descriptor.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Api::MetricDescriptor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Api::MetricDescriptor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateMetricDescriptorRequest.new
            #
            #   # Call the create_metric_descriptor method.
            #   result = client.create_metric_descriptor request
            #
            #   # The returned object is of type Google::Api::MetricDescriptor.
            #   p result
            #
            def create_metric_descriptor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateMetricDescriptorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_metric_descriptor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_metric_descriptor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_metric_descriptor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :create_metric_descriptor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a metric descriptor. Only user-created
            # [custom metrics](https://cloud.google.com/monitoring/custom-metrics) can be
            # deleted.
            #
            # @overload delete_metric_descriptor(request, options = nil)
            #   Pass arguments to `delete_metric_descriptor` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::DeleteMetricDescriptorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::DeleteMetricDescriptorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_metric_descriptor(name: nil)
            #   Pass arguments to `delete_metric_descriptor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The metric descriptor on which to execute the request. The format
            #     is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]/metricDescriptors/[METRIC_ID]
            #
            #     An example of `[METRIC_ID]` is:
            #     `"custom.googleapis.com/my_test_metric"`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::DeleteMetricDescriptorRequest.new
            #
            #   # Call the delete_metric_descriptor method.
            #   result = client.delete_metric_descriptor request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_metric_descriptor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::DeleteMetricDescriptorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_metric_descriptor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_metric_descriptor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_metric_descriptor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :delete_metric_descriptor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists time series that match a filter.
            #
            # @overload list_time_series(request, options = nil)
            #   Pass arguments to `list_time_series` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::ListTimeSeriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::ListTimeSeriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_time_series(name: nil, filter: nil, interval: nil, aggregation: nil, secondary_aggregation: nil, order_by: nil, view: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_time_series` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name),
            #     organization or folder on which to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #         organizations/[ORGANIZATION_ID]
            #         folders/[FOLDER_ID]
            #   @param filter [::String]
            #     Required. A [monitoring
            #     filter](https://cloud.google.com/monitoring/api/v3/filters) that specifies
            #     which time series should be returned.  The filter must specify a single
            #     metric type, and can additionally specify metric labels and other
            #     information. For example:
            #
            #         metric.type = "compute.googleapis.com/instance/cpu/usage_time" AND
            #             metric.labels.instance_name = "my-instance-name"
            #   @param interval [::Google::Cloud::Monitoring::V3::TimeInterval, ::Hash]
            #     Required. The time interval for which results should be returned. Only time
            #     series that contain data points in the specified interval are included in
            #     the response.
            #   @param aggregation [::Google::Cloud::Monitoring::V3::Aggregation, ::Hash]
            #     Specifies the alignment of data points in individual time series as
            #     well as how to combine the retrieved time series across specified labels.
            #
            #     By default (if no `aggregation` is explicitly specified), the raw time
            #     series data is returned.
            #   @param secondary_aggregation [::Google::Cloud::Monitoring::V3::Aggregation, ::Hash]
            #     Apply a second aggregation after `aggregation` is applied. May only be
            #     specified if `aggregation` is specified.
            #   @param order_by [::String]
            #     Unsupported: must be left blank. The points in each time series are
            #     currently returned in reverse time order (most recent to oldest).
            #   @param view [::Google::Cloud::Monitoring::V3::ListTimeSeriesRequest::TimeSeriesView]
            #     Required. Specifies which information is returned about the time series.
            #   @param page_size [::Integer]
            #     A positive number that is the maximum number of results to return. If
            #     `page_size` is empty or more than 100,000 results, the effective
            #     `page_size` is 100,000 results. If `view` is set to `FULL`, this is the
            #     maximum number of `Points` returned. If `view` is set to `HEADERS`, this is
            #     the maximum number of `TimeSeries` returned.
            #   @param page_token [::String]
            #     If this field is not empty then it must contain the `nextPageToken` value
            #     returned by a previous call to this method.  Using this field causes the
            #     method to return additional results from the previous method call.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::TimeSeries>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Monitoring::V3::TimeSeries>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::ListTimeSeriesRequest.new
            #
            #   # Call the list_time_series method.
            #   result = client.list_time_series request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Monitoring::V3::TimeSeries.
            #     p item
            #   end
            #
            def list_time_series request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::ListTimeSeriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_time_series.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_time_series.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_time_series.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :list_time_series, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metric_service_stub, :list_time_series, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates or adds data to one or more time series.
            # The response is empty if all time series in the request were written.
            # If any time series could not be written, a corresponding failure message is
            # included in the error response.
            # This method does not support
            # [resource locations constraint of an organization
            # policy](https://cloud.google.com/resource-manager/docs/organization-policy/defining-locations#setting_the_organization_policy).
            #
            # @overload create_time_series(request, options = nil)
            #   Pass arguments to `create_time_series` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_time_series(name: nil, time_series: nil)
            #   Pass arguments to `create_time_series` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param time_series [::Array<::Google::Cloud::Monitoring::V3::TimeSeries, ::Hash>]
            #     Required. The new data to be added to a list of time series.
            #     Adds at most one data point to each of several time series.  The new data
            #     point must be more recent than any other point in its time series.  Each
            #     `TimeSeries` value must fully specify a unique time series by supplying
            #     all label values for the metric and the monitored resource.
            #
            #     The maximum number of `TimeSeries` objects per `Create` request is 200.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest.new
            #
            #   # Call the create_time_series method.
            #   result = client.create_time_series request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def create_time_series request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_time_series.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_time_series.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_time_series.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :create_time_series, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates or adds data to one or more service time series. A service time
            # series is a time series for a metric from a Google Cloud service. The
            # response is empty if all time series in the request were written. If any
            # time series could not be written, a corresponding failure message is
            # included in the error response. This endpoint rejects writes to
            # user-defined metrics.
            # This method is only for use by Google Cloud services. Use
            # {::Google::Cloud::Monitoring::V3::MetricService::Client#create_time_series projects.timeSeries.create}
            # instead.
            #
            # @overload create_service_time_series(request, options = nil)
            #   Pass arguments to `create_service_time_series` via a request object, either of type
            #   {::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_service_time_series(name: nil, time_series: nil)
            #   Pass arguments to `create_service_time_series` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The
            #     [project](https://cloud.google.com/monitoring/api/v3#project_name) on which
            #     to execute the request. The format is:
            #
            #         projects/[PROJECT_ID_OR_NUMBER]
            #   @param time_series [::Array<::Google::Cloud::Monitoring::V3::TimeSeries, ::Hash>]
            #     Required. The new data to be added to a list of time series.
            #     Adds at most one data point to each of several time series.  The new data
            #     point must be more recent than any other point in its time series.  Each
            #     `TimeSeries` value must fully specify a unique time series by supplying
            #     all label values for the metric and the monitored resource.
            #
            #     The maximum number of `TimeSeries` objects per `Create` request is 200.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/monitoring/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Monitoring::V3::MetricService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest.new
            #
            #   # Call the create_service_time_series method.
            #   result = client.create_service_time_series request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def create_service_time_series request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Monitoring::V3::CreateTimeSeriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_service_time_series.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Monitoring::V3::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_service_time_series.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_service_time_series.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metric_service_stub.call_rpc :create_service_time_series, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the MetricService API.
            #
            # This class represents the configuration for MetricService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Monitoring::V3::MetricService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_monitored_resource_descriptors to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Monitoring::V3::MetricService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_monitored_resource_descriptors.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Monitoring::V3::MetricService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_monitored_resource_descriptors.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Monitoring::V3::MetricService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "monitoring.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the MetricService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_monitored_resource_descriptors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_monitored_resource_descriptors
                ##
                # RPC-specific configuration for `get_monitored_resource_descriptor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_monitored_resource_descriptor
                ##
                # RPC-specific configuration for `list_metric_descriptors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_metric_descriptors
                ##
                # RPC-specific configuration for `get_metric_descriptor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_metric_descriptor
                ##
                # RPC-specific configuration for `create_metric_descriptor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_metric_descriptor
                ##
                # RPC-specific configuration for `delete_metric_descriptor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_metric_descriptor
                ##
                # RPC-specific configuration for `list_time_series`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_time_series
                ##
                # RPC-specific configuration for `create_time_series`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_time_series
                ##
                # RPC-specific configuration for `create_service_time_series`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_service_time_series

                # @private
                def initialize parent_rpcs = nil
                  list_monitored_resource_descriptors_config = parent_rpcs.list_monitored_resource_descriptors if parent_rpcs.respond_to? :list_monitored_resource_descriptors
                  @list_monitored_resource_descriptors = ::Gapic::Config::Method.new list_monitored_resource_descriptors_config
                  get_monitored_resource_descriptor_config = parent_rpcs.get_monitored_resource_descriptor if parent_rpcs.respond_to? :get_monitored_resource_descriptor
                  @get_monitored_resource_descriptor = ::Gapic::Config::Method.new get_monitored_resource_descriptor_config
                  list_metric_descriptors_config = parent_rpcs.list_metric_descriptors if parent_rpcs.respond_to? :list_metric_descriptors
                  @list_metric_descriptors = ::Gapic::Config::Method.new list_metric_descriptors_config
                  get_metric_descriptor_config = parent_rpcs.get_metric_descriptor if parent_rpcs.respond_to? :get_metric_descriptor
                  @get_metric_descriptor = ::Gapic::Config::Method.new get_metric_descriptor_config
                  create_metric_descriptor_config = parent_rpcs.create_metric_descriptor if parent_rpcs.respond_to? :create_metric_descriptor
                  @create_metric_descriptor = ::Gapic::Config::Method.new create_metric_descriptor_config
                  delete_metric_descriptor_config = parent_rpcs.delete_metric_descriptor if parent_rpcs.respond_to? :delete_metric_descriptor
                  @delete_metric_descriptor = ::Gapic::Config::Method.new delete_metric_descriptor_config
                  list_time_series_config = parent_rpcs.list_time_series if parent_rpcs.respond_to? :list_time_series
                  @list_time_series = ::Gapic::Config::Method.new list_time_series_config
                  create_time_series_config = parent_rpcs.create_time_series if parent_rpcs.respond_to? :create_time_series
                  @create_time_series = ::Gapic::Config::Method.new create_time_series_config
                  create_service_time_series_config = parent_rpcs.create_service_time_series if parent_rpcs.respond_to? :create_service_time_series
                  @create_service_time_series = ::Gapic::Config::Method.new create_service_time_series_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
